/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.image;

import com.jogamp.opengl.util.texture.Texture;
import java.io.Serializable;
import java.util.Map;
import net.lustlab.packer.PackNode;
import net.lustlab.rndr.font.EntityPairIndex;
import net.lustlab.rndr.font.FontDescriptor;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.image.FontImageMapBuilder;

public final class FontImageMap
implements Serializable,
FontMap {
    private final transient Texture texture;
    private final Map<Character, PackNode> map;
    private final int sanding;
    private final Map<EntityPairIndex, Float> kerningPairs;
    private final FontDescriptor descriptor;
    public final int fontHeight;
    private int fontSize;
    private int leading;

    public FontImageMap(FontImageMap fontImageMap, Texture texture) {
        this.texture = texture;
        this.map = fontImageMap.map;
        this.sanding = fontImageMap.sanding;
        this.fontHeight = fontImageMap.fontHeight;
        this.kerningPairs = fontImageMap.kerningPairs;
        this.descriptor = fontImageMap.descriptor;
        this.fontSize = fontImageMap.fontSize;
        this.leading = fontImageMap.leading;
    }

    public FontImageMap(FontDescriptor descriptor, Texture texture, Map<Character, PackNode> map, Map<EntityPairIndex, Float> kerningPairs, int sanding, int fontHeight, int fontSize, int leading) {
        this.descriptor = descriptor;
        this.texture = texture;
        this.map = map;
        this.sanding = sanding;
        this.kerningPairs = kerningPairs;
        this.fontHeight = fontHeight;
        this.fontSize = fontSize;
        this.leading = leading;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public Map<Character, PackNode> getMap() {
        return this.map;
    }

    public float characterWidth(char character) {
        PackNode node = this.map.get(Character.valueOf(character));
        if (node != null) {
            FontImageMapBuilder.Entry data = (FontImageMapBuilder.Entry)node.getData();
            return data.width;
        }
        return 0.0f;
    }

    public int getSanding() {
        return this.sanding;
    }

    public float kerning(char left, char right) {
        Float kerning = this.kerningPairs.get(new EntityPairIndex(left, right));
        if (kerning == null) {
            return 0.0f;
        }
        return kerning.floatValue();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public double fontHeight() {
        return this.fontHeight;
    }

    @Override
    public double leading() {
        return this.leading;
    }
}

