/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Tessellation;
import net.lustlab.rndr.gl.GLError;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.VBODrawer;

public class TessellationRendererGL3 {
    static Shader shader;

    public static void initShader(GL3 gl3) {
        if (shader == null) {
            shader = Shader.createShader((GL)gl3, VertexShader.load((GL)gl3, TessellationRendererGL3.class.getResourceAsStream("/shaders/gl3/tessellation.vert")), FragmentShader.load((GL)gl3, TessellationRendererGL3.class.getResourceAsStream("/shaders/gl3/tessellation.frag")));
        }
    }

    public static void drawTessellation(GL3 gl2, Matrix44 projection, Matrix44 modelView, Tessellation ts) {
        TessellationRendererGL3.initShader(gl2);
        shader.begin();
        for (Tessellation.PrimitiveData pd : ts.data) {
            Matrix44 transform = modelView.multiply(pd.polygon.transform.matrix);
            Matrix44 worldViewProjection = projection.multiply(transform);
            shader.setUniform("modelViewProjectionMatrix", worldViewProjection.transpose());
            if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Fill) {
                shader.setUniform("color", pd.polygon.fill);
            } else if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Stroke) {
                shader.setUniform("color", pd.polygon.stroke);
            }
            if (pd.vbo == null) {
                pd.createVBO((GL)gl2, shader);
            }
            pd.vbo.bind();
            VBODrawer.draw((GL)gl2, shader, pd.vbo, Tessellation.PrimitiveData.layout, pd.command, pd.vertices.size());
        }
        shader.end();
        GLError.check((GL)gl2);
    }

    public static void applyTransform(GL3 gl2, Tessellation.PrimitiveData pd) {
        FloatBuffer fb = FloatBuffer.allocate(16);
        pd.polygon.transform.matrix.toFloatBuffer(fb);
        fb.rewind();
    }

    public static void drawTessellationSmooth(GL3 gl2, Matrix44 projection, Matrix44 modelView, Tessellation ts) {
        TessellationRendererGL3.drawTessellationSmooth(gl2, projection, modelView, ts, null, null);
    }

    public static void drawTessellationSmooth(GL3 gl2, Matrix44 projection, Matrix44 modelView, Tessellation ts, Color fill, Color stroke) {
        TessellationRendererGL3.initShader(gl2);
        gl2.glEnable(2848);
        gl2.glEnable(3042);
        gl2.glBlendFunc(770, 771);
        shader.begin();
        for (Tessellation.PrimitiveData pd : ts.data) {
            Matrix44 transform = modelView.multiply(pd.polygon.transform.matrix);
            Matrix44 worldViewProjection = projection.multiply(transform);
            shader.setUniform("modelViewProjectionMatrix", worldViewProjection.transpose());
            if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Fill) {
                if (fill != null) {
                    shader.setUniform("color", fill);
                } else {
                    shader.setUniform("color", pd.polygon.fill);
                }
            } else if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Stroke) {
                if (stroke != null) {
                    shader.setUniform("color", stroke);
                } else {
                    shader.setUniform("color", pd.polygon.stroke);
                }
            }
            if (pd.vbo == null) {
                pd.createVBO((GL)gl2, shader);
            }
            pd.vbo.bind();
            VBODrawer.draw(gl2, pd.vao, pd.command, pd.vertices.size());
        }
        shader.end();
    }
}

