/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Figure;
import net.lustlab.rndr.draw.Polygon;
import net.lustlab.rndr.draw.PolygonContour;
import net.lustlab.rndr.draw.Vertex;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBOLayout;

public class Tessellation
implements Serializable {
    public HashMap<Polygon, Integer> polygons;
    public List<PrimitiveData> data = new ArrayList<PrimitiveData>();

    public void outputEdge(PolygonContour contour, Polygon polygon) {
        PrimitiveData pd = new PrimitiveData();
        pd.polygon = polygon;
        pd.colorSource = PrimitiveData.ColorSource.Stroke;
        pd.command = 3;
        for (Vertex vertex : contour) {
            pd.vertices.add(vertex);
        }
        this.data.add(pd);
    }

    public static Tessellation tessellate(Figure figure) {
        GLU glu = new GLU();
        GLUtessellator tessellator = glu.gluNewTess();
        Tessellation tessellation = new Tessellation();
        TesselCallBack callback = new TesselCallBack(glu, tessellation);
        GLU.gluTessCallback((GLUtessellator)tessellator, (int)100101, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)tessellator, (int)100106, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)tessellator, (int)100102, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)tessellator, (int)100103, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)tessellator, (int)100105, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)tessellator, (int)100110, (GLUtessellatorCallback)callback);
        for (Polygon polygon : figure) {
            if (polygon.contoursClosed()) {
                if (polygon.fill != null) {
                    GLU.gluTessProperty((GLUtessellator)tessellator, (int)100141, (double)0.0);
                    callback.mode = TesselCallBack.TessellatorMode.Fill;
                    Tessellation.tessellatePolygon(glu, tessellator, polygon);
                    GLU.gluTessProperty((GLUtessellator)tessellator, (int)100141, (double)1.0);
                    callback.mode = TesselCallBack.TessellatorMode.Fill;
                    Tessellation.tessellatePolygon(glu, tessellator, polygon);
                }
                if (polygon.stroke == null) continue;
                GLU.gluTessProperty((GLUtessellator)tessellator, (int)100141, (double)1.0);
                callback.mode = TesselCallBack.TessellatorMode.Stroke;
                Tessellation.tessellatePolygon(glu, tessellator, polygon);
                continue;
            }
            if (polygon.stroke == null) continue;
            for (PolygonContour contour : polygon) {
                tessellation.outputEdge(contour, polygon);
            }
        }
        GLU.gluDeleteTess((GLUtessellator)tessellator);
        return tessellation;
    }

    private static void tessellatePolygon(GLU glu, GLUtessellator tessellator, Polygon polygon) {
        GLU.gluTessBeginPolygon((GLUtessellator)tessellator, (Object)polygon);
        for (PolygonContour polygonContour : polygon) {
            GLU.gluTessBeginContour((GLUtessellator)tessellator);
            for (Vertex vertex : polygonContour) {
                Vector3 t = vertex.position;
                GLU.gluTessVertex((GLUtessellator)tessellator, (double[])t.array(), (int)0, (Object)t.array());
            }
            GLU.gluTessEndContour((GLUtessellator)tessellator);
        }
        GLU.gluTessEndPolygon((GLUtessellator)tessellator);
    }

    static class TesselCallBack
    extends GLUtessellatorCallbackAdapter {
        private GLU glu;
        Tessellation shape;
        boolean edge;
        TessellatorMode mode = TessellatorMode.Fill;

        public TesselCallBack(GLU glu, Tessellation shape) {
            this.glu = glu;
            this.shape = shape;
        }

        public void beginData(int type, Object polygonData) {
            this.edge = false;
            Polygon polygon = (Polygon)polygonData;
            PrimitiveData pd = new PrimitiveData();
            pd.command = type;
            pd.polygon = polygon;
            if (this.mode == TessellatorMode.Fill) {
                pd.colorSource = PrimitiveData.ColorSource.Fill;
            } else if (this.mode == TessellatorMode.Stroke) {
                pd.colorSource = PrimitiveData.ColorSource.Stroke;
            }
            this.shape.data.add(pd);
        }

        public void end() {
        }

        public void vertex(Object vertexData) {
            if (vertexData != null) {
                double[] pointer = (double[])vertexData;
                Vertex vertex = new Vertex().position(pointer[0], pointer[1], pointer[2]).edge(this.edge);
                this.shape.data.get((int)(this.shape.data.size() - 1)).vertices.add(vertex);
            }
        }

        public void edgeFlagData(boolean b, Object o) {
            this.edge = b;
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            double[] vertex = new double[6];
            vertex[0] = coords[0];
            vertex[1] = coords[1];
            vertex[2] = coords[2];
            outData[0] = vertex;
        }

        public void combineData(double[] coords, Object[] data, float[] weight, Object[] outData, Object polygonData) {
        }

        public void error(int errnum) {
            String estring = this.glu.gluErrorString(errnum);
            System.err.println("Tessellation Error: " + estring);
            System.exit(0);
        }

        static enum TessellatorMode {
            Fill,
            Stroke;

        }
    }

    public static class PrimitiveData
    implements Serializable {
        public static VBOLayout layout = new VBOLayout().color(4).position(3);
        public int command;
        public ColorSource colorSource;
        public Polygon polygon;
        public List<Vertex> vertices = new ArrayList<Vertex>();
        public VBO vbo;
        public VAO vao;

        public void createVBO(GL gl, Shader shader) {
            ByteBuffer buffer;
            if (this.vbo == null) {
                buffer = ByteBuffer.allocateDirect(layout.size() * this.vertices.size());
                BufferWriter bw = new BufferWriter(buffer);
                for (Vertex vertex : this.vertices) {
                    bw.write(Color.WHITE);
                    bw.write(vertex.position);
                }
            } else {
                throw new RuntimeException("already has vbo");
            }
            buffer.rewind();
            this.vbo = VBO.createStaticVBO(gl, buffer, layout.size() * this.vertices.size());
            this.vao = VAO.createVAO(gl.getGL3(), this.vbo, layout, shader);
        }

        static enum ColorSource {
            Fill,
            Stroke;

        }
    }
}

