/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.BezierCubicRenderer;
import net.lustlab.rndr.draw.BezierQuadraticRenderer;
import net.lustlab.rndr.draw.Contour;
import net.lustlab.rndr.draw.Node;
import net.lustlab.rndr.draw.Polygon;
import net.lustlab.rndr.draw.PolygonContour;
import net.lustlab.rndr.draw.Segment;
import net.lustlab.rndr.draw.Vertex;
import net.lustlab.rndr.math.Vector2;

public class Shape
extends Node
implements Iterable<Contour>,
Serializable {
    public List<Contour> contours = new ArrayList<Contour>();
    public Color fill;
    public Color stroke;

    @Override
    public String toString() {
        return "Shape{contours=" + this.contours + ", fill=" + this.fill + ", stroke=" + this.stroke + '}';
    }

    public boolean contoursClosed() {
        boolean closed = true;
        for (Contour contour : this.contours) {
            if (contour.closed) continue;
            closed = false;
            break;
        }
        return closed;
    }

    @Override
    public Iterator<Contour> iterator() {
        return this.contours.iterator();
    }

    public Polygon polygon() {
        return this.polygon(-1.0);
    }

    public Polygon polygon(double distanceTolerance) {
        Polygon polygon = new Polygon();
        polygon.fill = this.fill != null ? this.fill.copy() : null;
        polygon.stroke = this.stroke != null ? this.stroke.copy() : null;
        polygon.transform = this.transform;
        polygon.id = this.id;
        for (Contour contour : this.contours) {
            PolygonContour polygonContour = new PolygonContour();
            polygonContour.closed = contour.closed;
            int segmentIndex = 0;
            for (Segment segment : contour) {
                if (segment.isLinear()) {
                    polygonContour.vertices.add(new Vertex().position(segment.start.copy()));
                    if (segmentIndex == contour.segments.size() - 1) {
                        polygonContour.vertices.add(new Vertex().position(segment.end.copy()));
                    }
                } else {
                    int p;
                    int o;
                    List<Vector2> points;
                    if (segment.control.length == 1) {
                        BezierQuadraticRenderer bqr = new BezierQuadraticRenderer();
                        if (distanceTolerance != -1.0) {
                            bqr.distanceTolerance = distanceTolerance;
                        }
                        points = bqr.render(segment.start, segment.control[0], segment.end);
                        o = segmentIndex == contour.segments.size() - 1 ? 0 : 1;
                        for (p = 0; p < points.size() - o; ++p) {
                            polygonContour.vertices.add(new Vertex().position(points.get(p)));
                        }
                    }
                    if (segment.control.length == 2) {
                        BezierCubicRenderer bcr = new BezierCubicRenderer();
                        if (distanceTolerance != -1.0) {
                            bcr.distanceTolerance = distanceTolerance;
                        }
                        points = bcr.render(segment.start, segment.control[0], segment.control[1], segment.end);
                        o = segmentIndex == contour.segments.size() - 1 ? 0 : 1;
                        for (p = 0; p < points.size() - o; ++p) {
                            polygonContour.vertices.add(new Vertex().position(points.get(p)));
                        }
                    }
                }
                ++segmentIndex;
            }
            polygon.polygonContours.add(polygonContour);
        }
        return polygon;
    }
}

