/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lustlab.rndr.draw.Node;
import net.lustlab.rndr.draw.Polygon;
import net.lustlab.rndr.draw.Rectangle;

public class Figure
implements Iterable<Polygon>,
Serializable {
    public List<Polygon> polygons = new ArrayList<Polygon>();

    public Rectangle bounds() {
        double minx = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        for (Node node : this.polygons) {
            Rectangle localBounds = node.bounds();
            minx = Math.min(minx, localBounds.x);
            miny = Math.min(miny, localBounds.y);
            maxx = Math.max(maxx, localBounds.x + localBounds.width);
            maxy = Math.max(maxy, localBounds.y + localBounds.height);
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    @Override
    public Iterator<Polygon> iterator() {
        return this.polygons.iterator();
    }

    public Figure addPolygon(Polygon polygon) {
        this.polygons.add(polygon);
        return this;
    }

    public Polygon polygon(String name) {
        for (Polygon polygon : this.polygons) {
            if (!name.equals(polygon.id)) continue;
            return polygon;
        }
        return null;
    }

    public List<Polygon> polygons(String regex) {
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        for (Polygon polygon : this.polygons) {
            if (polygon.id == null || !polygon.id.matches(regex)) continue;
            result.add(polygon);
        }
        return result;
    }

    public String toString() {
        return "Figure{polygons=" + this.polygons + '}';
    }
}

