/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.lustlab.rndr.draw.Batch;
import net.lustlab.rndr.draw.Figure;
import net.lustlab.rndr.draw.Node;
import net.lustlab.rndr.draw.Polygon;
import net.lustlab.rndr.draw.Shape;

public class Composition
implements Serializable {
    public Node root = new Batch();

    public Shape shape(String name) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.root);
        while (!stack.empty()) {
            Node node = (Node)stack.pop();
            if (node instanceof Shape) {
                Shape shape = (Shape)node;
                if (!name.equals(shape.id)) continue;
                return shape;
            }
            if (!(node instanceof Batch)) continue;
            Batch b = (Batch)node;
            for (Node child : b) {
                stack.push(child);
            }
        }
        return null;
    }

    public List<Shape> shapes(String regex) {
        ArrayList<Shape> result = new ArrayList<Shape>();
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.root);
        while (!stack.empty()) {
            Node node = (Node)stack.pop();
            if (node instanceof Shape) {
                Shape shape = (Shape)node;
                String shapeId = shape.id != null ? shape.id : "";
                if (!shapeId.matches(regex)) continue;
                result.add(shape);
                continue;
            }
            if (!(node instanceof Batch)) continue;
            Batch b = (Batch)node;
            for (Node child : b) {
                stack.push(child);
            }
        }
        return result;
    }

    private void outputPolygon(Node node, Figure figure, double distanceTolerance) {
        if (node instanceof Shape) {
            Polygon polygon = ((Shape)node).polygon(distanceTolerance);
            figure.polygons.add(polygon);
        } else if (node instanceof Batch) {
            Batch b = (Batch)node;
            for (Node child : b) {
                this.outputPolygon(child, figure, distanceTolerance);
            }
        }
    }

    public Figure figure() {
        return this.figure(-1.0);
    }

    public Figure figure(double distanceTolerance) {
        Figure figure = new Figure();
        this.outputPolygon(this.root, figure, distanceTolerance);
        return figure;
    }
}

