/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.util.ArrayList;
import java.util.List;
import net.lustlab.rndr.math.Vector2;

public class BezierQuadraticRenderer {
    private int recursionLimit = 8;
    private static final double colinearityEpsilon = 1.0E-30;
    public double distanceTolerance = 0.5;
    private double distanceToleranceSquare;
    private double angleToleranceEpsilon = 0.01;
    private double angleTolerance = 0.0;
    List<Vector2> points = new ArrayList<Vector2>();

    private void render(Vector2 x1, Vector2 x2, Vector2 x3, int level) {
        if (level > this.recursionLimit) {
            return;
        }
        Vector2 x12 = x1.add(x2).scale(0.5);
        Vector2 x23 = x2.add(x3).scale(0.5);
        Vector2 x123 = x12.add(x23).scale(0.5);
        double dy = x3.y - x1.y;
        double dx = x3.x - x1.x;
        double d = Math.abs((x2.x - x3.x) * dy - (x2.y - x3.y) * dx);
        if (d > 1.0E-30) {
            if (d * d <= this.distanceToleranceSquare * (dx * dx + dy * dy)) {
                if (this.angleTolerance < this.angleToleranceEpsilon) {
                    this.points.add(new Vector2(x123));
                    return;
                }
                double da = Math.abs(Math.atan2(x3.y - x2.y, x3.x - x2.x) - Math.atan2(x2.y - x1.y, x2.x - x1.x));
                if (da >= Math.PI) {
                    da = Math.PI * 2 - da;
                }
                if (da < this.angleTolerance) {
                    this.points.add(new Vector2(x123));
                    return;
                }
            }
        } else {
            double da = dx * dx + dy * dy;
            if (da == 0.0) {
                d = BezierQuadraticRenderer.squaredDistance(x1.x, x1.y, x2.x, x2.y);
            } else {
                d = ((x2.x - x1.x) * dx + (x2.y - x1.y) * dy) / da;
                if (d > 0.0 && d < 1.0) {
                    return;
                }
                d = d <= 0.0 ? BezierQuadraticRenderer.squaredDistance(x2.x, x2.y, x1.x, x1.y) : (d >= 1.0 ? BezierQuadraticRenderer.squaredDistance(x2.x, x2.y, x3.x, x3.y) : BezierQuadraticRenderer.squaredDistance(x2.x, x2.y, x1.x + d * dx, x1.y + d * dy));
            }
            if (d < this.distanceToleranceSquare) {
                this.points.add(new Vector2(x2));
                return;
            }
        }
        this.render(x1, x12, x123, level + 1);
        this.render(x123, x23, x3, level + 1);
    }

    private static double squaredDistance(double x1, double y, double x2, double y1) {
        double dx = x2 - x1;
        double dy = y1 - 1.0;
        return dx * dx + dy * dy;
    }

    public List<Vector2> render(Vector2 x1, Vector2 x2, Vector2 x3) {
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.points.add(new Vector2(x1));
        this.render(x1, x2, x3, 0);
        this.points.add(new Vector2(x3));
        return this.points;
    }
}

