/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.util.ArrayList;
import java.util.List;
import net.lustlab.rndr.math.Vector2;

public class BezierCubicRenderer {
    private final int recursionLimit = 8;
    private List<Vector2> points = new ArrayList<Vector2>();
    private static final double colinearityEpsilon = 1.0E-30;
    private static final double angleToleranceEpsilon = 0.01;
    private double distanceToleranceSquare;
    private double angleTolerance = 0.0;
    private double cuspLimit = 0.0;
    public double distanceTolerance = 0.5;

    public List<Vector2> render(Vector2 x1, Vector2 x2, Vector2 x3, Vector2 x4) {
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.points.add(new Vector2(x1));
        this.render(x1, x2, x3, x4, 0);
        this.points.add(new Vector2(x4));
        return this.points;
    }

    private void render(Vector2 x1, Vector2 x2, Vector2 x3, Vector2 x4, int level) {
        if (level > 8) {
            return;
        }
        Vector2 x12 = x1.add(x2).scale(0.5);
        Vector2 x23 = x2.add(x3).scale(0.5);
        Vector2 x34 = x3.add(x4).scale(0.5);
        Vector2 x123 = x12.add(x23).scale(0.5);
        Vector2 x234 = x23.add(x34).scale(0.5);
        Vector2 x1234 = x123.add(x234).scale(0.5);
        double dx = x4.x - x1.x;
        double dy = x4.y - x1.y;
        double d2 = Math.abs((x2.x - x4.x) * dy - (x2.y - x4.y) * dx);
        double d3 = Math.abs((x3.x - x4.x) * dy - (x3.y - x4.y) * dx);
        boolean p1 = d2 > 1.0E-30;
        boolean p0 = d3 > 1.0E-30;
        int p = (p1 ? 2 : 0) + (p0 ? 1 : 0);
        switch (p) {
            case 0: {
                double k = dx * dx + dy * dy;
                if (k == 0.0) {
                    d2 = BezierCubicRenderer.squareDistance(x1.x, x1.y, x2.x, x2.y);
                    d3 = BezierCubicRenderer.squareDistance(x4.x, x4.y, x3.x, x3.y);
                } else {
                    k = 1.0 / k;
                    double da1 = x2.x - x1.x;
                    double da2 = x2.y - x1.y;
                    d2 = k * (da1 * dx + da2 * dy);
                    da1 = x3.x - x1.x;
                    da2 = x3.y - x1.y;
                    d3 = k * (da1 * dx + da2 * dy);
                    if (d2 > 0.0 && d2 < 1.0 && d3 > 0.0 && d3 < 1.0) {
                        return;
                    }
                    d2 = d2 <= 0.0 ? BezierCubicRenderer.squareDistance(x2.x, x2.y, x1.x, x1.y) : (d2 >= 1.0 ? BezierCubicRenderer.squareDistance(x2.x, x2.y, x4.x, x4.y) : BezierCubicRenderer.squareDistance(x2.x, x2.y, x1.x + d2 * dx, x1.y + d2 * dy));
                    d3 = d3 <= 0.0 ? BezierCubicRenderer.squareDistance(x3.x, x3.y, x1.x, x1.y) : (d3 >= 1.0 ? BezierCubicRenderer.squareDistance(x3.x, x3.y, x4.x, x4.y) : BezierCubicRenderer.squareDistance(x3.x, x3.y, x1.x + d3 * dx, x1.y + d3 * dy));
                }
                if (d2 > d3) {
                    if (!(d2 < this.distanceToleranceSquare)) break;
                    this.points.add(new Vector2(x2.x, x2.y));
                    return;
                }
                if (!(d3 < this.distanceToleranceSquare)) break;
                this.points.add(new Vector2(x3.x, x3.y));
                return;
            }
            case 1: {
                if (!(d3 * d3 <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < 0.01) {
                    this.points.add(new Vector2(x23));
                    return;
                }
                double da1 = Math.abs(Math.atan2(x4.y - x3.y, x4.x - x3.x) - Math.atan2(x3.y - x2.y, x3.x - x2.x));
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    this.points.add(new Vector2(x2));
                    this.points.add(new Vector2(x3));
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                this.points.add(new Vector2(x3));
                return;
            }
            case 2: {
                if (!(d2 * d2 <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < 0.01) {
                    this.points.add(new Vector2(x23));
                    return;
                }
                double da1 = Math.abs(Math.atan2(x3.y - x2.y, x3.x - x2.x) - Math.atan2(x2.y - x1.y, x2.x - x1.x));
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    this.points.add(new Vector2(x2));
                    this.points.add(new Vector2(x3));
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                this.points.add(new Vector2(x2));
                return;
            }
            case 3: {
                if (!((d2 + d3) * (d2 + d3) <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < 0.01) {
                    this.points.add(new Vector2(x23));
                    return;
                }
                double k = Math.atan2(x3.y - x2.y, x3.x - x2.x);
                double da1 = Math.abs(k - Math.atan2(x2.y - x1.y, x2.x - x1.x));
                double da2 = Math.abs(Math.atan2(x4.y - x3.y, x4.x - x3.x) - k);
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da2 >= Math.PI) {
                    da2 = Math.PI * 2 - da2;
                }
                if (da1 + da2 < this.angleTolerance) {
                    this.points.add(new Vector2(x23));
                    return;
                }
                if (this.cuspLimit == 0.0) break;
                if (da1 > this.cuspLimit) {
                    this.points.add(new Vector2(x2));
                    return;
                }
                if (!(da2 > this.cuspLimit)) break;
                this.points.add(new Vector2(x3));
                return;
            }
        }
        this.render(x1, x12, x123, x1234, level + 1);
        this.render(x1234, x234, x34, x4, level + 1);
    }

    private static double squareDistance(double x, double y, double x1, double y1) {
        double dx = x1 - x;
        double dy = y1 - y;
        return dx * dx + dy * dy;
    }
}

