/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.color;

import java.io.Serializable;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;

public class Color
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Color WHITE = new Color(1.0, 1.0, 1.0, 1.0);
    public static final Color GRAY = new Color(0.5, 0.5, 0.5, 1.0);
    public static final Color BLACK = new Color(0.0, 0.0, 0.0, 1.0);
    public static final Color RED = new Color(1.0, 0.0, 0.0, 1.0);
    public static final Color GREEN = new Color(0.0, 1.0, 0.0, 1.0);
    public static final Color BLUE = new Color(0.0, 0.0, 1.0, 1.0);
    public static final Color CYAN = new Color(0.0, 1.0, 1.0, 1.0);
    public static final Color YELLOW = new Color(1.0, 1.0, 0.0, 1.0);
    public double r;
    public double g;
    public double b;
    public double a;

    public Color(Vector3 v3) {
        this(v3.x, v3.y, v3.z, 1.0);
    }

    public Color(Vector4 v4) {
        this(v4.x, v4.y, v4.z, v4.w);
    }

    public Color red(double r) {
        this.r = r;
        return this;
    }

    public Color green(double g) {
        this.g = g;
        return this;
    }

    public Color blue(double b) {
        this.b = b;
        return this;
    }

    public Color alpha(double a) {
        this.a = a;
        return this;
    }

    public Color(double r, double g, double b) {
        this(r, g, b, 1.0);
    }

    public Color(Color that) {
        this(that.r, that.g, that.b, that.a);
    }

    public Color() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Color(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color add(Color right) {
        return new Color(this.r + right.r, this.g + right.g, this.b + right.b, this.a + right.a);
    }

    public Color shade(double scale) {
        return new Color(this.r * scale, this.g * scale, this.b * scale, this.a);
    }

    public Color scale(double scale) {
        return new Color(this.r * scale, this.g * scale, this.b * scale, this.a * scale);
    }

    public Color copy() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "} ";
    }
}

