/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import net.lustlab.rndr.Configuration;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Drawer;
import net.lustlab.rndr.fbo.FBO;
import net.lustlab.rndr.image.Image;

public class Sketch
implements GLEventListener,
MouseListener,
KeyListener,
WindowListener {
    public Configuration configuration = new Configuration();
    public GLAutoDrawable drawable;
    public Drawer drawer;
    public GL2 gl2;
    public long start = System.currentTimeMillis();
    public FPSAnimator animator;
    public int width;
    public int height;
    public GLWindow window;

    public void setup() {
    }

    public void draw() {
    }

    public double seconds() {
        return (double)(System.currentTimeMillis() - this.start) / 1000.0;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseWheelMoved(MouseEvent event) {
    }

    public void draw(Image image, double x, double y) {
        this.drawImage(image, x, y, image.width, image.height);
    }

    public void drawImage(Image image, double x, double y, double width, double height) {
        GL2 gl2 = this.drawable.getGL().getGL2();
        TextureCoords tc = image.texture.getImageTexCoords();
        float u0 = tc.left();
        float u1 = tc.right();
        float v0 = tc.top();
        float v1 = tc.bottom();
        image.texture.bind((GL)gl2);
        image.texture.enable((GL)gl2);
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        gl2.glTranslated(x, y, 0.0);
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glTexCoord2f(u0, v0);
        gl2.glVertex2f(0.0f, 0.0f);
        gl2.glTexCoord2f(u1, v0);
        gl2.glVertex2d(width, 0.0);
        gl2.glTexCoord2f(u1, v1);
        gl2.glVertex2d(width, height);
        gl2.glTexCoord2f(u0, v1);
        gl2.glVertex2d(0.0, height);
        gl2.glEnd();
        gl2.glDisable(3553);
        gl2.glBindTexture(3553, 0);
        gl2.glPopMatrix();
    }

    public void drawFBO(FBO fbo, double x, double y) {
        GL2 gl2 = this.drawable.getGL().getGL2();
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 1.0f;
        float v1 = 0.0f;
        fbo.bindTexture();
        gl2.glEnable(3553);
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        gl2.glTranslated(x, y, 0.0);
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glTexCoord2f(u0, v0);
        gl2.glVertex2f(0.0f, 0.0f);
        gl2.glTexCoord2f(u1, v0);
        gl2.glVertex2f((float)fbo.width, 0.0f);
        gl2.glTexCoord2f(u1, v1);
        gl2.glVertex2f((float)fbo.width, (float)fbo.height);
        gl2.glTexCoord2f(u0, v1);
        gl2.glVertex2f(0.0f, (float)fbo.height);
        gl2.glEnd();
        gl2.glDisable(3553);
        gl2.glBindTexture(3553, 0);
        gl2.glPopMatrix();
    }

    public final void display(GLAutoDrawable drawable) {
        GL2 gl;
        this.width = this.configuration.width;
        this.height = this.configuration.height;
        this.drawer.size(this.configuration.width, this.configuration.height);
        this.drawable = drawable;
        this.gl2 = gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)this.configuration.width, (double)this.configuration.height, 0.0, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.draw();
    }

    public final void dispose(GLAutoDrawable drawable) {
    }

    public final void init(GLAutoDrawable drawable) {
        GL2 gl;
        this.drawable = drawable;
        this.width = this.configuration.width;
        this.height = this.configuration.height;
        this.drawer = new Drawer(drawable.getGL());
        this.gl2 = gl = drawable.getGL().getGL2();
        gl.setSwapInterval(1);
        this.drawer.size(this.configuration.width, this.configuration.height);
        this.setup();
    }

    public final void reshape(GLAutoDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
    }

    public final void background(Color color) {
        this.background(color.r, color.g, color.b, color.a);
    }

    public final void background(double r, double g, double b, double a) {
        GL gl = this.drawable.getGL();
        gl.glClearColor((float)r, (float)g, (float)b, (float)a);
        gl.glClear(16640);
    }

    public static final void run(Sketch sketch) {
        Sketch.run(sketch, null);
    }

    public static final void run(final Sketch sketch, Configuration configuration) {
        GLWindow window;
        GLProfile glp = GLProfile.getDefault();
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setDoubleBuffered(true);
        caps.setSampleBuffers(sketch.configuration.superSampling);
        caps.setNumSamples(sketch.configuration.superSamples);
        caps.setDepthBits(24);
        sketch.window = window = GLWindow.create((GLCapabilitiesImmutable)caps);
        if (configuration == null) {
            configuration = sketch.configuration;
        }
        sketch.configuration = configuration;
        for (String logger : sketch.configuration.logLevels.keySet()) {
            String level = sketch.configuration.logLevels.get(logger);
            System.out.println("setting loglevel " + logger + " to " + Level.parse(level));
            Logger.getLogger(logger).setLevel(Level.parse(level));
        }
        sketch.animator = new FPSAnimator((GLAutoDrawable)window, configuration.fps, true);
        window.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyNotify(WindowEvent event) {
                new Thread(){

                    @Override
                    public void run() {
                        sketch.animator.stop();
                    }
                }.start();
            }
        });
        window.setTitle(sketch.getClass().getName());
        window.setTitle(configuration.title);
        window.setPosition(configuration.left, configuration.top);
        window.setSize(configuration.width, configuration.height);
        if (configuration.hideWindowDecorations) {
            window.setUndecorated(true);
        }
        window.addWindowListener((WindowListener)sketch);
        window.addGLEventListener((GLEventListener)sketch);
        window.addMouseListener((MouseListener)sketch);
        window.addKeyListener((KeyListener)sketch);
        window.setVisible(true);
        if (configuration.hideMouseCursor) {
            window.setPointerVisible(false);
        }
        window.setFullscreen(configuration.fullscreen);
        window.setPosition(configuration.left, configuration.top);
        window.requestFocus();
        sketch.animator.start();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowResized(WindowEvent windowEvent) {
    }

    public void windowMoved(WindowEvent windowEvent) {
    }

    public void windowDestroyNotify(WindowEvent windowEvent) {
        System.out.println("stopping");
        this.animator.stop();
    }

    public void windowDestroyed(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }
}

