/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.lustlab.rndr.RNDRException;
import org.yaml.snakeyaml.Yaml;

public class Configuration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int width = 640;
    public int height = 480;
    public int left = 0;
    public int top = 0;
    public int fps = 60;
    public boolean fullscreen = false;
    public boolean resizable = false;
    public boolean changeMode = false;
    public String title = "RNDR";
    public boolean superSampling = false;
    public int superSamples = 1;
    public boolean hideWindowDecorations = false;
    public Map<String, String> application = new HashMap<String, String>();
    public Map<String, String> logLevels = new HashMap<String, String>();
    public boolean hideMouseCursor = false;

    public static Configuration defaults() {
        Configuration configuration = new Configuration();
        return configuration;
    }

    public static Configuration loadFromYAML(String filename) {
        try {
            File file = new File(filename);
            Yaml yaml = new Yaml();
            FileInputStream fis = new FileInputStream(file);
            Configuration configuration = (Configuration)yaml.loadAs((InputStream)fis, Configuration.class);
            return configuration;
        }
        catch (IOException e) {
            throw new RNDRException(e);
        }
    }
}

