/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.sndr;

import com.jogamp.openal.AL;
import net.lustlab.sndr.AudioBuffer;
import net.lustlab.sndr.Vector;

public class AudioSource
extends Vector {
    protected AL al;
    protected AudioBuffer buffer;
    protected int id;
    protected int size;
    protected float[] position = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] velocity = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] direction = new float[]{0.0f, 0.0f, 0.0f};
    protected int[] alResult = new int[1];
    protected boolean isLooping;

    public AudioSource(AL al, int id) {
        this(al, id, null);
    }

    public AudioSource(AL al, int id, AudioBuffer buf) {
        this.al = al;
        this.id = id;
        this.setBuffer(buf);
    }

    public void delete() {
        this.stop();
        this.al.alDeleteSources(1, new int[]{this.id}, 0);
    }

    public AudioBuffer getBuffer() {
        return this.buffer;
    }

    public int getBuffersProcessed() {
        this.al.alGetSourcei(this.id, 4118, this.alResult, 0);
        return this.alResult[0];
    }

    public float[] getDirection() {
        return this.direction;
    }

    public int getID() {
        return this.id;
    }

    public int getOffset() {
        this.al.alGetSourcei(this.id, 4133, this.alResult, 0);
        return this.alResult[0];
    }

    public float[] getPosition() {
        return this.position;
    }

    public float[] getVelocity() {
        return this.velocity;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public int length() {
        return this.size;
    }

    public void play() {
        if (this.buffer != null) {
            this.al.alSourcePlay(this.id);
        }
    }

    public void rewind() {
        if (this.buffer != null) {
            this.al.alSourceRewind(this.id);
        }
    }

    public void setBuffer(AudioBuffer buffer) {
        this.buffer = buffer;
        if (buffer != null) {
            this.al.alSourcei(this.id, 4105, buffer.getID());
            this.size = buffer.getSampleSize();
        } else {
            this.size = 0;
        }
    }

    public void setDirection(float xx, float yy, float zz) {
        this.direction[0] = xx;
        this.direction[1] = yy;
        this.direction[2] = zz;
        this.setDirection(this.direction);
    }

    private final void setDirection(float[] dir) {
        if (dir.length >= 3) {
            this.direction[0] = dir[0];
            this.direction[1] = dir[1];
            this.direction[2] = dir[2];
            this.al.alSourcefv(this.id, 4101, this.direction, 0);
        }
    }

    public void setGain(float gain) {
        this.al.alSourcef(this.id, 4106, gain);
    }

    public void setLooping(boolean state) {
        this.isLooping = state;
        this.al.alSourcei(this.id, 4103, state ? 1 : 0);
    }

    public void setOffset(int off) {
        this.al.alSourcei(this.id, 4133, off);
    }

    public void setPitch(float pitch) {
        this.al.alSourcef(this.id, 4099, pitch);
    }

    public void setPosition(float xx, float yy, float zz) {
        this.position[0] = xx;
        this.position[1] = yy;
        this.position[2] = zz;
        this.setPosition(this.position);
    }

    private final void setPosition(float[] p) {
        this.position = p;
        this.x = this.position[0];
        this.y = this.position[1];
        this.z = this.position[2];
        this.al.alSourcefv(this.id, 4100, this.position, 0);
    }

    public final void setPosition(Vector p) {
        this.setPosition(p.x, p.y, p.z);
    }

    public void setReferenceDistance(float d) {
        this.al.alSourcef(this.id, 4128, d);
    }

    public void setVelocity(float xx, float yy, float zz) {
        this.velocity[0] = xx;
        this.velocity[1] = yy;
        this.velocity[2] = zz;
        this.setVelocity(this.velocity);
    }

    private final void setVelocity(float[] v) {
        this.velocity = v;
        this.al.alSourcefv(this.id, 4102, this.velocity, 0);
    }

    public final void setVelocity(Vector p) {
        this.setVelocity(p.x, p.y, p.z);
    }

    public void stop() {
        this.al.alSourceStop(this.id);
    }

    public final void updatePosition() {
        this.setPosition(this.x, this.y, this.z);
    }
}

