/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.demo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.KeyEvent;
import org.openrndr.Program;
import org.openrndr.animatable.Animatable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Quaternion;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.text.Writer;
import rndr.studio.demo.camera.NoiseTable;
import rndr.studio.demo.camera.NoiseType;
import scenes.BackBox;
import scenes.CityFloor;
import scenes.Crawlers;
import scenes.CrawlersBase;
import scenes.CrawlersIntro;
import scenes.Crowd02;
import scenes.CrowdIntro;
import scenes.CrowdOutro;
import scenes.DisplayLines;
import scenes.Floor;
import scenes.Light;
import scenes.MegaCrawlers;
import scenes.MegaMarchingCrawlers;
import scenes.RenderStyle;
import scenes.SkyBox;
import scenes.TexturedRectangle;
import studio.rndr.camera.CameraKey;
import studio.rndr.camera.CameraKeyframer;
import studio.rndr.camera.FirstPersonCamera;
import studio.rndr.demo.Demo;
import studio.rndr.demo.Demo$schedule$;
import studio.rndr.demo.DemoKt;
import studio.rndr.demo.FrameClock;
import studio.rndr.demo.bass.BassKt;
import studio.rndr.demo.bass.Channel;
import studio.rndr.demosystem.Scheduler;
import studio.rndr.demosystem.TaskContext;
import studio.rndr.post.PostProcessor;
import studio.rndr.screens.City;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010P\u001a\u00020QH\u0016J\u0006\u0010R\u001a\u00020QJ\b\u0010S\u001a\u00020QH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\f\"\u0004\b&\u0010\u000eR\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0012\"\u0004\b/\u0010\u0014R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020=X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010D\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\f\"\u0004\bF\u0010\u000eR\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020I0H\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0014\u0010L\u001a\u00020\u001cX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u001eR\u0014\u0010N\u001a\u00020\u001cX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u001e\u00a8\u0006T"}, d2={"Lstudio/rndr/demo/Demo;", "Lorg/openrndr/Program;", "()V", "channel", "Lstudio/rndr/demo/bass/Channel;", "getChannel", "()Lstudio/rndr/demo/bass/Channel;", "setChannel", "(Lstudio/rndr/demo/bass/Channel;)V", "dumpVideo", "", "getDumpVideo", "()Z", "setDumpVideo", "(Z)V", "finalTarget", "Lorg/openrndr/draw/RenderTarget;", "getFinalTarget", "()Lorg/openrndr/draw/RenderTarget;", "setFinalTarget", "(Lorg/openrndr/draw/RenderTarget;)V", "frameClock", "Lstudio/rndr/demo/FrameClock;", "getFrameClock", "()Lstudio/rndr/demo/FrameClock;", "setFrameClock", "(Lstudio/rndr/demo/FrameClock;)V", "freakDuration", "", "getFreakDuration", "()I", "setFreakDuration", "(I)V", "freakMethod", "getFreakMethod", "setFreakMethod", "freakMode", "getFreakMode", "setFreakMode", "freakPitch", "", "getFreakPitch", "()D", "setFreakPitch", "(D)V", "gbuffer", "getGbuffer", "setGbuffer", "lastFreak", "", "getLastFreak", "()J", "setLastFreak", "(J)V", "post", "Lstudio/rndr/post/PostProcessor;", "getPost", "()Lstudio/rndr/post/PostProcessor;", "setPost", "(Lstudio/rndr/post/PostProcessor;)V", "result", "Lorg/openrndr/draw/ColorBuffer;", "getResult", "()Lorg/openrndr/draw/ColorBuffer;", "setResult", "(Lorg/openrndr/draw/ColorBuffer;)V", "scheduler", "Lstudio/rndr/demosystem/Scheduler;", "showDebug", "getShowDebug", "setShowDebug", "subtitles", "", "", "getSubtitles", "()Ljava/util/List;", "targetHeight", "getTargetHeight", "targetWidth", "getTargetWidth", "draw", "", "schedule", "setup", "demo-strap"})
public final class Demo
extends Program {
    @NotNull
    public Channel channel;
    private final Scheduler scheduler = new Scheduler(112.0);
    private boolean showDebug;
    private final int targetWidth = 1280;
    private final int targetHeight = 720;
    @NotNull
    public RenderTarget gbuffer;
    @NotNull
    public PostProcessor post;
    @NotNull
    public ColorBuffer result;
    @NotNull
    public RenderTarget finalTarget;
    @NotNull
    private final List<String> subtitles = FilesKt.readLines$default(new File("data/texts/subtitles.txt"), null, 1, null);
    private boolean dumpVideo;
    @NotNull
    public FrameClock frameClock;
    private boolean freakMode;
    private int freakDuration = 100;
    private long lastFreak;
    private double freakPitch = 44100.0;
    private int freakMethod;

    @NotNull
    public final Channel getChannel() {
        Channel channel = this.channel;
        if (channel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("channel");
        }
        return channel;
    }

    public final void setChannel(@NotNull Channel channel) {
        Intrinsics.checkParameterIsNotNull(channel, "<set-?>");
        this.channel = channel;
    }

    public final boolean getShowDebug() {
        return this.showDebug;
    }

    public final void setShowDebug(boolean bl) {
        this.showDebug = bl;
    }

    public final int getTargetWidth() {
        return this.targetWidth;
    }

    public final int getTargetHeight() {
        return this.targetHeight;
    }

    @NotNull
    public final RenderTarget getGbuffer() {
        RenderTarget renderTarget = this.gbuffer;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gbuffer");
        }
        return renderTarget;
    }

    public final void setGbuffer(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkParameterIsNotNull(renderTarget, "<set-?>");
        this.gbuffer = renderTarget;
    }

    @NotNull
    public final PostProcessor getPost() {
        PostProcessor postProcessor = this.post;
        if (postProcessor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("post");
        }
        return postProcessor;
    }

    public final void setPost(@NotNull PostProcessor postProcessor) {
        Intrinsics.checkParameterIsNotNull(postProcessor, "<set-?>");
        this.post = postProcessor;
    }

    @NotNull
    public final ColorBuffer getResult() {
        ColorBuffer colorBuffer = this.result;
        if (colorBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("result");
        }
        return colorBuffer;
    }

    public final void setResult(@NotNull ColorBuffer colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "<set-?>");
        this.result = colorBuffer;
    }

    @NotNull
    public final RenderTarget getFinalTarget() {
        RenderTarget renderTarget = this.finalTarget;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("finalTarget");
        }
        return renderTarget;
    }

    public final void setFinalTarget(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkParameterIsNotNull(renderTarget, "<set-?>");
        this.finalTarget = renderTarget;
    }

    @NotNull
    public final List<String> getSubtitles() {
        return this.subtitles;
    }

    public final boolean getDumpVideo() {
        return this.dumpVideo;
    }

    public final void setDumpVideo(boolean bl) {
        this.dumpVideo = bl;
    }

    @NotNull
    public final FrameClock getFrameClock() {
        FrameClock frameClock = this.frameClock;
        if (frameClock == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frameClock");
        }
        return frameClock;
    }

    public final void setFrameClock(@NotNull FrameClock frameClock) {
        Intrinsics.checkParameterIsNotNull(frameClock, "<set-?>");
        this.frameClock = frameClock;
    }

    @Override
    public void setup() {
        if (this.dumpVideo) {
            FrameClock frameClock = this.frameClock = new FrameClock();
            if (frameClock == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameClock");
            }
            Animatable.Companion.clock(frameClock);
        }
        this.finalTarget = DrawerKt.renderTarget$default(this.targetWidth, this.targetHeight, 0.0, setup.1.INSTANCE, 4, null);
        BassKt.initBass();
        String string = "loading music";
        System.out.println((Object)string);
        if (!this.dumpVideo) {
            this.channel = BassKt.openStream("data/audio/demo.mp3");
        }
        string = "loaded music";
        System.out.println((Object)string);
        this.getKeyboard().getKeyDown().filter(setup.2.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Demo this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.getChannel().setPosition(RangesKt.coerceAtLeast(this.this$0.getChannel().getPosition() - 60.0 / Demo.access$getScheduler$p(this.this$0).getBpm() * (double)16, 0.0));
            }
            {
                this.this$0 = demo;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.4.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Demo this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.getChannel().setPosition(this.this$0.getChannel().getPosition() + 60.0 / Demo.access$getScheduler$p(this.this$0).getBpm() * (double)16);
            }
            {
                this.this$0 = demo;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.6.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Demo this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.setShowDebug(!this.this$0.getShowDebug());
            }
            {
                this.this$0 = demo;
                super(1);
            }
        });
        PostProcessor postProcessor = this.post = new PostProcessor(this.targetWidth, this.targetHeight);
        if (postProcessor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("post");
        }
        this.gbuffer = postProcessor.createGBuffer();
        this.result = DrawerKt.colorBuffer(this.targetWidth, this.targetHeight, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.schedule();
        if (!this.dumpVideo) {
            Channel channel = this.channel;
            if (channel == null) {
                Intrinsics.throwUninitializedPropertyAccessException("channel");
            }
            channel.play();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void schedule() {
        Iterable $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv$iv222;
        Iterable $receiver$iv;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object[] objectArray;
        void $receiver$iv$iv3;
        Iterable $receiver$iv2;
        Demo demo;
        FontImageMap font96 = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, "file:data/fonts/CooperHewitt-Heavy.otf", 96.0, 0.0, 4, null);
        FontImageMap font16 = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, "file:data/fonts/CooperHewitt-Heavy.otf", 16.0, 0.0, 4, null);
        double beatDuration = 60.0 / this.scheduler.getBpm();
        double barDuration = beatDuration * (double)4;
        double patternDuration = barDuration * (double)4;
        BackBox backBox = new BackBox(1400.0);
        Floor floor2 = new Floor(0.0, 0.0, 3, null);
        City city = new City();
        SkyBox skyBox = new SkyBox(0.0, 1, null);
        CityFloor cityFloor = new CityFloor(city.getIrradiance(), 0.0, 0.0, 6, null);
        RenderTarget lightMap2 = DrawerKt.renderTarget$default(2048, 2048, 0.0, schedule.lightMap.1.INSTANCE, 4, null);
        Function3<RenderTarget, Light, Function0<? extends Unit>, Unit> drawLight$ = new Function3<RenderTarget, Light, Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ Demo this$0;

            public final void invoke(@NotNull RenderTarget rt2, @NotNull Light light, @NotNull Function0<Unit> drawFunction) {
                Intrinsics.checkParameterIsNotNull(rt2, "rt");
                Intrinsics.checkParameterIsNotNull(light, "light");
                Intrinsics.checkParameterIsNotNull(drawFunction, "drawFunction");
                DrawerKt.isolatedWithTarget(this.this$0.getDrawer(), rt2, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, light, drawFunction){
                    final /* synthetic */ schedule.1 this$0;
                    final /* synthetic */ Light $light;
                    final /* synthetic */ Function0 $drawFunction;

                    public final void invoke(@NotNull Drawer $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        this.this$0.this$0.getDrawer().setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
                        this.this$0.this$0.getDrawer().setDepthWrite(true);
                        $receiver.setProjection(this.$light.getProjection());
                        $receiver.setView(this.$light.getView());
                        this.this$0.this$0.getDrawer().setModel(Matrix44.Companion.getIDENTITY());
                        $receiver.background(ColorRGBa.Companion.getBLACK());
                        this.$drawFunction.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$light = light;
                        this.$drawFunction = function0;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = demo;
                super(3);
            }
        };
        Function2<FirstPersonCamera, Function0<? extends Unit>, Unit> drawPost$ = new Function2<FirstPersonCamera, Function0<? extends Unit>, Unit>(this){
            final /* synthetic */ Demo this$0;

            public final void invoke(@NotNull FirstPersonCamera camera, @NotNull Function0<Unit> drawFunction) {
                Intrinsics.checkParameterIsNotNull(camera, "camera");
                Intrinsics.checkParameterIsNotNull(drawFunction, "drawFunction");
                DrawerKt.isolatedWithTarget(this.this$0.getDrawer(), this.this$0.getGbuffer(), (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, camera, drawFunction){
                    final /* synthetic */ schedule.2 this$0;
                    final /* synthetic */ FirstPersonCamera $camera;
                    final /* synthetic */ Function0 $drawFunction;

                    public final void invoke(@NotNull Drawer $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        this.this$0.this$0.getDrawer().setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
                        this.this$0.this$0.getDrawer().setDepthWrite(true);
                        $receiver.setProjection(TransformsKt.perspective(this.$camera.getFov(), (double)this.this$0.this$0.getTargetWidth() * 1.0 / (double)this.this$0.this$0.getTargetHeight(), 0.1, 1400.0, this.$camera.getCenterX() * 0.1, this.$camera.getCenterY() * 0.1));
                        this.this$0.this$0.getPost().setProjection($receiver.getProjection());
                        this.this$0.this$0.getPost().setProjection(this.this$0.this$0.getDrawer().getProjection());
                        this.this$0.this$0.getPost().setAperture(this.$camera.getAperture());
                        this.this$0.this$0.getPost().setFocalPlane(this.$camera.getFocalPlane());
                        this.this$0.this$0.getPost().setExposure(this.$camera.getExposure());
                        this.this$0.this$0.getDrawer().setView(this.$camera.getViewMatrix());
                        this.this$0.this$0.getDrawer().setModel(Matrix44.Companion.getIDENTITY());
                        $receiver.background(ColorRGBa.Companion.getBLACK());
                        this.$drawFunction.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$camera = firstPersonCamera;
                        this.$drawFunction = function0;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = demo;
                super(2);
            }
        };
        Demo $receiver = demo = this;
        int n2 = 1;
        Iterable iterable = $receiver$iv2 = (Iterable)new IntRange(n2, 4);
        Object[] destination$iv$iv22 = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        Iterator iterator2 = $receiver$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            void it2;
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            objectArray = destination$iv$iv22;
            object7 = StringCompanionObject.INSTANCE;
            object6 = "%02d";
            object5 = new Object[]{(int)it2};
            object4 = new StringBuilder().append("data/tracks/display-");
            object3 = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format((String)object6, Arrays.copyOf(object5, ((Object[])object5).length)), "java.lang.String.format(format, *args)");
            object = ((CameraKeyframer.Companion)object3).fromFile(((StringBuilder)object4).append((String)object2).append(".json").toString());
            objectArray.add(object);
        }
        Object cameras = (List)destination$iv$iv22;
        DisplayLines displayLines = new DisplayLines();
        TexturedRectangle texturedRectangle = new TexturedRectangle(displayLines.getRt().colorBuffer(0), 0.0, 0.0, 6, null);
        Scheduler.task$default($receiver.scheduler, barDuration * (double)8, 0, 0.0, new Function1<TaskContext, Unit>($receiver, (List)cameras, displayLines, texturedRectangle, barDuration, drawPost$, backBox, floor2, font96){
            final /* synthetic */ Demo receiver$0;
            final /* synthetic */ List $cameras;
            final /* synthetic */ DisplayLines $displayLines;
            final /* synthetic */ TexturedRectangle $texturedRectangle;
            final /* synthetic */ double $barDuration$inlined;
            final /* synthetic */ schedule.2 $drawPost$2$inlined;
            final /* synthetic */ BackBox $backBox$inlined;
            final /* synthetic */ Floor $floor$inlined;
            final /* synthetic */ FontImageMap $font96$inlined;
            {
                this.receiver$0 = demo;
                this.$cameras = list;
                this.$displayLines = displayLines;
                this.$texturedRectangle = texturedRectangle;
                this.$barDuration$inlined = d;
                this.$drawPost$2$inlined = var7_6;
                this.$backBox$inlined = backBox;
                this.$floor$inlined = floor2;
                this.$font96$inlined = fontImageMap;
                super(1);
            }

            public final void invoke(@NotNull TaskContext it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getPurple03());
                FirstPersonCamera camera = new FirstPersonCamera().fromFrame(CameraKey.copy$default(((CameraKeyframer)this.$cameras.get((int)it2.getBar() / 2)).frame(it2.getBeat() % 8.0), null, null, 0.0, 0.0, 0.0, DemoKt.rampInOut(0.0, 8.0, 1.0, it2.getBeat() % 8.0), 0.0, 0.0, 0.0, null, 991, null));
                this.$drawPost$2$inlined.invoke(camera, new Function0<Unit>(this, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$1 this$0;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.$displayLines.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat());
                        this.this$0.$displayLines.getRt().colorBuffer(0).generateMipmaps();
                        RenderStyle renderStyle = new RenderStyle();
                        this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getBLACK());
                        this.this$0.$backBox$inlined.draw(this.this$0.receiver$0.getDrawer());
                        this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.1));
                        Floor.draw$default(this.this$0.$floor$inlined, this.this$0.receiver$0.getDrawer(), null, 2, null);
                        this.this$0.$texturedRectangle.draw(this.this$0.receiver$0.getDrawer());
                    }
                });
                this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                this.receiver$0.getDrawer().image(this.receiver$0.getResult());
                Writer w = new Writer(this.receiver$0.getDrawer());
                this.receiver$0.getDrawer().setFontMap(this.$font96$inlined);
                this.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().opacify(1.0));
                w.setBox(new Rectangle(new Vector2(100.0, 100.0), 1280.0, 720.0));
                w.newLine();
                DrawerKt.isolated(this.receiver$0.getDrawer(), (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this){
                    final /* synthetic */ schedule$$inlined$run$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Drawer $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        this.this$0.receiver$0.getDrawer().setShadeStyle(ShadeStyleKt.shadeStyle(schedule.3.1.INSTANCE));
                    }
                });
            }
        }, 6, null);
        $receiver.scheduler.complete();
        $receiver = demo = this;
        CrowdIntro crowd = new CrowdIntro();
        NoiseTable noiseTable22 = new NoiseTable(0, NoiseType.BROWNIAN, 0.8, 0.0, 9, null);
        int destination$iv$iv22 = 1;
        int n4 = 5;
        while (destination$iv$iv22 < n4) {
            void i;
            StringCompanionObject item$iv$iv = StringCompanionObject.INSTANCE;
            String it2 = "%02d";
            objectArray = new Object[]{(int)i};
            object7 = new StringBuilder().append("data/tracks/person-");
            object6 = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format(it2, Arrays.copyOf(objectArray, objectArray.length)), "java.lang.String.format(format, *args)");
            CameraKeyframer ckf = ((CameraKeyframer.Companion)object6).fromFile(((StringBuilder)object7).append((String)object5).append(".json").toString());
            Scheduler.task$default($receiver.scheduler, barDuration * (double)2, 0, 0.0, new Function1<TaskContext, Unit>($receiver, ckf, noiseTable22, crowd, barDuration, drawPost$, skyBox, cityFloor){
                final /* synthetic */ Demo receiver$0;
                final /* synthetic */ CameraKeyframer $ckf;
                final /* synthetic */ NoiseTable $noiseTable;
                final /* synthetic */ CrowdIntro $crowd;
                final /* synthetic */ double $barDuration$inlined;
                final /* synthetic */ schedule.2 $drawPost$2$inlined;
                final /* synthetic */ SkyBox $skyBox$inlined;
                final /* synthetic */ CityFloor $cityFloor$inlined;
                {
                    this.receiver$0 = demo;
                    this.$ckf = cameraKeyframer;
                    this.$noiseTable = noiseTable;
                    this.$crowd = crowdIntro;
                    this.$barDuration$inlined = d;
                    this.$drawPost$2$inlined = var7_6;
                    this.$skyBox$inlined = skyBox;
                    this.$cityFloor$inlined = cityFloor;
                    super(1);
                }

                public final void invoke(@NotNull TaskContext it2) {
                    CameraKey cameraKey;
                    Intrinsics.checkParameterIsNotNull(it2, "it");
                    CameraKey f = cameraKey = this.$ckf.frame(it2.getBeat() / 2.0);
                    Vector3 vector3 = this.$noiseTable.get(it2.getTime() * 2.29).times(2.0);
                    Vector3 vector32 = f.getPosition().plus(this.$noiseTable.get(it2.getTime() * 0.43).times(new Vector3(1.0, 1.0, 0.1)).times(0.05));
                    CameraKey cameraKey2 = f;
                    Vector3 r = vector3;
                    Quaternion quaternion = f.getOrientation().times(Quaternion.Companion.fromAngles(r.getX(), r.getY(), r.getZ() * 0.1));
                    CameraKey frame = CameraKey.copy$default(cameraKey2, vector32, quaternion, 0.0, 0.0, 0.0, DemoKt.rampInOut(0.0, 7.0, 1.0, it2.getBeat() % 8.0), 0.0, 0.0, 0.0, null, 988, null);
                    this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getCripWinter());
                    FirstPersonCamera camera = new FirstPersonCamera().fromFrame(frame);
                    this.$drawPost$2$inlined.invoke(camera, new Function0<Unit>(this, it2){
                        final /* synthetic */ schedule$$inlined$run$lambda$2 this$0;
                        final /* synthetic */ TaskContext $it;
                        {
                            this.this$0 = var1_1;
                            this.$it = taskContext;
                            super(0);
                        }

                        public final void invoke() {
                            RenderStyle renderStyle = new RenderStyle();
                            this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.02));
                            SkyBox.draw$default(this.this$0.$skyBox$inlined, this.this$0.receiver$0.getDrawer(), null, 2, null);
                            CityFloor.draw$default(this.this$0.$cityFloor$inlined, this.this$0.receiver$0.getDrawer(), null, 2, null);
                            this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.1 + 0.7 * DemoKt.rampInOut(2.0, 8.0, 0.25, this.$it.getBeat()) * (this.this$0.$noiseTable.get(this.$it.getTime() * 60.0).getX() * 0.5 + 0.5) + 0.5 * DemoKt.rampInOut(1.75, 2.75, 0.5, this.$it.getBeat())));
                            this.this$0.$crowd.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), renderStyle);
                        }
                    });
                    this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                    this.receiver$0.getDrawer().image(this.receiver$0.getResult());
                }
            }, 6, null);
            $receiver.scheduler.complete();
            ++i;
        }
        $receiver = demo = this;
        CrawlersBase crawlers = new CrawlersIntro();
        int noiseTable22 = 0;
        Iterable i = $receiver$iv = (Iterable)new IntRange(noiseTable22, 1);
        Iterable<Object> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator item$iv$iv = $receiver$iv$iv222.iterator();
        while (item$iv$iv.hasNext()) {
            void it3;
            int item$iv$iv2;
            int n5 = item$iv$iv2 = ((IntIterator)item$iv$iv).nextInt();
            object7 = destination$iv$iv;
            object6 = StringCompanionObject.INSTANCE;
            object5 = "%02d";
            object4 = new Object[]{(int)it3};
            object3 = new StringBuilder().append("data/tracks/crawler-intro-");
            object2 = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format((String)object5, Arrays.copyOf(object4, ((Object[])object4).length)), "java.lang.String.format(format, *args)");
            cameras = ((CameraKeyframer.Companion)object2).fromFile(((StringBuilder)object3).append((String)object).append(".json").toString());
            object7.add(cameras);
        }
        Object cameras2 = (List)destination$iv$iv;
        Scheduler.task$default($receiver.scheduler, patternDuration * (double)2, 0, 0.0, new Function1<TaskContext, Unit>($receiver, (List)cameras2, crawlers, patternDuration, drawPost$, backBox, floor2){
            final /* synthetic */ Demo receiver$0;
            final /* synthetic */ List $cameras;
            final /* synthetic */ CrawlersIntro $crawlers;
            final /* synthetic */ double $patternDuration$inlined;
            final /* synthetic */ schedule.2 $drawPost$2$inlined;
            final /* synthetic */ BackBox $backBox$inlined;
            final /* synthetic */ Floor $floor$inlined;
            {
                this.receiver$0 = demo;
                this.$cameras = list;
                this.$crawlers = crawlersIntro;
                this.$patternDuration$inlined = d;
                this.$drawPost$2$inlined = var6_5;
                this.$backBox$inlined = backBox;
                this.$floor$inlined = floor2;
                super(1);
            }

            public final void invoke(@NotNull TaskContext it2) {
                CameraKey cameraKey;
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getNeutral());
                if (it2.getBeat() < 4.0) {
                    this.receiver$0.getPost().setMoveThreshold(140.0);
                    this.receiver$0.getPost().setApplyMove(true);
                } else {
                    this.receiver$0.getPost().setApplyMove(false);
                }
                CameraKey f = cameraKey = ((CameraKeyframer)this.$cameras.get((int)it2.getBar() % 2)).frame(it2.getBeat());
                CameraKey camera = CameraKey.copy$default(f, null, null, 0.0, 0.0, 0.0, f.getExposure() * DemoKt.rampInOut(0.1, 4.0, 0.5, it2.getBeat() % 4.0), 0.0, 0.0, 0.0, null, 991, null);
                this.$drawPost$2$inlined.invoke(new FirstPersonCamera().fromFrame(camera), new Function0<Unit>(this, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$3 this$0;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.01));
                        this.this$0.$backBox$inlined.draw(this.this$0.receiver$0.getDrawer());
                        Floor.draw$default(this.this$0.$floor$inlined, this.this$0.receiver$0.getDrawer(), null, 2, null);
                        CrawlersBase.draw$default(this.this$0.$crawlers, this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), null, false, 12, null);
                    }
                });
                this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                this.receiver$0.getDrawer().image(this.receiver$0.getResult());
            }
        }, 6, null);
        $receiver.scheduler.complete();
        $receiver = demo = this;
        crawlers = new Crawlers();
        Crowd02 crowd22 = new Crowd02();
        int $receiver$iv$iv222 = 1;
        Iterable $receiver$iv3 = new IntRange($receiver$iv$iv222, 2);
        destination$iv$iv = $receiver$iv3;
        Iterator destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
        Iterator item$iv$iv2 = $receiver$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            void it4;
            int item$iv$iv3;
            int n6 = item$iv$iv3 = ((IntIterator)item$iv$iv2).nextInt();
            object6 = destination$iv$iv3;
            object5 = StringCompanionObject.INSTANCE;
            object4 = "%02d";
            object3 = new Object[]{(int)it4};
            object2 = new StringBuilder().append("data/tracks/crawler-carnage-");
            object = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format((String)object4, Arrays.copyOf(object3, ((Object[])object3).length)), "java.lang.String.format(format, *args)");
            cameras2 = ((CameraKeyframer.Companion)object).fromFile(((StringBuilder)object2).append((String)cameras).append(".json").toString());
            object6.add(cameras2);
        }
        List cameras3 = (List)((Object)destination$iv$iv3);
        Scheduler.task$default($receiver.scheduler, patternDuration * (double)2, 0, 0.0, new Function1<TaskContext, Unit>($receiver, cameras3, crowd22, (Crawlers)crawlers, patternDuration, lightMap2, drawLight$, drawPost$, backBox, floor2){
            final /* synthetic */ Demo receiver$0;
            final /* synthetic */ List $cameras;
            final /* synthetic */ Crowd02 $crowd;
            final /* synthetic */ Crawlers $crawlers;
            final /* synthetic */ double $patternDuration$inlined;
            final /* synthetic */ RenderTarget $lightMap$inlined;
            final /* synthetic */ schedule.1 $drawLight$1$inlined;
            final /* synthetic */ schedule.2 $drawPost$2$inlined;
            final /* synthetic */ BackBox $backBox$inlined;
            final /* synthetic */ Floor $floor$inlined;
            {
                this.receiver$0 = demo;
                this.$cameras = list;
                this.$crowd = crowd02;
                this.$crawlers = crawlers;
                this.$patternDuration$inlined = d;
                this.$lightMap$inlined = renderTarget;
                this.$drawLight$1$inlined = var8_7;
                this.$drawPost$2$inlined = var9_8;
                this.$backBox$inlined = backBox;
                this.$floor$inlined = floor2;
                super(1);
            }

            public final void invoke(@NotNull TaskContext it2) {
                Light light;
                CameraKey cameraKey;
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getCripWinter());
                RenderStyle renderStyle = new RenderStyle();
                CameraKey f = cameraKey = ((CameraKeyframer)this.$cameras.get((int)it2.getBar() % 2)).frame(it2.getBeat() % (double)28);
                CameraKey camera = CameraKey.copy$default(f, null, null, 0.0, 0.0, 0.0, f.getExposure() * DemoKt.rampInOut(0.1, 4.0, 0.5, it2.getBeat() % 4.0), 0.0, 0.0, 0.0, null, 991, null);
                FirstPersonCamera fps = new FirstPersonCamera().fromFrame(camera);
                Light $receiver = light = new Light();
                $receiver.setProjection(TransformsKt.ortho(-10.0, 10.0, -10.0, 10.0, 0.0, 100.0));
                $receiver.setView(TransformsKt.lookAt(fps.getPosition().plus(new Vector3(0.0, 10.0, 0.0)), camera.getPosition().plus(fps.getForward()).minus(new Vector3(0.0, 1.0, 0.0)), Vector3.Companion.getUNIT_Y()));
                $receiver.setMap(this.$lightMap$inlined.colorBuffer(0));
                Light light2 = light;
                this.$crowd.update(it2.getScheduleTime());
                this.$drawLight$1$inlined.invoke(this.$lightMap$inlined, light2, new Function0<Unit>(this, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$4 this$0;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.$crawlers.drawShadow(this.this$0.receiver$0.getDrawer(), this.$it.getBeat() % 8.0);
                        Crowd02.drawShadow$default(this.this$0.$crowd, this.this$0.receiver$0.getDrawer(), this.$it.getScheduleTime(), null, 4, null);
                    }
                });
                this.$drawPost$2$inlined.invoke(fps, new Function0<Unit>(this, renderStyle, it2, light2){
                    final /* synthetic */ schedule$$inlined$run$lambda$4 this$0;
                    final /* synthetic */ RenderStyle $renderStyle;
                    final /* synthetic */ TaskContext $it;
                    final /* synthetic */ Light $light;
                    {
                        this.this$0 = var1_1;
                        this.$renderStyle = renderStyle;
                        this.$it = taskContext;
                        this.$light = light;
                        super(0);
                    }

                    public final void invoke() {
                        this.$renderStyle.setObjectFill(ColorRGBa.Companion.getWHITE().shade(1.0 - this.$it.getTime() / this.$it.getDuration()));
                        this.$renderStyle.getLights().add(this.$light);
                        this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.05 * (1.0 - this.$it.getTime() / this.$it.getDuration())));
                        this.this$0.$backBox$inlined.draw(this.this$0.receiver$0.getDrawer());
                        this.this$0.$floor$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$renderStyle);
                        CrawlersBase.draw$default(this.this$0.$crawlers, this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), null, false, 4, null);
                        this.this$0.$crowd.draw(this.this$0.receiver$0.getDrawer(), this.$it.getScheduleTime(), this.$renderStyle);
                    }
                });
                if (it2.getBeat() < 2.0) {
                    this.receiver$0.getPost().setMoveThreshold(MappingKt.smoothstep(0.0, 0.5, 1.0 - it2.getBeat() / 2.0));
                    this.receiver$0.getPost().setApplyMove(true);
                } else {
                    this.receiver$0.getPost().setApplyMove(false);
                }
                this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                this.receiver$0.getDrawer().image(this.receiver$0.getResult());
            }
        }, 6, null);
        $receiver.scheduler.complete();
        $receiver = demo = this;
        CrawlersBase megaCrawlers = new MegaCrawlers();
        int crowd22 = 1;
        $receiver$iv3 = $receiver$iv22 = (Iterable)new IntRange(crowd22, 4);
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv22, 10));
        destination$iv$iv3 = $receiver$iv$iv.iterator();
        while (destination$iv$iv3.hasNext()) {
            void it5;
            int item$iv$iv3 = item$iv$iv = ((IntIterator)destination$iv$iv3).nextInt();
            Iterable<Object> iterable2 = destination$iv$iv;
            object6 = StringCompanionObject.INSTANCE;
            object5 = "%02d";
            object4 = new Object[]{(int)it5};
            object3 = new StringBuilder().append("data/tracks/city-scan-");
            object2 = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format((String)object5, Arrays.copyOf(object4, ((Object[])object4).length)), "java.lang.String.format(format, *args)");
            cameras = ((CameraKeyframer.Companion)object2).fromFile(((StringBuilder)object3).append((String)object).append(".json").toString());
            iterable2.add(cameras);
        }
        cameras2 = (List)destination$iv$iv;
        Scheduler.task$default($receiver.scheduler, patternDuration * (double)2, 0, 0.0, new Function1<TaskContext, Unit>($receiver, (List)cameras2, megaCrawlers, patternDuration, drawPost$, skyBox, cityFloor, city){
            final /* synthetic */ Demo receiver$0;
            final /* synthetic */ List $cameras;
            final /* synthetic */ MegaCrawlers $megaCrawlers;
            final /* synthetic */ double $patternDuration$inlined;
            final /* synthetic */ schedule.2 $drawPost$2$inlined;
            final /* synthetic */ SkyBox $skyBox$inlined;
            final /* synthetic */ CityFloor $cityFloor$inlined;
            final /* synthetic */ City $city$inlined;
            {
                this.receiver$0 = demo;
                this.$cameras = list;
                this.$megaCrawlers = megaCrawlers;
                this.$patternDuration$inlined = d;
                this.$drawPost$2$inlined = var6_5;
                this.$skyBox$inlined = skyBox;
                this.$cityFloor$inlined = cityFloor;
                this.$city$inlined = city;
                super(1);
            }

            public final void invoke(@NotNull TaskContext it2) {
                double d;
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getNeutral());
                RenderStyle renderStyle = new RenderStyle();
                double d2 = d = it2.getBeat();
                renderStyle.setSkyIntensity(d2 >= 0.0 && d2 <= 8.0 ? 0.25 : ((d2 = d) >= 8.0 && d2 <= 16.0 ? 0.125 : 0.0685));
                CameraKey frame = CameraKey.copy$default(((CameraKeyframer)this.$cameras.get((int)(it2.getBar() / (double)2) % 4)).frame(it2.getBeat() % 8.0), null, null, 0.0, 0.0, 0.0, DemoKt.rampInOut(0.0, 8.0, 1.0, it2.getBeat() % 8.0), 0.0, 0.0, 0.0, null, 991, null);
                this.$drawPost$2$inlined.invoke(new FirstPersonCamera().fromFrame(frame), new Function0<Unit>(this, renderStyle, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$5 this$0;
                    final /* synthetic */ RenderStyle $renderStyle;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$renderStyle = renderStyle;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.receiver$0.getDrawer().setFill(new ColorRGBa(0.5, 0.7, 1.0, 0.0, null, 24, null).shade(0.05));
                        this.this$0.$skyBox$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$renderStyle);
                        this.this$0.$cityFloor$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$renderStyle);
                        this.this$0.$city$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), this.$renderStyle);
                        CrawlersBase.draw$default(this.this$0.$megaCrawlers, this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), null, false, 12, null);
                    }
                });
                this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                this.receiver$0.getDrawer().image(this.receiver$0.getResult());
            }
        }, 6, null);
        $receiver.scheduler.complete();
        $receiver = demo = this;
        megaCrawlers = new MegaCrawlers();
        int $receiver$iv22 = 1;
        $receiver$iv$iv = $receiver$iv32 = (Iterable)new IntRange($receiver$iv22, 4);
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv32, 10));
        destination$iv$iv3 = $receiver$iv$iv.iterator();
        while (destination$iv$iv3.hasNext()) {
            int it5 = item$iv$iv = ((IntIterator)destination$iv$iv3).nextInt();
            Iterable<Object> iterable3 = destination$iv$iv;
            object6 = StringCompanionObject.INSTANCE;
            object5 = "%02d";
            object4 = new Object[]{it5};
            object3 = new StringBuilder().append("data/tracks/city-fly-");
            object2 = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format((String)object5, Arrays.copyOf(object4, ((Object[])object4).length)), "java.lang.String.format(format, *args)");
            cameras = ((CameraKeyframer.Companion)object2).fromFile(((StringBuilder)object3).append((String)object).append(".json").toString());
            iterable3.add((Object)cameras);
        }
        cameras2 = (List)destination$iv$iv;
        Scheduler.task$default($receiver.scheduler, patternDuration * (double)2, 0, 0.0, new Function1<TaskContext, Unit>($receiver, megaCrawlers, (List)cameras2, patternDuration, lightMap2, drawLight$, drawPost$, skyBox, cityFloor, city){
            final /* synthetic */ Demo receiver$0;
            final /* synthetic */ MegaCrawlers $megaCrawlers;
            final /* synthetic */ List $cameras;
            final /* synthetic */ double $patternDuration$inlined;
            final /* synthetic */ RenderTarget $lightMap$inlined;
            final /* synthetic */ schedule.1 $drawLight$1$inlined;
            final /* synthetic */ schedule.2 $drawPost$2$inlined;
            final /* synthetic */ SkyBox $skyBox$inlined;
            final /* synthetic */ CityFloor $cityFloor$inlined;
            final /* synthetic */ City $city$inlined;
            {
                this.receiver$0 = demo;
                this.$megaCrawlers = megaCrawlers;
                this.$cameras = list;
                this.$patternDuration$inlined = d;
                this.$lightMap$inlined = renderTarget;
                this.$drawLight$1$inlined = var7_6;
                this.$drawPost$2$inlined = var8_7;
                this.$skyBox$inlined = skyBox;
                this.$cityFloor$inlined = cityFloor;
                this.$city$inlined = city;
                super(1);
            }

            public final void invoke(@NotNull TaskContext it2) {
                Light light;
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getNeutral());
                Light $receiver = light = new Light();
                $receiver.setProjection(TransformsKt.ortho(-500.0, 500.0, -500.0, 500.0, 0.0, 500.0));
                $receiver.setView(TransformsKt.lookAt(new Vector3(0.0, 500.0, -300.0), new Vector3(0.0, 0.0, -300.0), Vector3.Companion.getUNIT_Z()));
                $receiver.setMap(this.$lightMap$inlined.colorBuffer(0));
                Light light2 = light;
                this.$drawLight$1$inlined.invoke(this.$lightMap$inlined, light2, new Function0<Unit>(this, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$6 this$0;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.$megaCrawlers.drawShadow(this.this$0.receiver$0.getDrawer(), this.$it.getBeat() % 8.0);
                    }
                });
                CameraKey frame = CameraKey.copy$default(((CameraKeyframer)this.$cameras.get((int)(it2.getBar() / (double)2) % 4)).frame(it2.getBeat() % 8.0), null, null, 0.0, 0.0, 0.0, DemoKt.rampInOut(0.0, 8.0, 1.0, it2.getBeat() % 8.0), 0.0, 0.0, 0.0, null, 991, null);
                this.$drawPost$2$inlined.invoke(new FirstPersonCamera().fromFrame(frame), new Function0<Unit>(this, light2, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$6 this$0;
                    final /* synthetic */ Light $light;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$light = light;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        RenderStyle renderStyle = new RenderStyle();
                        renderStyle.getLights().add(this.$light);
                        renderStyle.setSkyIntensity(0.0685);
                        this.this$0.receiver$0.getDrawer().setFill(new ColorRGBa(0.5, 0.7, 1.0, 0.0, null, 24, null).shade(0.05));
                        this.this$0.$skyBox$inlined.draw(this.this$0.receiver$0.getDrawer(), renderStyle);
                        this.this$0.$cityFloor$inlined.draw(this.this$0.receiver$0.getDrawer(), renderStyle);
                        this.this$0.$city$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), renderStyle);
                        CrawlersBase.draw$default(this.this$0.$megaCrawlers, this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), null, false, 12, null);
                    }
                });
                this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                this.receiver$0.getDrawer().image(this.receiver$0.getResult());
            }
        }, 6, null);
        $receiver.scheduler.complete();
        $receiver = demo = this;
        megaCrawlers = new MegaMarchingCrawlers();
        int $receiver$iv32 = 1;
        $receiver$iv$iv = $receiver$iv = (Iterable)new IntRange($receiver$iv32, 4);
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        destination$iv$iv3 = $receiver$iv$iv.iterator();
        while (destination$iv$iv3.hasNext()) {
            int it6 = item$iv$iv4 = ((IntIterator)destination$iv$iv3).nextInt();
            Iterable<Object> iterable4 = destination$iv$iv;
            object6 = StringCompanionObject.INSTANCE;
            object5 = "%02d";
            object4 = new Object[]{it6};
            object3 = new StringBuilder().append("data/tracks/city-march-");
            object2 = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format((String)object5, Arrays.copyOf(object4, ((Object[])object4).length)), "java.lang.String.format(format, *args)");
            cameras = ((CameraKeyframer.Companion)object2).fromFile(((StringBuilder)object3).append((String)object).append(".json").toString());
            iterable4.add((Object)cameras);
        }
        cameras2 = (List)destination$iv$iv;
        Scheduler.task$default($receiver.scheduler, patternDuration * (double)2, 0, 0.0, new Function1<TaskContext, Unit>($receiver, (List)cameras2, (MegaMarchingCrawlers)megaCrawlers, patternDuration, lightMap2, drawLight$, drawPost$, skyBox, cityFloor, city){
            final /* synthetic */ Demo receiver$0;
            final /* synthetic */ List $cameras;
            final /* synthetic */ MegaMarchingCrawlers $megaCrawlers;
            final /* synthetic */ double $patternDuration$inlined;
            final /* synthetic */ RenderTarget $lightMap$inlined;
            final /* synthetic */ schedule.1 $drawLight$1$inlined;
            final /* synthetic */ schedule.2 $drawPost$2$inlined;
            final /* synthetic */ SkyBox $skyBox$inlined;
            final /* synthetic */ CityFloor $cityFloor$inlined;
            final /* synthetic */ City $city$inlined;
            {
                this.receiver$0 = demo;
                this.$cameras = list;
                this.$megaCrawlers = megaMarchingCrawlers;
                this.$patternDuration$inlined = d;
                this.$lightMap$inlined = renderTarget;
                this.$drawLight$1$inlined = var7_6;
                this.$drawPost$2$inlined = var8_7;
                this.$skyBox$inlined = skyBox;
                this.$cityFloor$inlined = cityFloor;
                this.$city$inlined = city;
                super(1);
            }

            public final void invoke(@NotNull TaskContext it2) {
                Light light;
                Intrinsics.checkParameterIsNotNull(it2, "it");
                CameraKey frame = CameraKey.copy$default(((CameraKeyframer)this.$cameras.get((int)(it2.getBar() / (double)2) % 4)).frame(it2.getBeat() % 8.0), null, null, 0.0, 0.0, 0.0, DemoKt.rampInOut(0.0, 8.0, 1.0, it2.getBeat() % 8.0), 0.0, 0.0, 0.0, null, 991, null);
                this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getPurple03());
                Light $receiver = light = new Light();
                $receiver.setProjection(TransformsKt.ortho(-500.0, 500.0, -500.0, 500.0, 0.0, 500.0));
                $receiver.setView(TransformsKt.lookAt(new Vector3(0.0, 500.0, -300.0), new Vector3(0.0, 0.0, -300.0), Vector3.Companion.getUNIT_Z()));
                $receiver.setMap(this.$lightMap$inlined.colorBuffer(0));
                Light light2 = light;
                this.$drawLight$1$inlined.invoke(this.$lightMap$inlined, light2, new Function0<Unit>(this, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$7 this$0;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.$megaCrawlers.drawShadow(this.this$0.receiver$0.getDrawer(), this.$it.getBeat() % 8.0);
                    }
                });
                this.$drawPost$2$inlined.invoke(new FirstPersonCamera().fromFrame(frame), new Function0<Unit>(this, light2, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$7 this$0;
                    final /* synthetic */ Light $light;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$light = light;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        RenderStyle renderStyle = new RenderStyle();
                        renderStyle.getLights().add(this.$light);
                        renderStyle.setSkyIntensity(this.$it.getBeat() % 2.0 < 1.0 ? 0.274 : (1.0 - (this.$it.getBeat() % 2.0 - 1.0)) * 0.4 + 0.274);
                        this.this$0.receiver$0.getDrawer().setFill(new ColorRGBa(0.5, 0.7, 1.0, 0.0, null, 24, null).shade(0.05));
                        this.this$0.$skyBox$inlined.draw(this.this$0.receiver$0.getDrawer(), renderStyle);
                        this.this$0.$cityFloor$inlined.draw(this.this$0.receiver$0.getDrawer(), renderStyle);
                        this.this$0.$city$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), renderStyle);
                        this.this$0.$megaCrawlers.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat() % 8.0, renderStyle, false);
                    }
                });
                this.receiver$0.getPost().setApplyMove(true);
                this.receiver$0.getPost().setMoveThreshold(DemoKt.rampInOut(-0.5, 0.75, 0.5, it2.getBeat() % 2.0));
                this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                this.receiver$0.getDrawer().image(this.receiver$0.getResult());
            }
        }, 6, null);
        $receiver.scheduler.complete();
        $receiver = demo = this;
        int megaCrawlers2 = 4;
        $receiver$iv = $receiver$iv = (Iterable)new IntRange(megaCrawlers2, 4);
        Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator3 = $receiver$iv$iv.iterator();
        while (iterator3.hasNext()) {
            void it7;
            int item$iv$iv4 = item$iv$iv = ((IntIterator)iterator3).nextInt();
            Collection collection = destination$iv$iv322;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            object6 = "%02d";
            object5 = new Object[]{(int)it7};
            object4 = new StringBuilder().append("data/tracks/city-");
            object3 = CameraKeyframer.Companion;
            Intrinsics.checkExpressionValueIsNotNull(String.format((String)object6, Arrays.copyOf(object5, ((Object[])object5).length)), "java.lang.String.format(format, *args)");
            object = ((CameraKeyframer.Companion)object3).fromFile(((StringBuilder)object4).append((String)object2).append(".json").toString());
            collection.add(object);
        }
        cameras = (List)destination$iv$iv322;
        Scheduler.task$default($receiver.scheduler, barDuration * (double)2, 0, 0.0, new Function1<TaskContext, Unit>($receiver, (List)cameras, barDuration, drawPost$, skyBox, cityFloor, city){
            final /* synthetic */ Demo receiver$0;
            final /* synthetic */ List $cameras;
            final /* synthetic */ double $barDuration$inlined;
            final /* synthetic */ schedule.2 $drawPost$2$inlined;
            final /* synthetic */ SkyBox $skyBox$inlined;
            final /* synthetic */ CityFloor $cityFloor$inlined;
            final /* synthetic */ City $city$inlined;
            {
                this.receiver$0 = demo;
                this.$cameras = list;
                this.$barDuration$inlined = d;
                this.$drawPost$2$inlined = var5_4;
                this.$skyBox$inlined = skyBox;
                this.$cityFloor$inlined = cityFloor;
                this.$city$inlined = city;
                super(1);
            }

            public final void invoke(@NotNull TaskContext it2) {
                double d;
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getCripWinter());
                RenderStyle renderStyle = new RenderStyle();
                double d2 = d = it2.getBeat();
                renderStyle.setSkyIntensity(d2 >= 0.0 && d2 <= 8.0 ? 0.25 : ((d2 = d) >= 8.0 && d2 <= 16.0 ? 0.125 : 0.0685));
                CameraKey frame = CameraKey.copy$default(((CameraKeyframer)this.$cameras.get((int)(it2.getBar() / (double)2) % 4)).frame(it2.getBeat() / 2.0 % 8.0), null, null, 0.0, 0.0, 0.0, DemoKt.rampInOut(0.0, 8.0, 1.0, it2.getBeat() / 2.0 % 8.0), 0.0, 0.0, 0.0, null, 991, null);
                this.$drawPost$2$inlined.invoke(new FirstPersonCamera().fromFrame(frame), new Function0<Unit>(this, renderStyle, it2){
                    final /* synthetic */ schedule$$inlined$run$lambda$8 this$0;
                    final /* synthetic */ RenderStyle $renderStyle;
                    final /* synthetic */ TaskContext $it;
                    {
                        this.this$0 = var1_1;
                        this.$renderStyle = renderStyle;
                        this.$it = taskContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.receiver$0.getDrawer().setFill(new ColorRGBa(0.5, 0.7, 1.0, 0.0, null, 24, null).shade(0.05));
                        this.$renderStyle.setLightDensity(1.0 - this.$it.getBeat() / 16.0);
                        this.this$0.$skyBox$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$renderStyle);
                        this.this$0.$cityFloor$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$renderStyle);
                        this.this$0.$city$inlined.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), this.$renderStyle);
                    }
                });
                this.receiver$0.getPost().setApplyMove(it2.getBeat() < 1.0);
                this.receiver$0.getPost().setMoveThreshold(1.0);
                this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                this.receiver$0.getDrawer().image(this.receiver$0.getResult());
            }
        }, 6, null);
        $receiver.scheduler.complete();
        $receiver = demo = this;
        CrowdOutro crowd3 = new CrowdOutro();
        NoiseTable noiseTable = new NoiseTable(0, NoiseType.BROWNIAN, 0.8, 0.0, 9, null);
        boolean destination$iv$iv322 = false;
        boolean bl = true;
        while (destination$iv$iv322 < bl) {
            CameraKeyframer ckf = CameraKeyframer.Companion.fromFile("data/tracks/crowd-outro.json");
            Scheduler.task$default($receiver.scheduler, barDuration * (double)6, 0, 0.0, new Function1<TaskContext, Unit>($receiver, ckf, noiseTable, crowd3, barDuration, drawPost$, skyBox){
                final /* synthetic */ Demo receiver$0;
                final /* synthetic */ CameraKeyframer $ckf;
                final /* synthetic */ NoiseTable $noiseTable;
                final /* synthetic */ CrowdOutro $crowd;
                final /* synthetic */ double $barDuration$inlined;
                final /* synthetic */ schedule.2 $drawPost$2$inlined;
                final /* synthetic */ SkyBox $skyBox$inlined;
                {
                    this.receiver$0 = demo;
                    this.$ckf = cameraKeyframer;
                    this.$noiseTable = noiseTable;
                    this.$crowd = crowdOutro;
                    this.$barDuration$inlined = d;
                    this.$drawPost$2$inlined = var7_6;
                    this.$skyBox$inlined = skyBox;
                    super(1);
                }

                public final void invoke(@NotNull TaskContext it2) {
                    CameraKey cameraKey;
                    Intrinsics.checkParameterIsNotNull(it2, "it");
                    CameraKey f = cameraKey = this.$ckf.frame(it2.getBeat() / 2.0);
                    CameraKey frame = CameraKey.copy$default(f, f.getPosition().plus(this.$noiseTable.get(it2.getTime() * 0.43).times(new Vector3(1.0, 1.0, 0.1)).times(0.005)), null, 0.0, 0.0, 0.0, (this.$noiseTable.get(it2.getTime() * 14.0).getX() + 1.0) * DemoKt.rampInOut(0.0, 20.0, 2.0, it2.getBeat()), 0.0, 0.0, 0.0, null, 990, null);
                    this.receiver$0.getPost().setLut(this.receiver$0.getPost().getLuts().getHorrorBlue());
                    FirstPersonCamera camera = new FirstPersonCamera().fromFrame(frame);
                    this.$drawPost$2$inlined.invoke(camera, new Function0<Unit>(this, it2){
                        final /* synthetic */ schedule$$inlined$run$lambda$9 this$0;
                        final /* synthetic */ TaskContext $it;
                        {
                            this.this$0 = var1_1;
                            this.$it = taskContext;
                            super(0);
                        }

                        public final void invoke() {
                            RenderStyle renderStyle = new RenderStyle();
                            renderStyle.setSkyIntensity(0.05);
                            this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.02));
                            this.this$0.$skyBox$inlined.draw(this.this$0.receiver$0.getDrawer(), renderStyle);
                            this.this$0.receiver$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.2));
                            this.this$0.$crowd.draw(this.this$0.receiver$0.getDrawer(), this.$it.getBeat(), renderStyle);
                        }
                    });
                    this.receiver$0.getPost().apply(this.receiver$0.getGbuffer(), this.receiver$0.getResult(), it2.getTime());
                    this.receiver$0.getDrawer().image(this.receiver$0.getResult());
                }
            }, 6, null);
            $receiver.scheduler.complete();
            ++i;
        }
    }

    public final boolean getFreakMode() {
        return this.freakMode;
    }

    public final void setFreakMode(boolean bl) {
        this.freakMode = bl;
    }

    public final int getFreakDuration() {
        return this.freakDuration;
    }

    public final void setFreakDuration(int n2) {
        this.freakDuration = n2;
    }

    public final long getLastFreak() {
        return this.lastFreak;
    }

    public final void setLastFreak(long l) {
        this.lastFreak = l;
    }

    public final double getFreakPitch() {
        return this.freakPitch;
    }

    public final void setFreakPitch(double d) {
        this.freakPitch = d;
    }

    public final int getFreakMethod() {
        return this.freakMethod;
    }

    public final void setFreakMethod(int n2) {
        this.freakMethod = n2;
    }

    @Override
    public void draw() {
        double d;
        if (!this.dumpVideo) {
            Channel channel = this.channel;
            if (channel == null) {
                Intrinsics.throwUninitializedPropertyAccessException("channel");
            }
            if (channel.getPosition() > (double)136) {
                this.freakMode = true;
            }
        }
        if (this.freakMode && System.currentTimeMillis() - this.lastFreak > (long)this.freakDuration) {
            if (this.freakMethod == 0) {
                this.freakDuration = (int)(Math.random() * (double)1000) + 1000;
                this.freakPitch = Math.random() * (double)22000 + (double)22000;
                Channel channel = this.channel;
                if (channel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("channel");
                }
                channel.setPosition(Math.random() * 130.0);
                Channel channel2 = this.channel;
                if (channel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("channel");
                }
                channel2.setPitch(this.freakPitch);
                this.lastFreak = System.currentTimeMillis();
                PostProcessor postProcessor = this.post;
                if (postProcessor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("post");
                }
                postProcessor.setFreakMode(true);
                if (Math.random() < 0.5) {
                    this.freakMethod = 1;
                }
            } else {
                PostProcessor postProcessor = this.post;
                if (postProcessor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("post");
                }
                postProcessor.setFreakMode(false);
                this.freakDuration = (int)(Math.random() * (double)100);
                this.lastFreak = System.currentTimeMillis();
                this.freakPitch = Math.random() * (double)42000 + (double)22000;
                Channel channel = this.channel;
                if (channel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("channel");
                }
                channel.setPosition(Math.random() * 130.0);
                Channel channel3 = this.channel;
                if (channel3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("channel");
                }
                channel3.setPitch(this.freakPitch);
                if (Math.random() < 0.01) {
                    this.freakMethod = 0;
                }
            }
        }
        if (this.freakMode && this.freakMethod == 0) {
            PostProcessor postProcessor = this.post;
            if (postProcessor == null) {
                Intrinsics.throwUninitializedPropertyAccessException("post");
            }
            postProcessor.setFreakMode(true);
        }
        if (!this.freakMode) {
            PostProcessor postProcessor = this.post;
            if (postProcessor == null) {
                Intrinsics.throwUninitializedPropertyAccessException("post");
            }
            postProcessor.setFreakMode(false);
        }
        if (this.freakMode && this.freakMethod == 0) {
            Channel channel = this.channel;
            if (channel == null) {
                Intrinsics.throwUninitializedPropertyAccessException("channel");
            }
            channel.setPitch(this.freakPitch);
            this.freakPitch *= 0.99;
        }
        RenderTarget renderTarget = this.finalTarget;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("finalTarget");
        }
        renderTarget.bind();
        Drawer drawer = this.getDrawer();
        RenderTarget renderTarget2 = this.finalTarget;
        if (renderTarget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("finalTarget");
        }
        drawer.ortho(renderTarget2);
        this.getDrawer().background(ColorRGBa.Companion.getBLACK());
        if (this.dumpVideo) {
            FrameClock frameClock = this.frameClock;
            if (frameClock == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameClock");
            }
            d = (double)frameClock.getTime() / 1000.0;
        } else {
            Channel channel = this.channel;
            if (channel == null) {
                Intrinsics.throwUninitializedPropertyAccessException("channel");
            }
            d = channel.getPosition();
        }
        double time = d;
        this.scheduler.update(time);
        if (this.showDebug) {
            this.getDrawer().ortho();
            this.getDrawer().setView(Matrix44.Companion.getIDENTITY());
            this.getDrawer().setFontMap(FontImageMap.Companion.fromUrl("file:data/fonts/IBMPlexMono-Bold.ttf", 16.0, this.getWindow().getScale().getX()));
            this.getDrawer().text("position: " + time, 40.0, 40.0);
            Drawer drawer2 = this.getDrawer();
            PostProcessor postProcessor = this.post;
            if (postProcessor == null) {
                Intrinsics.throwUninitializedPropertyAccessException("post");
            }
            drawer2.image(postProcessor.getColorLookup().getLookup());
        }
        double beat = time * (this.scheduler.getBpm() / 60.0);
        DrawerKt.isolated(this.getDrawer(), (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, beat){
            final /* synthetic */ Demo this$0;
            final /* synthetic */ double $beat;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                FontImageMap font16 = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, "file:data/fonts/CooperHewitt-Heavy.otf", 16.0, 0.0, 4, null);
                this.this$0.getDrawer().setFontMap(font16);
                Writer w = new Writer(this.this$0.getDrawer());
                double tw = w.textWidth(this.this$0.getSubtitles().get((int)this.$beat / 4));
                int subIndex = (int)this.$beat / 4;
                if (subIndex != 58) {
                    this.this$0.getDrawer().text(this.this$0.getSubtitles().get(subIndex), (double)this.this$0.getTargetWidth() / 2.0 - tw / 2.0, (double)this.this$0.getTargetHeight() - 50.0);
                } else {
                    double l = this.$beat / 4.0 - (double)((int)this.$beat / 4);
                    int li = (int)((double)this.this$0.getSubtitles().get(subIndex).length() * l);
                    String string = this.this$0.getSubtitles().get(subIndex);
                    int n2 = 0;
                    Drawer drawer = this.this$0.getDrawer();
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n2, li);
                    Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = string3;
                    drawer.text(string4, (double)this.this$0.getTargetWidth() / 2.0 - tw / 2.0, (double)this.this$0.getTargetHeight() - 50.0);
                }
            }
            {
                this.this$0 = demo;
                this.$beat = d;
                super(1);
            }
        });
        RenderTarget renderTarget3 = this.finalTarget;
        if (renderTarget3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("finalTarget");
        }
        renderTarget3.unbind();
        Drawer drawer3 = this.getDrawer();
        RenderTarget renderTarget4 = this.finalTarget;
        if (renderTarget4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("finalTarget");
        }
        drawer3.ortho(renderTarget4);
        Drawer drawer4 = this.getDrawer();
        RenderTarget renderTarget5 = this.finalTarget;
        if (renderTarget5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("finalTarget");
        }
        drawer4.image(renderTarget5.colorBuffer(0));
        if (this.dumpVideo) {
            FrameClock frameClock = this.frameClock;
            if (frameClock == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frameClock");
            }
            frameClock.next();
        }
    }

    @NotNull
    public static final /* synthetic */ Scheduler access$getScheduler$p(Demo $this) {
        return $this.scheduler;
    }
}

