/*
 * Decompiled with CFR 0.152.
 */
package scenes;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.WrapMode;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import scenes.CityFloor;
import scenes.RenderStyle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006 "}, d2={"Lscenes/CityFloor;", "", "irradiance", "Lorg/openrndr/draw/Cubemap;", "width", "", "depth", "(Lorg/openrndr/draw/Cubemap;DD)V", "floor", "Lorg/openrndr/draw/VertexBuffer;", "getFloor", "()Lorg/openrndr/draw/VertexBuffer;", "getIrradiance", "()Lorg/openrndr/draw/Cubemap;", "normalMap", "Lorg/openrndr/draw/ColorBuffer;", "getNormalMap", "()Lorg/openrndr/draw/ColorBuffer;", "previousModelView", "Lorg/openrndr/math/Matrix44;", "getPreviousModelView", "()Lorg/openrndr/math/Matrix44;", "setPreviousModelView", "(Lorg/openrndr/math/Matrix44;)V", "texture", "getTexture", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "renderStyle", "Lscenes/RenderStyle;", "demo-strap"})
public final class CityFloor {
    @NotNull
    private final ColorBuffer texture;
    @NotNull
    private final ColorBuffer normalMap;
    @NotNull
    private Matrix44 previousModelView;
    @NotNull
    private final VertexBuffer floor;
    @NotNull
    private final Cubemap irradiance;

    @NotNull
    public final ColorBuffer getTexture() {
        return this.texture;
    }

    @NotNull
    public final ColorBuffer getNormalMap() {
        return this.normalMap;
    }

    @NotNull
    public final Matrix44 getPreviousModelView() {
        return this.previousModelView;
    }

    public final void setPreviousModelView(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.previousModelView = matrix44;
    }

    @NotNull
    public final VertexBuffer getFloor() {
        return this.floor;
    }

    public final void draw(@NotNull Drawer drawer, @NotNull RenderStyle renderStyle) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(renderStyle, "renderStyle");
        RenderTarget gbuffer = RenderTarget.Companion.getActive();
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer, renderStyle, gbuffer){
            final /* synthetic */ CityFloor this$0;
            final /* synthetic */ Drawer $drawer;
            final /* synthetic */ RenderStyle $renderStyle;
            final /* synthetic */ RenderTarget $gbuffer;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this){
                    final /* synthetic */ draw.1 this$0;

                    public final void invoke(@NotNull ShadeStyle $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                        $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                ");
                        $receiver.setVertexTransform("\n                    previousView = (p_previousModelView * vec4(x_position,1.0));\n                    previousClip = u_projectionMatrix * previousView;\n                    currentClip = u_projectionMatrix * u_viewMatrix * u_modelMatrix * vec4(x_position, 1.0);\n                ");
                        $receiver.setFragmentTransform("\n                    vec2 uv = va_position.xz*0.1;\n\n                    float normalFactor = max(1.0 + v_viewPosition.z/100.0, 0.0);\n                    vec3 normal = normalize(\n                                        mix( vec3(0.0, 1.0, 0.0), texture(p_normalMap, uv).xzy - vec3(0.5, 0.0, 0.5), 1.0-normalFactor)\n                    );\n\n                    x_fill.rgb = pow(texture(p_irradiance, normalize(v_worldNormal)).rgb, vec3(1.0))*0.01;\n                    vec3 color = pow(texture(p_textureMap, uv).rgb, vec3(2.2))*0.05;\n\n                    mat3 tbn = mat3(u_viewNormalMatrix * u_modelNormalMatrix);\n\n                    //x_fill.rgb = color;\n                    o_position.xyz = v_viewPosition.xyz;\n                    o_position.w = max(-1.0, v_viewPosition.z/400.0);\n\n                    o_normal.xyz = tbn * normal;\n                    o_velocity.xy = vec2(0.0, 0.0);\n                    o_normal.w = 1.0;////max(1.0 + v_viewPosition.z/100.0, 0.0);\n\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.08;\n\n                    float haze = min(1.0, -v_viewPosition.z/400.0);\n                    vec3 viewDirection = normalize(inverse(mat3(u_viewNormalMatrix)) * v_viewPosition);\n                    vec3 hazeColor = texture(p_irradiance, viewDirection).rgb * p_skyIntensity;\n                    x_fill.rgb = mix(max(vec3(0.0), x_fill.rgb), hazeColor, haze);\n                ");
                        this.this$0.this$0.getNormalMap().setWrapU(WrapMode.REPEAT);
                        this.this$0.this$0.getNormalMap().setWrapV(WrapMode.REPEAT);
                        this.this$0.this$0.getTexture().setWrapU(WrapMode.REPEAT);
                        this.this$0.this$0.getTexture().setWrapV(WrapMode.REPEAT);
                        $receiver.parameter("normalMap", this.this$0.this$0.getNormalMap());
                        $receiver.parameter("textureMap", this.this$0.this$0.getTexture());
                        $receiver.parameter("irradiance", this.this$0.this$0.getIrradiance());
                        $receiver.parameter("skyIntensity", this.this$0.$renderStyle.getSkyIntensity());
                        $receiver.output("position", this.this$0.$gbuffer.colorBufferIndex("position"));
                        $receiver.output("normal", this.this$0.$gbuffer.colorBufferIndex("normal"));
                        $receiver.output("velocity", this.this$0.$gbuffer.colorBufferIndex("velocity"));
                        $receiver.parameter("previousModelView", this.this$0.this$0.getPreviousModelView());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                Drawer.vertexBuffer$default(this.$drawer, this.this$0.getFloor(), DrawPrimitive.TRIANGLES, 0, 0, 12, null);
                this.this$0.setPreviousModelView(this.$drawer.getView().times(this.$drawer.getModel()));
            }
            {
                this.this$0 = cityFloor;
                this.$drawer = drawer;
                this.$renderStyle = renderStyle;
                this.$gbuffer = renderTarget;
                super(1);
            }
        });
    }

    public static /* bridge */ /* synthetic */ void draw$default(CityFloor cityFloor, Drawer drawer, RenderStyle renderStyle, int n2, Object object) {
        if ((n2 & 2) != 0) {
            renderStyle = new RenderStyle();
        }
        cityFloor.draw(drawer, renderStyle);
    }

    @NotNull
    public final Cubemap getIrradiance() {
        return this.irradiance;
    }

    public CityFloor(@NotNull Cubemap irradiance, final double width, final double depth) {
        Intrinsics.checkParameterIsNotNull(irradiance, "irradiance");
        this.irradiance = irradiance;
        this.texture = ColorBuffer.Companion.fromUrl("file:data/textures/ground.png");
        this.normalMap = ColorBuffer.Companion.fromUrl("file:data/textures/ground_normal.png");
        this.previousModelView = Matrix44.Companion.getIDENTITY();
        this.floor = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(floor.1.INSTANCE), 6);
        this.floor.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Vector3 p00 = new Vector3(-width / 2.0, 0.0, -depth / 2.0);
                Vector3 p10 = new Vector3(width / 2.0, 0.0, -depth / 2.0);
                Vector3 p11 = new Vector3(width / 2.0, 0.0, depth / 2.0);
                Vector3 p01 = new Vector3(-width / 2.0, 0.0, depth / 2.0);
                Vector2 t00 = new Vector2(0.0, 0.0);
                Vector2 t10 = new Vector2(1.0, 0.0);
                Vector2 t11 = new Vector2(1.0, 1.0);
                Vector2 t01 = new Vector2(0.0, 1.0);
                Vector3 n2 = Vector3.Companion.getUNIT_Y();
                $receiver.write(p00);
                $receiver.write(n2);
                $receiver.write(t00);
                $receiver.write(p10);
                $receiver.write(n2);
                $receiver.write(t10);
                $receiver.write(p11);
                $receiver.write(n2);
                $receiver.write(t11);
                $receiver.write(p11);
                $receiver.write(n2);
                $receiver.write(t11);
                $receiver.write(p01);
                $receiver.write(n2);
                $receiver.write(t01);
                $receiver.write(p00);
                $receiver.write(n2);
                $receiver.write(t00);
            }
        });
    }

    public /* synthetic */ CityFloor(Cubemap cubemap, double d, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 1500.0;
        }
        if ((n2 & 4) != 0) {
            d2 = 1500.0;
        }
        this(cubemap, d, d2);
    }
}

