/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0086\u0002J'\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020\u0003J\u0016\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\r\u00a8\u00061"}, d2={"Lorg/openrndr/shape/Rectangle;", "", "x", "", "y", "width", "height", "(DDDD)V", "corner", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector2;DD)V", "area", "getArea", "()D", "center", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getCorner", "getHeight", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "getWidth", "getX", "getY", "component1", "component2", "component3", "contains", "", "point", "copy", "equals", "other", "hashCode", "", "offsetEdges", "offset", "offsetY", "position", "u", "v", "toString", "", "openrndr-shape"})
public final class Rectangle {
    @NotNull
    private final Vector2 corner;
    private final double width;
    private final double height;

    @NotNull
    public final Vector2 getCenter() {
        return this.corner.plus(new Vector2(this.width / 2.0, this.height / (double)2));
    }

    public final double getArea() {
        return this.width * this.height;
    }

    @NotNull
    public final Vector2 position(double u, double v) {
        return this.corner.plus(new Vector2(u * this.width, v * this.height));
    }

    public final double getX() {
        return this.corner.getX();
    }

    public final double getY() {
        return this.corner.getY();
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final ShapeContour getContour() {
        return ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{this.corner, this.corner.plus(new Vector2(this.width, 0.0)), this.corner.plus(new Vector2(this.width, this.height)), this.corner.plus(new Vector2(0.0, this.height)), this.corner}), true);
    }

    @NotNull
    public final Rectangle offsetEdges(double offset, double offsetY) {
        return new Rectangle(new Vector2(this.corner.getX() - offset, this.corner.getY() - offsetY), this.width + (double)2 * offset, this.height + (double)2 * offsetY);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Rectangle offsetEdges$default(Rectangle rectangle, double d, double d2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d2 = d;
        }
        return rectangle.offsetEdges(d, d2);
    }

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        return point.getX() >= this.corner.getX() && point.getX() < this.corner.getX() + this.width && point.getY() >= this.corner.getY() && point.getY() < this.corner.getY() + this.height;
    }

    @NotNull
    public final Vector2 getCorner() {
        return this.corner;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public Rectangle(@NotNull Vector2 corner, double width, double height) {
        Intrinsics.checkParameterIsNotNull(corner, "corner");
        this.corner = corner;
        this.width = width;
        this.height = height;
    }

    public Rectangle(double x, double y, double width, double height) {
        this(new Vector2(x, y), width, height);
    }

    @NotNull
    public final Vector2 component1() {
        return this.corner;
    }

    public final double component2() {
        return this.width;
    }

    public final double component3() {
        return this.height;
    }

    @NotNull
    public final Rectangle copy(@NotNull Vector2 corner, double width, double height) {
        Intrinsics.checkParameterIsNotNull(corner, "corner");
        return new Rectangle(corner, width, height);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Rectangle copy$default(Rectangle rectangle, Vector2 vector2, double d, double d2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            vector2 = rectangle.corner;
        }
        if ((n2 & 2) != 0) {
            d = rectangle.width;
        }
        if ((n2 & 4) != 0) {
            d2 = rectangle.height;
        }
        return rectangle.copy(vector2, d, d2);
    }

    public String toString() {
        return "Rectangle(corner=" + this.corner + ", width=" + this.width + ", height=" + this.height + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.corner;
        return ((vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + Double.hashCode(this.width)) * 31 + Double.hashCode(this.height);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Rectangle)) break block3;
                Rectangle rectangle = (Rectangle)object;
                if (!Intrinsics.areEqual(this.corner, rectangle.corner) || Double.compare(this.width, rectangle.width) != 0 || Double.compare(this.height, rectangle.height) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

