/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0019J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u000e\u0010%\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0019\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000'2\u0006\u0010(\u001a\u00020\u0019\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0019J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0019J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u00061"}, d2={"Lorg/openrndr/shape/LineSegment;", "", "start", "Lorg/openrndr/math/Vector2;", "end", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "direction", "getDirection", "()Lorg/openrndr/math/Vector2;", "getEnd", "normal", "getNormal", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "getStart", "component1", "component2", "copy", "distance", "", "query", "endingAtNearest", "x", "y", "endingAtX", "endingAtY", "equals", "", "other", "hashCode", "", "nearest", "split", "", "t", "(D)[Lorg/openrndr/shape/LineSegment;", "startingAtX", "startingAtY", "sub", "t0", "t1", "toString", "", "openrndr-shape"})
public final class LineSegment {
    @NotNull
    private final Vector2 start;
    @NotNull
    private final Vector2 end;

    @NotNull
    public final Vector2 getDirection() {
        return this.end.minus(this.start);
    }

    @NotNull
    public final Vector2 getNormal() {
        return this.end.minus(this.start).getNormalized().getPerpendicular();
    }

    @NotNull
    public final Vector2 nearest(@NotNull Vector2 query) {
        Intrinsics.checkParameterIsNotNull(query, "query");
        double l2 = this.end.minus(this.start).getLength();
        l2 *= l2;
        if (l2 == 0.0) {
            return this.start;
        }
        double t2 = ((query.getX() - this.start.getX()) * (this.end.getX() - this.start.getX()) + (query.getY() - this.start.getY()) * (this.end.getY() - this.start.getY())) / l2;
        t2 = Math.max(0.0, Math.min(1.0, t2));
        return new Vector2(this.start.getX() + t2 * (this.end.getX() - this.start.getX()), this.start.getY() + t2 * (this.end.getY() - this.start.getY()));
    }

    public final double distance(@NotNull Vector2 query) {
        Intrinsics.checkParameterIsNotNull(query, "query");
        double l2 = this.end.minus(this.start).getLength();
        l2 *= l2;
        if (l2 == 0.0) {
            return query.minus(this.start).getLength();
        }
        double t2 = ((query.getX() - this.start.getX()) * (this.end.getX() - this.start.getX()) + (query.getY() - this.start.getY()) * (this.end.getY() - this.start.getY())) / l2;
        t2 = Math.max(0.0, Math.min(1.0, t2));
        return query.minus(new Vector2(this.start.getX() + t2 * (this.end.getX() - this.start.getX()), this.start.getY() + t2 * (this.end.getY() - this.start.getY()))).getLength();
    }

    @NotNull
    public final LineSegment endingAtY(double y) {
        double dy = this.end.getY() - this.start.getY();
        double y0 = y - this.start.getY();
        double t2 = y0 / dy;
        return new LineSegment(this.start, this.start.plus(this.end.minus(this.start).times(t2)));
    }

    @NotNull
    public final LineSegment startingAtY(double y) {
        double dy = this.end.getY() - this.start.getY();
        double y0 = y - this.start.getY();
        double t2 = y0 / dy;
        return new LineSegment(this.start.plus(this.end.minus(this.start).times(t2)), this.end);
    }

    @NotNull
    public final LineSegment startingAtX(double x) {
        double dx = this.end.getX() - this.start.getX();
        double x0 = x - this.start.getX();
        double t2 = x0 / dx;
        return new LineSegment(this.start.plus(this.end.minus(this.start).times(t2)), this.end);
    }

    @NotNull
    public final LineSegment endingAtX(double x) {
        double dx = this.end.getX() - this.start.getX();
        double x0 = x - this.start.getX();
        double t2 = x0 / dx;
        return new LineSegment(this.start, this.start.plus(this.end.minus(this.start).times(t2)));
    }

    @NotNull
    public final LineSegment endingAtNearest(double x, double y) {
        double dx = this.end.getX() - this.start.getX();
        double x0 = x - this.start.getX();
        double tx = x0 / dx;
        double dy = this.end.getY() - this.start.getY();
        double y0 = y - this.start.getY();
        double ty = y0 / dy;
        return tx == tx && tx < ty ? new LineSegment(this.start, this.start.plus(this.end.minus(this.start).times(tx))) : new LineSegment(this.start, this.start.plus(this.end.minus(this.start).times(ty)));
    }

    @NotNull
    public final LineSegment sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map(z0, 1.0, 0.0, 1.0, z1))[0]);
    }

    @NotNull
    public final LineSegment[] split(double t2) {
        double u = RangesKt.coerceIn(t2, 0.0, 1.0);
        Vector2 cut = this.start.plus(this.end.minus(this.start).times(u));
        return new LineSegment[]{new LineSegment(this.start, cut), new LineSegment(cut, this.end)};
    }

    @NotNull
    public final ShapeContour getContour() {
        return ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{this.start, this.end}), false);
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final Vector2 getStart() {
        return this.start;
    }

    @NotNull
    public final Vector2 getEnd() {
        return this.end;
    }

    public LineSegment(@NotNull Vector2 start, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.end = end2;
    }

    @NotNull
    public final Vector2 component1() {
        return this.start;
    }

    @NotNull
    public final Vector2 component2() {
        return this.end;
    }

    @NotNull
    public final LineSegment copy(@NotNull Vector2 start, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        return new LineSegment(start, end2);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LineSegment copy$default(LineSegment lineSegment, Vector2 vector2, Vector2 vector22, int n2, Object object) {
        if ((n2 & 1) != 0) {
            vector2 = lineSegment.start;
        }
        if ((n2 & 2) != 0) {
            vector22 = lineSegment.end;
        }
        return lineSegment.copy(vector2, vector22);
    }

    public String toString() {
        return "LineSegment(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.start;
        Vector2 vector22 = this.end;
        return (vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (vector22 != null ? ((Object)vector22).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LineSegment)) break block3;
                LineSegment lineSegment = (LineSegment)object;
                if (!Intrinsics.areEqual(this.start, lineSegment.start) || !Intrinsics.areEqual(this.end, lineSegment.end)) break block3;
            }
            return true;
        }
        return false;
    }
}

