/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Quaternion;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"dot", "", "q1", "Lorg/openrndr/math/Quaternion;", "q2", "slerp", "x", "openrndr-math"})
public final class QuaternionKt {
    public static final double dot(@NotNull Quaternion q1, @NotNull Quaternion q2) {
        Intrinsics.checkParameterIsNotNull(q1, "q1");
        Intrinsics.checkParameterIsNotNull(q2, "q2");
        return q1.getW() * q2.getW() + q1.getX() * q2.getX() + q1.getY() * q2.getY() + q2.getZ() * q2.getZ();
    }

    @NotNull
    public static final Quaternion slerp(@NotNull Quaternion q1, @NotNull Quaternion q2, double x) {
        Intrinsics.checkParameterIsNotNull(q1, "q1");
        Intrinsics.checkParameterIsNotNull(q2, "q2");
        if (q1.getX() == q2.getX() && q1.getY() == q2.getY() && q1.getZ() == q2.getZ() && q1.getW() == q2.getW()) {
            return q1;
        }
        Quaternion q2e = q2;
        double result = q1.getX() * q2.getX() + q1.getY() * q2.getY() + q1.getZ() * q2.getZ() + q1.getW() * q2.getW();
        if (result < 0.0) {
            q2e = q2.getNegated();
            result = -result;
        }
        double scale0 = 1.0 - x;
        double scale1 = x;
        if (1.0 - result > 0.1) {
            double theta = Math.acos(result);
            double invSinTheta = 1.0 / Math.sin(theta);
            scale0 = Math.sin((1.0 - x) * theta) * invSinTheta;
            scale1 = Math.sin(x * theta) * invSinTheta;
        }
        return new Quaternion(scale0 * q1.getX() + scale1 * q2e.getX(), scale0 * q1.getY() + scale1 * q2e.getY(), scale0 * q1.getZ() + scale1 * q2e.getZ(), scale0 * q1.getW() + scale1 * q2e.getW());
    }
}

