/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u001a\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ \u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/math/CatmulRom1;", "", "p0", "", "p1", "p2", "p3", "alpha", "(DDDDD)V", "getAlpha", "()D", "getP0", "getP1", "getP2", "getP3", "t0", "getT0", "t1", "getT1", "t2", "getT2", "t3", "getT3", "calculateT", "t", "f", "x", "position", "rt", "openrndr-math"})
public final class CatmulRom1 {
    private final double t0 = 0.0;
    private final double t1;
    private final double t2;
    private final double t3;
    private final double p0;
    private final double p1;
    private final double p2;
    private final double p3;
    private final double alpha;

    public final double getT0() {
        return this.t0;
    }

    public final double getT1() {
        return this.t1;
    }

    public final double getT2() {
        return this.t2;
    }

    public final double getT3() {
        return this.t3;
    }

    private final double f(double x) {
        return Math.abs(x) < 1.0E-8 ? 1.0 : x;
    }

    public final double position(double rt2) {
        double t2 = (this.t2 - this.t1) * rt2 + this.t1;
        double a1 = this.p0 * ((this.t1 - t2) / this.f(this.t1 - this.t0)) + this.p1 * ((t2 - this.t0) / this.f(this.t1 - this.t0));
        double a2 = this.p1 * ((this.t2 - t2) / this.f(this.t2 - this.t1)) + this.p2 * ((t2 - this.t1) / this.f(this.t2 - this.t1));
        double a3 = this.p2 * ((this.t3 - t2) / this.f(this.t3 - this.t2)) + this.p3 * ((t2 - this.t2) / this.f(this.t3 - this.t2));
        double b1 = a1 * ((this.t2 - t2) / this.f(this.t2 - this.t0)) + a2 * ((t2 - this.t0) / this.f(this.t2 - this.t0));
        double b2 = a2 * ((this.t3 - t2) / this.f(this.t3 - this.t1)) + a3 * ((t2 - this.t1) / this.f(this.t3 - this.t1));
        double c = b1 * ((this.t2 - t2) / this.f(this.t2 - this.t1)) + b2 * ((t2 - this.t1) / this.f(this.t2 - this.t1));
        return c;
    }

    private final double calculateT(double t2, double p0, double p1) {
        double a = Math.pow(p1 - p0, 2.0);
        double b = Math.pow(a, 0.5);
        double c = Math.pow(b, this.alpha);
        return c + t2;
    }

    public final double getP0() {
        return this.p0;
    }

    public final double getP1() {
        return this.p1;
    }

    public final double getP2() {
        return this.p2;
    }

    public final double getP3() {
        return this.p3;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public CatmulRom1(double p0, double p1, double p2, double p3, double alpha) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.alpha = alpha;
        this.t1 = this.calculateT(this.t0, this.p0, this.p1);
        this.t2 = this.calculateT(this.t1, this.p1, this.p2);
        this.t3 = this.calculateT(this.t2, this.p2, this.p3);
    }

    public /* synthetic */ CatmulRom1(double d, double d2, double d3, double d4, double d5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            d5 = 0.5;
        }
        this(d, d2, d3, d4, d5);
    }
}

