/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.gl3.ShadeStructureGL3Kt;
import org.openrndr.internal.gl3.ShadeStyleManagerGL3;
import org.openrndr.internal.gl3.ShadeStyleManagerGL3Kt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J.\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/internal/gl3/ShadeStyleManagerGL3;", "Lorg/openrndr/draw/ShadeStyleManager;", "vertexShaderGenerator", "Lkotlin/Function1;", "Lorg/openrndr/draw/ShadeStructure;", "", "fragmentShaderGenerator", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "defaultShader", "Lorg/openrndr/draw/Shader;", "getDefaultShader", "()Lorg/openrndr/draw/Shader;", "setDefaultShader", "(Lorg/openrndr/draw/Shader;)V", "getFragmentShaderGenerator", "()Lkotlin/jvm/functions/Function1;", "shaders", "", "getShaders", "()Ljava/util/Map;", "getVertexShaderGenerator", "shader", "style", "Lorg/openrndr/draw/ShadeStyle;", "vertexFormats", "", "Lorg/openrndr/draw/VertexFormat;", "instanceFormats", "openrndr-gl3"})
public final class ShadeStyleManagerGL3
extends ShadeStyleManager {
    @Nullable
    private Shader defaultShader;
    @NotNull
    private final Map<ShadeStructure, Shader> shaders;
    @NotNull
    private final Function1<ShadeStructure, String> vertexShaderGenerator;
    @NotNull
    private final Function1<ShadeStructure, String> fragmentShaderGenerator;

    @Nullable
    public final Shader getDefaultShader() {
        return this.defaultShader;
    }

    public final void setDefaultShader(@Nullable Shader shader2) {
        this.defaultShader = shader2;
    }

    @NotNull
    public final Map<ShadeStructure, Shader> getShaders() {
        return this.shaders;
    }

    @Override
    @NotNull
    public Shader shader(@Nullable ShadeStyle style, @NotNull List<VertexFormat> vertexFormats, @NotNull List<VertexFormat> instanceFormats) {
        Shader shader2;
        Intrinsics.checkParameterIsNotNull(vertexFormats, "vertexFormats");
        Intrinsics.checkParameterIsNotNull(instanceFormats, "instanceFormats");
        if (style == null) {
            if (this.defaultShader == null) {
                ShadeStyleManagerGL3Kt.access$getLogger$p().debug(shader.1.INSTANCE);
                ShadeStructure structure = ShadeStructureGL3Kt.structureFromShadeTyle(style, vertexFormats, instanceFormats);
                this.defaultShader = Shader.Companion.createFromCode(this.vertexShaderGenerator.invoke(structure), this.fragmentShaderGenerator.invoke(structure));
            }
            Shader shader3 = this.defaultShader;
            if (shader3 == null) {
                Intrinsics.throwNpe();
            }
            return shader3;
        }
        Map<ShadeStructure, Shader> $receiver$iv = this.shaders;
        ShadeStructure structure = ShadeStructureGL3Kt.structureFromShadeTyle(style, vertexFormats, instanceFormats);
        Shader value$iv = $receiver$iv.get(structure);
        if (value$iv == null) {
            Object object;
            try {
                object = Shader.Companion.createFromCode(this.vertexShaderGenerator.invoke(structure), this.fragmentShaderGenerator.invoke(structure));
            }
            catch (RuntimeException e) {
                object = this.shader(null, vertexFormats, instanceFormats);
            }
            Shader answer$iv = object;
            $receiver$iv.put(structure, answer$iv);
            shader2 = answer$iv;
        } else {
            shader2 = value$iv;
        }
        Shader shader4 = shader2;
        shader4.begin();
        int textureIndex = 2;
        Iterable $receiver$iv2 = style.getParameterValues().entrySet();
        for (Object element$iv : $receiver$iv2) {
            int n2;
            Map.Entry it2 = (Map.Entry)element$iv;
            Object value = it2.getValue();
            Object v = value;
            if (v instanceof Integer) {
                shader4.uniform("p_" + (String)it2.getKey(), ((Number)value).intValue());
                continue;
            }
            if (v instanceof Float) {
                shader4.uniform("p_" + (String)it2.getKey(), ((Number)value).floatValue());
                continue;
            }
            if (v instanceof Double) {
                shader4.uniform("p_" + (String)it2.getKey(), ((Number)value).doubleValue());
                continue;
            }
            if (v instanceof Matrix44) {
                shader4.uniform("p_" + (String)it2.getKey(), (Matrix44)value);
                continue;
            }
            if (v instanceof Vector4) {
                shader4.uniform("p_" + (String)it2.getKey(), (Vector4)value);
                continue;
            }
            if (v instanceof Vector3) {
                shader4.uniform("p_" + (String)it2.getKey(), (Vector3)value);
                continue;
            }
            if (v instanceof Vector2) {
                shader4.uniform("p_" + (String)it2.getKey(), (Vector2)value);
                continue;
            }
            if (v instanceof ColorRGBa) {
                shader4.uniform("p_" + (String)it2.getKey(), (ColorRGBa)value);
                continue;
            }
            if (v instanceof ColorBuffer) {
                ((ColorBuffer)value).bind(textureIndex);
                shader4.uniform("p_" + (String)it2.getKey(), textureIndex);
                n2 = textureIndex;
                textureIndex = n2 + 1;
                continue;
            }
            if (v instanceof BufferTexture) {
                ((BufferTexture)value).bind(textureIndex);
                shader4.uniform("p_" + (String)it2.getKey(), textureIndex);
                n2 = textureIndex;
                textureIndex = n2 + 1;
                continue;
            }
            if (v instanceof Cubemap) {
                ((Cubemap)value).bind(textureIndex);
                shader4.uniform("p_" + (String)it2.getKey(), textureIndex);
                n2 = textureIndex;
                textureIndex = n2 + 1;
                continue;
            }
            throw (Throwable)new RuntimeException("unsupported value type");
        }
        return shader4;
    }

    @NotNull
    public final Function1<ShadeStructure, String> getVertexShaderGenerator() {
        return this.vertexShaderGenerator;
    }

    @NotNull
    public final Function1<ShadeStructure, String> getFragmentShaderGenerator() {
        return this.fragmentShaderGenerator;
    }

    public ShadeStyleManagerGL3(@NotNull Function1<? super ShadeStructure, String> vertexShaderGenerator, @NotNull Function1<? super ShadeStructure, String> fragmentShaderGenerator) {
        Map map;
        Intrinsics.checkParameterIsNotNull(vertexShaderGenerator, "vertexShaderGenerator");
        Intrinsics.checkParameterIsNotNull(fragmentShaderGenerator, "fragmentShaderGenerator");
        this.vertexShaderGenerator = vertexShaderGenerator;
        this.fragmentShaderGenerator = fragmentShaderGenerator;
        ShadeStyleManagerGL3 shadeStyleManagerGL3 = this;
        shadeStyleManagerGL3.shaders = map = (Map)new LinkedHashMap();
    }
}

