/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/internal/ImageDrawer;", "", "()V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "drawImage", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "x", "", "y", "width", "height", "source", "Lorg/openrndr/shape/Rectangle;", "target", "openrndr-core"})
public final class ImageDrawer {
    private final VertexBuffer vertices;
    private final ShadeStyleManager shaderManager;

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, @NotNull Rectangle source, @NotNull Rectangle target) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Function1<Double, Double> flipV$ = new Function1<Double, Double>(colorBuffer){
            final /* synthetic */ ColorBuffer $colorBuffer;

            public final double invoke(double v) {
                return this.$colorBuffer.getFlipV() ? 1.0 - v : v;
            }
            {
                this.$colorBuffer = colorBuffer;
                super(1);
            }
        };
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        Vector3 pa = new Vector3(target.getX(), target.getY(), 0.0);
        Vector3 pb = new Vector3(target.getX() + target.getWidth(), target.getY(), 0.0);
        Vector3 pc = new Vector3(target.getX() + target.getWidth(), target.getY() + target.getHeight(), 0.0);
        Vector3 pd = new Vector3(target.getX(), target.getY() + target.getHeight(), 0.0);
        double u0 = source.getX() / (double)colorBuffer.getWidth();
        double u1 = (source.getX() + source.getWidth()) / (double)colorBuffer.getWidth();
        double v0 = 1.0 - (source.getY() + source.getHeight()) / (double)colorBuffer.getHeight();
        double v1 = 1.0 - source.getY() / (double)colorBuffer.getHeight();
        Vector2 ta = new Vector2(u0, flipV$.invoke(v1));
        Vector2 tb = new Vector2(u1, flipV$.invoke(v1));
        Vector2 tc = new Vector2(u1, flipV$.invoke(v0));
        Vector2 td = new Vector2(u0, flipV$.invoke(v0));
        Vector3 n2 = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $receiver = bufferWriter = w;
        $receiver.write(pa);
        $receiver.write(n2);
        $receiver.write(ta);
        $receiver.write(pd);
        $receiver.write(n2);
        $receiver.write(td);
        $receiver.write(pc);
        $receiver.write(n2);
        $receiver.write(tc);
        $receiver.write(pc);
        $receiver.write(n2);
        $receiver.write(tc);
        $receiver.write(pb);
        $receiver.write(n2);
        $receiver.write(tb);
        $receiver.write(pa);
        $receiver.write(n2);
        $receiver.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
        colorBuffer.bind(0);
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.TRIANGLES, 0, 6);
        shader2.end();
    }

    public final void drawImage(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull ColorBuffer colorBuffer, double x, double y, double width, double height) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        Function1<Double, Double> flipV$ = new Function1<Double, Double>(colorBuffer){
            final /* synthetic */ ColorBuffer $colorBuffer;

            public final double invoke(double v) {
                return this.$colorBuffer.getFlipV() ? 1.0 - v : v;
            }
            {
                this.$colorBuffer = colorBuffer;
                super(1);
            }
        };
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        Vector3 pa = new Vector3(x, y, 0.0);
        Vector3 pb = new Vector3(x + width, y, 0.0);
        Vector3 pc = new Vector3(x + width, y + height, 0.0);
        Vector3 pd = new Vector3(x, y + height, 0.0);
        Vector2 ta = new Vector2(0.0, flipV$.invoke(1.0));
        Vector2 tb = new Vector2(1.0, flipV$.invoke(1.0));
        Vector2 tc = new Vector2(1.0, flipV$.invoke(0.0));
        Vector2 td = new Vector2(0.0, flipV$.invoke(0.0));
        Vector3 n2 = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $receiver = bufferWriter = w;
        $receiver.write(pa);
        $receiver.write(n2);
        $receiver.write(ta);
        $receiver.write(pd);
        $receiver.write(n2);
        $receiver.write(td);
        $receiver.write(pc);
        $receiver.write(n2);
        $receiver.write(tc);
        $receiver.write(pc);
        $receiver.write(n2);
        $receiver.write(tc);
        $receiver.write(pb);
        $receiver.write(n2);
        $receiver.write(tb);
        $receiver.write(pa);
        $receiver.write(n2);
        $receiver.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
        colorBuffer.bind(0);
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.TRIANGLES, 0, 6);
        shader2.end();
    }

    public ImageDrawer() {
        VertexFormat vertexFormat = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        ImageDrawer imageDrawer = this;
        VertexFormat $receiver = vertexFormat;
        $receiver.position(3);
        $receiver.normal(3);
        $receiver.textureCoordinate(2);
        VertexFormat vertexFormat2 = vertexFormat;
        imageDrawer.vertices = companion.createDynamic(vertexFormat2, 6);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageVertexShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageVertexShader";
            }

            public final String getSignature() {
                return "imageVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).imageFragmentShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "imageFragmentShader";
            }

            public final String getSignature() {
                return "imageFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
    }
}

