/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ0\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J0\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/internal/FontImageMapDrawer;", "", "()V", "quads", "", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "drawText", "", "context", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "text", "", "x", "", "y", "flush", "insertCharacterQuad", "fontMap", "Lorg/openrndr/draw/FontImageMap;", "bw", "Lorg/openrndr/draw/BufferWriter;", "character", "", "queueText", "Lorg/openrndr/draw/FontMap;", "tracking", "openrndr-core"})
public final class FontImageMapDrawer {
    private final ShadeStyleManager shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkParameterIsNotNull(p1, "p1");
            return ((ShaderGenerators)this.receiver).fontImageMapVertexShader(p1);
        }

        public final KDeclarationContainer getOwner() {
            return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
        }

        public final String getName() {
            return "fontImageMapVertexShader";
        }

        public final String getSignature() {
            return "fontImageMapVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
        }
    }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkParameterIsNotNull(p1, "p1");
            return ((ShaderGenerators)this.receiver).fontImageMapFragmentShader(p1);
        }

        public final KDeclarationContainer getOwner() {
            return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
        }

        public final String getName() {
            return "fontImageMapFragmentShader";
        }

        public final String getSignature() {
            return "fontImageMapFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
        }
    });
    private final VertexBuffer vertices;
    private int quads;

    public final void drawText(@NotNull DrawContext context, @NotNull DrawStyle drawStyle, @NotNull String text, double x, double y) {
        block3: {
            CharSequence $receiver$iv;
            FontImageMap fontImageMap;
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
            Intrinsics.checkParameterIsNotNull(text, "text");
            FontMap fontMap = drawStyle.getFontMap();
            if (!(fontMap instanceof FontImageMap)) {
                fontMap = null;
            }
            FontImageMap fontImageMap2 = (FontImageMap)fontMap;
            if (fontImageMap2 == null) break block3;
            FontImageMap fontMap2 = fontImageMap = fontImageMap2;
            double cursorX = 0.0;
            double cursorY = 0.0;
            BufferWriter bw = this.vertices.getShadow().writer();
            bw.setPosition(this.vertices.getVertexFormat().getSize() * this.quads * 6);
            CharSequence charSequence = $receiver$iv = (CharSequence)text;
            for (int i = 0; i < charSequence.length(); ++i) {
                GlyphMetrics metrics;
                char element$iv;
                char it2 = element$iv = charSequence.charAt(i);
                if (fontMap2.getGlyphMetrics().get(Character.valueOf(it2)) == null) {
                    Intrinsics.throwNpe();
                }
                this.insertCharacterQuad(fontMap2, bw, it2, x + cursorX + metrics.getLeftSideBearing() / fontMap2.getContentScale(), y + cursorY + metrics.getYBitmapShift() / fontMap2.getContentScale());
                cursorX += metrics.getAdvanceWidth();
            }
            this.flush(context, drawStyle);
        }
    }

    public final void queueText(@NotNull FontMap fontMap, @NotNull String text, double x, double y, double tracking) {
        CharSequence $receiver$iv;
        Intrinsics.checkParameterIsNotNull(fontMap, "fontMap");
        Intrinsics.checkParameterIsNotNull(text, "text");
        BufferWriter bw = this.vertices.getShadow().writer();
        bw.setPosition(this.vertices.getVertexFormat().getSize() * this.quads * 6);
        FontImageMap cfr_ignored_0 = (FontImageMap)fontMap;
        double cursorX = 0.0;
        double cursorY = 0.0;
        CharSequence charSequence = $receiver$iv = (CharSequence)text;
        for (int i = 0; i < charSequence.length(); ++i) {
            GlyphMetrics glyphMetrics;
            char element$iv;
            char it2 = element$iv = charSequence.charAt(i);
            GlyphMetrics metrics = ((FontImageMap)fontMap).getGlyphMetrics().get(Character.valueOf(it2));
            if (metrics == null) continue;
            GlyphMetrics m = glyphMetrics;
            this.insertCharacterQuad((FontImageMap)fontMap, bw, it2, x + cursorX + m.getLeftSideBearing() / ((FontImageMap)fontMap).getContentScale(), y + cursorY + m.getYBitmapShift() / ((FontImageMap)fontMap).getContentScale());
            cursorX += m.getAdvanceWidth() + tracking;
        }
    }

    public static /* bridge */ /* synthetic */ void queueText$default(FontImageMapDrawer fontImageMapDrawer, FontMap fontMap, String string, double d, double d2, double d3, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            d3 = 0.0;
        }
        fontImageMapDrawer.queueText(fontMap, string, d, d2, d3);
    }

    public final void flush(@NotNull DrawContext context, @NotNull DrawStyle drawStyle) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        if (this.quads > 0) {
            this.vertices.getShadow().uploadElements(0, this.quads * 6);
            Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
            shader2.begin();
            context.applyToShader(shader2);
            Driver.Companion.getInstance().setState(drawStyle);
            drawStyle.applyToShader(shader2);
            FontMap fontMap = drawStyle.getFontMap();
            if (fontMap == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            ((FontImageMap)fontMap).getTexture().bind(0);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.TRIANGLES, 0, this.quads * 6);
            shader2.end();
            this.quads = 0;
        }
    }

    private final void insertCharacterQuad(FontImageMap fontMap, BufferWriter bw, char character, double x, double y) {
        BufferWriter bufferWriter;
        IntRectangle intRectangle = fontMap.getMap().get(Character.valueOf(character));
        if (intRectangle == null) {
            Intrinsics.throwNpe();
        }
        IntRectangle rectangle = intRectangle;
        float pad = 1.0f;
        float u0 = ((float)rectangle.getX() - pad) / (float)fontMap.getTexture().getWidth();
        float u1 = u0 + (1.0f + pad * (float)2 + (float)rectangle.getWidth()) / (float)fontMap.getTexture().getWidth();
        float v0 = ((float)rectangle.getY() - pad) / (float)fontMap.getTexture().getHeight();
        float v1 = v0 + (1.0f + pad * (float)2 + (float)rectangle.getHeight()) / (float)fontMap.getTexture().getHeight();
        float x0 = (float)x - pad;
        float x1 = x0 + (float)rectangle.getWidth() / (float)fontMap.getContentScale() + pad * (float)2;
        float y0 = (float)y - pad;
        float y1 = y0 + (float)rectangle.getHeight() / (float)fontMap.getContentScale() + pad * (float)2;
        float s0 = 0.0f;
        float t0 = 0.0f;
        float s1 = 1.0f;
        float t1 = 1.0f;
        float w = x1 - x0;
        float h = y1 - y0;
        float z = this.quads;
        BufferWriter $receiver = bufferWriter = bw;
        $receiver.write(u0, v0);
        $receiver.write(s0, t0, w, h);
        $receiver.write(x0, y0, z);
        $receiver.write(u1, v0);
        $receiver.write(s1, t0, w, h);
        $receiver.write(x1, y0, z);
        $receiver.write(u1, v1);
        $receiver.write(s1, t1, w, h);
        $receiver.write(x1, y1, z);
        $receiver.write(u0, v0);
        $receiver.write(s0, t0, w, h);
        $receiver.write(x0, y0, z);
        $receiver.write(u0, v1);
        $receiver.write(s0, t1, w, h);
        $receiver.write(x0, y1, z);
        $receiver.write(u1, v1);
        $receiver.write(s1, t1, w, h);
        $receiver.write(x1, y1, z);
        int n2 = this.quads;
        this.quads = n2 + 1;
    }

    public FontImageMapDrawer() {
        VertexFormat vertexFormat = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        FontImageMapDrawer fontImageMapDrawer = this;
        VertexFormat $receiver = vertexFormat;
        $receiver.textureCoordinate(2);
        $receiver.attribute("bounds", 4, VertexElementType.FLOAT32);
        $receiver.position(3);
        VertexFormat vertexFormat2 = vertexFormat;
        fontImageMapDrawer.vertices = companion.createDynamic(vertexFormat2, 48000);
    }
}

