/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.filter;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.openrndr.ApplicationKt;
import org.openrndr.draw.Filter;
import org.openrndr.draw.Shader;
import org.openrndr.filter.FilterTools;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"filterFragmentCode", "", "resourceId", "filterShaderFromCode", "Lorg/openrndr/draw/Shader;", "fragmentShaderCode", "filterShaderFromUrl", "url", "openrndr-filter"})
public final class FilterToolsKt {
    @NotNull
    public static final String filterFragmentCode(@NotNull String resourceId) {
        Intrinsics.checkParameterIsNotNull(resourceId, "resourceId");
        String urlString = ApplicationKt.resourceUrl("gl3/" + resourceId, FilterTools.class);
        URL uRL = new URL(urlString);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        return new String(byArray, charset);
    }

    @NotNull
    public static final Shader filterShaderFromUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        URL uRL = new URL(url);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        return FilterToolsKt.filterShaderFromCode(new String(byArray, charset));
    }

    @NotNull
    public static final Shader filterShaderFromCode(@NotNull String fragmentShaderCode) {
        Intrinsics.checkParameterIsNotNull(fragmentShaderCode, "fragmentShaderCode");
        return Shader.Companion.createFromCode(Filter.Companion.getFilterVertexCode(), fragmentShaderCode);
    }
}

