/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL33C;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.DepthBufferGL3;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.RenderTargetGL3;
import org.openrndr.internal.gl3.RenderTargetGL3Kt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 B2\u00020\u0001:\u0001BB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u0019H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0019H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\b\u00100\u001a\u00020-H\u0016J\b\u00101\u001a\u00020-H\u0002J\u0016\u0010\u0012\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u00020-03H\u0002J\r\u00104\u001a\u00020-H\u0000\u00a2\u0006\u0002\b5J\u0018\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0016H\u0016J\u0010\u0010=\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0016H\u0016J\b\u0010>\u001a\u00020-H\u0016J\b\u0010?\u001a\u00020-H\u0016J\b\u0010@\u001a\u00020-H\u0016J\b\u0010A\u001a\u00020-H\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\"\u00a8\u0006C"}, d2={"Lorg/openrndr/internal/gl3/RenderTargetGL3;", "Lorg/openrndr/draw/RenderTarget;", "framebuffer", "", "width", "height", "contentScale", "", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "thread", "Ljava/lang/Thread;", "(IIIDLorg/openrndr/draw/BufferMultisample;Ljava/lang/Thread;)V", "_colorBuffers", "", "Lorg/openrndr/internal/gl3/ColorBufferGL3;", "_depthBuffer", "Lorg/openrndr/draw/DepthBuffer;", "bound", "", "colorBufferIndices", "", "", "colorBuffers", "", "Lorg/openrndr/draw/ColorBuffer;", "getColorBuffers", "()Ljava/util/List;", "getContentScale", "()D", "depthBuffer", "getDepthBuffer", "()Lorg/openrndr/draw/DepthBuffer;", "getFramebuffer", "()I", "hasColorBuffer", "getHasColorBuffer", "()Z", "hasDepthBuffer", "getHasDepthBuffer", "getHeight", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "getWidth", "attach", "", "name", "colorBuffer", "bind", "bindTarget", "function", "Lkotlin/Function0;", "checkFramebufferStatus", "checkFramebufferStatus$openrndr_gl3", "clearColor", "index", "color", "Lorg/openrndr/color/ColorRGBa;", "clearDepth", "depth", "stencil", "colorBufferIndex", "destroy", "detachColorBuffers", "detachDepthBuffer", "unbind", "Companion", "openrndr-gl3"})
public class RenderTargetGL3
implements RenderTarget {
    private final Map<String, Integer> colorBufferIndices;
    private final List<ColorBufferGL3> _colorBuffers;
    private DepthBuffer _depthBuffer;
    private boolean bound;
    private final int framebuffer;
    private final int width;
    private final int height;
    private final double contentScale;
    @NotNull
    private final BufferMultisample multisample;
    private final Thread thread;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ColorBuffer> getColorBuffers() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this._colorBuffers;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ColorBufferGL3 colorBufferGL3 = (ColorBufferGL3)item$iv$iv;
            Collection collection = destination$iv$iv;
            void var11_8 = it;
            collection.add(var11_8);
        }
        return (List)var3_3;
    }

    @Override
    @Nullable
    public DepthBuffer getDepthBuffer() {
        return this._depthBuffer;
    }

    @Override
    public boolean getHasColorBuffer() {
        Collection collection = this.getColorBuffers();
        return !collection.isEmpty();
    }

    @Override
    public boolean getHasDepthBuffer() {
        return this.getDepthBuffer() != null;
    }

    @Override
    @NotNull
    public ColorBuffer colorBuffer(int index) {
        return this._colorBuffers.get(index);
    }

    @Override
    @NotNull
    public ColorBuffer colorBuffer(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Integer n = this.colorBufferIndices.get(name);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return this._colorBuffers.get(((Number)n).intValue());
    }

    @Override
    public int colorBufferIndex(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Integer n = this.colorBufferIndices.get(name);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind() {
        Object object;
        void $receiver$iv;
        if (this.bound) {
            throw (Throwable)new RuntimeException("already bound");
        }
        Map map2 = RenderTargetGL3Kt.access$getActive$p();
        Long key$iv = GLFW.glfwGetCurrentContext();
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            Stack answer$iv = new Stack();
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Stack stack = (Stack)object;
        stack.push(this);
        this.bindTarget();
    }

    /*
     * WARNING - void declaration
     */
    private final void bindTarget() {
        ErrorGL3Kt.debugGLErrors(bindTarget.1.INSTANCE);
        GL33C.glBindFramebuffer(36160, this.framebuffer);
        if (Intrinsics.areEqual(Thread.currentThread(), this.thread) ^ true) {
            throw (Throwable)new IllegalStateException("this render target is created by " + this.thread + " and cannot be bound to " + Thread.currentThread());
        }
        ErrorGL3Kt.debugGLErrors(bindTarget.2.INSTANCE);
        if (this._colorBuffers.size() > 0) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this._colorBuffers;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void index;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                ColorBufferGL3 colorBufferGL3 = (ColorBufferGL3)item$iv$iv;
                int n3 = n2;
                Collection collection2 = collection;
                Integer n4 = 36064 + index;
                collection2.add(n4);
            }
            int[] drawBuffers = CollectionsKt.toIntArray((List)destination$iv$iv);
            GL33C.glDrawBuffers(drawBuffers);
            ErrorGL3Kt.debugGLErrors(bindTarget.3.INSTANCE);
        }
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        RenderTargetGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(effectiveWidth, effectiveHeight){
            final /* synthetic */ int $effectiveWidth;
            final /* synthetic */ int $effectiveHeight;

            @NotNull
            public final String invoke() {
                return "setting viewport to (0, 0, " + this.$effectiveWidth + ", " + this.$effectiveHeight + ')';
            }
            {
                this.$effectiveWidth = n;
                this.$effectiveHeight = n2;
                super(0);
            }
        });
        GL33C.glViewport(0, 0, effectiveWidth, effectiveHeight);
        ErrorGL3Kt.debugGLErrors(bindTarget.5.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unbind() {
        RenderTargetGL3 previous;
        if (!this.bound) {
            Object object;
            void $receiver$iv;
            Map map2 = RenderTargetGL3Kt.access$getActive$p();
            Long key$iv = GLFW.glfwGetCurrentContext();
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                Stack answer$iv = new Stack();
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = object;
            Stack it = (Stack)((Object)map2);
            it.pop();
            previous = (RenderTargetGL3)it.peek();
            if (previous == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
        } else {
            throw (Throwable)new RuntimeException("target not bound");
        }
        RenderTargetGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(previous){
            final /* synthetic */ RenderTargetGL3 $previous;

            @NotNull
            public final String invoke() {
                return "restoring to previous render target " + this.$previous;
            }
            {
                this.$previous = renderTargetGL3;
                super(0);
            }
        });
        previous.bindTarget();
    }

    @Override
    public void attach(@NotNull String name, @NotNull ColorBuffer colorBuffer) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        Map<String, Integer> map2 = this.colorBufferIndices;
        Integer n = this._colorBuffers.size();
        map2.put(name, n);
        this.attach(colorBuffer);
    }

    @Override
    public void attach(@NotNull ColorBuffer colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        long context = GLFW.glfwGetCurrentContext();
        this.bindTarget();
        int effectiveWidth = (int)((double)this.getWidth() * this.getContentScale());
        int effectiveHeight = (int)((double)this.getHeight() * this.getContentScale());
        if (colorBuffer.getEffectiveWidth() != effectiveWidth || colorBuffer.getEffectiveHeight() != effectiveHeight) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch. expected: (" + this.getWidth() + " x " + this.getHeight() + " @" + colorBuffer.getContentScale() + "x, got: (" + colorBuffer.getWidth() + " x " + colorBuffer.getHeight() + " @" + colorBuffer.getContentScale() + "x)");
        }
        ColorBufferGL3 cfr_ignored_0 = (ColorBufferGL3)colorBuffer;
        GL33C.glFramebufferTexture2D(36160, 36064 + this.getColorBuffers().size(), ((ColorBufferGL3)colorBuffer).getTarget(), ((ColorBufferGL3)colorBuffer).getTexture(), 0);
        ErrorGL3Kt.debugGLErrors(attach.1.INSTANCE);
        this._colorBuffers.add((ColorBufferGL3)colorBuffer);
        Stack stack = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
        if ((stack != null ? (RenderTargetGL3)stack.peek() : null) != null) {
            Stack stack2 = (Stack)RenderTargetGL3Kt.access$getActive$p().get(context);
            RenderTargetGL3 renderTargetGL3 = stack2 != null ? (RenderTargetGL3)stack2.peek() : null;
            if (renderTargetGL3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            }
            renderTargetGL3.bindTarget();
        }
    }

    private final void bound(Function0<Unit> function) {
        this.bind();
        function.invoke();
        this.unbind();
    }

    @Override
    public void clearColor(int index, @NotNull ColorRGBa color) {
        Intrinsics.checkParameterIsNotNull(color, "color");
        this.bound(new Function0<Unit>(color, index){
            final /* synthetic */ ColorRGBa $color;
            final /* synthetic */ int $index;

            public final void invoke() {
                float[] ca = new float[]{(float)this.$color.getR(), (float)this.$color.getG(), (float)this.$color.getB(), (float)this.$color.getA()};
                GL33C.glClearBufferfv(6144, 34853 + this.$index, ca);
            }
            {
                this.$color = colorRGBa;
                this.$index = n;
                super(0);
            }
        });
    }

    @Override
    public void clearDepth(double depth, int stencil) {
        this.bound(new Function0<Unit>(depth, stencil){
            final /* synthetic */ double $depth;
            final /* synthetic */ int $stencil;

            public final void invoke() {
                GL33C.glClearBufferfi(34041, 0, (float)this.$depth, this.$stencil);
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
            }
            {
                this.$depth = d;
                this.$stencil = n;
                super(0);
            }
        });
    }

    @Override
    public void attach(@NotNull DepthBuffer depthBuffer) {
        Intrinsics.checkParameterIsNotNull(depthBuffer, "depthBuffer");
        if (depthBuffer.getWidth() != this.getEffectiveWidth() || depthBuffer.getHeight() != this.getEffectiveHeight()) {
            throw (Throwable)new IllegalArgumentException("buffer dimension mismatch");
        }
        if (Intrinsics.areEqual(depthBuffer.getMultisample(), this.getMultisample()) ^ true) {
            throw (Throwable)new IllegalArgumentException("buffer multisample mismatch");
        }
        this.bound(new Function0<Unit>(this, depthBuffer){
            final /* synthetic */ RenderTargetGL3 this$0;
            final /* synthetic */ DepthBuffer $depthBuffer;

            public final void invoke() {
                DepthBuffer depthBuffer = this.$depthBuffer;
                if (depthBuffer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.DepthBufferGL3");
                }
                DepthBufferGL3 cfr_ignored_0 = (DepthBufferGL3)depthBuffer;
                GL33C.glFramebufferTexture2D(36160, 36096, ((DepthBufferGL3)this.$depthBuffer).getTarget(), ((DepthBufferGL3)this.$depthBuffer).getTexture(), 0);
                ErrorGL3Kt.debugGLErrors(attach.1.INSTANCE);
                if (this.$depthBuffer.getHasStencil()) {
                    GL33C.glFramebufferTexture2D(36160, 36128, ((DepthBufferGL3)this.$depthBuffer).getTarget(), ((DepthBufferGL3)this.$depthBuffer).getTexture(), 0);
                    ErrorGL3Kt.debugGLErrors(attach.2.INSTANCE);
                }
                ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                RenderTargetGL3.access$set_depthBuffer$p(this.this$0, this.$depthBuffer);
                this.this$0.checkFramebufferStatus$openrndr_gl3();
            }
            {
                this.this$0 = renderTargetGL3;
                this.$depthBuffer = depthBuffer;
                super(0);
            }
        });
    }

    @Override
    public void detachDepthBuffer() {
        block1: {
            DepthBuffer depthBuffer;
            DepthBuffer it;
            DepthBuffer depthBuffer2 = this._depthBuffer;
            if (depthBuffer2 == null) break block1;
            DepthBuffer depthBuffer3 = it = (depthBuffer = depthBuffer2);
            if (depthBuffer3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.DepthBufferGL3");
            }
            DepthBufferGL3 cfr_ignored_0 = (DepthBufferGL3)depthBuffer3;
            this.bound(new Function0<Unit>(it){
                final /* synthetic */ DepthBuffer $it;

                public final void invoke() {
                    GL33C.glFramebufferTexture2D(36160, 36096, ((DepthBufferGL3)this.$it).getTarget(), 0, 0);
                    GL33C.glFramebufferTexture2D(36160, 36128, ((DepthBufferGL3)this.$it).getTarget(), 0, 0);
                    ErrorGL3Kt.checkGLErrors$default(null, 1, null);
                }
                {
                    this.$it = depthBuffer;
                    super(0);
                }
            });
        }
    }

    public final void checkFramebufferStatus$openrndr_gl3() {
        int status = GL33C.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            switch (status) {
                case 33305: {
                    throw (Throwable)new GL3Exception("Framebuffer undefined");
                }
                case 36054: {
                    throw (Throwable)new GL3Exception("Attachment incomplete");
                }
                case 36055: {
                    throw (Throwable)new GL3Exception("Attachment missing");
                }
                case 36059: {
                    throw (Throwable)new GL3Exception("Incomplete draw buffer");
                }
            }
            throw (Throwable)new GL3Exception("error creating framebuffer " + status);
        }
        ErrorGL3Kt.checkGLErrors$default(null, 1, null);
    }

    @Override
    public void detachColorBuffers() {
        this.bound(new Function0<Unit>(this){
            final /* synthetic */ RenderTargetGL3 this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Iterable $receiver$iv = RenderTargetGL3.access$get_colorBuffers$p(this.this$0);
                int index$iv = 0;
                for (T item$iv : $receiver$iv) {
                    void it;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    ColorBufferGL3 colorBufferGL3 = (ColorBufferGL3)item$iv;
                    int index = n2;
                    GL33C.glFramebufferTexture2D(36160, 36064 + index, it.getTarget(), 0, 0);
                }
            }
            {
                this.this$0 = renderTargetGL3;
                super(0);
            }
        });
        this._colorBuffers.clear();
    }

    @Override
    public void destroy() {
        GL33C.glDeleteFramebuffers(this.framebuffer);
    }

    public final int getFramebuffer() {
        return this.framebuffer;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getContentScale() {
        return this.contentScale;
    }

    @Override
    @NotNull
    public BufferMultisample getMultisample() {
        return this.multisample;
    }

    public RenderTargetGL3(int framebuffer, int width, int height, double contentScale, @NotNull BufferMultisample multisample, @NotNull Thread thread2) {
        Intrinsics.checkParameterIsNotNull(multisample, "multisample");
        Intrinsics.checkParameterIsNotNull(thread2, "thread");
        this.framebuffer = framebuffer;
        this.width = width;
        this.height = height;
        this.contentScale = contentScale;
        this.multisample = multisample;
        this.thread = thread2;
        RenderTargetGL3 renderTargetGL3 = this;
        Object object = new LinkedHashMap();
        renderTargetGL3.colorBufferIndices = object;
        renderTargetGL3 = this;
        renderTargetGL3._colorBuffers = object = (List)new ArrayList();
    }

    public /* synthetic */ RenderTargetGL3(int n, int n2, int n3, double d, BufferMultisample bufferMultisample, Thread thread2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x20) != 0) {
            Thread thread3 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread3, "Thread.currentThread()");
            thread2 = thread3;
        }
        this(n, n2, n3, d, bufferMultisample, thread2);
    }

    @Override
    public int getEffectiveHeight() {
        return RenderTarget.DefaultImpls.getEffectiveHeight(this);
    }

    @Override
    public int getEffectiveWidth() {
        return RenderTarget.DefaultImpls.getEffectiveWidth(this);
    }

    @Nullable
    public static final /* synthetic */ DepthBuffer access$get_depthBuffer$p(RenderTargetGL3 $this) {
        return $this._depthBuffer;
    }

    public static final /* synthetic */ void access$set_depthBuffer$p(RenderTargetGL3 $this, @Nullable DepthBuffer depthBuffer) {
        $this._depthBuffer = depthBuffer;
    }

    @NotNull
    public static final /* synthetic */ List access$get_colorBuffers$p(RenderTargetGL3 $this) {
        return $this._colorBuffers;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/internal/gl3/RenderTargetGL3$Companion;", "", "()V", "activeRenderTarget", "Lorg/openrndr/internal/gl3/RenderTargetGL3;", "getActiveRenderTarget", "()Lorg/openrndr/internal/gl3/RenderTargetGL3;", "create", "width", "", "height", "contentScale", "", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "openrndr-gl3"})
    public static final class Companion {
        @NotNull
        public final RenderTargetGL3 create(int width, int height, double contentScale, @NotNull BufferMultisample multisample) {
            Intrinsics.checkParameterIsNotNull(multisample, "multisample");
            RenderTargetGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(width, height, contentScale, multisample){
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ double $contentScale;
                final /* synthetic */ BufferMultisample $multisample;

                @NotNull
                public final String invoke() {
                    return "created new render target (" + this.$width + '*' + this.$height + ") @ " + this.$contentScale + "x " + this.$multisample;
                }
                {
                    this.$width = n;
                    this.$height = n2;
                    this.$contentScale = d;
                    this.$multisample = bufferMultisample;
                    super(0);
                }
            });
            int framebuffer = GL33C.glGenFramebuffers();
            return new RenderTargetGL3(framebuffer, width, height, contentScale, multisample, null, 32, null);
        }

        @NotNull
        public static /* synthetic */ RenderTargetGL3 create$default(Companion companion, int n, int n2, double d, BufferMultisample bufferMultisample, int n3, Object object) {
            if ((n3 & 4) != 0) {
                d = 1.0;
            }
            if ((n3 & 8) != 0) {
                bufferMultisample = BufferMultisample.Disabled.INSTANCE;
            }
            return companion.create(n, n2, d, bufferMultisample);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RenderTargetGL3 getActiveRenderTarget() {
            Object object;
            void $receiver$iv;
            Map map2 = RenderTargetGL3Kt.access$getActive$p();
            Long key$iv = GLFW.glfwGetCurrentContext();
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                Stack answer$iv = new Stack();
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Stack stack = (Stack)object;
            Object e = stack.peek();
            Intrinsics.checkExpressionValueIsNotNull(e, "stack.peek()");
            return (RenderTargetGL3)e;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

