/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.system.MemoryStack;
import org.openrndr.Application;
import org.openrndr.Configuration;
import org.openrndr.DropEvent;
import org.openrndr.Fullscreen;
import org.openrndr.KeyEvent;
import org.openrndr.KeyEventType;
import org.openrndr.KeyboardModifier;
import org.openrndr.MouseButton;
import org.openrndr.MouseEvent;
import org.openrndr.MouseEventType;
import org.openrndr.PresentationMode;
import org.openrndr.Program;
import org.openrndr.UnfocusBehaviour;
import org.openrndr.WindowEvent;
import org.openrndr.WindowEventType;
import org.openrndr.WindowMultisample;
import org.openrndr.draw.Drawer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationGLFWGL3;
import org.openrndr.internal.gl3.ApplicationGLFWGL3Kt;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.IntVector2;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0002J\n\u0010;\u001a\u0004\u0018\u00010<H\u0002J\b\u0010=\u001a\u000209H\u0016J\b\u0010>\u001a\u000209H\u0016J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010B\u001a\u00020CH\u0002J\u0006\u0010D\u001a\u000209J\b\u0010E\u001a\u000209H\u0016J\b\u0010F\u001a\u000209H\u0016J\b\u0010G\u001a\u000209H\u0016J\b\u0010H\u001a\u000209H\u0002R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010\u0011\"\u0004\b4\u0010\u0013R$\u00105\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u000b\"\u0004\b7\u0010\r\u00a8\u0006I"}, d2={"Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "Lorg/openrndr/Application;", "program", "Lorg/openrndr/Program;", "configuration", "Lorg/openrndr/Configuration;", "(Lorg/openrndr/Program;Lorg/openrndr/Configuration;)V", "value", "", "clipboardContents", "getClipboardContents", "()Ljava/lang/String;", "setClipboardContents", "(Ljava/lang/String;)V", "Lorg/openrndr/math/Vector2;", "cursorPosition", "getCursorPosition", "()Lorg/openrndr/math/Vector2;", "setCursorPosition", "(Lorg/openrndr/math/Vector2;)V", "", "cursorVisible", "getCursorVisible", "()Z", "setCursorVisible", "(Z)V", "drawRequested", "driver", "Lorg/openrndr/internal/gl3/DriverGL3;", "exitRequested", "fixWindowSize", "presentationMode", "Lorg/openrndr/PresentationMode;", "getPresentationMode", "()Lorg/openrndr/PresentationMode;", "setPresentationMode", "(Lorg/openrndr/PresentationMode;)V", "realCursorPosition", "realCursorVisible", "realWindowTitle", "seconds", "", "getSeconds", "()D", "setupCalled", "vaos", "", "window", "", "windowFocused", "windowPosition", "getWindowPosition", "setWindowPosition", "windowTitle", "getWindowTitle", "setWindowTitle", "createPrimaryWindow", "", "deliverEvents", "drawFrame", "", "exit", "loop", "modifierSet", "", "Lorg/openrndr/KeyboardModifier;", "mods", "", "preloop", "requestDraw", "requestFocus", "setup", "setupSizes", "openrndr-gl3"})
public final class ApplicationGLFWGL3
extends Application {
    private boolean windowFocused;
    private long window;
    private DriverGL3 driver;
    private String realWindowTitle;
    private boolean exitRequested;
    private final boolean fixWindowSize;
    private boolean setupCalled;
    @NotNull
    private PresentationMode presentationMode;
    private Vector2 realCursorPosition;
    private boolean realCursorVisible;
    private final int[] vaos;
    private boolean drawRequested;
    private final Program program;
    private final Configuration configuration;

    @Override
    @NotNull
    public PresentationMode getPresentationMode() {
        return this.presentationMode;
    }

    @Override
    public void setPresentationMode(@NotNull PresentationMode presentationMode) {
        Intrinsics.checkParameterIsNotNull((Object)presentationMode, "<set-?>");
        this.presentationMode = presentationMode;
    }

    @Override
    @NotNull
    public Vector2 getCursorPosition() {
        return this.realCursorPosition;
    }

    @Override
    public void setCursorPosition(@NotNull Vector2 value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this.realCursorPosition = value2;
        GLFW.glfwSetCursorPos(this.window, value2.getX(), value2.getY());
    }

    @Override
    public boolean getCursorVisible() {
        return this.realCursorVisible;
    }

    @Override
    public void setCursorVisible(boolean value2) {
        if (value2) {
            GLFW.glfwSetInputMode(this.window, 208897, 212993);
        } else {
            GLFW.glfwSetInputMode(this.window, 208897, 212995);
        }
    }

    @Override
    @NotNull
    public Vector2 getWindowPosition() {
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowPos(this.window, x, y);
        return new Vector2(this.fixWindowSize ? (double)x[0] / this.program.getWindow().getScale().getX() : (double)x[0], this.fixWindowSize ? (double)y[0] / this.program.getWindow().getScale().getY() : (double)y[0]);
    }

    @Override
    public void setWindowPosition(@NotNull Vector2 value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        GLFW.glfwSetWindowPos(this.window, this.fixWindowSize ? (int)(value2.getX() * this.program.getWindow().getScale().getX()) : (int)value2.getX(), this.fixWindowSize ? (int)(value2.getY() * this.program.getWindow().getScale().getY()) : (int)value2.getY());
    }

    @Override
    @Nullable
    public String getClipboardContents() {
        String string;
        try {
            String result = GLFW.glfwGetClipboardString(this.window);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @Override
    public void setClipboardContents(@Nullable String value2) {
        if (value2 == null) {
            throw (Throwable)new RuntimeException("clipboard contents can't be null");
        }
        GLFW.glfwSetClipboardString(this.window, value2);
    }

    @Override
    public double getSeconds() {
        return GLFW.glfwGetTime();
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return this.realWindowTitle;
    }

    @Override
    public void setWindowTitle(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        GLFW.glfwSetWindowTitle(this.window, value2);
        this.realWindowTitle = value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setup() {
        ApplicationGLFWGL3 applicationGLFWGL3;
        void readyFrames;
        ByteBuffer buf;
        int requestHeight;
        long l;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 3);
        GLFW.glfwWindowHint(139270, 1);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, this.configuration.getWindowResizable() ? 1 : 0);
        GLFW.glfwWindowHint(131077, this.configuration.getHideWindowDecorations() ? 0 : 1);
        Object c2 = this.configuration.getMultisample();
        if (c2 instanceof WindowMultisample.SampleCount) {
            GLFW.glfwWindowHint(135181, ((WindowMultisample.SampleCount)c2).getCount());
        } else if (Intrinsics.areEqual(c2, WindowMultisample.SystemDefault.INSTANCE)) {
            GLFW.glfwWindowHint(135181, -1);
        } else if (Intrinsics.areEqual(c2, WindowMultisample.Disabled.INSTANCE)) {
            GLFW.glfwWindowHint(135181, 0);
        }
        GLFW.glfwWindowHint(135169, 8);
        GLFW.glfwWindowHint(135170, 8);
        GLFW.glfwWindowHint(135171, 8);
        GLFW.glfwWindowHint(135174, 8);
        GLFW.glfwWindowHint(135173, 24);
        if (this.configuration.getWindowAlwaysOnTop()) {
            GLFW.glfwWindowHint(131079, 1);
        }
        c2 = GLFW.glfwGetVersionString();
        System.out.println(c2);
        if (DriverGL3Kt.getUseDebugContext()) {
            GLFW.glfwWindowHint(139271, 1);
        }
        float[] xscale = new float[1];
        float[] yscale = new float[1];
        GLFW.glfwGetMonitorContentScale(GLFW.glfwGetPrimaryMonitor(), xscale, yscale);
        if (this.configuration.getFullscreen() == Fullscreen.SET_DISPLAY_MODE) {
            xscale[0] = 1.0f;
            yscale[0] = 1.0f;
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(xscale, yscale){
            final /* synthetic */ float[] $xscale;
            final /* synthetic */ float[] $yscale;

            @NotNull
            public final String invoke() {
                return "content scale " + this.$xscale[0] + ' ' + this.$yscale[0];
            }
            {
                this.$xscale = fArray;
                this.$yscale = fArray2;
                super(0);
            }
        });
        this.program.getWindow().setScale(new Vector2(xscale[0], yscale[0]));
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.2.INSTANCE);
        if (this.configuration.getFullscreen() == Fullscreen.DISABLED) {
            int adjustedWidth = this.fixWindowSize ? (int)(xscale[0] * (float)this.configuration.getWidth()) : this.configuration.getWidth();
            int adjustedHeight = this.fixWindowSize ? (int)(yscale[0] * (float)this.configuration.getHeight()) : this.configuration.getHeight();
            l = GLFW.glfwCreateWindow(adjustedWidth, adjustedHeight, this.configuration.getTitle(), 0L, ApplicationGLFWGL3Kt.getPrimaryWindow());
        } else {
            ApplicationGLFWGL3Kt.access$getLogger$p().info(setup.3.INSTANCE);
            int requestWidth = this.configuration.getWidth();
            requestHeight = this.configuration.getHeight();
            if (this.configuration.getFullscreen() == Fullscreen.CURRENT_DISPLAY_MODE) {
                GLFWVidMode mode22 = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
                if (mode22 != null) {
                    requestWidth = mode22.width();
                    requestHeight = mode22.height();
                } else {
                    throw (Throwable)new RuntimeException("failed to determine current video mode");
                }
            }
            l = GLFW.glfwCreateWindow(requestWidth, requestHeight, this.configuration.getTitle(), GLFW.glfwGetPrimaryMonitor(), ApplicationGLFWGL3Kt.getPrimaryWindow());
        }
        this.window = l;
        ByteBuffer byteBuffer = buf = BufferUtils.createByteBuffer(65536);
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        byteBuffer.rewind();
        requestHeight = 0;
        int mode22 = 128;
        while (requestHeight < mode22) {
            void y;
            int n = 0;
            int n2 = 128;
            while (n < n2) {
                void x;
                buf.putInt((int)4290825215L);
                ++x;
            }
            ++y;
        }
        buf.flip();
        Object y = MemoryStack.stackPush();
        Throwable mode22 = null;
        try {
            Object it = (MemoryStack)y;
            GLFW.glfwSetWindowIcon(this.window, GLFWImage.mallocStack(1, (MemoryStack)it).width(128).height(128).pixels(buf));
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            mode22 = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)y, mode22);
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            @NotNull
            public final String invoke() {
                return "window created: " + ApplicationGLFWGL3.access$getWindow$p(this.this$0);
            }
            {
                this.this$0 = applicationGLFWGL3;
                super(0);
            }
        });
        if (this.window == 0L) {
            throw (Throwable)new RuntimeException("Failed to create the GLFW window");
        }
        y = MemoryStack.stackPush();
        AutoCloseable stack = y;
        IntBuffer pWidth = ((MemoryStack)stack).mallocInt(1);
        IntBuffer pHeight = ((MemoryStack)stack).mallocInt(1);
        GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        if (this.configuration.getPosition() == null) {
            if (vidmode != null) {
                GLFW.glfwSetWindowPos(this.window, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
            }
        } else {
            IntVector2 intVector2 = this.configuration.getPosition();
            if (intVector2 != null) {
                IntVector2 intVector22;
                IntVector2 it = intVector22 = intVector2;
                GLFW.glfwSetWindowPos(this.window, it.getX(), it.getY());
            }
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.7.INSTANCE);
        GLFW.glfwMakeContextCurrent(this.window);
        if (GLFW.glfwExtensionSupported("GLX_EXT_swap_control_tear") || GLFW.glfwExtensionSupported("WGL_EXT_swap_control_tear")) {
            GLFW.glfwSwapInterval(-1);
        } else {
            GLFW.glfwSwapInterval(1);
        }
        y = new Ref.IntRef();
        ((Ref.IntRef)y).element = 0;
        GLFW.glfwSetWindowRefreshCallback(this.window, new GLFWWindowRefreshCallbackI(this, (Ref.IntRef)readyFrames){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.IntRef $readyFrames;

            public final void invoke(long it) {
                if (this.$readyFrames.element > 0) {
                    if (ApplicationGLFWGL3.access$getSetupCalled$p(this.this$0)) {
                        ApplicationGLFWGL3.access$drawFrame(this.this$0);
                    }
                    GLFW.glfwSwapBuffers(ApplicationGLFWGL3.access$getWindow$p(this.this$0));
                }
                int n = this.$readyFrames.element;
                this.$readyFrames.element = n + 1;
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$readyFrames = intRef;
            }
        });
        GLFW.glfwSetFramebufferSizeCallback(this.window, new GLFWFramebufferSizeCallbackI(this, (Ref.IntRef)readyFrames){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.IntRef $readyFrames;

            public final void invoke(long window, int width, int height) {
                ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(width, height){
                    final /* synthetic */ int $width;
                    final /* synthetic */ int $height;

                    @NotNull
                    public final String invoke() {
                        return "resizing window to " + this.$width + 'x' + this.$height + ' ';
                    }
                    {
                        this.$width = n;
                        this.$height = n2;
                        super(0);
                    }
                });
                if (this.$readyFrames.element > 0) {
                    ApplicationGLFWGL3.access$setupSizes(this.this$0);
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSized().trigger(new WindowEvent(WindowEventType.RESIZED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                }
                int n = this.$readyFrames.element;
                this.$readyFrames.element = n + 1;
                ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.2.INSTANCE);
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$readyFrames = intRef;
            }
        });
        GLFW.glfwSetWindowPosCallback(this.window, new GLFWWindowPosCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, int x, int y) {
                ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(x, y){
                    final /* synthetic */ int $x;
                    final /* synthetic */ int $y;

                    @NotNull
                    public final String invoke() {
                        return "window has moved to " + this.$x + ' ' + this.$y;
                    }
                    {
                        this.$x = n;
                        this.$y = n2;
                        super(0);
                    }
                });
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getMoved().trigger(new WindowEvent(WindowEventType.MOVED, new Vector2(x, y), new Vector2(0.0, 0.0), true));
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetWindowFocusCallback(this.window, new GLFWWindowFocusCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, boolean focused) {
                ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(focused){
                    final /* synthetic */ boolean $focused;

                    @NotNull
                    public final String invoke() {
                        return "window focus has changed; focused=" + this.$focused;
                    }
                    {
                        this.$focused = bl;
                        super(0);
                    }
                });
                ApplicationGLFWGL3.access$setWindowFocused$p(this.this$0, focused);
                if (focused) {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getFocused().trigger(new WindowEvent(WindowEventType.FOCUSED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                } else {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getUnfocused().trigger(new WindowEvent(WindowEventType.FOCUSED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), false));
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.12.INSTANCE);
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(setup.13.INSTANCE);
        ApplicationGLFWGL3 $receiver = applicationGLFWGL3 = this;
        int adjustedMinimumWidth = $receiver.fixWindowSize ? (int)(xscale[0] * (float)$receiver.configuration.getMinimumWidth()) : $receiver.configuration.getMinimumWidth();
        int adjustedMinimumHeight = $receiver.fixWindowSize ? (int)(yscale[0] * (float)$receiver.configuration.getMinimumHeight()) : $receiver.configuration.getMinimumHeight();
        int adjustedMaximumWidth = $receiver.fixWindowSize && $receiver.configuration.getMaximumWidth() != Integer.MAX_VALUE ? (int)(xscale[0] * (float)$receiver.configuration.getMaximumWidth()) : $receiver.configuration.getMaximumWidth();
        int adjustedMaximumHeight = $receiver.fixWindowSize && $receiver.configuration.getMaximumHeight() != Integer.MAX_VALUE ? (int)(yscale[0] * (float)$receiver.configuration.getMaximumHeight()) : $receiver.configuration.getMaximumHeight();
        GLFW.glfwSetWindowSizeLimits($receiver.window, adjustedMinimumWidth, adjustedMinimumHeight, adjustedMaximumWidth, adjustedMaximumHeight);
        GLFW.glfwShowWindow(this.window);
    }

    private final void createPrimaryWindow() {
        if (ApplicationGLFWGL3Kt.getPrimaryWindow() == 0L) {
            GLFW.glfwSetErrorCallback(GLFWErrorCallback.create(createPrimaryWindow.1.INSTANCE));
            if (!GLFW.glfwInit()) {
                throw (Throwable)new IllegalStateException("Unable to initialize GLFW");
            }
            GLFW.glfwDefaultWindowHints();
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 3);
            GLFW.glfwWindowHint(139270, 1);
            GLFW.glfwWindowHint(139272, 204801);
            GLFW.glfwWindowHint(135169, 8);
            GLFW.glfwWindowHint(135170, 8);
            GLFW.glfwWindowHint(135171, 8);
            GLFW.glfwWindowHint(135174, 8);
            GLFW.glfwWindowHint(135173, 24);
            GLFW.glfwWindowHint(131076, 0);
            ApplicationGLFWGL3Kt.setPrimaryWindow(GLFW.glfwCreateWindow(640, 480, "OPENRNDR primary window", 0L, 0L));
        }
    }

    public final void preloop() {
        GL.createCapabilities();
        if (DriverGL3Kt.getUseDebugContext()) {
            GLUtil.setupDebugMessageCallback();
        }
        this.driver = new DriverGL3();
        this.program.setDriver(this.driver);
        this.program.setDrawer(new Drawer(this.driver));
        ProgramRenderTargetGL3 defaultRenderTarget = new ProgramRenderTargetGL3(this.program);
        defaultRenderTarget.bind();
        this.setupSizes();
        this.program.getDrawer().ortho();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loop() {
        void lastDragPosition;
        void down;
        void globalModifiers;
        Ref.ObjectRef objectRef;
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.1.INSTANCE);
        this.preloop();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = Vector2.Companion.getZERO();
        Ref.ObjectRef objectRef3 = objectRef = new Ref.ObjectRef();
        Set set = SetsKt.emptySet();
        objectRef3.element = set;
        GLFW.glfwSetKeyCallback(this.window, new GLFWKeyCallbackI(this, (Ref.ObjectRef)globalModifiers){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;

            public final void invoke(long $noName_0, int key, int scancode, int action, int mods) {
                Set modifiers = ApplicationGLFWGL3.access$modifierSet(this.this$0, mods);
                String string = GLFW.glfwGetKeyName(key, scancode);
                if (string == null) {
                    string = "<null>";
                }
                Intrinsics.checkExpressionValueIsNotNull(string, "glfwGetKeyName(key, scancode) ?: \"<null>\"");
                String name = string;
                this.$globalModifiers.element = modifiers;
                switch (action) {
                    case 1: {
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyDown().trigger(new KeyEvent(KeyEventType.KEY_DOWN, key, scancode, name, modifiers, false, 32, null));
                        break;
                    }
                    case 0: {
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyUp().trigger(new KeyEvent(KeyEventType.KEY_UP, key, scancode, name, modifiers, false, 32, null));
                        break;
                    }
                    case 2: {
                        ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyRepeat().trigger(new KeyEvent(KeyEventType.KEY_REPEAT, key, scancode, name, modifiers, false, 32, null));
                    }
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$globalModifiers = objectRef;
            }
        });
        GLFW.glfwSetCharCallback(this.window, new GLFWCharCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long window, int codepoint) {
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getKeyboard().getCharacter().trigger(new Program.CharacterEvent((char)codepoint, SetsKt.emptySet(), false, 4, null));
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetDropCallback(this.window, new GLFWDropCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(long $noName_0, int count2, long names) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                ApplicationGLFWGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(count2){
                    final /* synthetic */ int $count;

                    @NotNull
                    public final String invoke() {
                        return this.$count + " file(s) have been dropped";
                    }
                    {
                        this.$count = n;
                        super(0);
                    }
                });
                PointerBuffer pointers = PointerBuffer.create(names, count2);
                Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, count2);
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator<T> iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    File file = new File(pointers.getStringUTF8((int)it));
                    collection.add(file);
                }
                List files = (List)destination$iv$iv;
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getDrop().trigger(new DropEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), files));
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        GLFW.glfwSetScrollCallback(this.window, new GLFWScrollCallbackI(this, (Ref.ObjectRef)globalModifiers){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;

            public final void invoke(long $noName_0, double xoffset, double yoffset) {
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getScrolled().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), new Vector2(xoffset, yoffset), Vector2.Companion.getZERO(), MouseEventType.SCROLLED, MouseButton.NONE, (Set)this.$globalModifiers.element, false, 64, null));
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$globalModifiers = objectRef;
            }
        });
        GLFW.glfwSetWindowIconifyCallback(this.window, new GLFWWindowIconifyCallbackI(this){
            final /* synthetic */ ApplicationGLFWGL3 this$0;

            public final void invoke(long $noName_0, boolean iconified) {
                if (iconified) {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getMinimized().trigger(new WindowEvent(WindowEventType.MINIMIZED, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), false));
                } else {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getRestored().trigger(new WindowEvent(WindowEventType.RESTORED, ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
            }
        });
        GLFW.glfwSetMouseButtonCallback(this.window, new GLFWMouseButtonCallbackI(this, (Ref.BooleanRef)down, (Ref.ObjectRef)lastDragPosition){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.BooleanRef $down;
            final /* synthetic */ Ref.ObjectRef $lastDragPosition;

            public final void invoke(long $noName_0, int button, int action, int mods) {
                MouseButton mouseButton;
                switch (button) {
                    case 0: {
                        mouseButton = MouseButton.LEFT;
                        break;
                    }
                    case 1: {
                        mouseButton = MouseButton.RIGHT;
                        break;
                    }
                    case 2: {
                        mouseButton = MouseButton.CENTER;
                        break;
                    }
                    default: {
                        mouseButton = MouseButton.NONE;
                    }
                }
                MouseButton mouseButton2 = mouseButton;
                Set modifiers = new LinkedHashSet<E>();
                BitSet buttonsDown = new BitSet();
                if ((mods & 1) != 0) {
                    modifiers.add(KeyboardModifier.SHIFT);
                }
                if ((mods & 4) != 0) {
                    modifiers.add(KeyboardModifier.ALT);
                }
                if ((mods & 2) != 0) {
                    modifiers.add(KeyboardModifier.CTRL);
                }
                if ((mods & 8) != 0) {
                    modifiers.add(KeyboardModifier.SUPER);
                }
                if (action == 1) {
                    this.$down.element = true;
                    this.$lastDragPosition.element = ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition();
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getButtonDown().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_DOWN, mouseButton2, modifiers, false, 64, null));
                    buttonsDown.set(button, true);
                }
                if (action == 0) {
                    this.$down.element = false;
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getButtonUp().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_UP, mouseButton2, modifiers, false, 64, null));
                    buttonsDown.set(button, false);
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getClicked().trigger(new MouseEvent(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.CLICKED, mouseButton2, modifiers, false, 64, null));
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$down = booleanRef;
                this.$lastDragPosition = objectRef;
            }
        });
        GLFW.glfwSetCursorPosCallback(this.window, new GLFWCursorPosCallbackI(this, (Ref.ObjectRef)globalModifiers, (Ref.BooleanRef)down, (Ref.ObjectRef)lastDragPosition){
            final /* synthetic */ ApplicationGLFWGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;
            final /* synthetic */ Ref.BooleanRef $down;
            final /* synthetic */ Ref.ObjectRef $lastDragPosition;

            public final void invoke(long $noName_0, double xpos, double ypos) {
                Vector2 position = ApplicationGLFWGL3.access$getFixWindowSize$p(this.this$0) ? new Vector2(xpos, ypos).div(ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getScale()) : new Vector2(xpos, ypos);
                ApplicationGLFWGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(xpos, ypos, position){
                    final /* synthetic */ double $xpos;
                    final /* synthetic */ double $ypos;
                    final /* synthetic */ Vector2 $position;

                    @NotNull
                    public final String invoke() {
                        return "mouse moved " + this.$xpos + ' ' + this.$ypos + " -- " + this.$position;
                    }
                    {
                        this.$xpos = d;
                        this.$ypos = d2;
                        this.$position = vector2;
                        super(0);
                    }
                });
                ApplicationGLFWGL3.access$setRealCursorPosition$p(this.this$0, position);
                ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getMoved().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.MOVED, MouseButton.NONE, (Set)this.$globalModifiers.element, false, 64, null));
                if (this.$down.element) {
                    ApplicationGLFWGL3.access$getProgram$p(this.this$0).getMouse().getDragged().trigger(new MouseEvent(position, Vector2.Companion.getZERO(), position.minus((Vector2)this.$lastDragPosition.element), MouseEventType.DRAGGED, MouseButton.NONE, (Set)this.$globalModifiers.element, false, 64, null));
                    this.$lastDragPosition.element = position;
                }
            }
            {
                this.this$0 = applicationGLFWGL3;
                this.$globalModifiers = objectRef;
                this.$down = booleanRef;
                this.$lastDragPosition = objectRef2;
            }
        });
        GLFW.glfwSetCursorEnterCallback(this.window, loop.9.INSTANCE);
        if (this.configuration.getShowBeforeSetup()) {
            ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.10.INSTANCE);
            GL30.glDepthMask(true);
            GL30.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
            GL30.glClear(17664);
            GLFW.glfwSwapBuffers(this.window);
            GL30.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
            GL30.glClear(17664);
            GL30.glDepthMask(false);
            GLFW.glfwPollEvents();
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.11.INSTANCE);
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.12.INSTANCE);
        String string = "OpenGL vendor: " + GL30.glGetString(7936);
        System.out.println((Object)string);
        string = "OpenGL version: " + GL30.glGetString(7938);
        System.out.println((Object)string);
        if (this.configuration.getHideCursor()) {
            GLFW.glfwSetInputMode(this.window, 208897, 212995);
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(loop.13.INSTANCE);
        this.program.setup();
        this.setupCalled = true;
        if (GLFW.glfwExtensionSupported("GLX_EXT_swap_control_tear") || GLFW.glfwExtensionSupported("WGL_EXT_swap_control_tear")) {
            GLFW.glfwSwapInterval(-1);
        } else {
            GLFW.glfwSwapInterval(1);
        }
        Throwable exception = null;
        while (!this.exitRequested && !GLFW.glfwWindowShouldClose(this.window)) {
            if (this.getPresentationMode() == PresentationMode.AUTOMATIC || this.drawRequested) {
                this.drawRequested = false;
                exception = this.drawFrame();
                if (exception != null) break;
                GLFW.glfwSwapBuffers(this.window);
            }
            if (!this.windowFocused && this.configuration.getUnfocusBehaviour() == UnfocusBehaviour.THROTTLE) {
                Thread.sleep(100L);
            }
            if (this.getPresentationMode() == PresentationMode.AUTOMATIC) {
                GLFW.glfwPollEvents();
                continue;
            }
            Thread.sleep(1L);
            GLFW.glfwPollEvents();
            this.deliverEvents();
            this.program.getDispatcher().pump();
        }
        ApplicationGLFWGL3Kt.access$getLogger$p().info(loop.14.INSTANCE);
        Callbacks.glfwFreeCallbacks(this.window);
        GLFW.glfwDestroyWindow(this.window);
        ApplicationGLFWGL3Kt.access$getLogger$p().info(loop.15.INSTANCE);
        Throwable throwable = exception;
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            throw it;
        }
    }

    private final void deliverEvents() {
        this.program.getWindow().getDrop().deliver();
        this.program.getWindow().getSized().deliver();
        this.program.getWindow().getUnfocused().deliver();
        this.program.getWindow().getFocused().deliver();
        this.program.getWindow().getMinimized().deliver();
        this.program.getWindow().getRestored().deliver();
        this.program.getKeyboard().getKeyDown().deliver();
        this.program.getKeyboard().getKeyUp().deliver();
        this.program.getKeyboard().getKeyRepeat().deliver();
        this.program.getKeyboard().getCharacter().deliver();
        this.program.getMouse().getMoved().deliver();
        this.program.getMouse().getScrolled().deliver();
        this.program.getMouse().getClicked().deliver();
        this.program.getMouse().getButtonDown().deliver();
        this.program.getMouse().getButtonUp().deliver();
        this.program.getMouse().getDragged().deliver();
    }

    private final Throwable drawFrame() {
        this.setupSizes();
        GL30.glBindVertexArray(this.vaos[0]);
        this.program.getDrawer().reset();
        this.program.getDrawer().ortho();
        this.deliverEvents();
        this.program.getDispatcher().pump();
        try {
            ApplicationGLFWGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(this){
                final /* synthetic */ ApplicationGLFWGL3 this$0;

                @NotNull
                public final String invoke() {
                    return "window: " + (int)ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize().getX() + 'x' + (int)ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWindow().getSize().getY() + " program: " + ApplicationGLFWGL3.access$getProgram$p(this.this$0).getWidth() + 'x' + ApplicationGLFWGL3.access$getProgram$p(this.this$0).getHeight();
                }
                {
                    this.this$0 = applicationGLFWGL3;
                    super(0);
                }
            });
            this.program.drawImpl();
        }
        catch (Throwable e) {
            ApplicationGLFWGL3Kt.access$getLogger$p().error(drawFrame.2.INSTANCE);
            e.printStackTrace();
            return e;
        }
        return null;
    }

    private final void setupSizes() {
        float[] wcsx = new float[1];
        float[] wcsy = new float[1];
        GLFW.glfwGetWindowContentScale(this.window, wcsx, wcsy);
        this.program.getWindow().setScale(new Vector2(wcsx[0], wcsy[0]));
        int[] fbw = new int[1];
        int[] fbh = new int[1];
        GLFW.glfwGetFramebufferSize(this.window, fbw, fbh);
        GL30.glViewport(0, 0, fbw[0], fbh[0]);
        this.program.setWidth((int)Math.ceil((double)fbw[0] / this.program.getWindow().getScale().getX()));
        this.program.setHeight((int)Math.ceil((double)fbh[0] / this.program.getWindow().getScale().getY()));
        this.program.getWindow().setSize(new Vector2(this.program.getWidth(), this.program.getHeight()));
        this.program.getDrawer().setWidth(this.program.getWidth());
        this.program.getDrawer().setHeight(this.program.getHeight());
    }

    private final Set<KeyboardModifier> modifierSet(int mods) {
        Set modifiers = new LinkedHashSet();
        if ((mods & 1) != 0) {
            modifiers.add(KeyboardModifier.SHIFT);
        }
        if ((mods & 4) != 0) {
            modifiers.add(KeyboardModifier.ALT);
        }
        if ((mods & 2) != 0) {
            modifiers.add(KeyboardModifier.CTRL);
        }
        if ((mods & 8) != 0) {
            modifiers.add(KeyboardModifier.SUPER);
        }
        return modifiers;
    }

    @Override
    public void exit() {
        this.exitRequested = true;
    }

    @Override
    public void requestDraw() {
        this.drawRequested = true;
    }

    @Override
    public void requestFocus() {
        GLFW.glfwFocusWindow(this.window);
    }

    public ApplicationGLFWGL3(@NotNull Program program2, @NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull(program2, "program");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.program = program2;
        this.configuration = configuration;
        this.windowFocused = true;
        this.realWindowTitle = this.configuration.getTitle();
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"os.name\")");
        this.fixWindowSize = StringsKt.contains((CharSequence)string, "windows", true);
        this.presentationMode = PresentationMode.AUTOMATIC;
        this.realCursorPosition = new Vector2(0.0, 0.0);
        this.realCursorVisible = true;
        ApplicationGLFWGL3Kt.access$getLogger$p().debug(1.INSTANCE);
        ApplicationGLFWGL3Kt.access$getLogger$p().trace(2.INSTANCE);
        this.driver = new DriverGL3();
        Driver.Companion.setDriver(this.driver);
        this.program.setApplication(this);
        this.createPrimaryWindow();
        this.vaos = new int[1];
        this.drawRequested = true;
    }

    public static final /* synthetic */ long access$getWindow$p(ApplicationGLFWGL3 $this) {
        return $this.window;
    }

    public static final /* synthetic */ void access$setWindow$p(ApplicationGLFWGL3 $this, long l) {
        $this.window = l;
    }

    public static final /* synthetic */ boolean access$getSetupCalled$p(ApplicationGLFWGL3 $this) {
        return $this.setupCalled;
    }

    public static final /* synthetic */ void access$setSetupCalled$p(ApplicationGLFWGL3 $this, boolean bl) {
        $this.setupCalled = bl;
    }

    @Nullable
    public static final /* synthetic */ Throwable access$drawFrame(ApplicationGLFWGL3 $this) {
        return $this.drawFrame();
    }

    public static final /* synthetic */ void access$setupSizes(ApplicationGLFWGL3 $this) {
        $this.setupSizes();
    }

    @NotNull
    public static final /* synthetic */ Program access$getProgram$p(ApplicationGLFWGL3 $this) {
        return $this.program;
    }

    public static final /* synthetic */ boolean access$getWindowFocused$p(ApplicationGLFWGL3 $this) {
        return $this.windowFocused;
    }

    public static final /* synthetic */ void access$setWindowFocused$p(ApplicationGLFWGL3 $this, boolean bl) {
        $this.windowFocused = bl;
    }

    @NotNull
    public static final /* synthetic */ Set access$modifierSet(ApplicationGLFWGL3 $this, int mods) {
        return $this.modifierSet(mods);
    }

    public static final /* synthetic */ boolean access$getFixWindowSize$p(ApplicationGLFWGL3 $this) {
        return $this.fixWindowSize;
    }

    @NotNull
    public static final /* synthetic */ Vector2 access$getRealCursorPosition$p(ApplicationGLFWGL3 $this) {
        return $this.realCursorPosition;
    }

    public static final /* synthetic */ void access$setRealCursorPosition$p(ApplicationGLFWGL3 $this, @NotNull Vector2 vector2) {
        $this.realCursorPosition = vector2;
    }
}

