/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.callbacks;

import java.util.Enumeration;
import java.util.Hashtable;
import jouvieje.bass.callbacks.CallbackBridge;
import jouvieje.bass.exceptions.BassException;

public class CallbackManager {
    private static final boolean DEBUG_MODE = false;
    protected static Hashtable[] callbacksTable = null;
    protected static Object[] lastCallbacksAdded = null;
    protected static Hashtable ownersTable = null;

    static {
        callbacksTable = new Hashtable[17];
        lastCallbacksAdded = new Object[17];
        ownersTable = new Hashtable();
        int i = 0;
        while (i < callbacksTable.length) {
            CallbackManager.callbacksTable[i] = new Hashtable();
            CallbackManager.lastCallbacksAdded[i] = null;
            ++i;
        }
    }

    public static Object getCallback(int type) {
        return CallbackManager.getCallback(type, 0L, false);
    }

    public static Object getCallback(int type, long object, boolean autoAttach) {
        Long owner;
        Long l = owner = object == 0L ? new Long(0L) : (Long)ownersTable.get(new Long(object));
        if (owner != null) {
            Object callback = callbacksTable[type].get(owner);
            if (callback == null) {
                if (object == 0L) {
                    callback = lastCallbacksAdded[type];
                }
                if (callback == null) {
                    throw new BassException("A callback may not be implemented. Please contact support.");
                }
            }
            return callback;
        }
        Object callback = lastCallbacksAdded[type];
        if (callback == null) {
            throw new BassException("A callback may not be implemented. Please contact support.");
        }
        if (autoAttach) {
            Enumeration values2 = callbacksTable[type].elements();
            Enumeration keys2 = callbacksTable[type].keys();
            while (values2.hasMoreElements()) {
                Object currentValue = values2.nextElement();
                Long currentKey = (Long)keys2.nextElement();
                if (currentValue != callback) continue;
                owner = currentKey;
                CallbackManager.addOwner(owner, object);
                break;
            }
        }
        return callback;
    }

    public static void addTmpCallback(int type, Object callback) {
        if (callback != null) {
            CallbackManager.lastCallbacksAdded[type] = callback;
        }
    }

    public static void addCallback(int type, Object callback, long owner) {
        if (callbacksTable[type].remove(new Long(owner)) != null) {
            CallbackManager.lastCallbacksAdded[type] = null;
        }
        if (callback != null) {
            callbacksTable[type].put(new Long(owner), callback);
            CallbackManager.lastCallbacksAdded[type] = callback;
        }
    }

    public static void addOwner(long owner, long object) {
        Object o = ownersTable.remove(new Long(object));
        if (o != null) {
            // empty if block
        }
        if (owner != 0L) {
            ownersTable.put(new Long(object), new Long(owner));
        }
    }

    public static String getCallbackName(int type) {
        return CallbackBridge.getCallbackName(type);
    }

    private static void printDebug(String message) {
        System.out.println("CALLBACK MANAGER : " + message);
    }
}

