/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearSet;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Set;
import io.lacuna.bifurcan.utils.Iterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.IntStream;

public class Sets {
    public static final ISet EMPTY = new ISet(){

        public boolean contains(Object value2) {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        public IList elements() {
            return Lists.EMPTY;
        }

        public long indexOf(Object element) {
            return -1L;
        }

        public Object nth(long index) {
            throw new IndexOutOfBoundsException();
        }

        public ISet add(Object value2) {
            return new Set().add(value2);
        }

        public ISet remove(Object value2) {
            return this;
        }

        @Override
        public ISet forked() {
            return new Set().forked();
        }

        @Override
        public ISet linear() {
            return new Set().linear();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ISet) {
                return ((ISet)obj).size() == 0L;
            }
            return false;
        }

        public ISet clone() {
            return this;
        }

        public String toString() {
            return Sets.toString(this);
        }
    };

    public static <V> long hash(ISet<V> s2) {
        return Sets.hash(s2, Objects::hashCode, (a2, b) -> a2 + b);
    }

    public static <V> long hash(ISet<V> set, ToLongFunction<V> hash, LongBinaryOperator combiner) {
        return set.elements().stream().mapToLong(hash).reduce(combiner).orElse(0L);
    }

    public static <V> boolean equals(ISet<V> a2, ISet<V> b) {
        if (a2.size() != b.size()) {
            return false;
        }
        if (a2 == b) {
            return true;
        }
        return a2.elements().stream().allMatch(b::contains);
    }

    static <V> ISet<V> difference(ISet<V> a2, ISet<V> b) {
        for (V e : b) {
            a2 = a2.remove(e);
        }
        return a2;
    }

    static <V> ISet<V> union(ISet<V> a2, ISet<V> b) {
        for (V e : b) {
            a2 = a2.add(e);
        }
        return a2;
    }

    static <V> ISet<V> intersection(ISet<V> accumulator, ISet<V> a2, ISet<V> b) {
        if (b.size() < a2.size()) {
            return Sets.intersection(accumulator, b, a2);
        }
        for (V e : a2) {
            if (!b.contains(e)) continue;
            accumulator = accumulator.add(e);
        }
        return accumulator;
    }

    public static <V> java.util.Set<V> toSet(final IList<V> elements, final Predicate<V> contains) {
        return new java.util.Set<V>(){

            @Override
            public int size() {
                return (int)elements.size();
            }

            @Override
            public boolean isEmpty() {
                return elements.size() == 0L;
            }

            @Override
            public boolean contains(Object o) {
                return contains.test(o);
            }

            @Override
            public Iterator<V> iterator() {
                return elements.iterator();
            }

            @Override
            public Object[] toArray() {
                return elements.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a2) {
                Object[] ary = a2.length < this.size() ? (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size()) : a2;
                IntStream.range(0, this.size()).forEach((int i) -> {
                    ary[i] = elements.nth(i);
                });
                return ary;
            }

            @Override
            public boolean add(V v) {
                return false;
            }

            @Override
            public boolean remove(Object o) {
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c2) {
                return c2.stream().allMatch(this::contains);
            }

            @Override
            public boolean addAll(Collection<? extends V> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <V> ISet<V> from(IList<V> elements, Predicate<V> contains) {
        return Sets.from(elements, contains, elements::iterator);
    }

    public static <V> ISet<V> from(final IList<V> elements, final Predicate<V> contains, final Supplier<Iterator<V>> iterator2) {
        return new ISet<V>(){

            @Override
            public boolean contains(V value2) {
                return contains.test(value2);
            }

            @Override
            public long size() {
                return elements.size();
            }

            @Override
            public IList<V> elements() {
                return elements;
            }

            @Override
            public long indexOf(V element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V nth(long index) {
                return elements.nth(index);
            }

            @Override
            public Iterator<V> iterator() {
                return (Iterator)iterator2.get();
            }

            public int hashCode() {
                return (int)Sets.hash(this);
            }

            public boolean equals(Object obj) {
                if (obj instanceof ISet) {
                    return Sets.equals(this, (ISet)obj);
                }
                return false;
            }

            @Override
            public ISet<V> clone() {
                return this;
            }

            public String toString() {
                return Sets.toString(this);
            }
        };
    }

    public static <V> String toString(ISet<V> set) {
        return Sets.toString(set, Objects::toString);
    }

    public static <V> String toString(ISet<V> set, Function<V, String> elementPrinter) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<V> it = set.elements().iterator();
        while (it.hasNext()) {
            sb.append(elementPrinter.apply(it.next()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static <V> Collector<V, LinearSet<V>, LinearSet<V>> linearCollector() {
        return Sets.linearCollector(8);
    }

    public static <V> Collector<V, LinearSet<V>, LinearSet<V>> linearCollector(final int capacity) {
        return new Collector<V, LinearSet<V>, LinearSet<V>>(){

            @Override
            public Supplier<LinearSet<V>> supplier() {
                return () -> new LinearSet(capacity);
            }

            @Override
            public BiConsumer<LinearSet<V>, V> accumulator() {
                return LinearSet::add;
            }

            @Override
            public BinaryOperator<LinearSet<V>> combiner() {
                return LinearSet::union;
            }

            @Override
            public Function<LinearSet<V>, LinearSet<V>> finisher() {
                return s2 -> s2;
            }

            @Override
            public java.util.Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
            }
        };
    }

    public static <V> Collector<V, Set<V>, Set<V>> collector() {
        return new Collector<V, Set<V>, Set<V>>(){

            @Override
            public Supplier<Set<V>> supplier() {
                return () -> new Set().linear();
            }

            @Override
            public BiConsumer<Set<V>, V> accumulator() {
                return Set::add;
            }

            @Override
            public BinaryOperator<Set<V>> combiner() {
                return Set::union;
            }

            @Override
            public Function<Set<V>, Set<V>> finisher() {
                return Set::forked;
            }

            @Override
            public java.util.Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.UNORDERED);
            }
        };
    }

    static class VirtualSet<V>
    implements ISet<V> {
        private Set<V> canonical;
        private ISet<V> base;
        private ISet<V> added;
        private ISet<V> removed;
        private boolean linear;

        public VirtualSet(ISet<V> base2) {
            this(base2, EMPTY, EMPTY, false);
        }

        private VirtualSet(ISet<V> base2, ISet<V> added, ISet<V> removed, boolean linear) {
            this.base = base2;
            this.added = added;
            this.removed = removed;
            this.linear = linear;
        }

        private void canonicalize() {
            if (this.canonical != null) {
                this.canonical = ((Set)Set.from(this.base).union((ISet)this.added)).difference((ISet)this.removed);
                this.base = null;
                this.added = null;
                this.removed = null;
            }
        }

        private boolean altered() {
            return this.removed.size() > 0L;
        }

        @Override
        public synchronized boolean contains(V value2) {
            return !this.removed.contains(value2) && (this.base.contains(value2) || this.added.contains(value2));
        }

        @Override
        public long size() {
            return this.base.size() + this.added.size() - this.removed.size();
        }

        @Override
        public long indexOf(V element) {
            if (!this.altered()) {
                long idx = this.added.indexOf(element);
                if (idx == -1L) {
                    idx = this.base.indexOf(element);
                    return idx == -1L ? idx : this.added.size() + idx;
                }
                return idx;
            }
            this.canonicalize();
            return this.canonical.indexOf(element);
        }

        @Override
        public V nth(long index) {
            if (!this.altered()) {
                if (index < this.added.size()) {
                    return this.added.nth(index);
                }
                return this.base.nth(index - this.added.size());
            }
            this.canonicalize();
            return this.canonical.nth(index);
        }

        @Override
        public synchronized ISet<V> add(V value2) {
            if (this.canonical != null) {
                return this.canonical.add((Object)value2);
            }
            ISet<V> removedPrime = this.removed.remove(value2);
            ISet<V> addedPrime = this.added;
            if (!this.base.contains(value2)) {
                addedPrime = this.added.add(value2);
            }
            return this.linear ? this : new VirtualSet<V>(this.base, addedPrime, removedPrime, false);
        }

        @Override
        public synchronized ISet<V> remove(V value2) {
            if (this.canonical != null) {
                return this.canonical.remove((Object)value2);
            }
            ISet<V> removedPrime = this.removed.add(value2);
            ISet<V> addedPrime = this.added.remove(value2);
            return this.linear ? this : new VirtualSet<V>(this.base, addedPrime, removedPrime, false);
        }

        @Override
        public synchronized Iterator<V> iterator() {
            if (this.canonical != null) {
                return this.canonical.iterator();
            }
            if (!this.altered()) {
                return Iterators.concat(this.added.iterator(), this.base.iterator());
            }
            return Iterators.concat(this.added.iterator(), Iterators.filter(this.base.iterator(), v -> !this.removed.contains(v)));
        }

        @Override
        public ISet<V> forked() {
            if (this.canonical != null) {
                return this.canonical.forked();
            }
            return new VirtualSet<V>(this.added.forked(), this.removed.forked(), this.base, false);
        }

        @Override
        public ISet<V> linear() {
            if (this.canonical != null) {
                return this.canonical.linear();
            }
            return new VirtualSet<V>(this.added.linear(), this.removed.linear(), this.base, true);
        }

        public int hashCode() {
            return (int)Sets.hash(this);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ISet) {
                return Sets.equals(this, (ISet)obj);
            }
            return false;
        }

        @Override
        public VirtualSet<V> clone() {
            return new VirtualSet<V>(this.added.clone(), this.removed.clone(), this.base, this.isLinear());
        }

        public String toString() {
            return Sets.toString(this);
        }
    }
}

