/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.LinearType;
import org.openrndr.shape.internal.BezierCubicSamplerTKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 !*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001!B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005JG\u0010\u0013\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n0\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0088\u0001\u0010\u0013\u001a\u00020\u001a2\u001c\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n2\u001c\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n2\u001c\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n2\u001c\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n2\u0006\u0010\u001f\u001a\u00020 H\u0002R*\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/openrndr/shape/internal/BezierCubicSamplerT;", "T", "Lorg/openrndr/math/EuclideanVector;", "", "<init>", "()V", "points", "", "Lkotlin/Pair;", "", "Lorg/openrndr/shape/internal/Tt;", "distanceToleranceSquare", "angleTolerance", "cuspLimit", "distanceTolerance", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "sample", "", "x1", "x2", "x3", "x4", "(Lorg/openrndr/math/EuclideanVector;Lorg/openrndr/math/EuclideanVector;Lorg/openrndr/math/EuclideanVector;Lorg/openrndr/math/EuclideanVector;)Ljava/util/List;", "", "vt1", "vt2", "vt3", "vt4", "level", "", "Companion", "openrndr-shape"})
public final class BezierCubicSamplerT<T extends EuclideanVector<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<T, Double>> points = new ArrayList();
    private double distanceToleranceSquare;
    private final double angleTolerance;
    private final double cuspLimit;
    private double distanceTolerance = 0.5;
    private static final double colinearityEpsilon = 1.0E-30;
    private static final double angleToleranceEpsilon = 0.01;
    private static final int recursionLimit = 12;

    public final double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public final void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    @NotNull
    public final List<Pair<T, Double>> sample(@NotNull T x1, @NotNull T x2, @NotNull T x3, @NotNull T x4) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        Intrinsics.checkNotNullParameter(x4, "x4");
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.points.add(TuplesKt.to(x1, 0.0));
        this.sample(TuplesKt.to(x1, 0.0), TuplesKt.to(x2, 0.3333333333333333), TuplesKt.to(x3, 0.6666666666666666), TuplesKt.to(x4, 1.0), 0);
        if (((EuclideanVector)CollectionsKt.last(this.points).getFirst()).squaredDistanceTo(x4) > 0.0) {
            this.points.add(TuplesKt.to(x4, 1.0));
        }
        return this.points;
    }

    private final void sample(Pair<? extends T, Double> vt1, Pair<? extends T, Double> vt2, Pair<? extends T, Double> vt3, Pair<? extends T, Double> vt4, int level) {
        EuclideanVector x1 = (EuclideanVector)vt1.getFirst();
        EuclideanVector x2 = (EuclideanVector)vt2.getFirst();
        EuclideanVector x3 = (EuclideanVector)vt3.getFirst();
        EuclideanVector x4 = (EuclideanVector)vt4.getFirst();
        if (level > 12) {
            return;
        }
        Pair vt12 = BezierCubicSamplerTKt.access$times(BezierCubicSamplerTKt.access$plus(vt1, vt2), 0.5);
        Pair vt23 = BezierCubicSamplerTKt.access$times(BezierCubicSamplerTKt.access$plus(vt2, vt3), 0.5);
        Pair vt34 = BezierCubicSamplerTKt.access$times(BezierCubicSamplerTKt.access$plus(vt3, vt4), 0.5);
        Pair vt123 = BezierCubicSamplerTKt.access$times(BezierCubicSamplerTKt.access$plus(vt12, vt23), 0.5);
        Pair vt234 = BezierCubicSamplerTKt.access$times(BezierCubicSamplerTKt.access$plus(vt23, vt34), 0.5);
        Pair vt1234 = BezierCubicSamplerTKt.access$times(BezierCubicSamplerTKt.access$plus(vt123, vt234), 0.5);
        EuclideanVector d = (EuclideanVector)x4.minus((LinearType)x1);
        double d2 = ((EuclideanVector)x2.minus((LinearType)x4)).areaBetween(d);
        double d3 = ((EuclideanVector)x3.minus((LinearType)x4)).areaBetween(d);
        boolean p1 = d2 > 1.0E-30;
        boolean p0 = d3 > 1.0E-30;
        int p = (p1 ? 2 : 0) + (p0 ? 1 : 0);
        double k = 0.0;
        switch (p) {
            case 0: {
                k = d.getSquaredLength();
                if (k == 0.0) {
                    d2 = x1.squaredDistanceTo(x2);
                    d3 = x3.squaredDistanceTo(x4);
                } else {
                    k = 1.0 / k;
                    BezierCubicSamplerT $this$sample_u24lambda_u240 = this;
                    boolean bl = false;
                    EuclideanVector dl = (EuclideanVector)x2.minus((LinearType)x1);
                    d2 = k * d.dot(dl);
                    BezierCubicSamplerT $this$sample_u24lambda_u241 = this;
                    boolean bl2 = false;
                    dl = (EuclideanVector)x3.minus((LinearType)x1);
                    d3 = k * d.dot(dl);
                    if (d2 > 0.0 && d2 < 1.0 && d3 > 0.0 && d3 < 1.0) {
                        return;
                    }
                    d2 = d2 <= 0.0 ? x1.squaredDistanceTo(x2) : (d2 >= 1.0 ? x2.squaredDistanceTo(x4) : x2.squaredDistanceTo((EuclideanVector)x1.plus(d.times(d2))));
                    double d4 = d3 <= 0.0 ? x3.squaredDistanceTo(x1) : (d3 = d3 >= 1.0 ? x3.squaredDistanceTo(x4) : x3.squaredDistanceTo((EuclideanVector)x1.plus(d.times(d3))));
                }
                if (d2 > d3) {
                    if (!(d2 < this.distanceToleranceSquare)) break;
                    if (((EuclideanVector)CollectionsKt.last(this.points).getFirst()).squaredDistanceTo(x2) > 0.0) {
                        this.points.add(vt2);
                    }
                    return;
                }
                if (!(d3 < this.distanceToleranceSquare)) break;
                if (((EuclideanVector)CollectionsKt.last(this.points).getFirst()).squaredDistanceTo(x3) > 0.0) {
                    this.points.add(vt3);
                }
                return;
            }
            case 1: {
                if (!(d3 * d3 <= this.distanceToleranceSquare * d.getSquaredLength())) break;
                if (this.angleTolerance < 0.01) {
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt23) > 0.0) {
                        this.points.add(vt23);
                    }
                    return;
                }
                double da1 = Math.abs(((EuclideanVector)x4.minus((LinearType)x3)).atan2((EuclideanVector)x3.minus((LinearType)x2)));
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), x2) > 0.0) {
                        this.points.add(vt2);
                    }
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), x3) > 0.0) {
                        this.points.add(vt3);
                    }
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), x3) > 0.0) {
                    this.points.add(vt3);
                }
                return;
            }
            case 2: {
                if (!(d2 * d2 <= this.distanceToleranceSquare * d.getSquaredLength())) break;
                if (this.angleTolerance < 0.01) {
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt23) > 0.0) {
                        this.points.add(vt23);
                    }
                    return;
                }
                double da1 = Math.abs(((EuclideanVector)x3.minus((LinearType)x2)).atan2((EuclideanVector)x2.minus((LinearType)x1)));
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt2) > 0.0) {
                        this.points.add(vt2);
                    }
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt3) > 0.0) {
                        this.points.add(vt3);
                    }
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt2) > 0.0) {
                    this.points.add(vt2);
                }
                return;
            }
            case 3: {
                if (!((d2 + d3) * (d2 + d3) <= this.distanceToleranceSquare * d.getSquaredLength())) break;
                if (this.angleTolerance < 0.01) {
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt23) > 0.0) {
                        this.points.add(vt23);
                    }
                    return;
                }
                double da1 = Math.abs(((EuclideanVector)x3.minus((LinearType)x2)).atan2((EuclideanVector)x2.minus((LinearType)x1)));
                double da2 = Math.abs(((EuclideanVector)x4.minus((LinearType)x3)).atan2((EuclideanVector)x3.minus((LinearType)x2)));
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da2 >= Math.PI) {
                    da2 = Math.PI * 2 - da2;
                }
                if (da1 + da2 < this.angleTolerance) {
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt23) > 0.0) {
                        this.points.add(vt23);
                    }
                    return;
                }
                if (this.cuspLimit == 0.0) break;
                if (da1 > this.cuspLimit) {
                    if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt2) > 0.0) {
                        this.points.add(vt2);
                    }
                    return;
                }
                if (!(da2 > this.cuspLimit)) break;
                if (BezierCubicSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt3) > 0.0) {
                    this.points.add(vt3);
                }
                return;
            }
        }
        this.sample(vt1, vt12, vt123, vt1234, level + 1);
        this.sample(vt1234, vt234, vt34, vt4, level + 1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/openrndr/shape/internal/BezierCubicSamplerT$Companion;", "", "<init>", "()V", "colinearityEpsilon", "", "angleToleranceEpsilon", "recursionLimit", "", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

