/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.ktessellation.IndexedPrimitive;
import org.openrndr.ktessellation.IndexedTessellator;
import org.openrndr.ktessellation.Primitive;
import org.openrndr.ktessellation.Tessellator;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.FillRule;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeTopology;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a1\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00012\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b\n\u001a1\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00010\u00012\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"triangulate", "", "Lorg/openrndr/math/Vector2;", "shape", "Lorg/openrndr/shape/Shape;", "distanceTolerance", "", "fillRule", "Lorg/openrndr/shape/FillRule;", "", "triangulateV2", "Lorg/openrndr/math/Vector3;", "triangulateV3", "openrndr-shape"})
public final class TriangulatorKt {
    @NotNull
    public static final List<Vector2> triangulate(@NotNull Shape shape, double distanceTolerance, @NotNull FillRule fillRule) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter(shape, "shape");
        Intrinsics.checkNotNullParameter((Object)fillRule, "fillRule");
        if (shape.getContours().isEmpty() || shape.getTopology() == ShapeTopology.OPEN) {
            return CollectionsKt.emptyList();
        }
        Tessellator tessellator = new Tessellator();
        if (shape.getTopology() == ShapeTopology.CLOSED) {
            switch (WhenMappings.$EnumSwitchMapping$0[fillRule.ordinal()]) {
                case 1: {
                    tessellator.gluTessProperty(100140, 100130);
                    break;
                }
                case 2: {
                    tessellator.gluTessProperty(100140, 100131);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        tessellator.gluTessBeginPolygon(null);
        for (ShapeContour contour : shape.getClosedContours()) {
            if (!(!((Collection)contour.getSegments()).isEmpty())) continue;
            tessellator.gluTessBeginContour();
            List<Vector2> positions = CollectionsKt.dropLast(contour.adaptivePositions(distanceTolerance), 1);
            int n2 = 0;
            int n3 = positions.size() * 3;
            double[] dArray = new double[n3];
            while (n2 < n3) {
                int n4 = n2++;
                dArray[n4] = 0.0;
            }
            double[] positionData = dArray;
            int offset = 0;
            n = ((Collection)positions).size();
            for (i = 0; i < n; ++i) {
                positionData[offset] = positions.get(i).x();
                positionData[++offset] = positions.get(i).y();
                positionData[++offset] = 0.0;
                ++offset;
            }
            n = ((Collection)positions).size();
            for (i = 0; i < n; ++i) {
                double[] dArray2 = new double[]{positions.get(i).x(), positions.get(i).y(), 0.0};
                tessellator.gluTessVertex(positionData, i * 3, dArray2);
            }
            tessellator.gluTessEndContour();
        }
        tessellator.gluTessEndPolygon();
        List result = new ArrayList();
        block13: for (Primitive pd : tessellator.getPrimitives()) {
            if (!(!((Collection)pd.getPositions()).isEmpty())) continue;
            switch (pd.getType()) {
                case 4: {
                    result.addAll((Collection)pd.getPositions());
                    continue block13;
                }
                case 6: {
                    Vector2 fixed = pd.getPositions().get(0);
                    n = pd.getPositions().size() - 1;
                    for (i = 1; i < n; ++i) {
                        result.add(fixed);
                        result.add(pd.getPositions().get(i));
                        result.add(pd.getPositions().get(i + 1));
                    }
                    continue block13;
                }
                case 5: {
                    i = pd.getPositions().size() - 2;
                    for (int i2 = 0; i2 < i; ++i2) {
                        result.add(pd.getPositions().get(i2));
                        result.add(pd.getPositions().get(i2 + 1));
                        result.add(pd.getPositions().get(i2 + 2));
                    }
                    continue block13;
                }
            }
            throw new IllegalStateException(("type not supported: " + pd.getType()).toString());
        }
        int i3 = 0;
        int n5 = ((Collection)result).size() + -1;
        int n6 = ProgressionUtilKt.getProgressionLastElement(0, n5, 3);
        if (i3 <= n6) {
            while (true) {
                Vector2 a = (Vector2)result.get(i3);
                Vector2 b = (Vector2)result.get(i3 + 1);
                Vector2 c2 = (Vector2)result.get(i3 + 2);
                if ((b.x() - a.x()) * (c2.y() - a.y()) < (b.y() - a.y()) * (c2.x() - a.x())) {
                    result.set(i3 + 1, c2);
                    result.set(i3 + 2, b);
                }
                if (i3 == n6) break;
                i3 += 3;
            }
        }
        tessellator.gluDeleteTess();
        return result;
    }

    public static /* synthetic */ List triangulate$default(Shape shape, double d, FillRule fillRule, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        if ((n & 4) != 0) {
            fillRule = FillRule.NONZERO_WINDING;
        }
        return TriangulatorKt.triangulate(shape, d, fillRule);
    }

    @JvmName(name="triangulateV2")
    @NotNull
    public static final List<Integer> triangulateV2(@NotNull List<? extends List<Vector2>> shape, @NotNull FillRule fillRule) {
        int i;
        int dArray;
        Intrinsics.checkNotNullParameter(shape, "shape");
        Intrinsics.checkNotNullParameter((Object)fillRule, "fillRule");
        if (shape.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        IndexedTessellator tessellator = new IndexedTessellator();
        switch (WhenMappings.$EnumSwitchMapping$0[fillRule.ordinal()]) {
            case 1: {
                tessellator.gluTessProperty(100140, 100130);
                break;
            }
            case 2: {
                tessellator.gluTessProperty(100140, 100131);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        tessellator.gluTessBeginPolygon(null);
        int vertexIndex = 0;
        List flatVertices = CollectionsKt.flatten((Iterable)shape);
        for (List<Vector2> list : shape) {
            if (!(!((Collection)list).isEmpty())) continue;
            tessellator.gluTessBeginContour();
            List<Vector2> positions = list;
            int n = 0;
            int n2 = positions.size() * 3;
            double[] dArray2 = new double[n2];
            while (n < n2) {
                int n3 = n++;
                dArray2[n3] = 0.0;
            }
            double[] positionData = dArray2;
            int offset = 0;
            dArray = ((Collection)positions).size();
            for (i = 0; i < dArray; ++i) {
                positionData[offset] = positions.get(i).x();
                positionData[++offset] = positions.get(i).y();
                positionData[++offset] = 0.0;
                ++offset;
            }
            dArray = ((Collection)positions).size();
            for (i = 0; i < dArray; ++i) {
                tessellator.gluTessVertex(positionData, i * 3, vertexIndex);
                ++vertexIndex;
            }
            tessellator.gluTessEndContour();
        }
        tessellator.gluTessEndPolygon();
        List result = new ArrayList();
        block13: for (IndexedPrimitive pd : tessellator.getPrimitives()) {
            if (!(!((Collection)pd.getIndices()).isEmpty())) continue;
            switch (pd.getType()) {
                case 4: {
                    result.addAll((Collection)pd.getIndices());
                    continue block13;
                }
                case 6: {
                    int fixed = ((Number)pd.getIndices().get(0)).intValue();
                    dArray = pd.getIndices().size() - 1;
                    for (i = 1; i < dArray; ++i) {
                        result.add(fixed);
                        result.add(pd.getIndices().get(i));
                        result.add(pd.getIndices().get(i + 1));
                    }
                    continue block13;
                }
                case 5: {
                    i = pd.getIndices().size() - 2;
                    for (int i2 = 0; i2 < i; ++i2) {
                        result.add(pd.getIndices().get(i2));
                        result.add(pd.getIndices().get(i2 + 1));
                        result.add(pd.getIndices().get(i2 + 2));
                    }
                    continue block13;
                }
            }
            throw new IllegalStateException(("type not supported: " + pd.getType()).toString());
        }
        int i3 = 0;
        int n = ((Collection)result).size() + -1;
        int n4 = ProgressionUtilKt.getProgressionLastElement(0, n, 3);
        if (i3 <= n4) {
            while (true) {
                int ia = ((Number)result.get(i3)).intValue();
                int ib = ((Number)result.get(i3 + 1)).intValue();
                int ic = ((Number)result.get(i3 + 2)).intValue();
                Vector2 a = (Vector2)flatVertices.get(ia);
                Vector2 b = (Vector2)flatVertices.get(ib);
                Vector2 c2 = (Vector2)flatVertices.get(ic);
                if ((b.x() - a.x()) * (c2.y() - a.y()) < (b.y() - a.y()) * (c2.x() - a.x())) {
                    result.set(i3 + 1, ic);
                    result.set(i3 + 2, ib);
                }
                if (i3 == n4) break;
                i3 += 3;
            }
        }
        tessellator.gluDeleteTess();
        return result;
    }

    public static /* synthetic */ List triangulateV2$default(List list, FillRule fillRule, int n, Object object) {
        if ((n & 2) != 0) {
            fillRule = FillRule.NONZERO_WINDING;
        }
        return TriangulatorKt.triangulateV2(list, fillRule);
    }

    @JvmName(name="triangulateV3")
    @NotNull
    public static final List<Integer> triangulateV3(@NotNull List<? extends List<Vector3>> shape, @NotNull FillRule fillRule) {
        int i;
        int dArray;
        int n;
        Intrinsics.checkNotNullParameter(shape, "shape");
        Intrinsics.checkNotNullParameter((Object)fillRule, "fillRule");
        if (shape.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        IndexedTessellator tessellator = new IndexedTessellator();
        switch (WhenMappings.$EnumSwitchMapping$0[fillRule.ordinal()]) {
            case 1: {
                tessellator.gluTessProperty(100140, 100130);
                break;
            }
            case 2: {
                tessellator.gluTessProperty(100140, 100131);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        tessellator.gluTessBeginPolygon(null);
        int vertexIndex = 0;
        List flatVertices = CollectionsKt.flatten((Iterable)shape);
        for (List<Vector3> list : shape) {
            if (!(!((Collection)list).isEmpty())) continue;
            tessellator.gluTessBeginContour();
            List<Vector3> positions = list;
            int n2 = 0;
            n = positions.size() * 3;
            double[] dArray2 = new double[n];
            while (n2 < n) {
                int n3 = n2++;
                dArray2[n3] = 0.0;
            }
            double[] positionData = dArray2;
            int offset = 0;
            dArray = ((Collection)positions).size();
            for (i = 0; i < dArray; ++i) {
                positionData[offset] = positions.get(i).x();
                positionData[++offset] = positions.get(i).y();
                positionData[++offset] = positions.get(i).z();
                ++offset;
            }
            dArray = ((Collection)positions).size();
            for (i = 0; i < dArray; ++i) {
                tessellator.gluTessVertex(positionData, i * 3, vertexIndex);
                ++vertexIndex;
            }
            tessellator.gluTessEndContour();
        }
        tessellator.gluTessEndPolygon();
        List result = new ArrayList();
        block13: for (IndexedPrimitive pd : tessellator.getPrimitives()) {
            if (!(!((Collection)pd.getIndices()).isEmpty())) continue;
            switch (pd.getType()) {
                case 4: {
                    result.addAll((Collection)pd.getIndices());
                    continue block13;
                }
                case 6: {
                    int fixed = ((Number)pd.getIndices().get(0)).intValue();
                    dArray = pd.getIndices().size() - 1;
                    for (i = 1; i < dArray; ++i) {
                        result.add(fixed);
                        result.add(pd.getIndices().get(i));
                        result.add(pd.getIndices().get(i + 1));
                    }
                    continue block13;
                }
                case 5: {
                    n = pd.getIndices().size() - 2;
                    for (int i2 = 0; i2 < n; ++i2) {
                        result.add(pd.getIndices().get(i2));
                        result.add(pd.getIndices().get(i2 + 1));
                        result.add(pd.getIndices().get(i2 + 2));
                    }
                    continue block13;
                }
            }
            throw new IllegalStateException(("type not supported: " + pd.getType()).toString());
        }
        tessellator.gluDeleteTess();
        return result;
    }

    public static /* synthetic */ List triangulateV3$default(List list, FillRule fillRule, int n, Object object) {
        if ((n & 2) != 0) {
            fillRule = FillRule.NONZERO_WINDING;
        }
        return TriangulatorKt.triangulateV3(list, fillRule);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FillRule.values().length];
            try {
                nArray[FillRule.ODD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FillRule.NONZERO_WINDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

