/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.LoadFontKt;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.Vector2;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/panel/elements/TextNode;", "Lorg/openrndr/panel/elements/Element;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "sizeHint", "Lorg/openrndr/shape/Rectangle;", "toString", "orx-panel"})
public final class TextNode
extends Element {
    @NotNull
    private String text;

    public TextNode(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        super(new ElementType("text"));
        this.text = text;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.text = string;
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        StyleSheet style = this.getComputedStyle();
        boolean bl = false;
        Color it = StyleSheetKt.getColor(style);
        boolean bl2 = false;
        Object object = it instanceof Color.RGBa ? (Color.RGBa)it : null;
        if (object == null || (object = ((Color.RGBa)object).getColor()) == null) {
            object = ColorRGBa.Companion.getWHITE();
        }
        Object fill = object;
        drawer.setFill((ColorRGBa)fill);
        Element element = this.root();
        Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.panel.elements.Body");
        FontImageMap fontMap = ((Body)element).getControlManager().getFontManager().font(this.getComputedStyle());
        TextWriter writer = new TextWriter(drawer);
        drawer.setFontMap(fontMap);
        writer.setBox(new Rectangle(new Vector2(this.getLayout().getScreenX() * 0.0, this.getLayout().getScreenY() * 0.0), this.getLayout().getScreenWidth(), this.getLayout().getScreenHeight()));
        writer.newLine();
        TextWriter.text$default(writer, this.text, false, 2, null);
    }

    @NotNull
    public final Rectangle sizeHint() {
        StyleSheet style = this.getComputedStyle();
        boolean bl = false;
        Element element = this.root();
        Object object = element instanceof Body ? (Body)element : null;
        if (object == null || (object = ((Body)object).getControlManager()) == null || (object = ((ControlManager)object).getFontManager()) == null || (object = ((FontManager)object).resolve(StyleSheetKt.getFontFamily(style))) == null) {
            object = "broken";
        }
        Object fontUrl = object;
        LinearDimension linearDimension = StyleSheetKt.getFontSize(style);
        LinearDimension.PX pX = linearDimension instanceof LinearDimension.PX ? (LinearDimension.PX)linearDimension : null;
        double fontSize = pX != null ? pX.getValue() : 14.0;
        Element element2 = this.root();
        Object object2 = element2 instanceof Body ? (Body)element2 : null;
        if (object2 == null || (object2 = ((Body)object2).getControlManager()) == null || (object2 = ((ControlManager)object2).getProgram()) == null) {
            throw new IllegalStateException("no program".toString());
        }
        Object program2 = object2;
        FontImageMap fontMap = LoadFontKt.loadFont$default((Program)program2, (String)fontUrl, fontSize, null, 0.0, null, 28, null);
        TextWriter writer = new TextWriter(null);
        writer.setBox(RectangleKt.Rectangle(this.getLayout().getScreenX(), this.getLayout().getScreenY(), this.getLayout().getScreenWidth(), this.getLayout().getScreenHeight()));
        writer.getDrawStyle().setFontMap(fontMap);
        writer.newLine();
        writer.text(this.text, false);
        return RectangleKt.Rectangle(this.getLayout().getScreenX(), this.getLayout().getScreenY(), this.getLayout().getScreenWidth(), writer.getCursor().getY() - this.getLayout().getScreenY() - fontMap.getDescenderLength() * (double)2);
    }

    @NotNull
    public String toString() {
        return "TextNode(id='" + this.getId() + "',text='" + this.text + "')";
    }
}

