/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.collections;

import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.events.Event;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/panel/collections/ObservableHashSet;", "E", "Ljava/util/HashSet;", "<init>", "()V", "changed", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/collections/ObservableHashSet$ChangeEvent;", "getChanged", "()Lorg/openrndr/events/Event;", "add", "", "element", "(Ljava/lang/Object;)Z", "remove", "clear", "", "ChangeEvent", "orx-panel"})
public final class ObservableHashSet<E>
extends HashSet<E> {
    @NotNull
    private final Event<ChangeEvent<E>> changed = new Event(null, false, 3, null);

    @NotNull
    public final Event<ChangeEvent<E>> getChanged() {
        return this.changed;
    }

    @Override
    public boolean add(E element) {
        boolean bl;
        if (super.add(element)) {
            this.changed.trigger(new ChangeEvent<E>(this, SetsKt.setOf(element), SetsKt.emptySet()));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean remove(Object element) {
        boolean bl;
        if (super.remove(element)) {
            this.changed.trigger(new ChangeEvent<Object>(this, SetsKt.emptySet(), SetsKt.setOf(element)));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void clear() {
        Set old = CollectionsKt.toSet(this);
        super.clear();
        this.changed.trigger(new ChangeEvent(this, SetsKt.emptySet(), old));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/panel/collections/ObservableHashSet$ChangeEvent;", "E", "", "source", "Lorg/openrndr/panel/collections/ObservableHashSet;", "added", "", "removed", "<init>", "(Lorg/openrndr/panel/collections/ObservableHashSet;Ljava/util/Set;Ljava/util/Set;)V", "getSource", "()Lorg/openrndr/panel/collections/ObservableHashSet;", "getAdded", "()Ljava/util/Set;", "getRemoved", "orx-panel"})
    public static final class ChangeEvent<E> {
        @NotNull
        private final ObservableHashSet<E> source;
        @NotNull
        private final Set<E> added;
        @NotNull
        private final Set<E> removed;

        public ChangeEvent(@NotNull ObservableHashSet<E> source, @NotNull Set<? extends E> added, @NotNull Set<? extends E> removed) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(added, "added");
            Intrinsics.checkNotNullParameter(removed, "removed");
            this.source = source;
            this.added = added;
            this.removed = removed;
        }

        @NotNull
        public final ObservableHashSet<E> getSource() {
            return this.source;
        }

        @NotNull
        public final Set<E> getAdded() {
            return this.added;
        }

        @NotNull
        public final Set<E> getRemoved() {
            return this.removed;
        }
    }
}

