/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.LinearType;
import org.openrndr.math.Matrix33$;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002ABBa\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eBc\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\r\u0010\u0013J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0086\u0002J\b\u0010(\u001a\u00020)H\u0016J\t\u0010*\u001a\u00020\u0004H\u00c6\u0003J\t\u0010+\u001a\u00020\u0004H\u00c6\u0003J\t\u0010,\u001a\u00020\u0004H\u00c6\u0003J\t\u0010-\u001a\u00020\u0004H\u00c6\u0003J\t\u0010.\u001a\u00020\u0004H\u00c6\u0003J\t\u0010/\u001a\u00020\u0004H\u00c6\u0003J\t\u00100\u001a\u00020\u0004H\u00c6\u0003J\t\u00101\u001a\u00020\u0004H\u00c6\u0003J\t\u00102\u001a\u00020\u0004H\u00c6\u0003Jc\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u00c6\u0001J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u00d6\u0003J\t\u00108\u001a\u00020\u0010H\u00d6\u0001J%\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0001\u00a2\u0006\u0002\b@R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0014R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u001a\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"\u00a8\u0006C"}, d2={"Lorg/openrndr/math/Matrix33;", "Lorg/openrndr/math/LinearType;", "Ljava/lang/Record;", "c0r0", "", "c1r0", "c2r0", "c0r1", "c1r1", "c2r1", "c0r2", "c1r2", "c2r2", "<init>", "(DDDDDDDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDDDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "get", "Lorg/openrndr/math/Vector3;", "index", "trace", "determinant", "inversed", "()Lorg/openrndr/math/Matrix33;", "plus", "right", "minus", "transposed", "matrix44", "Lorg/openrndr/math/Matrix44;", "()Lorg/openrndr/math/Matrix44;", "times", "v", "scale", "div", "mat", "toString", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class Matrix33
extends Record
implements LinearType<Matrix33> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double c0r0;
    private final double c1r0;
    private final double c2r0;
    private final double c0r1;
    private final double c1r1;
    private final double c2r1;
    private final double c0r2;
    private final double c1r2;
    private final double c2r2;
    @NotNull
    private static final Matrix33 IDENTITY = new Matrix33(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 238, null);
    @NotNull
    private static final Matrix33 ZERO = new Matrix33(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 511, null);

    public Matrix33(double c0r0, double c1r0, double c2r0, double c0r1, double c1r1, double c2r1, double c0r2, double c1r2, double c2r2) {
        this.c0r0 = c0r0;
        this.c1r0 = c1r0;
        this.c2r0 = c2r0;
        this.c0r1 = c0r1;
        this.c1r1 = c1r1;
        this.c2r1 = c2r1;
        this.c0r2 = c0r2;
        this.c1r2 = c1r2;
        this.c2r2 = c2r2;
    }

    public /* synthetic */ Matrix33(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d7 = 0.0;
        }
        if ((n & 0x80) != 0) {
            d8 = 0.0;
        }
        if ((n & 0x100) != 0) {
            d9 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public final double c0r0() {
        return this.c0r0;
    }

    public final double c1r0() {
        return this.c1r0;
    }

    public final double c2r0() {
        return this.c2r0;
    }

    public final double c0r1() {
        return this.c0r1;
    }

    public final double c1r1() {
        return this.c1r1;
    }

    public final double c2r1() {
        return this.c2r1;
    }

    public final double c0r2() {
        return this.c0r2;
    }

    public final double c1r2() {
        return this.c1r2;
    }

    public final double c2r2() {
        return this.c2r2;
    }

    @NotNull
    public final Vector3 get(int index) {
        return switch (index) {
            case 0 -> new Vector3(this.c0r0, this.c0r1, this.c0r2);
            case 1 -> new Vector3(this.c1r0, this.c1r1, this.c1r2);
            case 2 -> new Vector3(this.c2r0, this.c2r1, this.c2r2);
            default -> throw new RuntimeException("not implemented");
        };
    }

    public final double trace() {
        return this.c0r0 + this.c1r1 + this.c2r2;
    }

    public final double determinant() {
        double x = this.c0r0 * (this.c1r1 * this.c2r2 - this.c1r2 * this.c2r1);
        double y = -this.c1r0 * (this.c0r1 * this.c2r2 - this.c0r2 * this.c2r1);
        double z = this.c2r0 * (this.c0r1 * this.c1r2 - this.c1r1 * this.c0r2);
        return x + y + z;
    }

    @NotNull
    public final Matrix33 inversed() {
        double invDet = 1.0 / this.determinant();
        return new Matrix33(invDet * (this.c1r1 * this.c2r2 - this.c2r1 * this.c1r2), invDet * (this.c2r0 * this.c1r2 - this.c1r0 * this.c2r2), invDet * (this.c1r0 * this.c2r1 - this.c2r0 * this.c1r1), invDet * (this.c2r1 * this.c0r2 - this.c0r1 * this.c2r2), invDet * (this.c0r0 * this.c2r2 - this.c2r0 * this.c0r2), invDet * (this.c2r0 * this.c0r1 - this.c0r0 * this.c2r1), invDet * (this.c0r1 * this.c1r2 - this.c1r1 * this.c0r2), invDet * (this.c1r0 * this.c0r2 - this.c0r0 * this.c1r2), invDet * (this.c0r0 * this.c1r1 - this.c1r0 * this.c0r1));
    }

    @Override
    @NotNull
    public Matrix33 plus(@NotNull Matrix33 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Matrix33(this.c0r0 + right.c0r0, this.c1r0 + right.c1r0, this.c2r0 + right.c2r0, this.c0r1 + right.c0r1, this.c1r1 + right.c1r1, this.c2r1 + right.c2r1, this.c0r2 + right.c0r2, this.c1r2 + right.c1r2, this.c2r2 + right.c2r2);
    }

    @Override
    @NotNull
    public Matrix33 minus(@NotNull Matrix33 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Matrix33(this.c0r0 - right.c0r0, this.c1r0 - right.c1r0, this.c2r0 - right.c2r0, this.c0r1 - right.c0r1, this.c1r1 - right.c1r1, this.c2r1 - right.c2r1, this.c0r2 - right.c0r2, this.c1r2 - right.c1r2, this.c2r2 - right.c2r2);
    }

    @NotNull
    public final Matrix33 transposed() {
        return new Matrix33(this.c0r0, this.c0r1, this.c0r2, this.c1r0, this.c1r1, this.c1r2, this.c2r0, this.c2r1, this.c2r2);
    }

    @NotNull
    public final Matrix44 matrix44() {
        return new Matrix44(this.c0r0, this.c1r0, this.c2r0, 0.0, this.c0r1, this.c1r1, this.c2r1, 0.0, this.c0r2, this.c1r2, this.c2r2, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector3(v.x() * this.c0r0 + v.y() * this.c1r0 + v.z() * this.c2r0, v.x() * this.c0r1 + v.y() * this.c1r1 + v.z() * this.c2r1, v.x() * this.c0r2 + v.y() * this.c1r2 + v.z() * this.c2r2);
    }

    @Override
    @NotNull
    public Matrix33 times(double scale) {
        return new Matrix33(this.c0r0 * scale, this.c1r0 * scale, this.c2r0 * scale, this.c0r1 * scale, this.c1r1 * scale, this.c2r1 * scale, this.c0r2 * scale, this.c1r2 * scale, this.c2r2 * scale);
    }

    @Override
    @NotNull
    public Matrix33 div(double scale) {
        return new Matrix33(this.c0r0 / scale, this.c1r0 / scale, this.c2r0 / scale, this.c0r1 / scale, this.c1r1 / scale, this.c2r1 / scale, this.c0r2 / scale, this.c1r2 / scale, this.c2r2 / scale);
    }

    @NotNull
    public final Matrix33 times(@NotNull Matrix33 mat) {
        Intrinsics.checkNotNullParameter(mat, "mat");
        return new Matrix33(this.c0r0 * mat.c0r0 + this.c1r0 * mat.c0r1 + this.c2r0 * mat.c0r2, this.c0r0 * mat.c1r0 + this.c1r0 * mat.c1r1 + this.c2r0 * mat.c1r2, this.c0r0 * mat.c2r0 + this.c1r0 * mat.c2r1 + this.c2r0 * mat.c2r2, this.c0r1 * mat.c0r0 + this.c1r1 * mat.c0r1 + this.c2r1 * mat.c0r2, this.c0r1 * mat.c1r0 + this.c1r1 * mat.c1r1 + this.c2r1 * mat.c1r2, this.c0r1 * mat.c2r0 + this.c1r1 * mat.c2r1 + this.c2r1 * mat.c2r2, this.c0r2 * mat.c0r0 + this.c1r2 * mat.c0r1 + this.c2r2 * mat.c0r2, this.c0r2 * mat.c1r0 + this.c1r2 * mat.c1r1 + this.c2r2 * mat.c1r2, this.c0r2 * mat.c2r0 + this.c1r2 * mat.c2r1 + this.c2r2 * mat.c2r2);
    }

    @Override
    @NotNull
    public String toString() {
        return this.c0r0 + ", " + this.c1r0 + ", " + this.c2r0 + ",\n" + this.c0r1 + ", " + this.c1r1 + ", " + this.c2r1 + ",\n" + this.c0r2 + ", " + this.c1r2 + ", " + this.c2r2;
    }

    public final double component1() {
        return this.c0r0;
    }

    public final double component2() {
        return this.c1r0;
    }

    public final double component3() {
        return this.c2r0;
    }

    public final double component4() {
        return this.c0r1;
    }

    public final double component5() {
        return this.c1r1;
    }

    public final double component6() {
        return this.c2r1;
    }

    public final double component7() {
        return this.c0r2;
    }

    public final double component8() {
        return this.c1r2;
    }

    public final double component9() {
        return this.c2r2;
    }

    @NotNull
    public final Matrix33 copy(double c0r0, double c1r0, double c2r0, double c0r1, double c1r1, double c2r1, double c0r2, double c1r2, double c2r2) {
        return new Matrix33(c0r0, c1r0, c2r0, c0r1, c1r1, c2r1, c0r2, c1r2, c2r2);
    }

    public static /* synthetic */ Matrix33 copy$default(Matrix33 matrix33, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, Object object) {
        if ((n & 1) != 0) {
            d = matrix33.c0r0;
        }
        if ((n & 2) != 0) {
            d2 = matrix33.c1r0;
        }
        if ((n & 4) != 0) {
            d3 = matrix33.c2r0;
        }
        if ((n & 8) != 0) {
            d4 = matrix33.c0r1;
        }
        if ((n & 0x10) != 0) {
            d5 = matrix33.c1r1;
        }
        if ((n & 0x20) != 0) {
            d6 = matrix33.c2r1;
        }
        if ((n & 0x40) != 0) {
            d7 = matrix33.c0r2;
        }
        if ((n & 0x80) != 0) {
            d8 = matrix33.c1r2;
        }
        if ((n & 0x100) != 0) {
            d9 = matrix33.c2r2;
        }
        return matrix33.copy(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    @Override
    public int hashCode() {
        int result = Double.hashCode(this.c0r0);
        result = result * 31 + Double.hashCode(this.c1r0);
        result = result * 31 + Double.hashCode(this.c2r0);
        result = result * 31 + Double.hashCode(this.c0r1);
        result = result * 31 + Double.hashCode(this.c1r1);
        result = result * 31 + Double.hashCode(this.c2r1);
        result = result * 31 + Double.hashCode(this.c0r2);
        result = result * 31 + Double.hashCode(this.c1r2);
        result = result * 31 + Double.hashCode(this.c2r2);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Matrix33)) {
            return false;
        }
        Matrix33 matrix33 = (Matrix33)other;
        if (Double.compare(this.c0r0, matrix33.c0r0) != 0) {
            return false;
        }
        if (Double.compare(this.c1r0, matrix33.c1r0) != 0) {
            return false;
        }
        if (Double.compare(this.c2r0, matrix33.c2r0) != 0) {
            return false;
        }
        if (Double.compare(this.c0r1, matrix33.c0r1) != 0) {
            return false;
        }
        if (Double.compare(this.c1r1, matrix33.c1r1) != 0) {
            return false;
        }
        if (Double.compare(this.c2r1, matrix33.c2r1) != 0) {
            return false;
        }
        if (Double.compare(this.c0r2, matrix33.c0r2) != 0) {
            return false;
        }
        if (Double.compare(this.c1r2, matrix33.c1r2) != 0) {
            return false;
        }
        return Double.compare(this.c2r2, matrix33.c2r2) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(Matrix33 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : Double.compare(self.c0r0, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 0, self.c0r0);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : Double.compare(self.c1r0, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 1, self.c1r0);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : Double.compare(self.c2r0, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 2, self.c2r0);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.c0r1, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.c0r1);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : Double.compare(self.c1r1, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 4, self.c1r1);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : Double.compare(self.c2r1, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 5, self.c2r1);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : Double.compare(self.c0r2, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 6, self.c0r2);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : Double.compare(self.c1r2, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 7, self.c1r2);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : Double.compare(self.c2r2, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 8, self.c2r2);
        }
    }

    public /* synthetic */ Matrix33(int seen0, double c0r0, double c1r0, double c2r0, double c0r1, double c1r1, double c2r1, double c0r2, double c1r2, double c2r2, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen0) != 0) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 0, $serializer.INSTANCE.getDescriptor());
        }
        this.c0r0 = (seen0 & 1) == 0 ? 0.0 : c0r0;
        this.c1r0 = (seen0 & 2) == 0 ? 0.0 : c1r0;
        this.c2r0 = (seen0 & 4) == 0 ? 0.0 : c2r0;
        this.c0r1 = (seen0 & 8) == 0 ? 0.0 : c0r1;
        this.c1r1 = (seen0 & 0x10) == 0 ? 0.0 : c1r1;
        this.c2r1 = (seen0 & 0x20) == 0 ? 0.0 : c2r1;
        this.c0r2 = (seen0 & 0x40) == 0 ? 0.0 : c0r2;
        this.c1r2 = (seen0 & 0x80) == 0 ? 0.0 : c1r2;
        this.c2r2 = (seen0 & 0x100) == 0 ? 0.0 : c2r2;
    }

    public Matrix33() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 511, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/openrndr/math/Matrix33$Companion;", "", "<init>", "()V", "IDENTITY", "Lorg/openrndr/math/Matrix33;", "getIDENTITY", "()Lorg/openrndr/math/Matrix33;", "ZERO", "getZERO", "fromColumnVectors", "c0", "Lorg/openrndr/math/Vector3;", "c1", "c2", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix33 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix33 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Matrix33 fromColumnVectors(@NotNull Vector3 c0, @NotNull Vector3 c1, @NotNull Vector3 c2) {
            Intrinsics.checkNotNullParameter(c0, "c0");
            Intrinsics.checkNotNullParameter(c1, "c1");
            Intrinsics.checkNotNullParameter(c2, "c2");
            return new Matrix33(c0.x(), c1.x(), c2.x(), c0.y(), c1.y(), c2.y(), c0.z(), c1.z(), c2.z());
        }

        @NotNull
        public final KSerializer<Matrix33> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

