/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.kartifex.Box;
import org.openrndr.kartifex.Line2;
import org.openrndr.kartifex.Ring2;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 *2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001*B)\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u0011\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0000H\u0016J\b\u0010$\u001a\u00020\u0002H\u0016J\b\u0010%\u001a\u00020\u0002H\u0016J\u0018\u0010(\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\b\u0010)\u001a\u00020\u0000H\u0014R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010&\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006+"}, d2={"Lorg/openrndr/kartifex/Box2;", "Lorg/openrndr/kartifex/Box;", "Lorg/openrndr/kartifex/Vec2;", "ax", "", "ay", "bx", "by", "<init>", "(DDDD)V", "a", "b", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;)V", "lx", "getLx", "()D", "ly", "getLy", "ux", "getUx", "uy", "getUy", "width", "height", "scale", "k", "x", "y", "translate", "vertices", "", "()[Lorg/openrndr/kartifex/Vec2;", "outline", "Lorg/openrndr/kartifex/Ring2;", "intersects", "", "lower", "upper", "isEmpty", "()Z", "construct", "empty", "Companion", "openrndr-kartifex"})
public final class Box2
extends Box<Vec2, Box2> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double lx;
    private final double ly;
    private final double ux;
    private final double uy;
    @NotNull
    private static final Box2 EMPTY = new Box2(new Vec2(Double.NaN, Double.NaN), new Vec2(Double.NaN, Double.NaN));

    public Box2(double ax, double ay, double bx, double by) {
        if (ax < bx) {
            this.lx = ax;
            this.ux = bx;
        } else {
            this.ux = ax;
            this.lx = bx;
        }
        if (ay < by) {
            this.ly = ay;
            this.uy = by;
        } else {
            this.uy = ay;
            this.ly = by;
        }
    }

    public final double getLx() {
        return this.lx;
    }

    public final double getLy() {
        return this.ly;
    }

    public final double getUx() {
        return this.ux;
    }

    public final double getUy() {
        return this.uy;
    }

    public final double width() {
        return this.ux - this.lx;
    }

    public final double height() {
        return this.uy - this.ly;
    }

    public Box2(@NotNull Vec2 a, @NotNull Vec2 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        this(a.x(), a.y(), b.x(), b.y());
    }

    @Override
    @NotNull
    public final Box2 scale(double k) {
        return (Box2)this.scale((Vec)new Vec2(k, k));
    }

    @NotNull
    public final Box2 scale(double x, double y) {
        return (Box2)this.scale((Vec)new Vec2(x, y));
    }

    @NotNull
    public final Box2 translate(double x, double y) {
        return (Box2)this.translate((Vec)new Vec2(x, y));
    }

    @NotNull
    public final Vec2[] vertices() {
        Vec2[] vec2Array = new Vec2[]{new Vec2(this.lx, this.ly), new Vec2(this.ux, this.ly), new Vec2(this.ux, this.uy), new Vec2(this.lx, this.uy)};
        return vec2Array;
    }

    @NotNull
    public final Ring2 outline() {
        List cs = new ArrayList();
        Vec2[] vs = this.vertices();
        int n = vs.length;
        for (int i = 0; i < n; ++i) {
            cs.add(Line2.Companion.line(vs[i], vs[(i + 1) % 4]));
        }
        return new Ring2(cs);
    }

    @Override
    public boolean intersects(@NotNull Box2 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        return this.isEmpty() || b.isEmpty() ? false : b.ux >= this.lx & this.ux >= b.lx & b.uy >= this.ly & this.uy >= b.ly;
    }

    @Override
    @NotNull
    public Vec2 lower() {
        return new Vec2(this.lx, this.ly);
    }

    @Override
    @NotNull
    public Vec2 upper() {
        return new Vec2(this.ux, this.uy);
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    @NotNull
    protected Box2 construct(@NotNull Vec2 a, @NotNull Vec2 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Box2(a.x(), a.y(), b.x(), b.y());
    }

    @Override
    @NotNull
    protected Box2 empty() {
        return EMPTY;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/kartifex/Box2$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/openrndr/kartifex/Box2;", "getEMPTY", "()Lorg/openrndr/kartifex/Box2;", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Box2 getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

