/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyexr.EXRChannelInfo;
import org.lwjgl.util.tinyexr.EXRHeader;
import org.lwjgl.util.tinyexr.EXRImage;
import org.lwjgl.util.tinyexr.EXRVersion;
import org.lwjgl.util.tinyexr.TinyEXR;
import org.openrndr.dds.DDSData;
import org.openrndr.dds.DDSReaderFunctions;
import org.openrndr.dds.DDSReaderKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ImageFileDetails;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.internal.CubemapImageData;
import org.openrndr.internal.ExrImageSaveConfiguration;
import org.openrndr.internal.HdrImageSaveConfiguration;
import org.openrndr.internal.ImageData;
import org.openrndr.internal.ImageDriver;
import org.openrndr.internal.ImageSaveConfiguration;
import org.openrndr.internal.ImageSaveContext;
import org.openrndr.internal.JpegImageSaveConfiguration;
import org.openrndr.internal.PngImageSaveConfiguration;
import org.openrndr.internal.gl3.CubemapImageDataDds;
import org.openrndr.internal.gl3.ImageDataDds;
import org.openrndr.internal.gl3.ImageDataStb;
import org.openrndr.utils.buffer.MPPBuffer;
import org.openrndr.utils.url.TextFromURLKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u001a"}, d2={"Lorg/openrndr/internal/gl3/ImageDriverStbImage;", "Lorg/openrndr/internal/ImageDriver;", "<init>", "()V", "probeImage", "Lorg/openrndr/draw/ImageFileDetails;", "fileOrUrl", "", "buffer", "Lorg/openrndr/utils/buffer/MPPBuffer;", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "loadImage", "Lorg/openrndr/internal/ImageData;", "allowSRGB", "", "name", "saveImage", "", "imageData", "filename", "configuration", "Lorg/openrndr/internal/ImageSaveConfiguration;", "imageToDataUrl", "loadCubemapImage", "Lorg/openrndr/internal/CubemapImageData;", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nImageDriverStbImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDriverStbImage.kt\norg/openrndr/internal/gl3/ImageDriverStbImage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,771:1\n1#2:772\n1557#3:773\n1628#3,3:774\n1557#3:777\n1628#3,3:778\n1557#3:781\n1628#3,3:782\n1557#3:785\n1628#3,3:786\n1557#3:789\n1628#3,3:790\n2632#3,3:793\n1557#3:796\n1628#3,3:797\n1863#3,2:800\n1863#3,2:802\n1863#3,2:804\n1872#3,3:806\n*S KotlinDebug\n*F\n+ 1 ImageDriverStbImage.kt\norg/openrndr/internal/gl3/ImageDriverStbImage\n*L\n432#1:773\n432#1:774,3\n434#1:777\n434#1:778,3\n442#1:781\n442#1:782,3\n443#1:785\n443#1:786,3\n444#1:789\n444#1:790,3\n447#1:793,3\n449#1:796\n449#1:797,3\n450#1:800,2\n625#1:802,2\n634#1:804,2\n650#1:806,3\n*E\n"})
public final class ImageDriverStbImage
implements ImageDriver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageFileDetails probeImage(@NotNull String fileOrUrl) {
        Throwable throwable;
        Closeable closeable;
        Serializable it;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        Pair<File, URL> pair = TextFromURLKt.resolveFileOrUrl(fileOrUrl);
        File file = pair.component1();
        URL url = pair.component2();
        byte[] header = new byte[1024];
        URL uRL = url;
        if (uRL != null) {
            it = uRL;
            boolean bl = false;
            closeable = it.openStream();
            throwable = null;
            try {
                InputStream stream22 = (InputStream)closeable;
                boolean bl2 = false;
                int stream22 = stream22.read(header);
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        File file2 = file;
        if (file2 != null) {
            it = file2;
            boolean bl = false;
            closeable = new FileInputStream((File)it);
            throwable = null;
            try {
                FileInputStream stream = (FileInputStream)closeable;
                boolean bl3 = false;
                int n = stream.read(header);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable3 = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            ByteBuffer byteBuffer = stack.malloc(header.length);
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "malloc(...)");
            ByteBuffer bb = byteBuffer;
            bb.put(header);
            bb.flip();
            ImageFileDetails imageFileDetails = this.probeImage(new MPPBuffer(bb), null);
            return imageFileDetails;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageFileDetails probeImage(@NotNull MPPBuffer buffer, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer intBuffer = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer x = intBuffer;
            IntBuffer intBuffer2 = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer2, "mallocInt(...)");
            IntBuffer y = intBuffer2;
            IntBuffer intBuffer3 = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer3, "mallocInt(...)");
            IntBuffer channels = intBuffer3;
            boolean result = STBImage.stbi_info_from_memory(buffer.getByteBuffer(), x, y, channels);
            if (result) {
                ImageFileDetails imageFileDetails = new ImageFileDetails(x.get(), y.get(), channels.get());
                return imageFileDetails;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ImageData loadImage(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint, boolean allowSRGB) {
        ImageData imageData;
        Object object;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        if (StringsKt.startsWith$default(fileOrUrl, "data:", false, 2, null)) {
            Base64.Decoder decoder = Base64.getDecoder();
            int commaIndex = StringsKt.indexOf$default((CharSequence)fileOrUrl, ",", 0, false, 6, null);
            String base64Data = StringsKt.replace$default(StringsKt.replace$default(StringsKt.drop(fileOrUrl, commaIndex + 1), "\r\n", "", false, 4, null), "\n", "", false, 4, null);
            byte[] decoded = decoder.decode(base64Data);
            ByteBuffer buffer = ByteBuffer.allocateDirect(decoded.length);
            buffer.put(decoded);
            Intrinsics.checkNotNull(buffer, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)buffer).rewind();
            return this.loadImage(new MPPBuffer(buffer), "data-url", formatHint, allowSRGB);
        }
        try {
            object = new URL(fileOrUrl);
        }
        catch (MalformedURLException e) {
            object = null;
        }
        URL url = object;
        if (url != null) {
            AutoCloseable it;
            object = url.openStream();
            Throwable e = null;
            try {
                ImageData imageData2;
                it = (InputStream)object;
                boolean bl = false;
                byte[] byteArray = TextStreamsKt.readBytes(url);
                if (byteArray.length == 0) {
                    throw new IllegalStateException(("read 0 bytes from stream " + fileOrUrl).toString());
                }
                ByteBuffer byteBuffer = MemoryUtil.memAlloc(byteArray.length);
                Intrinsics.checkNotNullExpressionValue(byteBuffer, "memAlloc(...)");
                ByteBuffer buffer = byteBuffer;
                buffer.put(byteArray);
                buffer.flip();
                try {
                    imageData2 = this.loadImage(new MPPBuffer(buffer), fileOrUrl, formatHint, allowSRGB);
                }
                finally {
                    MemoryUtil.memFree(buffer);
                }
                it = imageData2;
            }
            catch (Throwable bl) {
                e = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, e);
            }
            return it;
        }
        Path path = Path.of(fileOrUrl, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "of(...)");
        object = path;
        LinkOption[] e = new LinkOption[]{};
        if (!Files.exists((Path)object, Arrays.copyOf(e, e.length))) {
            boolean bl = false;
            String string = fileOrUrl + " not found";
            throw new IllegalArgumentException(string.toString());
        }
        object = FileChannel.open(Path.of(fileOrUrl, new String[0]), new OpenOption[0]);
        Throwable throwable = null;
        try {
            ImageData imageData3;
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)channel.size());
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "memAlloc(...)");
            ByteBuffer buffer = byteBuffer;
            channel.read(buffer);
            buffer.flip();
            try {
                imageData3 = this.loadImage(new MPPBuffer(buffer), fileOrUrl, formatHint, allowSRGB);
            }
            finally {
                MemoryUtil.memFree(buffer);
            }
            imageData = imageData3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        return imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public ImageData loadImage(@NotNull MPPBuffer buffer, @Nullable String name, @Nullable ImageFileFormat formatHint, boolean allowSRGB) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        assumedFormat = ImageFileFormat.PNG;
        inputIsDirect = buffer.getByteBuffer().isDirect();
        if (inputIsDirect) {
            v0 = buffer.getByteBuffer();
        } else {
            it = var9_7 = MemoryUtil.memAlloc(buffer.getByteBuffer().remaining());
            $i$a$-also-ImageDriverStbImage$loadImage$buffer$1 = false;
            it.put(buffer.getByteBuffer());
            it.rewind();
            var8_15 = var9_7;
            Intrinsics.checkNotNull(var8_15);
            v0 = var8_15;
        }
        buffer = v0;
        try {
            if (formatHint != null) {
                assumedFormat = formatHint;
            }
            buffer.mark();
            switch (WhenMappings.$EnumSwitchMapping$1[assumedFormat.ordinal()]) {
                case 1: 
                case 2: {
                    wa /* !! */  = new int[1];
                    ha = new int[1];
                    ca = new int[1];
                    STBImage.stbi_set_flip_vertically_on_load(true);
                    STBImage.stbi_set_unpremultiply_on_load(false);
                    bitsPerChannel = assumedFormat == ImageFileFormat.PNG ? (STBImage.stbi_is_16_bit_from_memory(buffer) ? 16 : 8) : 8;
                    buffer.reset();
                    targetType = null;
                    mask = 0;
                    alphaOffset = 3;
                    redOffset = 0;
                    greenOffset = 1;
                    blueOffset = 2;
                    switch (bitsPerChannel) {
                        case 8: {
                            targetType = allowSRGB != false ? ColorType.UINT8_SRGB : ColorType.UINT8;
                            mask = 255;
                            v1 = Unit.INSTANCE;
                            break;
                        }
                        case 16: {
                            targetType = ColorType.UINT16;
                            mask = 65535;
                            v1 = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported bits per channel: " + bitsPerChannel).toString());
                        }
                    }
                    switch (bitsPerChannel) {
                        case 8: {
                            v2 = STBImage.stbi_load_from_memory(buffer, wa /* !! */ , ha, ca, 0);
                            if (v2 == null) {
                                throw new IllegalStateException(("stbi_load returned null while loading '" + name + "'").toString());
                            }
                            v3 = new Pair<ByteBuffer, Object>(v2, null);
                            break;
                        }
                        case 16: {
                            v4 = STBImage.stbi_load_16_from_memory(buffer, wa /* !! */ , ha, ca, 0);
                            if (v4 == null) {
                                throw new IllegalStateException(("stdi_load returned while loading '" + name + "'").toString());
                            }
                            v3 = new Pair<Object, ShortBuffer>(null, v4);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported bits per channel: " + bitsPerChannel).toString());
                        }
                    }
                    var20_52 = v3;
                    tdata8 = var20_52.component1();
                    tdata16 = var20_52.component2();
                    if (tdata8 != null) {
                        offset = 0;
                        if (ca[0] == 4) {
                            var25_65 = ha[0];
                            for (y = 0; y < var25_65; ++y) {
                                var27_75 = wa /* !! */ [0];
                                for (x = 0; x < var27_75; ++x) {
                                    a = (double)(tdata8.get(offset + alphaOffset) & mask) / (double)mask;
                                    r = (double)(tdata8.get(offset + redOffset) & mask) * a;
                                    g = (double)(tdata8.get(offset + greenOffset) & mask) * a;
                                    b = (double)(tdata8.get(offset + blueOffset) & mask) * a;
                                    tdata8.put(offset + redOffset, (byte)r);
                                    tdata8.put(offset + greenOffset, (byte)g);
                                    tdata8.put(offset + blueOffset, (byte)b);
                                    offset += 4;
                                }
                            }
                        }
                    }
                    v5 = tdata8;
                    if (v5 != null) {
                        it = v5;
                        $i$a$-let-ImageDriverStbImage$loadImage$data8$1 = 0;
                        if (ca[0] == 1) {
                            roffset = 0;
                            woffset = 0;
                            data8 = ByteBuffer.allocateDirect(tdata8.capacity() * 3);
                            var31_118 = ha[0];
                            for (y = 0; y < var31_118; ++y) {
                                var33_127 = wa /* !! */ [0];
                                for (x = 0; x < var33_127; ++x) {
                                    r = tdata8.get(roffset);
                                    data8.put(woffset + 0, r);
                                    data8.put(woffset + 1, r);
                                    data8.put(woffset + 2, r);
                                    ++roffset;
                                    woffset += 3;
                                }
                            }
                            v6 = data8;
                        } else {
                            v6 = tdata8;
                        }
                    } else {
                        v6 = data8 = null;
                    }
                    if (tdata16 != null) {
                        offset = 0;
                        if (ca[0] == 4) {
                            $i$a$-let-ImageDriverStbImage$loadImage$data8$1 = ha[0];
                            for (y = 0; y < $i$a$-let-ImageDriverStbImage$loadImage$data8$1; ++y) {
                                woffset = wa /* !! */ [0];
                                for (x = 0; x < woffset; ++x) {
                                    a = (double)(tdata16.get(offset + alphaOffset) & mask) / (double)mask;
                                    r = (double)(tdata16.get(offset + redOffset) & mask) * a;
                                    g = (double)(tdata16.get(offset + greenOffset) & mask) * a;
                                    b = (double)(tdata16.get(offset + blueOffset) & mask) * a;
                                    tdata16.put(offset + redOffset, (short)r);
                                    tdata16.put(offset + greenOffset, (short)g);
                                    tdata16.put(offset + blueOffset, (short)b);
                                    offset += 4;
                                }
                            }
                        }
                    }
                    data16 = tdata16;
                    v7 = data8;
                    if (v7 == null) ** GOTO lbl150
                    it = v7;
                    $i$a$-let-ImageDriverStbImage$loadImage$copyData$1 = false;
                    v8 = MemoryUtil.memAlloc(it.capacity());
                    v7 = v8;
                    if (v8 != null) ** GOTO lbl161
lbl150:
                    // 2 sources

                    v9 = data16;
                    if (v9 != null) {
                        it = v9;
                        $i$a$-let-ImageDriverStbImage$loadImage$copyData$2 = false;
                        v10 = MemoryUtil.memAlloc(it.capacity() * 2);
                    } else {
                        v10 = v7 = null;
                    }
                    if (v10 == null) {
                        throw new IllegalStateException(("alloc failed, data8: " + data8 + ", data16: " + data16 + ", " + assumedFormat + ", " + bitsPerChannel).toString());
                    }
lbl161:
                    // 3 sources

                    copyData = v7;
                    v11 = data8;
                    if (v11 != null) {
                        it /* !! */  = v11;
                        $i$a$-let-ImageDriverStbImage$loadImage$source$1 = false;
                        v12 = MemoryUtil.memAddress(it /* !! */ );
                    } else {
                        v13 = data16;
                        if (v13 != null) {
                            it /* !! */  = v13;
                            $i$a$-let-ImageDriverStbImage$loadImage$source$2 = false;
                            v12 = MemoryUtil.memAddress((ShortBuffer)it /* !! */ );
                        } else {
                            throw new IllegalStateException("get address failed".toString());
                        }
                    }
                    source = v12;
                    dest = MemoryUtil.memAddress(copyData);
                    MemoryUtil.memCopy(source, dest, copyData.capacity());
                    v14 = tdata8;
                    if (v14 != null) {
                        it /* !! */  = v14;
                        $i$a$-let-ImageDriverStbImage$loadImage$4 = false;
                        STBImage.stbi_image_free(it /* !! */ );
                        v15 = Unit.INSTANCE;
                    } else {
                        v15 = null;
                    }
                    v16 = tdata16;
                    if (v16 != null) {
                        it /* !! */  = v16;
                        $i$a$-let-ImageDriverStbImage$loadImage$5 = false;
                        STBImage.stbi_image_free((ShortBuffer)it /* !! */ );
                        v17 = Unit.INSTANCE;
                    } else {
                        v17 = null;
                    }
                    v18 = wa /* !! */ [0];
                    v19 = ha[0];
                    switch (ca[0]) {
                        case 1: {
                            if (tdata16 != null) {
                                v20 = ColorFormat.R;
                                break;
                            }
                            v20 = ColorFormat.RGB;
                            break;
                        }
                        case 2: {
                            v20 = ColorFormat.RG;
                            break;
                        }
                        case 3: {
                            v20 = ColorFormat.RGB;
                            break;
                        }
                        case 4: {
                            v20 = ColorFormat.RGBa;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("invalid component count " + ca[0]).toString());
                        }
                    }
                    $i$a$-let-ImageDriverStbImage$loadImage$copyData$2 = new ImageDataStb(v18, v19, v20, targetType, false, new MPPBuffer(copyData), null, 64, null);
                    return $i$a$-let-ImageDriverStbImage$loadImage$copyData$2;
                }
                case 3: {
                    STBImage.stbi_set_flip_vertically_on_load(true);
                    wa /* !! */  = (int[])MemoryStack.stackPush();
                    ha = null;
                    try {
                        stack /* !! */  = (MemoryStack)wa /* !! */ ;
                        $i$a$-use-ImageDriverStbImage$loadImage$6 = false;
                        if (!STBImage.stbi_is_hdr_from_memory(buffer)) {
                            $i$a$-require-ImageDriverStbImage$loadImage$6$1 = false;
                            $i$a$-require-ImageDriverStbImage$loadImage$6$1 = name + " does not contain HDR content";
                            throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$6$1.toString());
                        }
                        v21 = stack /* !! */ .mallocInt(1);
                        Intrinsics.checkNotNullExpressionValue(v21, "mallocInt(...)");
                        sx = v21;
                        v22 = stack /* !! */ .mallocInt(1);
                        Intrinsics.checkNotNullExpressionValue(v22, "mallocInt(...)");
                        sy = v22;
                        v23 = stack /* !! */ .mallocInt(1);
                        Intrinsics.checkNotNullExpressionValue(v23, "mallocInt(...)");
                        sc = v23;
                        floats = STBImage.stbi_loadf_from_memory(buffer, sx, sy, sc, 3);
                        if (!(floats != null)) {
                            $i$a$-require-ImageDriverStbImage$loadImage$6$2 = false;
                            $i$a$-require-ImageDriverStbImage$loadImage$6$2 = "load from .hdr failed (" + name + ")";
                            throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$6$2.toString());
                        }
                        v24 = MemoryUtil.memAllocFloat(sx.get(0) * sy.get(0) * sc.get(0));
                        Intrinsics.checkNotNullExpressionValue(v24, "memAllocFloat(...)");
                        copy = v24;
                        MemoryUtil.memCopy(floats, copy);
                        STBImage.stbi_image_free(floats);
                        v25 = sx.get(0);
                        v26 = sy.get(0);
                        v27 = MemoryUtil.memByteBuffer(copy);
                        Intrinsics.checkNotNullExpressionValue(v27, "memByteBuffer(...)");
                        stack /* !! */  = new ImageDataStb(v25, v26, ColorFormat.RGB, ColorType.FLOAT32, false, new MPPBuffer(v27), null, 64, null);
                    }
                    catch (Throwable $i$a$-use-ImageDriverStbImage$loadImage$6) {
                        ha = $i$a$-use-ImageDriverStbImage$loadImage$6;
                        throw $i$a$-use-ImageDriverStbImage$loadImage$6;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)wa /* !! */ , ha);
                    }
                    wa /* !! */  = (int[])((ImageData)stack /* !! */ );
                    return wa /* !! */ ;
                }
                case 4: {
                    data = DDSReaderFunctions.loadDDS(buffer);
                    readBuffer = data.image(0);
                    if (!(readBuffer.remaining() > 0)) {
                        $i$a$-require-ImageDriverStbImage$loadImage$7 = false;
                        $i$a$-require-ImageDriverStbImage$loadImage$7 = "image buffer " + readBuffer + " has no remaining bytes";
                        throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$7.toString());
                    }
                    stack = new ImageDataDds(data.width(), data.height(), data.format(), data.type(), data.flipV(), data.image(0), null, 64, null);
                    return stack;
                }
                case 5: {
                    v28 = EXRHeader.create();
                    Intrinsics.checkNotNullExpressionValue(v28, "create(...)");
                    exrHeader = v28;
                    v29 = EXRVersion.create();
                    Intrinsics.checkNotNullExpressionValue(v29, "create(...)");
                    exrVersion = v29;
                    versionResult = TinyEXR.ParseEXRVersionFromMemory(exrVersion, buffer);
                    buffer.rewind();
                    if (versionResult != 0) {
                        throw new IllegalStateException("failed to get version".toString());
                    }
                    v30 = PointerBuffer.allocateDirect(1);
                    Intrinsics.checkNotNullExpressionValue(v30, "allocateDirect(...)");
                    errors = v30;
                    parseResult = TinyEXR.ParseEXRHeaderFromMemory(exrHeader, exrVersion, buffer, errors);
                    if (parseResult != 0) {
                        throw new IllegalStateException("failed to parse file".toString());
                    }
                    sc = exrHeader.num_channels();
                    for (i = 0; i < sc; ++i) {
                        exrHeader.requested_pixel_types().put(i, exrHeader.pixel_types().get(i));
                    }
                    v31 = EXRImage.create();
                    Intrinsics.checkNotNullExpressionValue(v31, "create(...)");
                    exrImage = v31;
                    TinyEXR.InitEXRImage(exrImage);
                    TinyEXR.LoadEXRImageFromMemory(exrImage, exrHeader, buffer, errors);
                    c = exrImage.num_channels();
                    switch (c) {
                        case 1: {
                            v32 = ColorFormat.R;
                            break;
                        }
                        case 3: {
                            v32 = ColorFormat.RGB;
                            break;
                        }
                        case 4: {
                            v32 = ColorFormat.RGBa;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported number of channels " + c).toString());
                        }
                    }
                    format = v32;
                    t = exrHeader.requested_pixel_types().get(0);
                    switch (t) {
                        case 1: {
                            v33 = ColorType.FLOAT16;
                            break;
                        }
                        case 2: {
                            v33 = ColorType.FLOAT32;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("unsupported pixel type [type=" + t + "]").toString());
                        }
                    }
                    type = v33;
                    height = exrImage.height();
                    width = exrImage.width();
                    channels = exrImage.num_channels();
                    v34 = MemoryUtil.memAlloc(format.getComponentCount() * type.getComponentSize() * exrImage.width() * exrImage.height());
                    Intrinsics.checkNotNullExpressionValue(v34, "memAlloc(...)");
                    data = v34;
                    $this$map$iv = RangesKt.until(0, exrHeader.num_channels());
                    $i$f$map = false;
                    copyData = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    dest = $this$mapTo$iv$iv.iterator();
                    while (dest.hasNext()) {
                        $i$a$-let-ImageDriverStbImage$loadImage$copyData$2 = item$iv$iv = ((IntIterator)dest).nextInt();
                        var37_135 = destination$iv$iv;
                        $i$a$-map-ImageDriverStbImage$loadImage$channelNames$1 = false;
                        var37_135.add(((EXRChannelInfo)exrHeader.channels().get((int)it)).nameString());
                    }
                    channelNames = (List)destination$iv$iv;
                    v35 = exrImage.images();
                    Intrinsics.checkNotNull(v35);
                    images = v35;
                    $this$map$iv = RangesKt.until(0, exrHeader.num_channels());
                    $i$f$map = false;
                    $i$f$mapTo = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    it /* !! */  = $this$mapTo$iv$iv.iterator();
                    while (it /* !! */ .hasNext()) {
                        $i$a$-let-ImageDriverStbImage$loadImage$5 = item$iv$iv = ((IntIterator)it /* !! */ ).nextInt();
                        var37_135 = destination$iv$iv;
                        $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = false;
                        var37_135.add(images.getByteBuffer((int)it, width * height * type.getComponentSize()));
                    }
                    channelImages = (List)destination$iv$iv;
                    switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                        case 1: {
                            $this$map$iv = CollectionsKt.listOf("R");
                            $i$f$map = false;
                            it /* !! */  = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = $this$mapTo$iv$iv.iterator();
                            while ($i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.hasNext()) {
                                item$iv$iv = $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.next();
                                b = (String)item$iv$iv;
                                var37_135 = destination$iv$iv;
                                $i$a$-map-ImageDriverStbImage$loadImage$order$1 = false;
                                var37_135.add(channelNames.indexOf(it));
                            }
                            v36 = (List)destination$iv$iv;
                            break;
                        }
                        case 2: {
                            $this$map$iv = new String[]{"B", "G", "R"};
                            $this$map$iv = CollectionsKt.listOf($this$map$iv);
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = $this$mapTo$iv$iv.iterator();
                            while ($i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.hasNext()) {
                                item$iv$iv = $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.next();
                                it = (String)item$iv$iv;
                                var37_135 = destination$iv$iv;
                                $i$a$-map-ImageDriverStbImage$loadImage$order$2 = false;
                                var37_135.add(channelNames.indexOf(it));
                            }
                            v36 = (List)destination$iv$iv;
                            break;
                        }
                        case 3: {
                            $this$map$iv = new String[]{"B", "G", "R", "A"};
                            $this$map$iv = CollectionsKt.listOf($this$map$iv);
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1 = $this$mapTo$iv$iv.iterator();
                            while ($i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.hasNext()) {
                                item$iv$iv = $i$a$-map-ImageDriverStbImage$loadImage$channelImages$1.next();
                                it = (String)item$iv$iv;
                                var37_135 = destination$iv$iv;
                                $i$a$-map-ImageDriverStbImage$loadImage$order$3 = false;
                                var37_135.add(channelNames.indexOf(it));
                            }
                            v36 = (List)destination$iv$iv;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unsupported channel layout".toString());
                        }
                    }
                    order = v36;
                    $this$none$iv = order;
                    $i$f$none = false;
                    if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl431
                    v37 = true;
                    ** GOTO lbl438
lbl431:
                    // 2 sources

                    for (E element$iv : $this$none$iv) {
                        it = ((Number)element$iv).intValue();
                        $i$a$-none-ImageDriverStbImage$loadImage$8 = false;
                        if (!(it == -1)) continue;
                        v37 = false;
                        ** GOTO lbl438
                    }
                    v37 = true;
lbl438:
                    // 3 sources

                    if (!v37) {
                        $i$a$-require-ImageDriverStbImage$loadImage$9 = false;
                        $i$a$-require-ImageDriverStbImage$loadImage$9 = "some channels are not found";
                        throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadImage$9.toString());
                    }
                    $this$map$iv = order;
                    $i$f$map = false;
                    element$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    $i$f$mapTo = $this$mapTo$iv$iv.iterator();
                    while ($i$f$mapTo.hasNext()) {
                        item$iv$iv = $i$f$mapTo.next();
                        item$iv$iv = ((Number)item$iv$iv).intValue();
                        var37_135 = destination$iv$iv;
                        $i$a$-map-ImageDriverStbImage$loadImage$orderedImages$1 = false;
                        var37_135.add((ByteBuffer)channelImages.get((int)it));
                    }
                    orderedImages = (List)destination$iv$iv;
                    $this$forEach$iv = orderedImages;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (ByteBuffer)element$iv;
                        $i$a$-forEach-ImageDriverStbImage$loadImage$10 = false;
                        Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.nio.Buffer");
                        ((Buffer)it).rewind();
                    }
                    var28_89 = exrImage.height();
                    for (y = 0; y < var28_89; ++y) {
                        offset = (height - 1 - y) * format.getComponentCount() * type.getComponentSize() * width;
                        ((Buffer)data).position(offset);
                        var31_126 = exrImage.width();
                        for (x = 0; x < var31_126; ++x) {
                            for (c = 0; c < channels; ++c) {
                                var34_110 = type.getComponentSize();
                                for (i = 0; i < var34_110; ++i) {
                                    data.put(((ByteBuffer)orderedImages.get(c)).get());
                                }
                            }
                        }
                    }
                    ((Buffer)data).rewind();
                    TinyEXR.FreeEXRHeader(exrHeader);
                    TinyEXR.FreeEXRImage(exrImage);
                    var27_82 = new ImageDataStb(exrImage.width(), exrImage.height(), format, type, false, new MPPBuffer(data), null, 64, null);
                    return var27_82;
                }
            }
            throw new IllegalStateException("format not supported".toString());
        }
        finally {
            if (!inputIsDirect) {
                MemoryUtil.memFree(buffer);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveImage(@NotNull ImageData imageData, @NotNull String filename, @NotNull ImageSaveConfiguration configuration) {
        Intrinsics.checkNotNullParameter(imageData, "imageData");
        Intrinsics.checkNotNullParameter(filename, "filename");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        ImageSaveConfiguration imageSaveConfiguration = configuration;
        if (imageSaveConfiguration instanceof PngImageSaveConfiguration) {
            Object object = imageData.getData();
            if (object == null || (object = ((MPPBuffer)object).getByteBuffer()) == null) {
                throw new IllegalStateException("no data".toString());
            }
            ByteBuffer buffer = ImageDriverStbImage.saveImage$flipImage(imageData, (ByteBuffer)object);
            Pair<ColorFormat, ColorType> pair = new Pair<ColorFormat, ColorType>(imageData.getFormat(), imageData.getType());
            if (!Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT8)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.UINT8)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.UINT8_SRGB)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8_SRGB))) throw new IllegalStateException(("unsupported input for PNG (" + imageData.getType() + "/" + imageData.getType()).toString());
            if (!STBImageWrite.stbi_write_png(filename, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), buffer, imageData.getWidth() * imageData.getFormat().getComponentCount())) {
                boolean $i$a$-require-ImageDriverStbImage$saveImage$52 = false;
                String $i$a$-require-ImageDriverStbImage$saveImage$52 = "write to png failed";
                throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$52.toString());
            }
            if (imageData.getFlipV()) return;
            MemoryUtil.memFree(buffer);
            return;
        } else if (imageSaveConfiguration instanceof JpegImageSaveConfiguration) {
            Object object = imageData.getData();
            if (object == null || (object = ((MPPBuffer)object).getByteBuffer()) == null) {
                throw new IllegalStateException("no data".toString());
            }
            ByteBuffer buffer = ImageDriverStbImage.saveImage$flipImage(imageData, (ByteBuffer)object);
            Pair<ColorFormat, ColorType> pair = new Pair<ColorFormat, ColorType>(imageData.getFormat(), imageData.getType());
            if (!Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT8)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.UINT8)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.UINT8)) && !Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8_SRGB))) throw new IllegalStateException(("unsupported input for JPG (" + imageData.getType() + "/" + imageData.getType()).toString());
            if (!STBImageWrite.stbi_write_jpg(filename, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), buffer, ((JpegImageSaveConfiguration)configuration).getQuality())) {
                boolean $i$a$-require-ImageDriverStbImage$saveImage$62 = false;
                String $i$a$-require-ImageDriverStbImage$saveImage$62 = "write to jpg failed";
                throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$62.toString());
            }
            if (imageData.getFlipV()) return;
            MemoryUtil.memFree(buffer);
            return;
        } else {
            int n;
            int n2;
            Object object;
            Object object2;
            if (imageSaveConfiguration instanceof HdrImageSaveConfiguration) {
                if (!Intrinsics.areEqual(new Pair<ColorFormat, ColorType>(imageData.getFormat(), imageData.getType()), new Pair<ColorFormat, ColorType>(ColorFormat.RGB, ColorType.FLOAT32))) throw new IllegalStateException(("unsupported input for HDR (" + imageData.getType() + "/" + imageData.getType()).toString());
                Object object3 = imageData.getData();
                if (object3 == null || (object3 = ((MPPBuffer)object3).getByteBuffer()) == null || (object3 = ((ByteBuffer)object3).asFloatBuffer()) == null) {
                    throw new IllegalStateException("no data".toString());
                }
                if (STBImageWrite.stbi_write_hdr((CharSequence)filename, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), (FloatBuffer)object3)) return;
                boolean $i$a$-require-ImageDriverStbImage$saveImage$72 = false;
                String $i$a$-require-ImageDriverStbImage$saveImage$72 = "write to hdr failed";
                throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$72.toString());
            }
            if (!(imageSaveConfiguration instanceof ExrImageSaveConfiguration)) throw new IllegalStateException(("unsupported file format when saving '" + filename + "' using " + Reflection.getOrCreateKotlinClass(configuration.getClass()).getSimpleName()).toString());
            if (!(imageData.getFormat() == ColorFormat.RGB || imageData.getFormat() == ColorFormat.RGBa)) {
                boolean $i$a$-require-ImageDriverStbImage$saveImage$82 = false;
                String $i$a$-require-ImageDriverStbImage$saveImage$82 = "can only save RGB and RGBa formats in EXR format";
                throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$saveImage$82.toString());
            }
            int exrType = imageData.getType() == ColorType.FLOAT16 ? 1 : 2;
            EXRImage eXRImage = EXRImage.create();
            Intrinsics.checkNotNullExpressionValue(eXRImage, "create(...)");
            EXRImage exrImage = eXRImage;
            TinyEXR.InitEXRImage(exrImage);
            EXRHeader eXRHeader = EXRHeader.create();
            Intrinsics.checkNotNullExpressionValue(eXRHeader, "create(...)");
            EXRHeader exrHeader = eXRHeader;
            TinyEXR.InitEXRHeader(exrHeader);
            int channelCount = imageData.getFormat().getComponentCount();
            exrHeader.num_channels(channelCount);
            exrHeader.compression_type(((ExrImageSaveConfiguration)configuration).getCompression());
            EXRChannelInfo.Buffer buffer = EXRChannelInfo.calloc(channelCount);
            Intrinsics.checkNotNullExpressionValue(buffer, "calloc(...)");
            EXRChannelInfo.Buffer exrChannels = buffer;
            String channelNames = "RGBA";
            for (int ch = 0; ch < channelCount; ++ch) {
                void $this$saveImage_u24lambda_u2434;
                object2 = ByteBuffer.allocateDirect(2);
                ByteBuffer byteBuffer = object2;
                object = (EXRChannelInfo)exrChannels.get(ch);
                n2 = 0;
                $this$saveImage_u24lambda_u2434.put((byte)channelNames.charAt(ch));
                $this$saveImage_u24lambda_u2434.put((byte)0);
                Intrinsics.checkNotNull($this$saveImage_u24lambda_u2434, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)$this$saveImage_u24lambda_u2434).rewind();
                ((EXRChannelInfo)object).name((ByteBuffer)object2);
            }
            exrHeader.channels(exrChannels);
            object2 = new ArrayList(channelCount);
            int $this$saveImage_u24lambda_u2434 = 0;
            while ($this$saveImage_u24lambda_u2434 < channelCount) {
                int n3 = n2 = $this$saveImage_u24lambda_u2434++;
                object = object2;
                boolean bl = false;
                ((ArrayList)object).add(ByteBuffer.allocateDirect(imageData.getWidth() * imageData.getHeight() * 4).order(ByteOrder.nativeOrder()));
            }
            List buffers = (List)object2;
            Object object4 = imageData.getData();
            if (object4 == null || (object4 = ((MPPBuffer)object4).getByteBuffer()) == null) {
                throw new IllegalStateException("no buffer".toString());
            }
            Object data = object4;
            n2 = imageData.getHeight();
            for (int y = 0; y < n2; ++y) {
                int row = !imageData.getFlipV() ? imageData.getHeight() - 1 - y : y;
                int offset = row * imageData.getWidth() * imageData.getType().getComponentSize() * channelCount;
                ((Buffer)data).position(offset);
                int n4 = imageData.getWidth();
                for (int x = 0; x < n4; ++x) {
                    Iterable $this$forEach$iv = buffers;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ByteBuffer it = (ByteBuffer)element$iv;
                        boolean bl = false;
                        int n5 = imageData.getType().getComponentSize();
                        for (int i = 0; i < n5; ++i) {
                            byte d = ((ByteBuffer)data).get();
                            it.put(d);
                        }
                    }
                }
            }
            Iterable $this$forEach$iv = buffers;
            boolean $i$f$forEach = false;
            Object row = $this$forEach$iv.iterator();
            while (row.hasNext()) {
                Object element$iv = row.next();
                ByteBuffer it = (ByteBuffer)element$iv;
                n = 0;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.nio.Buffer");
                ((Buffer)it).rewind();
            }
            Object $this$saveImage_u24lambda_u2439 = row = BufferUtils.createIntBuffer(4 * channelCount);
            boolean bl = false;
            n = 0;
            while (n < channelCount) {
                int it = n++;
                boolean bl2 = false;
                ((IntBuffer)$this$saveImage_u24lambda_u2439).put(exrType);
            }
            Intrinsics.checkNotNull($this$saveImage_u24lambda_u2439, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)$this$saveImage_u24lambda_u2439).rewind();
            Object object5 = row;
            Intrinsics.checkNotNullExpressionValue(object5, "apply(...)");
            Object pixelTypes = object5;
            exrHeader.pixel_types((IntBuffer)pixelTypes);
            ((Buffer)pixelTypes).rewind();
            exrHeader.requested_pixel_types((IntBuffer)pixelTypes);
            exrImage.width(imageData.getWidth());
            exrImage.height(imageData.getHeight());
            exrImage.num_channels(channelCount);
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(channelCount);
            Intrinsics.checkNotNullExpressionValue(pointerBuffer, "allocateDirect(...)");
            PointerBuffer images = pointerBuffer;
            Iterable $this$forEachIndexed$iv = buffers;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n6;
                if ((n6 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ByteBuffer byteBuffer = (ByteBuffer)item$iv;
                int i = n6;
                boolean bl3 = false;
                images.put(channelCount - 1 - i, (ByteBuffer)it);
            }
            images.rewind();
            exrImage.images(images);
            PointerBuffer pointerBuffer2 = PointerBuffer.allocateDirect(1);
            Intrinsics.checkNotNullExpressionValue(pointerBuffer2, "allocateDirect(...)");
            PointerBuffer errors = pointerBuffer2;
            int result = TinyEXR.SaveEXRImageToFile(exrImage, exrHeader, filename, errors);
            if (!(result == 0)) {
                boolean bl4 = false;
                String string = "failed to save EXR to " + filename + ", [result=" + result + "]";
                throw new IllegalArgumentException(string.toString());
            }
            exrImage.images(null);
            TinyEXR.FreeEXRImage(exrImage);
        }
    }

    @Override
    @NotNull
    public String imageToDataUrl(@NotNull ImageData imageData, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(imageData, "imageData");
        ImageFileFormat imageFileFormat = formatHint;
        if (imageFileFormat == null) {
            imageFileFormat = ImageFileFormat.JPG;
        }
        ImageFileFormat imageFileFormat2 = imageFileFormat;
        ByteBuffer saveBuffer = ByteBuffer.allocate(0x200000);
        STBIWriteCallback writeFunc2 = new STBIWriteCallback(saveBuffer){
            final /* synthetic */ ByteBuffer $saveBuffer;
            {
                this.$saveBuffer = $saveBuffer;
            }

            public void invoke(long context, long data, int size) {
                block0: {
                    ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(data, size);
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "memByteBuffer(...)");
                    ByteBuffer sourceBuffer = byteBuffer;
                    ByteBuffer byteBuffer2 = this.$saveBuffer;
                    if (byteBuffer2 == null) break block0;
                    byteBuffer2.put(sourceBuffer);
                }
            }
        };
        MPPBuffer mPPBuffer = imageData.getData();
        Intrinsics.checkNotNull(mPPBuffer);
        ByteBuffer pixels = mPPBuffer.getByteBuffer();
        if (!imageData.getFlipV()) {
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer(imageData.getWidth() * imageData.getHeight() * imageData.getFormat().getComponentCount());
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "createByteBuffer(...)");
            ByteBuffer flippedPixels = byteBuffer;
            ((Buffer)flippedPixels).rewind();
            int stride = imageData.getWidth() * imageData.getFormat().getComponentCount();
            byte[] row = new byte[stride];
            int n = imageData.getHeight();
            for (int y = 0; y < n; ++y) {
                MPPBuffer mPPBuffer2 = imageData.getData();
                Intrinsics.checkNotNull(mPPBuffer2);
                mPPBuffer2.getByteBuffer().position((imageData.getHeight() - y - 1) * stride);
                MPPBuffer mPPBuffer3 = imageData.getData();
                Intrinsics.checkNotNull(mPPBuffer3);
                mPPBuffer3.getByteBuffer().get(row);
                flippedPixels.put(row);
            }
            flippedPixels.rewind();
            pixels = flippedPixels;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[imageFileFormat2.ordinal()]) {
            case 2: {
                STBImageWrite.stbi_write_jpg_to_func(writeFunc2, 0L, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), pixels, 90);
                break;
            }
            case 1: {
                STBImageWrite.stbi_write_png_to_func(writeFunc2, 0L, imageData.getWidth(), imageData.getHeight(), imageData.getFormat().getComponentCount(), pixels, imageData.getWidth() * imageData.getFormat().getComponentCount());
                break;
            }
            default: {
                throw new IllegalStateException(("format not supported " + imageFileFormat2).toString());
            }
        }
        Intrinsics.checkNotNull(saveBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        byte[] byteArray = new byte[((Buffer)saveBuffer).position()];
        ((Buffer)saveBuffer).rewind();
        saveBuffer.get(byteArray);
        String base64Data = Base64.getEncoder().encodeToString(byteArray);
        return "data:" + imageFileFormat2.getMimeType() + ";base64," + base64Data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CubemapImageData loadCubemapImage(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint) {
        CubemapImageData cubemapImageData;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        Pair<File, URL> pair = TextFromURLKt.resolveFileOrUrl(fileOrUrl);
        File file = pair.component1();
        URL url = pair.component2();
        Path path = Path.of(fileOrUrl, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "of(...)");
        Object object = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = false;
            String $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = fileOrUrl + " not found";
            throw new IllegalArgumentException($i$a$-require-ImageDriverStbImage$loadCubemapImage$22.toString());
        }
        if (file != null) {
            object = FileChannel.open(Path.of(fileOrUrl, new String[0]), new OpenOption[0]);
            Throwable $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = null;
            try {
                CubemapImageData cubemapImageData2;
                FileChannel channel = (FileChannel)object;
                boolean bl = false;
                ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)channel.size());
                Intrinsics.checkNotNullExpressionValue(byteBuffer, "memAlloc(...)");
                ByteBuffer buffer = byteBuffer;
                channel.read(buffer);
                buffer.flip();
                try {
                    cubemapImageData2 = this.loadCubemapImage(new MPPBuffer(buffer), fileOrUrl, formatHint);
                }
                finally {
                    MemoryUtil.memFree(buffer);
                }
                CubemapImageData cubemapImageData3 = cubemapImageData2;
                cubemapImageData = cubemapImageData3;
            }
            catch (Throwable throwable) {
                $i$a$-require-ImageDriverStbImage$loadCubemapImage$22 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, $i$a$-require-ImageDriverStbImage$loadCubemapImage$22);
            }
        }
        if (url != null) {
            CubemapImageData cubemapImageData4;
            byte[] byteArray = TextStreamsKt.readBytes(url);
            if (byteArray.length == 0) {
                throw new IllegalStateException(("read 0 bytes from stream " + fileOrUrl).toString());
            }
            ByteBuffer byteBuffer = MemoryUtil.memAlloc(byteArray.length);
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "memAlloc(...)");
            ByteBuffer buffer = byteBuffer;
            buffer.put(byteArray);
            buffer.flip();
            try {
                cubemapImageData4 = this.loadCubemapImage(new MPPBuffer(buffer), fileOrUrl, formatHint);
            }
            finally {
                MemoryUtil.memFree(buffer);
            }
            cubemapImageData = cubemapImageData4;
        } else {
            throw new IllegalStateException(("can't resolve " + fileOrUrl).toString());
        }
        return cubemapImageData;
    }

    @Override
    @NotNull
    public CubemapImageData loadCubemapImage(@NotNull MPPBuffer buffer, @Nullable String name, @Nullable ImageFileFormat formatHint) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        DDSData ddsData = DDSReaderKt.loadDDS$default(buffer, false, 2, null);
        if (!ddsData.cubeMap()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(ddsData.width() == ddsData.height())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new CubemapImageDataDds(ddsData.width(), ddsData.height(), ddsData.format(), ddsData.type(), ddsData.mipmaps(), ddsData.bdata(), ddsData.bdata2());
    }

    @Override
    public void saveImage(@NotNull ImageData imageData, @NotNull String filename, @Nullable ImageFileFormat formatHint) {
        ImageDriver.DefaultImpls.saveImage((ImageDriver)this, imageData, filename, formatHint);
    }

    @Override
    public void saveImage(@NotNull ImageData imageData, @NotNull String filename, @NotNull Function1<? super ImageSaveContext, ? extends ImageSaveConfiguration> saveContext) {
        ImageDriver.DefaultImpls.saveImage((ImageDriver)this, imageData, filename, saveContext);
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteBuffer saveImage$flipImage(ImageData $imageData, ByteBuffer inputBuffer) {
        ByteBuffer byteBuffer;
        if ($imageData.getFlipV()) {
            byteBuffer = inputBuffer;
        } else {
            void var2_2;
            ByteBuffer byteBuffer2 = MemoryUtil.memAlloc($imageData.getWidth() * $imageData.getHeight() * $imageData.getFormat().getComponentCount() * $imageData.getType().getComponentSize());
            Intrinsics.checkNotNullExpressionValue(byteBuffer2, "memAlloc(...)");
            ByteBuffer flippedPixels = byteBuffer2;
            int stride = $imageData.getWidth() * $imageData.getFormat().getComponentCount();
            byte[] row = new byte[stride];
            flippedPixels.rewind();
            int n = $imageData.getHeight();
            for (int y = 0; y < n; ++y) {
                inputBuffer.position(($imageData.getHeight() - y - 1) * stride);
                inputBuffer.get(row);
                flippedPixels.put(row);
            }
            inputBuffer.rewind();
            inputBuffer.put(flippedPixels);
            inputBuffer.rewind();
            flippedPixels.rewind();
            byteBuffer = var2_2;
        }
        return byteBuffer;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ColorFormat.values().length];
            try {
                nArray[ColorFormat.R.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorFormat.RGB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorFormat.RGBa.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ImageFileFormat.values().length];
            try {
                nArray[ImageFileFormat.PNG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.JPG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.HDR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.DDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFileFormat.EXR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

