/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.draw.ArrayCubemap;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ArrayCubemapGL4;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.CubemapGL3Kt;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.RenderTargetGL3;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 F2\u00020\u0001:\u0001FB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u001d\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J(\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003H\u0016J \u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003H\u0016J(\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003H\u0016J0\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020.2\u0006\u0010'\u001a\u0002012\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0003H\u0016J0\u00105\u001a\u00020 2\u0006\u00100\u001a\u00020.2\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0003H\u0016JP\u00105\u001a\u00020 2\u0006\u00100\u001a\u00020.2\u0006\u00106\u001a\u0002092\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J\u0010\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020\u0003H\u0016J\b\u0010?\u001a\u00020 H\u0016J&\u0010@\u001a\u00020 2\u0017\u0010A\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 0B\u00a2\u0006\u0002\bCH\u0000\u00a2\u0006\u0002\bDJ\b\u0010E\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\t\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/openrndr/internal/gl3/CubemapGL3;", "Lorg/openrndr/draw/Cubemap;", "texture", "", "width", "type", "Lorg/openrndr/draw/ColorType;", "format", "Lorg/openrndr/draw/ColorFormat;", "levels", "session", "Lorg/openrndr/draw/Session;", "<init>", "(IILorg/openrndr/draw/ColorType;Lorg/openrndr/draw/ColorFormat;ILorg/openrndr/draw/Session;)V", "getTexture", "()I", "getWidth", "getType", "()Lorg/openrndr/draw/ColorType;", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getSession", "()Lorg/openrndr/draw/Session;", "value", "getLevels", "setLevels", "(I)V", "destroyed", "", "glFormat", "glFormat$openrndr_gl3", "generateMipmaps", "", "filter", "min", "Lorg/openrndr/draw/MinifyingFilter;", "mag", "Lorg/openrndr/draw/MagnifyingFilter;", "copyTo", "target", "Lorg/openrndr/draw/ArrayCubemap;", "layer", "fromLevel", "toLevel", "Lorg/openrndr/draw/ColorBuffer;", "fromSide", "Lorg/openrndr/draw/CubemapSide;", "read", "side", "Ljava/nio/ByteBuffer;", "targetFormat", "targetType", "level", "write", "source", "sourceFormat", "sourceType", "Lorg/openrndr/utils/buffer/MPPBuffer;", "x", "y", "height", "bind", "textureUnit", "destroy", "bound", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "bound$openrndr_gl3", "close", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nCubemapGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubemapGL3.kt\norg/openrndr/internal/gl3/CubemapGL3\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n*L\n1#1,347:1\n1169#2,3:348\n1169#2,3:375\n1169#2,3:426\n1154#2,3:453\n1154#2,3:456\n69#2,3:459\n62#2,3:630\n67#3,3:351\n51#3,13:354\n65#3,7:368\n67#3,3:378\n51#3,13:381\n65#3,7:395\n67#3,3:402\n51#3,13:405\n65#3,7:419\n67#3,3:429\n51#3,13:432\n65#3,7:446\n67#3,3:462\n51#3,13:465\n65#3,7:479\n67#3,3:486\n51#3,13:489\n65#3,7:503\n67#3,3:510\n51#3,13:513\n65#3,7:527\n67#3,3:534\n51#3,13:537\n65#3,7:551\n67#3,3:558\n51#3,13:561\n65#3,7:575\n67#3,3:582\n51#3,13:585\n65#3,7:599\n67#3,3:606\n51#3,13:609\n65#3,7:623\n68#3,2:633\n51#3,21:635\n67#3,3:656\n51#3,13:659\n65#3,7:673\n67#3,3:680\n51#3,13:683\n65#3,7:697\n67#4:367\n67#4:394\n67#4:418\n67#4:445\n67#4:478\n67#4:502\n67#4:526\n67#4:550\n67#4:574\n67#4:598\n67#4:622\n67#4:672\n67#4:696\n*S KotlinDebug\n*F\n+ 1 CubemapGL3.kt\norg/openrndr/internal/gl3/CubemapGL3\n*L\n139#1:348,3\n173#1:375,3\n208#1:426,3\n321#1:453,3\n337#1:456,3\n338#1:459,3\n263#1:630,3\n161#1:351,3\n161#1:354,13\n161#1:368,7\n174#1:378,3\n174#1:381,13\n174#1:395,7\n196#1:402,3\n196#1:405,13\n196#1:419,7\n209#1:429,3\n209#1:432,13\n209#1:446,7\n152#1:462,3\n152#1:465,13\n152#1:479,7\n168#1:486,3\n168#1:489,13\n168#1:503,7\n187#1:510,3\n187#1:513,13\n187#1:527,7\n203#1:534,3\n203#1:537,13\n203#1:551,7\n213#1:558,3\n213#1:561,13\n213#1:575,7\n230#1:582,3\n230#1:585,13\n230#1:599,7\n258#1:606,3\n258#1:609,13\n258#1:623,7\n277#1:633,2\n277#1:635,21\n295#1:656,3\n295#1:659,13\n295#1:673,7\n298#1:680,3\n298#1:683,13\n298#1:697,7\n161#1:367\n174#1:394\n196#1:418\n209#1:445\n152#1:478\n168#1:502\n187#1:526\n203#1:550\n213#1:574\n230#1:598\n258#1:622\n295#1:672\n298#1:696\n*E\n"})
public final class CubemapGL3
implements Cubemap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int texture;
    private final int width;
    @NotNull
    private final ColorType type;
    @NotNull
    private final ColorFormat format;
    @Nullable
    private final Session session;
    private int levels;
    private boolean destroyed;

    public CubemapGL3(int texture, int width, @NotNull ColorType type, @NotNull ColorFormat format, int levels, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        this.texture = texture;
        this.width = width;
        this.type = type;
        this.format = format;
        this.session = session;
        this.levels = levels;
    }

    public final int getTexture() {
        return this.texture;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    @NotNull
    public ColorType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ColorFormat getFormat() {
        return this.format;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    @Override
    public int getLevels() {
        return this.levels;
    }

    private void setLevels(int value) {
        if (this.levels != value) {
            this.levels = value;
            this.bound$openrndr_gl3(CubemapGL3::_set_levels_$lambda$0);
        }
    }

    public final int glFormat$openrndr_gl3() {
        return ((Number)ColorBufferGL3Kt.internalFormat(this.getFormat(), this.getType()).getFirst()).intValue();
    }

    @Override
    public void generateMipmaps() {
        this.bound$openrndr_gl3(CubemapGL3::generateMipmaps$lambda$1);
    }

    @Override
    public void filter(@NotNull MinifyingFilter min, @NotNull MagnifyingFilter mag) {
        Intrinsics.checkNotNullParameter((Object)min, "min");
        Intrinsics.checkNotNullParameter((Object)mag, "mag");
        this.bound$openrndr_gl3(arg_0 -> CubemapGL3.filter$lambda$2(min, mag, arg_0));
    }

    @Override
    public void copyTo(@NotNull ArrayCubemap target2, int layer, int fromLevel, int toLevel) {
        Intrinsics.checkNotNullParameter(target2, "target");
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int fromDiv = 1 << fromLevel;
        int toDiv = 1 << toLevel;
        for (CubemapSide side : CubemapSide.getEntries()) {
            RenderTarget renderTarget = RenderTargetKt.renderTarget$default(this.getWidth() / fromDiv, this.getWidth() / fromDiv, 0.0, null, null, arg_0 -> CubemapGL3.copyTo$lambda$3(this, side, fromLevel, arg_0), 28, null);
            Intrinsics.checkNotNull(renderTarget, "null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            RenderTargetGL3 readTarget = (RenderTargetGL3)renderTarget;
            ArrayCubemapGL4 cfr_ignored_0 = (ArrayCubemapGL4)target2;
            readTarget.bind();
            int src$iv = 36064;
            boolean $i$f$glReadBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glReadBuffer(src$iv);
                    break;
                }
                case 2: {
                    GLES32.glReadBuffer(src$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ((ArrayCubemapGL4)target2).bound$openrndr_gl3(arg_0 -> CubemapGL3.copyTo$lambda$4(target2, toLevel, layer, side, toDiv, arg_0));
            readTarget.unbind();
            readTarget.detachColorAttachments();
            readTarget.destroy();
        }
    }

    @Override
    public void copyTo(@NotNull Cubemap target2, int fromLevel, int toLevel) {
        Intrinsics.checkNotNullParameter(target2, "target");
        boolean $i$f$debugGLErrors2 = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var19_20 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_20;
                throw new GL3Exception(string);
            }
        }
        if (!(!this.destroyed)) {
            String $i$f$debugGLErrors2 = "Failed requirement.";
            throw new IllegalArgumentException($i$f$debugGLErrors2.toString());
        }
        int fromDiv = 1 << fromLevel;
        int toDiv = 1 << toLevel;
        for (CubemapSide side : CubemapSide.getEntries()) {
            RenderTarget renderTarget = RenderTargetKt.renderTarget$default(this.getWidth() / fromDiv, this.getWidth() / fromDiv, 0.0, null, null, arg_0 -> CubemapGL3.copyTo$lambda$5(this, side, fromLevel, arg_0), 28, null);
            Intrinsics.checkNotNull(renderTarget, "null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            RenderTargetGL3 readTarget = (RenderTargetGL3)renderTarget;
            CubemapGL3 cfr_ignored_0 = (CubemapGL3)target2;
            readTarget.bind();
            int src$iv = 36064;
            boolean $i$f$glReadBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glReadBuffer(src$iv);
                    break;
                }
                case 2: {
                    GLES32.glReadBuffer(src$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean $i$f$debugGLErrors3 = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                boolean $i$f$checkGLErrors = false;
                int error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int n = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    int it = n;
                    Object var19_21 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_21;
                    throw new GL3Exception(string);
                }
            }
            ((CubemapGL3)target2).bound$openrndr_gl3(arg_0 -> CubemapGL3.copyTo$lambda$6(side, toLevel, target2, toDiv, arg_0));
            readTarget.unbind();
            readTarget.detachColorAttachments();
            readTarget.destroy();
        }
    }

    @Override
    public void copyTo(@NotNull ColorBuffer target2, @NotNull CubemapSide fromSide, int fromLevel, int toLevel) {
        Intrinsics.checkNotNullParameter(target2, "target");
        Intrinsics.checkNotNullParameter((Object)fromSide, "fromSide");
        boolean $i$f$debugGLErrors2 = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var18_20 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var18_20;
                throw new GL3Exception(string);
            }
        }
        if (!(!this.destroyed)) {
            String $i$f$debugGLErrors2 = "Failed requirement.";
            throw new IllegalArgumentException($i$f$debugGLErrors2.toString());
        }
        int fromDiv = 1 << fromLevel;
        int toDiv = 1 << toLevel;
        RenderTarget renderTarget = RenderTargetKt.renderTarget$default(this.getWidth() / fromDiv, this.getWidth() / fromDiv, 0.0, null, null, arg_0 -> CubemapGL3.copyTo$lambda$7(this, fromSide, fromLevel, arg_0), 28, null);
        Intrinsics.checkNotNull(renderTarget, "null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
        RenderTargetGL3 readTarget = (RenderTargetGL3)renderTarget;
        ColorBufferGL3 cfr_ignored_0 = (ColorBufferGL3)target2;
        readTarget.bind();
        int src$iv = 36064;
        boolean $i$f$glReadBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glReadBuffer(src$iv);
                break;
            }
            case 2: {
                GLES32.glReadBuffer(src$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors3 = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var18_21 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var18_21;
                throw new GL3Exception(string);
            }
        }
        ((ColorBufferGL3)target2).bound(arg_0 -> CubemapGL3.copyTo$lambda$8(target2, toLevel, toDiv, arg_0));
        readTarget.unbind();
        readTarget.detachColorAttachments();
        readTarget.destroy();
    }

    @Override
    public void read(@NotNull CubemapSide side, @NotNull ByteBuffer target2, @NotNull ColorFormat targetFormat, @NotNull ColorType targetType, int level) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(target2, "target");
        Intrinsics.checkNotNullParameter((Object)targetFormat, "targetFormat");
        Intrinsics.checkNotNullParameter((Object)targetType, "targetType");
        this.bound$openrndr_gl3(arg_0 -> CubemapGL3.read$lambda$9(side, level, targetFormat, targetType, target2, arg_0));
    }

    @Override
    public void write(@NotNull CubemapSide side, @NotNull ByteBuffer source, @NotNull ColorFormat sourceFormat, @NotNull ColorType sourceType, int level) {
        int bytesNeeded;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter((Object)sourceFormat, "sourceFormat");
        Intrinsics.checkNotNullParameter((Object)sourceType, "sourceType");
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int div = 1 << level;
        if (!source.isDirect()) {
            throw new IllegalArgumentException("buffer is not a direct buffer.");
        }
        int effectiveWidth = this.getWidth();
        int effectiveHeight = this.getWidth();
        if (!sourceType.getCompressed() && !((bytesNeeded = sourceFormat.getComponentCount() * sourceType.getComponentSize() * (effectiveWidth / div) * (effectiveHeight / div)) <= source.remaining())) {
            boolean bl = false;
            String string = "write of " + this.getWidth() + "x" + this.getWidth() + " of " + this.getFormat() + "/" + this.getType() + " pixels to level " + level + " requires " + bytesNeeded + " bytes, buffer only has " + source.remaining() + " bytes left, buffer capacity is " + source.capacity();
            throw new IllegalArgumentException(string.toString());
        }
        this.bound$openrndr_gl3(arg_0 -> CubemapGL3.write$lambda$12(source, sourceType, side, level, div, sourceFormat, arg_0));
    }

    @Override
    public void write(@NotNull CubemapSide side, @NotNull MPPBuffer source, @NotNull ColorFormat sourceFormat, @NotNull ColorType sourceType, int x, int y, int width, int height, int level) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter((Object)sourceFormat, "sourceFormat");
        Intrinsics.checkNotNullParameter((Object)sourceType, "sourceType");
        this.write(side, source.getByteBuffer(), sourceFormat, sourceType, level);
    }

    @Override
    public void bind(int textureUnit) {
        if (!this.destroyed) {
            int texture$iv = 33984 + textureUnit;
            boolean $i$f$glActiveTexture = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glActiveTexture(texture$iv);
                    break;
                }
                case 2: {
                    GLES32.glActiveTexture(texture$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            throw new IllegalStateException("attempting to bind destroyed cubemap");
        }
        GLGLESKt.glBindTexture(34067, this.texture);
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            GLGLESKt.glDeleteTextures(this.texture);
            Session.Companion.getActive().untrack(this);
            this.destroyed = true;
        }
    }

    public final void bound$openrndr_gl3(@NotNull Function1<? super CubemapGL3, Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        int texture$iv = 33984;
        boolean $i$f$glActiveTexture = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glActiveTexture(texture$iv);
                break;
            }
            case 2: {
                GLES32.glActiveTexture(texture$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int pname$iv = 34068;
        boolean $i$f$glGetInteger = false;
        int current = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1 -> GL45C.glGetInteger(pname$iv);
            case 2 -> GLES32.glGetInteger(pname$iv);
            default -> throw new NoWhenBranchMatchedException();
        };
        GLGLESKt.glBindTexture(34067, this.texture);
        f.invoke(this);
        GLGLESKt.glBindTexture(34067, current);
    }

    @Override
    public void close() {
        this.destroy();
    }

    private static final Unit _set_levels_$lambda$0(CubemapGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glTexParameteri(3553, 33085, $this$bound.getLevels() - 1);
        return Unit.INSTANCE;
    }

    private static final Unit generateMipmaps$lambda$1(CubemapGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glGenerateMipmap(34067);
        return Unit.INSTANCE;
    }

    private static final Unit filter$lambda$2(MinifyingFilter $min, MagnifyingFilter $mag, CubemapGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glTexParameteri(34067, 10241, ColorBufferGL3Kt.toGLFilter($min));
        GLGLESKt.glTexParameteri(34067, 10240, ColorBufferGL3Kt.toGLFilter($mag));
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$3(CubemapGL3 this$0, CubemapSide $side, int $fromLevel, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        $this$renderTarget.cubemap(this$0, $side, $fromLevel);
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$4(ArrayCubemap $target, int $toLevel, int $layer, CubemapSide $side, int $toDiv, ArrayCubemapGL4 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glCopyTexSubImage3D(((ArrayCubemapGL4)$target).getTarget(), $toLevel, 0, 0, $layer * 6 + $side.ordinal(), 0, 0, ((ArrayCubemapGL4)$target).getWidth() / $toDiv, ((ArrayCubemapGL4)$target).getWidth() / $toDiv);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var15_14 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var15_14;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$5(CubemapGL3 this$0, CubemapSide $side, int $fromLevel, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        $this$renderTarget.cubemap(this$0, $side, $fromLevel);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var13_12 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var13_12;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$6(CubemapSide $side, int $toLevel, Cubemap $target, int $toDiv, CubemapGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glCopyTexSubImage2D(CubemapGL3Kt.getGlTextureTarget($side), $toLevel, 0, 0, 0, 0, ((CubemapGL3)$target).getWidth() / $toDiv, ((CubemapGL3)$target).getWidth() / $toDiv);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var14_13 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_13;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$7(CubemapGL3 this$0, CubemapSide $fromSide, int $fromLevel, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        $this$renderTarget.cubemap(this$0, $fromSide, $fromLevel);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var13_12 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var13_12;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$8(ColorBuffer $target, int $toLevel, int $toDiv, ColorBufferGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glCopyTexSubImage2D(((ColorBufferGL3)$target).getTarget(), $toLevel, 0, 0, 0, 0, ((ColorBufferGL3)$target).getWidth() / $toDiv, ((ColorBufferGL3)$target).getWidth() / $toDiv);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var13_12 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var13_12;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit read$lambda$9(CubemapSide $side, int $level, ColorFormat $targetFormat, ColorType $targetType, ByteBuffer $target, CubemapGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glPixelStorei(3333, 1);
        GL13.glGetTexImage(CubemapGL3Kt.getGlTextureTarget($side), $level, ColorBufferGL3Kt.glFormat($targetFormat), ColorBufferGL3Kt.glType($targetType), $target);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var15_14 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var15_14;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit write$lambda$12(ByteBuffer $source, ColorType $sourceType, CubemapSide $side, int $level, int $div, ColorFormat $sourceFormat, CubemapGL3 $this$bound) {
        int error$iv$iv;
        boolean $i$f$checkGLErrors;
        boolean $i$f$debugGLErrors;
        int error$iv$iv2;
        boolean $i$f$checkGLErrors2;
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        boolean $i$f$debugGLErrors22 = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            $i$f$checkGLErrors2 = false;
            error$iv$iv2 = GLGLESKt.glGetError();
            if (error$iv$iv2 != 0) {
                Object message$iv$iv = switch (error$iv$iv2) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv2 + ">";
                };
                int n = error$iv$iv2;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var18_31 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var18_31;
                throw new GL3Exception(string);
            }
        }
        Intrinsics.checkNotNull($source, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)$source).rewind();
        $source.order(ByteOrder.nativeOrder());
        int[] $i$f$debugGLErrors22 = new int[]{0};
        int[] currentPack = $i$f$debugGLErrors22;
        int pname$iv = 3317;
        boolean $i$f$glGetIntegerv = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glGetIntegerv(pname$iv, currentPack);
                break;
            }
            case 2: {
                GLES32.glGetIntegerv(pname$iv, currentPack);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GLGLESKt.glPixelStorei(3317, 1);
        if ($sourceType.getCompressed()) {
            GLGLESKt.glCompressedTexSubImage2D(CubemapGL3Kt.getGlTextureTarget($side), $level, 0, 0, $this$bound.getWidth() / $div, $this$bound.getWidth() / $div, ColorBufferGL3Kt.compressedType($sourceFormat, $sourceType), $source);
            boolean $i$f$debugGLErrors3 = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                $i$f$checkGLErrors2 = false;
                error$iv$iv2 = GLGLESKt.glGetError();
                if (error$iv$iv2 != 0) {
                    Object message$iv$iv = switch (error$iv$iv2) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv2 + ">";
                    };
                    int it = error$iv$iv2;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    String string = it == 1281 ? "data size mismatch? " + $source.remaining() : null;
                    String string2 = "[context=" + l + "] GL ERROR: " + (String)object + " " + string;
                    throw new GL3Exception(string2);
                }
            }
        } else {
            GLGLESKt.glTexSubImage2D(CubemapGL3Kt.getGlTextureTarget($side), $level, 0, 0, $this$bound.getWidth() / $div, $this$bound.getWidth() / $div, ColorBufferGL3Kt.glFormat($sourceFormat), ColorBufferGL3Kt.glType($sourceType), $source);
            $i$f$debugGLErrors = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                $i$f$checkGLErrors = false;
                error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int bl = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl2 = false;
                    int it = bl;
                    Object var18_33 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var18_33;
                    throw new GL3Exception(string);
                }
            }
        }
        GLGLESKt.glPixelStorei(3317, currentPack[0]);
        $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            $i$f$checkGLErrors = false;
            error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int it = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                Object var18_34 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var18_34;
                throw new GL3Exception(string);
            }
        }
        ((Buffer)$source).rewind();
        ((Buffer)$source).rewind();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/internal/gl3/CubemapGL3$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/CubemapGL3;", "width", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "levels", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nCubemapGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubemapGL3.kt\norg/openrndr/internal/gl3/CubemapGL3$Companion\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,347:1\n1154#2,3:348\n18#2,3:351\n50#3,14:354\n65#3:369\n51#3,15:370\n50#4:368\n*S KotlinDebug\n*F\n+ 1 CubemapGL3.kt\norg/openrndr/internal/gl3/CubemapGL3$Companion\n*L\n60#1:348,3\n64#1:351,3\n75#1:354,14\n75#1:369\n92#1:370,15\n75#1:368\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CubemapGL3 create(int width, @NotNull ColorFormat format, @NotNull ColorType type, int levels, @Nullable Session session) {
            boolean useStorage;
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            if (!(levels >= 1)) {
                boolean $i$a$-require-CubemapGL3$Companion$create$22 = false;
                String $i$a$-require-CubemapGL3$Companion$create$22 = "should have at least 1 level (has " + levels + ")";
                throw new IllegalArgumentException($i$a$-require-CubemapGL3$Companion$create$22.toString());
            }
            int texture = GLGLESKt.glGenTextures();
            int texture$iv = 33984;
            boolean $i$f$glActiveTexture = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glActiveTexture(texture$iv);
                    break;
                }
                case 2: {
                    GLES32.glActiveTexture(texture$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GLGLESKt.glBindTexture(34067, texture);
            if (DriverGL3Kt.getGlType(Driver.Companion) == DriverTypeGL.GL) {
                int target$iv = 34895;
                boolean $i$f$glEnable = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glEnable(target$iv);
                        break;
                    }
                    case 2: {
                        GLES32.glEnable(target$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            int internalFormat = ((Number)ColorBufferGL3Kt.internalFormat(format, type).component1()).intValue();
            boolean bl = useStorage = DriverGL3Kt.getGlType(Driver.Companion) == DriverTypeGL.GLES && DriverGL3Kt.getGlVersion(Driver.Companion).compareTo((Enum)DriverVersionGL.GLES_VERSION_3_1) >= 0 || DriverGL3Kt.getGlType(Driver.Companion) == DriverTypeGL.GL && DriverGL3Kt.getGlVersion(Driver.Companion).compareTo((Enum)DriverVersionGL.GL_VERSION_4_2) >= 0;
            if (useStorage) {
                GLGLESKt.glTexStorage2D(34067, levels, internalFormat, width, width);
                boolean $i$f$checkGLErrors = false;
                int error$iv = GLGLESKt.glGetError();
                if (error$iv != 0) {
                    Object message$iv = switch (error$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv + ">";
                    };
                    int n = error$iv;
                    Object object = message$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl2 = false;
                    int it = n;
                    Object var23_26 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var23_26;
                    throw new GL3Exception(string);
                }
            } else {
                for (CubemapSide side : CubemapSide.getEntries()) {
                    for (int level = 0; level < levels; ++level) {
                        int div = 1 << level;
                        ByteBuffer nullBB = null;
                        GLGLESKt.glTexImage2D(CubemapGL3Kt.getGlTextureTarget(side), level, internalFormat, width / div, width / div, 0, ColorBufferGL3Kt.glFormat(format), ColorBufferGL3Kt.glType(type), nullBB);
                        boolean $i$f$checkGLErrors = false;
                        int error$iv = GLGLESKt.glGetError();
                        if (error$iv == 0) continue;
                        Object message$iv = switch (error$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv + ">";
                        };
                        int n = error$iv;
                        Object object = message$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl3 = false;
                        String string = "width: " + width + ", format: " + format + ", type: " + type + " -> target: " + ErrorGL3Kt.glEnumName(CubemapGL3Kt.getGlTextureTarget(side)) + ", level: " + level + ", internalFormat: " + ErrorGL3Kt.glEnumName(internalFormat) + "format: " + ErrorGL3Kt.glEnumName(ColorBufferGL3Kt.glFormat(format)) + ", type: " + ErrorGL3Kt.glEnumName(ColorBufferGL3Kt.glType(type));
                        String string2 = "[context=" + l + "] GL ERROR: " + (String)object + " " + string;
                        throw new GL3Exception(string2);
                    }
                }
            }
            GLGLESKt.glTexParameteri(34067, 33084, 0);
            GLGLESKt.glTexParameteri(34067, 33085, levels - 1);
            return new CubemapGL3(texture, width, type, format, levels, session);
        }

        public static /* synthetic */ CubemapGL3 create$default(Companion companion, int n, ColorFormat colorFormat, ColorType colorType, int n2, Session session, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.create(n, colorFormat, colorType, n2, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

