/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.LineJoin;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionDrawer;
import org.openrndr.internal.Path;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\r2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/openrndr/internal/QualityPolygonDrawer;", "", "<init>", "()V", "expansionDrawer", "Lorg/openrndr/internal/ExpansionDrawer;", "drawPolygon", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "loops", "", "Lorg/openrndr/math/Vector2;", "corners", "", "fringeWidth", "", "openrndr-draw"})
public final class QualityPolygonDrawer {
    @NotNull
    private final ExpansionDrawer expansionDrawer = new ExpansionDrawer();

    public final void drawPolygon(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<? extends List<Vector2>> loops, @NotNull List<? extends List<Boolean>> corners, double fringeWidth) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(loops, "loops");
        Intrinsics.checkNotNullParameter(corners, "corners");
        if (drawStyle.getFill() != null && !((Collection)loops).isEmpty()) {
            Path path = Path.Companion.fromLineLoops(loops, corners);
            ColorRGBa colorRGBa = drawStyle.getStroke();
            double alpha = colorRGBa != null ? colorRGBa.getAlpha() : 0.0;
            double fw = drawStyle.getSmooth() ? fringeWidth * (1.0 - alpha) : 0.0;
            List<Expansion> fillExpansions = path.expandFill(fw, fw, LineJoin.BEVEL, 2.4);
            this.expansionDrawer.renderFill(drawContext, drawStyle, fillExpansions, path.getConvex(), fw);
        }
    }
}

