/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.CubemapSide;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00060\u0001j\u0002`\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/openrndr/internal/CubemapImageData;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "width", "", "height", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "mipmaps", "sides", "", "Lorg/openrndr/utils/buffer/MPPBuffer;", "mipmapSides", "<init>", "(IILorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;ILjava/util/List;Ljava/util/List;)V", "getWidth", "()I", "getHeight", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getType", "()Lorg/openrndr/draw/ColorType;", "getMipmaps", "getSides", "()Ljava/util/List;", "getMipmapSides", "side", "cubemapSide", "Lorg/openrndr/draw/CubemapSide;", "level", "openrndr-draw"})
public abstract class CubemapImageData
implements AutoCloseable {
    private final int width;
    private final int height;
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    private final int mipmaps;
    @NotNull
    private final List<MPPBuffer> sides;
    @NotNull
    private final List<MPPBuffer> mipmapSides;

    public CubemapImageData(int width, int height, @NotNull ColorFormat format, @NotNull ColorType type, int mipmaps, @NotNull List<MPPBuffer> sides, @NotNull List<MPPBuffer> mipmapSides) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(sides, "sides");
        Intrinsics.checkNotNullParameter(mipmapSides, "mipmapSides");
        this.width = width;
        this.height = height;
        this.format = format;
        this.type = type;
        this.mipmaps = mipmaps;
        this.sides = sides;
        this.mipmapSides = mipmapSides;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final ColorFormat getFormat() {
        return this.format;
    }

    @NotNull
    public final ColorType getType() {
        return this.type;
    }

    public final int getMipmaps() {
        return this.mipmaps;
    }

    @NotNull
    public final List<MPPBuffer> getSides() {
        return this.sides;
    }

    @NotNull
    public final List<MPPBuffer> getMipmapSides() {
        return this.mipmapSides;
    }

    @NotNull
    public final MPPBuffer side(@NotNull CubemapSide cubemapSide, int level) {
        Intrinsics.checkNotNullParameter((Object)cubemapSide, "cubemapSide");
        return switch (WhenMappings.$EnumSwitchMapping$0[cubemapSide.ordinal()]) {
            case 1 -> {
                if (level == 0) {
                    yield this.sides.get(0);
                }
                yield this.mipmapSides.get(level - 1 + 0 * (this.mipmaps - 1));
            }
            case 2 -> {
                if (level == 0) {
                    yield this.sides.get(2);
                }
                yield this.mipmapSides.get(level - 1 + 2 * (this.mipmaps - 1));
            }
            case 3 -> {
                if (level == 0) {
                    yield this.sides.get(4);
                }
                yield this.mipmapSides.get(level - 1 + 4 * (this.mipmaps - 1));
            }
            case 4 -> {
                if (level == 0) {
                    yield this.sides.get(1);
                }
                yield this.mipmapSides.get(level - 1 + 1 * (this.mipmaps - 1));
            }
            case 5 -> {
                if (level == 0) {
                    yield this.sides.get(3);
                }
                yield this.mipmapSides.get(level - 1 + 3 * (this.mipmaps - 1));
            }
            case 6 -> {
                if (level == 0) {
                    yield this.sides.get(5);
                }
                yield this.mipmapSides.get(level - 1 + 5 * (this.mipmaps - 1));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CubemapSide.values().length];
            try {
                nArray[CubemapSide.POSITIVE_X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.POSITIVE_Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.POSITIVE_Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.NEGATIVE_X.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.NEGATIVE_Y.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CubemapSide.NEGATIVE_Z.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

