/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.UHashKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Triangle;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u0002*\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"uniform", "", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/Triangle;", "count", "", "random", "Lkotlin/random/Random;", "hash", "seed", "x", "orx-noise"})
@SourceDebugExtension(value={"SMAP\nTriangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Triangle.kt\norg/openrndr/extra/noise/shapes/TriangleKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1#2:88\n1557#3:89\n1628#3,3:90\n1557#3:93\n1628#3,3:94\n1053#3:97\n*S KotlinDebug\n*F\n+ 1 Triangle.kt\norg/openrndr/extra/noise/shapes/TriangleKt\n*L\n19#1:89\n19#1:90,3\n47#1:93\n47#1:94,3\n49#1:97\n*E\n"})
public final class TriangleKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Vector2> uniform(@NotNull List<Triangle> $this$uniform, int count2, @NotNull Random random) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$uniform, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        Iterable iterable = $this$uniform;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Triangle triangle = (Triangle)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getArea();
            d = d2 + d3;
        }
        double totalArea = d;
        Iterable $this$map$iv = RangesKt.until(0, count2);
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator bl = $this$mapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)bl).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(UniformRandomKt.uniform(DoubleCompanionObject.INSTANCE, 0.0, totalArea, random));
        }
        List randoms = CollectionsKt.sorted((List)destination$iv$iv);
        List result = new ArrayList();
        int idx = 0;
        double sum = 0.0;
        for (Triangle t : $this$uniform) {
            sum += t.getArea();
            while (idx <= CollectionsKt.getLastIndex(randoms) && sum > ((Number)randoms.get(idx)).doubleValue()) {
                result.add(TriangleKt.uniform(t, random));
                ++idx;
            }
        }
        return result;
    }

    public static /* synthetic */ List uniform$default(List list, int n, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            random = Random.Default;
        }
        return TriangleKt.uniform(list, n, random);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Vector2> hash(@NotNull List<Triangle> $this$hash, int count2, int seed, int x) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$hash, "<this>");
        Iterable iterable = $this$hash;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Triangle triangle = (Triangle)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getArea();
            d = d2 + d3;
        }
        double totalArea = d;
        Iterable $this$map$iv = RangesKt.until(0, count2);
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator bl = $this$mapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)bl).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new Pair<Integer, Double>(x + it, UHashKt.fhash1D(seed, x + it) * totalArea));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List randoms = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getSecond()));
            }
        });
        List result = new ArrayList();
        int idx = 0;
        double sum = 0.0;
        for (Triangle t : $this$hash) {
            sum += t.getArea();
            while (idx <= CollectionsKt.getLastIndex(randoms) && sum > ((Number)((Pair)randoms.get(idx)).getSecond()).doubleValue()) {
                result.add(TriangleKt.hash(t, seed, ((Number)((Pair)randoms.get(idx)).getFirst()).intValue()));
                ++idx;
            }
        }
        return result;
    }

    public static /* synthetic */ List hash$default(List list, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return TriangleKt.hash(list, n, n2, n3);
    }

    @NotNull
    public static final Vector2 uniform(@NotNull Triangle $this$uniform, @NotNull Random random) {
        Intrinsics.checkNotNullParameter($this$uniform, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        return $this$uniform.position(random.nextDouble(), random.nextDouble());
    }

    public static /* synthetic */ Vector2 uniform$default(Triangle triangle, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return TriangleKt.uniform(triangle, random);
    }

    @NotNull
    public static final Vector2 hash(@NotNull Triangle $this$hash, int seed, int x) {
        Intrinsics.checkNotNullParameter($this$hash, "<this>");
        double u = UHashKt.fhash1D(seed, x);
        double v = UHashKt.fhash1D(seed, (int)Double.doubleToRawLongBits(u) + x);
        return $this$hash.position(u, v);
    }
}

