/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.meshgenerators;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.meshgenerators.MeshGeneratorsKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a@\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t\u001a\u008b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2O\u0010\r\u001aK\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u0016\u001a\u0093\u0001\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2O\u0010\r\u001aK\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u0016\u00a8\u0006\u001a"}, d2={"cylinderMesh", "Lorg/openrndr/draw/VertexBuffer;", "sides", "", "segments", "radius", "", "length", "flipNormals", "", "center", "generateCylinder", "", "writer", "Lkotlin/Function3;", "Lorg/openrndr/math/Vector3;", "Lkotlin/ParameterName;", "name", "position", "normal", "Lorg/openrndr/math/Vector2;", "texCoord", "Lorg/openrndr/extra/meshgenerators/VertexWriter;", "generateTaperedCylinder", "radiusStart", "radiusEnd", "orx-mesh-generators"})
@SourceDebugExtension(value={"SMAP\nCylinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cylinder.kt\norg/openrndr/extra/meshgenerators/CylinderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class CylinderKt {
    @NotNull
    public static final VertexBuffer cylinderMesh(int sides, int segments, double radius, double length, boolean flipNormals, boolean center) {
        int vertexCount = 6 * sides * segments;
        VertexBuffer vb = MeshGeneratorsKt.meshVertexBuffer(vertexCount);
        VertexBuffer.put$default(vb, 0, arg_0 -> CylinderKt.cylinderMesh$lambda$0(sides, segments, radius, length, flipNormals, center, arg_0), 1, null);
        return vb;
    }

    public static /* synthetic */ VertexBuffer cylinderMesh$default(int n, int n2, double d, double d2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 16;
        }
        if ((n3 & 2) != 0) {
            n2 = 16;
        }
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            bl2 = false;
        }
        return CylinderKt.cylinderMesh(n, n2, d, d2, bl, bl2);
    }

    public static final void generateCylinder(int sides, int segments, double radius, double length, boolean flipNormals, boolean center, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        CylinderKt.generateTaperedCylinder(sides, segments, radius, radius, length, flipNormals, center, writer);
    }

    public static /* synthetic */ void generateCylinder$default(int n, int n2, double d, double d2, boolean bl, boolean bl2, Function3 function3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            bl2 = false;
        }
        CylinderKt.generateCylinder(n, n2, d, d2, bl, bl2, function3);
    }

    public static final void generateTaperedCylinder(int sides, int segments, double radiusStart, double radiusEnd, double length, boolean flipNormals, boolean center, @NotNull Function3<? super Vector3, ? super Vector3, ? super Vector2, Unit> writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        double dphi = Math.PI * 2 / (double)sides;
        double ddeg = 360.0 / (double)sides;
        double invertFactor = flipNormals ? 1.0 : -1.0;
        double dr = radiusEnd - radiusStart;
        Vector2 it = Vector2.perpendicular$default((Vector2)new Vector2(length, dr).getNormalized(), null, 1, null);
        boolean bl = false;
        Vector3 baseNormal = new Vector3(it.y(), 0.0, it.x());
        double zOffset = center ? -length / 2.0 : 0.0;
        for (int segment = 0; segment < segments; ++segment) {
            double radius0 = MappingKt.mix(radiusStart, radiusEnd, (double)segment * 1.0 / (double)segments);
            double radius1 = MappingKt.mix(radiusStart, radiusEnd, (double)(segment + 1) * 1.0 / (double)segments);
            double z0 = length / (double)segments * (double)segment + zOffset;
            double z1 = length / (double)segments * (double)(segment + 1) + zOffset;
            for (int side = 0; side < sides; ++side) {
                double x00 = Math.cos((double)side * dphi) * radius0;
                double x10 = Math.cos((double)side * dphi + dphi) * radius0;
                double y00 = Math.sin((double)side * dphi) * radius0;
                double y10 = Math.sin((double)side * dphi + dphi) * radius0;
                double x01 = Math.cos((double)side * dphi) * radius1;
                double x11 = Math.cos((double)side * dphi + dphi) * radius1;
                double y01 = Math.sin((double)side * dphi) * radius1;
                double y11 = Math.sin((double)side * dphi + dphi) * radius1;
                double u0 = ((double)segment + 0.0) / (double)segments;
                double u1 = ((double)segment + 1.0) / (double)segments;
                double v0 = ((double)side + 0.0) / (double)sides;
                double v1 = ((double)side + 1.0) / (double)sides;
                Vector3 n0 = ((Vector3)TransformsKt.rotateZ(Matrix44.Companion, (double)side * ddeg).times(baseNormal.xyz0()).xyz().getNormalized()).times(invertFactor);
                Vector3 n1 = ((Vector3)TransformsKt.rotateZ(Matrix44.Companion, (double)(side + 1) * ddeg).times(baseNormal.xyz0()).xyz().getNormalized()).times(invertFactor);
                if (flipNormals) {
                    writer.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
                    writer.invoke(new Vector3(x10, y10, z0), n1, new Vector2(u0, v1));
                    writer.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                    writer.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                    writer.invoke(new Vector3(x01, y01, z1), n0, new Vector2(u1, v0));
                    writer.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
                    continue;
                }
                writer.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
                writer.invoke(new Vector3(x01, y01, z1), n0, new Vector2(u1, v0));
                writer.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                writer.invoke(new Vector3(x11, y11, z1), n1, new Vector2(u1, v1));
                writer.invoke(new Vector3(x10, y10, z0), n1, new Vector2(u0, v1));
                writer.invoke(new Vector3(x00, y00, z0), n0, new Vector2(u0, v0));
            }
        }
    }

    public static /* synthetic */ void generateTaperedCylinder$default(int n, int n2, double d, double d2, double d3, boolean bl, boolean bl2, Function3 function3, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            bl2 = false;
        }
        CylinderKt.generateTaperedCylinder(n, n2, d, d2, d3, bl, bl2, function3);
    }

    private static final Unit cylinderMesh$lambda$0(int $sides, int $segments, double $radius, double $length, boolean $flipNormals, boolean $center, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        CylinderKt.generateCylinder($sides, $segments, $radius, $length, $flipNormals, $center, MeshGeneratorsKt.bufferWriter($this$put));
        return Unit.INSTANCE;
    }
}

