/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JO\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/openrndr/extra/mesh/Point;", "", "position", "Lorg/openrndr/math/Vector3;", "textureCoord", "Lorg/openrndr/math/Vector2;", "color", "Lorg/openrndr/color/ColorRGBa;", "normal", "tangent", "bitangent", "<init>", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector2;Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "getPosition", "()Lorg/openrndr/math/Vector3;", "getTextureCoord", "()Lorg/openrndr/math/Vector2;", "getColor", "()Lorg/openrndr/color/ColorRGBa;", "getNormal", "getTangent", "getBitangent", "pose", "Lorg/openrndr/math/Matrix44;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "orx-mesh"})
public final class Point {
    @NotNull
    private final Vector3 position;
    @Nullable
    private final Vector2 textureCoord;
    @Nullable
    private final ColorRGBa color;
    @Nullable
    private final Vector3 normal;
    @Nullable
    private final Vector3 tangent;
    @Nullable
    private final Vector3 bitangent;

    public Point(@NotNull Vector3 position, @Nullable Vector2 textureCoord, @Nullable ColorRGBa color, @Nullable Vector3 normal, @Nullable Vector3 tangent, @Nullable Vector3 bitangent) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.position = position;
        this.textureCoord = textureCoord;
        this.color = color;
        this.normal = normal;
        this.tangent = tangent;
        this.bitangent = bitangent;
    }

    public /* synthetic */ Point(Vector3 vector3, Vector2 vector2, ColorRGBa colorRGBa, Vector3 vector32, Vector3 vector33, Vector3 vector34, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vector2 = null;
        }
        if ((n & 4) != 0) {
            colorRGBa = null;
        }
        if ((n & 8) != 0) {
            vector32 = null;
        }
        if ((n & 0x10) != 0) {
            vector33 = null;
        }
        if ((n & 0x20) != 0) {
            vector34 = null;
        }
        this(vector3, vector2, colorRGBa, vector32, vector33, vector34);
    }

    @NotNull
    public final Vector3 getPosition() {
        return this.position;
    }

    @Nullable
    public final Vector2 getTextureCoord() {
        return this.textureCoord;
    }

    @Nullable
    public final ColorRGBa getColor() {
        return this.color;
    }

    @Nullable
    public final Vector3 getNormal() {
        return this.normal;
    }

    @Nullable
    public final Vector3 getTangent() {
        return this.tangent;
    }

    @Nullable
    public final Vector3 getBitangent() {
        return this.bitangent;
    }

    @NotNull
    public final Matrix44 pose() {
        if (!(this.normal != null && this.tangent != null && this.bitangent != null)) {
            boolean bl = false;
            String string = "Normal, tangent, and bitangent must be non-null to compute the pose.";
            throw new IllegalArgumentException(string.toString());
        }
        return Matrix44.Companion.fromColumnVectors(((Vector3)this.tangent.getNormalized()).xyz0(), ((Vector3)this.bitangent.getNormalized()).xyz0(), ((Vector3)this.normal.getNormalized()).xyz0(), this.position.xyz1());
    }

    @NotNull
    public final Vector3 component1() {
        return this.position;
    }

    @Nullable
    public final Vector2 component2() {
        return this.textureCoord;
    }

    @Nullable
    public final ColorRGBa component3() {
        return this.color;
    }

    @Nullable
    public final Vector3 component4() {
        return this.normal;
    }

    @Nullable
    public final Vector3 component5() {
        return this.tangent;
    }

    @Nullable
    public final Vector3 component6() {
        return this.bitangent;
    }

    @NotNull
    public final Point copy(@NotNull Vector3 position, @Nullable Vector2 textureCoord, @Nullable ColorRGBa color, @Nullable Vector3 normal, @Nullable Vector3 tangent, @Nullable Vector3 bitangent) {
        Intrinsics.checkNotNullParameter(position, "position");
        return new Point(position, textureCoord, color, normal, tangent, bitangent);
    }

    public static /* synthetic */ Point copy$default(Point point, Vector3 vector3, Vector2 vector2, ColorRGBa colorRGBa, Vector3 vector32, Vector3 vector33, Vector3 vector34, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = point.position;
        }
        if ((n & 2) != 0) {
            vector2 = point.textureCoord;
        }
        if ((n & 4) != 0) {
            colorRGBa = point.color;
        }
        if ((n & 8) != 0) {
            vector32 = point.normal;
        }
        if ((n & 0x10) != 0) {
            vector33 = point.tangent;
        }
        if ((n & 0x20) != 0) {
            vector34 = point.bitangent;
        }
        return point.copy(vector3, vector2, colorRGBa, vector32, vector33, vector34);
    }

    @NotNull
    public String toString() {
        return "Point(position=" + this.position + ", textureCoord=" + this.textureCoord + ", color=" + this.color + ", normal=" + this.normal + ", tangent=" + this.tangent + ", bitangent=" + this.bitangent + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + (this.textureCoord == null ? 0 : this.textureCoord.hashCode());
        result = result * 31 + (this.color == null ? 0 : this.color.hashCode());
        result = result * 31 + (this.normal == null ? 0 : this.normal.hashCode());
        result = result * 31 + (this.tangent == null ? 0 : this.tangent.hashCode());
        result = result * 31 + (this.bitangent == null ? 0 : this.bitangent.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Point)) {
            return false;
        }
        Point point = (Point)other;
        if (!Intrinsics.areEqual(this.position, point.position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textureCoord, point.textureCoord)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.color, point.color)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.normal, point.normal)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tangent, point.tangent)) {
            return false;
        }
        return Intrinsics.areEqual(this.bitangent, point.bitangent);
    }
}

