/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.extra.mesh.IIndexedPolygon;
import org.openrndr.extra.mesh.IVertexData;
import org.openrndr.extra.mesh.Point;
import org.openrndr.math.LinearType;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Box;
import org.openrndr.shape.BoxKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a3\u0010\u0000\u001a\u0002H\u0001\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u001a\u0010\b\u001a\u00020\u0004*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0010"}, d2={"bc", "T", "Lorg/openrndr/math/LinearType;", "barycentric", "Lorg/openrndr/math/Vector3;", "items", "", "(Lorg/openrndr/math/Vector3;Ljava/util/List;)Lorg/openrndr/math/LinearType;", "position", "Lorg/openrndr/extra/mesh/IIndexedPolygon;", "vertexData", "Lorg/openrndr/extra/mesh/IVertexData;", "point", "Lorg/openrndr/extra/mesh/Point;", "bounds", "Lorg/openrndr/shape/Box;", "orx-mesh"})
public final class IndexedPolygonExtensionsKt {
    @NotNull
    public static final <T extends LinearType<T>> T bc(@NotNull Vector3 barycentric, @NotNull List<? extends T> items) {
        Intrinsics.checkNotNullParameter(barycentric, "barycentric");
        Intrinsics.checkNotNullParameter(items, "items");
        return ((LinearType)items.get(0)).times(barycentric.x()).plus(((LinearType)items.get(1)).times(barycentric.y())).plus(((LinearType)items.get(2)).times(barycentric.z()));
    }

    @NotNull
    public static final Vector3 position(@NotNull IIndexedPolygon $this$position, @NotNull IVertexData vertexData, @NotNull Vector3 barycentric) {
        Intrinsics.checkNotNullParameter($this$position, "<this>");
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Intrinsics.checkNotNullParameter(barycentric, "barycentric");
        if (!($this$position.getPositions().size() == 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List<Vector3> positions = CollectionsKt.slice(vertexData.getPositions(), (Iterable<Integer>)$this$position.getPositions());
        if (!(!((Collection)positions).isEmpty())) {
            throw new IllegalStateException("No positions".toString());
        }
        return IndexedPolygonExtensionsKt.bc(barycentric, positions);
    }

    @NotNull
    public static final Point point(@NotNull IIndexedPolygon $this$point, @NotNull IVertexData vertexData, @NotNull Vector3 barycentric) {
        Intrinsics.checkNotNullParameter($this$point, "<this>");
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Intrinsics.checkNotNullParameter(barycentric, "barycentric");
        if (!($this$point.getPositions().size() == 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List<Vector3> positions = CollectionsKt.slice(vertexData.getPositions(), (Iterable<Integer>)$this$point.getPositions());
        List<ColorRGBa> colors = CollectionsKt.slice(vertexData.getColors(), (Iterable<Integer>)$this$point.getColors());
        List<Vector3> normals = CollectionsKt.slice(vertexData.getNormals(), (Iterable<Integer>)$this$point.getNormals());
        List<Vector3> tangents = CollectionsKt.slice(vertexData.getTangents(), (Iterable<Integer>)$this$point.getTangents());
        List<Vector3> bitangents = CollectionsKt.slice(vertexData.getBitangents(), (Iterable<Integer>)$this$point.getBitangents());
        List<Vector2> textureCoords = CollectionsKt.slice(vertexData.getTextureCoords(), (Iterable<Integer>)$this$point.getTextureCoords());
        Vector3 vector3 = !((Collection)positions).isEmpty() ? IndexedPolygonExtensionsKt.bc(barycentric, positions) : null;
        Intrinsics.checkNotNull(vector3);
        return new Point(vector3, !((Collection)textureCoords).isEmpty() ? IndexedPolygonExtensionsKt.bc(barycentric, textureCoords) : null, !((Collection)colors).isEmpty() ? IndexedPolygonExtensionsKt.bc(barycentric, colors) : null, !((Collection)normals).isEmpty() ? IndexedPolygonExtensionsKt.bc(barycentric, normals) : null, !((Collection)tangents).isEmpty() ? IndexedPolygonExtensionsKt.bc(barycentric, tangents) : null, !((Collection)bitangents).isEmpty() ? IndexedPolygonExtensionsKt.bc(barycentric, bitangents) : null);
    }

    @NotNull
    public static final Box bounds(@NotNull List<? extends IIndexedPolygon> $this$bounds, @NotNull IVertexData vertexData) {
        Intrinsics.checkNotNullParameter($this$bounds, "<this>");
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        if ($this$bounds.isEmpty()) {
            return Box.Companion.getEMPTY();
        }
        double px = Double.NEGATIVE_INFINITY;
        double py = Double.NEGATIVE_INFINITY;
        double pz = Double.NEGATIVE_INFINITY;
        double nx = Double.POSITIVE_INFINITY;
        double ny = Double.POSITIVE_INFINITY;
        double nz = Double.POSITIVE_INFINITY;
        for (IIndexedPolygon iIndexedPolygon : $this$bounds) {
            Iterator<Integer> iterator2 = iIndexedPolygon.getPositions().iterator();
            while (iterator2.hasNext()) {
                int i = ((Number)iterator2.next()).intValue();
                Vector3 v = vertexData.getPositions().get(i);
                px = Math.max(px, v.x());
                py = Math.max(py, v.y());
                pz = Math.max(pz, v.z());
                nx = Math.min(nx, v.x());
                ny = Math.min(ny, v.y());
                nz = Math.min(nz, v.z());
            }
        }
        return BoxKt.Box(nx, ny, nz, px - nx, py - ny, pz - nz);
    }
}

