/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.mesh.IIndexedPolygon;
import org.openrndr.extra.mesh.IVertexData;
import org.openrndr.extra.mesh.Polygon;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.shape.TriangulatorKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B[\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JB\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003Ji\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u0004H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006("}, d2={"Lorg/openrndr/extra/mesh/IndexedPolygon;", "Lorg/openrndr/extra/mesh/IIndexedPolygon;", "positions", "", "", "textureCoords", "colors", "normals", "tangents", "bitangents", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getPositions", "()Ljava/util/List;", "getTextureCoords", "getColors", "getNormals", "getTangents", "getBitangents", "tessellate", "vertexData", "Lorg/openrndr/extra/mesh/IVertexData;", "triangulate", "toPolygon", "Lorg/openrndr/extra/mesh/Polygon;", "shiftIndices", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "", "orx-mesh"})
@SourceDebugExtension(value={"SMAP\nIndexedPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedPolygon.kt\norg/openrndr/extra/mesh/IndexedPolygon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1557#2:334\n1628#2,3:335\n1557#2:338\n1628#2,3:339\n1557#2:342\n1628#2,3:343\n1557#2:346\n1628#2,3:347\n1557#2:350\n1628#2,3:351\n1557#2:354\n1628#2,3:355\n1557#2:358\n1628#2,3:359\n1557#2:362\n1628#2,3:363\n*S KotlinDebug\n*F\n+ 1 IndexedPolygon.kt\norg/openrndr/extra/mesh/IndexedPolygon\n*L\n195#1:334\n195#1:335,3\n221#1:338\n221#1:339,3\n290#1:342\n290#1:343,3\n291#1:346\n291#1:347,3\n292#1:350\n292#1:351,3\n293#1:354\n293#1:355,3\n294#1:358\n294#1:359,3\n295#1:362\n295#1:363,3\n*E\n"})
public final class IndexedPolygon
implements IIndexedPolygon {
    @NotNull
    private final List<Integer> positions;
    @NotNull
    private final List<Integer> textureCoords;
    @NotNull
    private final List<Integer> colors;
    @NotNull
    private final List<Integer> normals;
    @NotNull
    private final List<Integer> tangents;
    @NotNull
    private final List<Integer> bitangents;

    public IndexedPolygon(@NotNull List<Integer> positions, @NotNull List<Integer> textureCoords, @NotNull List<Integer> colors, @NotNull List<Integer> normals, @NotNull List<Integer> tangents, @NotNull List<Integer> bitangents) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(textureCoords, "textureCoords");
        Intrinsics.checkNotNullParameter(colors, "colors");
        Intrinsics.checkNotNullParameter(normals, "normals");
        Intrinsics.checkNotNullParameter(tangents, "tangents");
        Intrinsics.checkNotNullParameter(bitangents, "bitangents");
        this.positions = positions;
        this.textureCoords = textureCoords;
        this.colors = colors;
        this.normals = normals;
        this.tangents = tangents;
        this.bitangents = bitangents;
    }

    @Override
    @NotNull
    public List<Integer> getPositions() {
        return this.positions;
    }

    @Override
    @NotNull
    public List<Integer> getTextureCoords() {
        return this.textureCoords;
    }

    @Override
    @NotNull
    public List<Integer> getColors() {
        return this.colors;
    }

    @Override
    @NotNull
    public List<Integer> getNormals() {
        return this.normals;
    }

    @Override
    @NotNull
    public List<Integer> getTangents() {
        return this.tangents;
    }

    @Override
    @NotNull
    public List<Integer> getBitangents() {
        return this.bitangents;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexedPolygon> tessellate(IVertexData vertexData) {
        void $this$mapTo$iv$iv;
        List<Vector3> points2 = CollectionsKt.slice(vertexData.getPositions(), CollectionsKt.toList((Iterable)this.getPositions()));
        List triangles = TriangulatorKt.triangulateV3$default(CollectionsKt.listOf(points2), null, 2, null);
        Iterable $this$map$iv = CollectionsKt.windowed$default(triangles, 3, 3, false, 4, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IndexedPolygon(CollectionsKt.slice(this.getPositions(), (Iterable)it), !((Collection)this.getTextureCoords()).isEmpty() ? CollectionsKt.slice(this.getTextureCoords(), (Iterable)it) : CollectionsKt.emptyList(), !((Collection)this.getColors()).isEmpty() ? CollectionsKt.slice(this.getColors(), (Iterable)it) : CollectionsKt.emptyList(), !((Collection)this.getNormals()).isEmpty() ? CollectionsKt.slice(this.getNormals(), (Iterable)it) : CollectionsKt.emptyList(), !((Collection)this.getTangents()).isEmpty() ? CollectionsKt.slice(this.getTangents(), (Iterable)it) : CollectionsKt.emptyList(), !((Collection)this.getBitangents()).isEmpty() ? CollectionsKt.slice(this.getBitangents(), (Iterable)it) : CollectionsKt.emptyList()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexedPolygon> triangulate(@NotNull IVertexData vertexData) {
        List list;
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        if (this.getPositions().size() == 3) {
            list = CollectionsKt.listOf(this);
        } else if (IIndexedPolygon.DefaultImpls.isPlanar$default(this, vertexData, 0.0, 2, null) && this.isConvex(vertexData)) {
            void $this$mapTo$iv$iv;
            int triangleCount = this.getPositions().size() - 2;
            Iterable $this$map$iv = RangesKt.until(0, triangleCount);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer[] integerArray = new Integer[]{this.getPositions().get(0), this.getPositions().get((int)(it + true)), this.getPositions().get((int)(it + 2))};
                List<Integer> list2 = CollectionsKt.listOf(integerArray);
                integerArray = new Integer[]{CollectionsKt.getOrNull(this.getTextureCoords(), 0), CollectionsKt.getOrNull(this.getTextureCoords(), (int)it), CollectionsKt.getOrNull(this.getTextureCoords(), (int)(it + true))};
                List<Integer> list3 = CollectionsKt.listOfNotNull(integerArray);
                integerArray = new Integer[]{CollectionsKt.getOrNull(this.getColors(), 0), CollectionsKt.getOrNull(this.getColors(), (int)(it + true)), CollectionsKt.getOrNull(this.getColors(), (int)(it + 2))};
                List<Integer> list4 = CollectionsKt.listOfNotNull(integerArray);
                integerArray = new Integer[]{CollectionsKt.getOrNull(this.getNormals(), 0), CollectionsKt.getOrNull(this.getNormals(), (int)it), CollectionsKt.getOrNull(this.getNormals(), (int)(it + true))};
                List<Integer> list5 = CollectionsKt.listOfNotNull(integerArray);
                integerArray = new Integer[]{CollectionsKt.getOrNull(this.getTangents(), 0), CollectionsKt.getOrNull(this.getTangents(), (int)(it + true)), CollectionsKt.getOrNull(this.getTangents(), (int)(it + 2))};
                List<Integer> list6 = CollectionsKt.listOfNotNull(integerArray);
                integerArray = new Integer[]{CollectionsKt.getOrNull(this.getBitangents(), 0), CollectionsKt.getOrNull(this.getBitangents(), (int)(it + true)), CollectionsKt.getOrNull(this.getBitangents(), (int)(it + 2))};
                collection.add(new IndexedPolygon(list2, list3, list4, list5, list6, CollectionsKt.listOfNotNull(integerArray)));
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.tessellate(vertexData);
        }
        return list;
    }

    @Override
    @NotNull
    public Polygon toPolygon(@NotNull IVertexData vertexData) {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        return new Polygon(CollectionsKt.slice(vertexData.getPositions(), (Iterable<Integer>)this.getPositions()), CollectionsKt.slice(vertexData.getTextureCoords(), (Iterable<Integer>)this.getTextureCoords()), CollectionsKt.slice(vertexData.getColors(), (Iterable<Integer>)this.getColors()), CollectionsKt.slice(vertexData.getNormals(), (Iterable<Integer>)this.getNormals()), CollectionsKt.slice(vertexData.getTangents(), (Iterable<Integer>)this.getTangents()), CollectionsKt.slice(vertexData.getBitangents(), (Iterable<Integer>)this.getBitangents()));
    }

    @NotNull
    public final IndexedPolygon shiftIndices(int positions, int textureCoords, int colors, int normals, int tangents, int bitangents) {
        Collection<Integer> collection;
        Collection<Integer> collection2;
        Collection<Integer> collection3;
        Collection<Integer> collection4;
        Collection collection5;
        int it;
        Collection<Integer> collection6;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getPositions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            collection6 = destination$iv$iv;
            boolean bl = false;
            collection6.add((int)(it + positions));
        }
        $this$map$iv = this.getTextureCoords();
        collection6 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection5 = destination$iv$iv;
            boolean bl = false;
            collection5.add(it + textureCoords);
        }
        $this$map$iv = this.getColors();
        collection5 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(it + colors);
        }
        collection4 = (List)destination$iv$iv;
        $this$map$iv = this.getNormals();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(it + normals);
        }
        collection3 = (List)destination$iv$iv;
        $this$map$iv = this.getTangents();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it + tangents);
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = this.getBitangents();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + bitangents);
        }
        Collection<Integer> collection7 = collection = (List)destination$iv$iv;
        Collection<Integer> collection8 = collection2;
        Collection<Integer> collection9 = collection3;
        Collection<Integer> collection10 = collection4;
        Collection collection11 = collection5;
        Collection<Integer> collection12 = collection6;
        return new IndexedPolygon((List<Integer>)collection12, (List<Integer>)collection11, (List<Integer>)collection10, (List<Integer>)collection9, (List<Integer>)collection8, (List<Integer>)collection7);
    }

    public static /* synthetic */ IndexedPolygon shiftIndices$default(IndexedPolygon indexedPolygon, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = 0;
        }
        if ((n7 & 2) != 0) {
            n2 = 0;
        }
        if ((n7 & 4) != 0) {
            n3 = 0;
        }
        if ((n7 & 8) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x20) != 0) {
            n6 = 0;
        }
        return indexedPolygon.shiftIndices(n, n2, n3, n4, n5, n6);
    }

    @NotNull
    public final List<Integer> component1() {
        return this.positions;
    }

    @NotNull
    public final List<Integer> component2() {
        return this.textureCoords;
    }

    @NotNull
    public final List<Integer> component3() {
        return this.colors;
    }

    @NotNull
    public final List<Integer> component4() {
        return this.normals;
    }

    @NotNull
    public final List<Integer> component5() {
        return this.tangents;
    }

    @NotNull
    public final List<Integer> component6() {
        return this.bitangents;
    }

    @NotNull
    public final IndexedPolygon copy(@NotNull List<Integer> positions, @NotNull List<Integer> textureCoords, @NotNull List<Integer> colors, @NotNull List<Integer> normals, @NotNull List<Integer> tangents, @NotNull List<Integer> bitangents) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(textureCoords, "textureCoords");
        Intrinsics.checkNotNullParameter(colors, "colors");
        Intrinsics.checkNotNullParameter(normals, "normals");
        Intrinsics.checkNotNullParameter(tangents, "tangents");
        Intrinsics.checkNotNullParameter(bitangents, "bitangents");
        return new IndexedPolygon(positions, textureCoords, colors, normals, tangents, bitangents);
    }

    public static /* synthetic */ IndexedPolygon copy$default(IndexedPolygon indexedPolygon, List list, List list2, List list3, List list4, List list5, List list6, int n, Object object) {
        if ((n & 1) != 0) {
            list = indexedPolygon.positions;
        }
        if ((n & 2) != 0) {
            list2 = indexedPolygon.textureCoords;
        }
        if ((n & 4) != 0) {
            list3 = indexedPolygon.colors;
        }
        if ((n & 8) != 0) {
            list4 = indexedPolygon.normals;
        }
        if ((n & 0x10) != 0) {
            list5 = indexedPolygon.tangents;
        }
        if ((n & 0x20) != 0) {
            list6 = indexedPolygon.bitangents;
        }
        return indexedPolygon.copy(list, list2, list3, list4, list5, list6);
    }

    @NotNull
    public String toString() {
        return "IndexedPolygon(positions=" + this.positions + ", textureCoords=" + this.textureCoords + ", colors=" + this.colors + ", normals=" + this.normals + ", tangents=" + this.tangents + ", bitangents=" + this.bitangents + ")";
    }

    public int hashCode() {
        int result = ((Object)this.positions).hashCode();
        result = result * 31 + ((Object)this.textureCoords).hashCode();
        result = result * 31 + ((Object)this.colors).hashCode();
        result = result * 31 + ((Object)this.normals).hashCode();
        result = result * 31 + ((Object)this.tangents).hashCode();
        result = result * 31 + ((Object)this.bitangents).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexedPolygon)) {
            return false;
        }
        IndexedPolygon indexedPolygon = (IndexedPolygon)other;
        if (!Intrinsics.areEqual(this.positions, indexedPolygon.positions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textureCoords, indexedPolygon.textureCoords)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.colors, indexedPolygon.colors)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.normals, indexedPolygon.normals)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tangents, indexedPolygon.tangents)) {
            return false;
        }
        return Intrinsics.areEqual(this.bitangents, indexedPolygon.bitangents);
    }

    @Override
    @NotNull
    public Matrix44 base(@NotNull IVertexData vertexData) {
        return IIndexedPolygon.DefaultImpls.base(this, vertexData);
    }

    @Override
    public boolean isPlanar(@NotNull IVertexData vertexData, double eps) {
        return IIndexedPolygon.DefaultImpls.isPlanar(this, vertexData, eps);
    }

    @Override
    public boolean isConvex(@NotNull IVertexData vertexData) {
        return IIndexedPolygon.DefaultImpls.isConvex(this, vertexData);
    }

    @Override
    @NotNull
    public Vector3 normal(@NotNull IVertexData vertexData) {
        return IIndexedPolygon.DefaultImpls.normal(this, vertexData);
    }
}

