/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.edges;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Filter1to1;
import org.openrndr.draw.FilterKt;
import org.openrndr.extra.parameters.ColorParameter;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;

@Description(title="Canny Edge Detector")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R1\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\f\u0010\r\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR1\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0012\u0010\r\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR1\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0017\u0010\r\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u000bR1\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00188F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001f\u0010\r\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR1\u0010 \u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b$\u0010\r\u0012\u0004\b!\u0010\u0003\u001a\u0004\b\"\u0010\t\"\u0004\b#\u0010\u000bR1\u0010%\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00188F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b)\u0010\r\u0012\u0004\b&\u0010\u0003\u001a\u0004\b'\u0010\u001c\"\u0004\b(\u0010\u001eR1\u0010*\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b.\u0010\r\u0012\u0004\b+\u0010\u0003\u001a\u0004\b,\u0010\t\"\u0004\b-\u0010\u000bR1\u0010/\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b3\u0010\r\u0012\u0004\b0\u0010\u0003\u001a\u0004\b1\u0010\t\"\u0004\b2\u0010\u000b\u00a8\u00064"}, d2={"Lorg/openrndr/extra/fx/edges/CannyEdgeDetector;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "threshold0", "getThreshold0$annotations", "getThreshold0", "()D", "setThreshold0", "(D)V", "threshold0$delegate", "Ljava/util/Map;", "threshold1", "getThreshold1$annotations", "getThreshold1", "setThreshold1", "threshold1$delegate", "thickness", "getThickness$annotations", "getThickness", "setThickness", "thickness$delegate", "Lorg/openrndr/color/ColorRGBa;", "foregroundColor", "getForegroundColor$annotations", "getForegroundColor", "()Lorg/openrndr/color/ColorRGBa;", "setForegroundColor", "(Lorg/openrndr/color/ColorRGBa;)V", "foregroundColor$delegate", "foregroundOpacity", "getForegroundOpacity$annotations", "getForegroundOpacity", "setForegroundOpacity", "foregroundOpacity$delegate", "backgroundColor", "getBackgroundColor$annotations", "getBackgroundColor", "setBackgroundColor", "backgroundColor$delegate", "backgroundOpacity", "getBackgroundOpacity$annotations", "getBackgroundOpacity", "setBackgroundOpacity", "backgroundOpacity$delegate", "fade", "getFade$annotations", "getFade", "setFade", "fade$delegate", "orx-fx"})
public final class CannyEdgeDetector
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map threshold0$delegate = this.getParameters();
    @NotNull
    private final Map threshold1$delegate = this.getParameters();
    @NotNull
    private final Map thickness$delegate = this.getParameters();
    @NotNull
    private final Map foregroundColor$delegate = this.getParameters();
    @NotNull
    private final Map foregroundOpacity$delegate = this.getParameters();
    @NotNull
    private final Map backgroundColor$delegate = this.getParameters();
    @NotNull
    private final Map backgroundOpacity$delegate = this.getParameters();
    @NotNull
    private final Map fade$delegate = this.getParameters();

    public CannyEdgeDetector() {
        super(FilterKt.filterShaderFromCode$default("// https://www.shadertoy.com/view/sdcSz2\n// ref: (in japanese)\n// https://imagingsolution.net/imaging/canny-edge-detector/\nuniform float thickness;\nuniform sampler2D tex0;\n\nin vec2 v_texCoord0;\nout vec4 o_output;\n\nuniform float threshold0;\nuniform float threshold1;\n\nuniform vec4 backgroundColor;\nuniform vec4 foregroundColor;\nuniform float backgroundOpacity;\nuniform float foregroundOpacity;\n\nuniform float fade;\n\nvec2 iResolution;\n\nfloat getAve(vec2 uv) {\n    vec3 rgb = texture(tex0, uv).rgb;\n    vec3 lum = vec3(0.299, 0.587, 0.114);\n    return dot(lum, rgb);\n}\n\n// Detect edge.\nvec4 sobel(vec2 fragCoord, vec2 dir) {\n    vec2 uv = fragCoord / iResolution.xy;\n    vec2 texel = 1. / iResolution.xy;\n    float np = getAve(uv + (vec2(-1, + 1) + dir) * texel * thickness);\n    float zp = getAve(uv + (vec2(0, + 1) + dir) * texel * thickness);\n    float pp = getAve(uv + (vec2(+ 1, + 1) + dir) * texel * thickness);\n\n    float nz = getAve(uv + (vec2(-1, 0) + dir) * texel * thickness);\n    // zz = 0\n    float pz = getAve(uv + (vec2(+ 1, 0) + dir) * texel * thickness);\n\n    float nn = getAve(uv + (vec2(-1, -1) + dir) * texel * thickness);\n    float zn = getAve(uv + (vec2(0, -1) + dir) * texel * thickness);\n    float pn = getAve(uv + (vec2(+ 1, -1) + dir) * texel * thickness);\n\n    // np zp pp\n    // nz zz pz\n    // nn zn pn\n\n    #if 0\n    float gx = (np * -1. + nz * -2. + nn * -1. + pp * 1. + pz * 2. + pn * 1.);\n    float gy = (np * -1. + zp * -2. + pp * -1. + nn * 1. + zn * 2. + pn * 1.);\n    #else\n    // https://www.shadertoy.com/view/Wds3Rl\n    float gx = (np * -3. + nz * -10. + nn * -3. + pp * 3. + pz * 10. + pn * 3.);\n    float gy = (np * -3. + zp * -10. + pp * -3. + nn * 3. + zn * 10. + pn * 3.);\n    #endif\n\n    vec2 G = vec2(gx, gy);\n\n    float grad = length(G);\n\n    float angle = atan(G.y, G.x);\n\n    return vec4(G, grad, angle);\n}\n\n// Make edge thinner.\nvec2 hysteresisThr(vec2 fragCoord, float mn, float mx) {\n\n    vec4 edge = sobel(fragCoord, vec2(0));\n\n    vec2 dir = vec2(cos(edge.w), sin(edge.w));\n    dir *= vec2(-1, 1); // rotate 90 degrees.\n\n    vec4 edgep = sobel(fragCoord, dir);\n    vec4 edgen = sobel(fragCoord, -dir);\n\n    if (edge.z < edgep.z || edge.z < edgen.z) edge.z = 0.;\n\n    return vec2(\n        (edge.z > mn) ? edge.z : 0.,\n        (edge.z > mx) ? edge.z : 0.\n    );\n}\n\nfloat cannyEdge(vec2 fragCoord, float mn, float mx) {\n\n    vec2 np = hysteresisThr(fragCoord + vec2(-1, + 1), mn, mx);\n    vec2 zp = hysteresisThr(fragCoord + vec2(0, + 1), mn, mx);\n    vec2 pp = hysteresisThr(fragCoord + vec2(+ 1, + 1), mn, mx);\n\n    vec2 nz = hysteresisThr(fragCoord + vec2(-1, 0), mn, mx);\n    vec2 zz = hysteresisThr(fragCoord + vec2(0, 0), mn, mx);\n    vec2 pz = hysteresisThr(fragCoord + vec2(+ 1, 0), mn, mx);\n\n    vec2 nn = hysteresisThr(fragCoord + vec2(-1, -1), mn, mx);\n    vec2 zn = hysteresisThr(fragCoord + vec2(0, -1), mn, mx);\n    vec2 pn = hysteresisThr(fragCoord + vec2(+ 1, -1), mn, mx);\n\n    // np zp pp\n    // nz zz pz\n    // nn zn pn\n    //return min(1., step(1e-3, zz.x) * (zp.y + nz.y + pz.y + zn.y)*8.);\n    //return min(1., step(1e-3, zz.x) * (np.y + pp.y + nn.y + pn.y)*8.);\n    return min(1., step(1e-2, zz.x * 8.) * smoothstep(.0, .3, np.y + zp.y + pp.y + nz.y + pz.y + nn.y + zn.y + pn.y) * 8.);\n}\n\nvoid main() {\n    iResolution = vec2(textureSize(tex0, 0));\n    vec4 original = texture(tex0, v_texCoord0);\n    vec2 fragCoord = v_texCoord0 * iResolution;\n    float edge = cannyEdge(fragCoord, threshold0, threshold1);\n    o_output = mix(original,\n                   mix(foregroundColor * foregroundOpacity,\n                       backgroundColor * backgroundOpacity, 1. - edge),\n                   fade);\n}", "canny-edge-detector", false, 4, null), null, 2, null);
        this.setThreshold0(2.0);
        this.setThreshold1(0.0);
        this.setThickness(1.0);
        this.setForegroundColor(ColorRGBa.Companion.getWHITE());
        this.setBackgroundColor(ColorRGBa.Companion.getBLACK());
        this.setBackgroundOpacity(1.0);
        this.setForegroundOpacity(1.0);
        this.setFade(1.0);
    }

    public final double getThreshold0() {
        Map map2 = this.threshold0$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).doubleValue();
    }

    public final void setThreshold0(double d) {
        Map map2 = this.threshold0$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="threshold 0", low=0.0, high=100.0, order=0)
    public static /* synthetic */ void getThreshold0$annotations() {
    }

    public final double getThreshold1() {
        Map map2 = this.threshold1$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setThreshold1(double d) {
        Map map2 = this.threshold1$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="threshold 1", low=0.0, high=100.0, order=1)
    public static /* synthetic */ void getThreshold1$annotations() {
    }

    public final double getThickness() {
        Map map2 = this.thickness$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setThickness(double d) {
        Map map2 = this.thickness$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="thickness", low=0.0, high=10.0, order=2)
    public static /* synthetic */ void getThickness$annotations() {
    }

    @NotNull
    public final ColorRGBa getForegroundColor() {
        Map map2 = this.foregroundColor$delegate;
        return (ColorRGBa)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName());
    }

    public final void setForegroundColor(@NotNull ColorRGBa colorRGBa) {
        Intrinsics.checkNotNullParameter(colorRGBa, "<set-?>");
        Map map2 = this.foregroundColor$delegate;
        map2.put($$delegatedProperties[3].getName(), colorRGBa);
    }

    @ColorParameter(label="foreground color", order=3)
    public static /* synthetic */ void getForegroundColor$annotations() {
    }

    public final double getForegroundOpacity() {
        Map map2 = this.foregroundOpacity$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[4].getName())).doubleValue();
    }

    public final void setForegroundOpacity(double d) {
        Map map2 = this.foregroundOpacity$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[4];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="foreground opacity", low=0.0, high=1.0, order=4)
    public static /* synthetic */ void getForegroundOpacity$annotations() {
    }

    @NotNull
    public final ColorRGBa getBackgroundColor() {
        Map map2 = this.backgroundColor$delegate;
        return (ColorRGBa)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[5].getName());
    }

    public final void setBackgroundColor(@NotNull ColorRGBa colorRGBa) {
        Intrinsics.checkNotNullParameter(colorRGBa, "<set-?>");
        Map map2 = this.backgroundColor$delegate;
        map2.put($$delegatedProperties[5].getName(), colorRGBa);
    }

    @ColorParameter(label="background color", order=5)
    public static /* synthetic */ void getBackgroundColor$annotations() {
    }

    public final double getBackgroundOpacity() {
        Map map2 = this.backgroundOpacity$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[6].getName())).doubleValue();
    }

    public final void setBackgroundOpacity(double d) {
        Map map2 = this.backgroundOpacity$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[6];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="background opacity", low=0.0, high=1.0, order=6)
    public static /* synthetic */ void getBackgroundOpacity$annotations() {
    }

    public final double getFade() {
        Map map2 = this.fade$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[7].getName())).doubleValue();
    }

    public final void setFade(double d) {
        Map map2 = this.fade$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[7];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="fade", low=0.0, high=1.0, order=7)
    public static /* synthetic */ void getFade$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "threshold0", "getThreshold0()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "threshold1", "getThreshold1()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "thickness", "getThickness()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "foregroundColor", "getForegroundColor()Lorg/openrndr/color/ColorRGBa;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "foregroundOpacity", "getForegroundOpacity()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "backgroundColor", "getBackgroundColor()Lorg/openrndr/color/ColorRGBa;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "backgroundOpacity", "getBackgroundOpacity()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(CannyEdgeDetector.class, "fade", "getFade()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

