/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.fx.blend.Passthrough;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.shape.Rectangle;

@Description(title="Frame blur")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R1\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/openrndr/extra/fx/blur/FrameBlur;", "Lorg/openrndr/draw/Filter1to1;", "colorType", "Lorg/openrndr/draw/ColorType;", "<init>", "(Lorg/openrndr/draw/ColorType;)V", "getColorType", "()Lorg/openrndr/draw/ColorType;", "<set-?>", "", "blend", "getBlend$annotations", "()V", "getBlend", "()D", "setBlend", "(D)V", "blend$delegate", "Ljava/util/Map;", "pt", "Lorg/openrndr/extra/fx/blend/Passthrough;", "getPt", "()Lorg/openrndr/extra/fx/blend/Passthrough;", "intermediate", "Lorg/openrndr/draw/ColorBuffer;", "intermediate2", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "orx-fx"})
public final class FrameBlur
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ColorType colorType;
    @NotNull
    private final Map blend$delegate;
    @NotNull
    private final Passthrough pt;
    @Nullable
    private ColorBuffer intermediate;
    @Nullable
    private ColorBuffer intermediate2;

    public FrameBlur(@NotNull ColorType colorType) {
        Intrinsics.checkNotNullParameter((Object)colorType, "colorType");
        super(FilterToolsKt.mppFilterShader("in vec2 v_texCoord0;\nuniform sampler2D tex0; // input image\nuniform sampler2D tex1; // accumulator image\nuniform float blend;\nout vec4 o_color;\nvoid main() {\n    vec4 inputColor = texture(tex0, v_texCoord0);\n    vec4 accumulator = texture(tex1, v_texCoord0);\n    o_color = accumulator * (1.0 - blend) + inputColor * blend;\n}", "frame-blur"), null, 2, null);
        this.colorType = colorType;
        this.blend$delegate = this.getParameters();
        this.pt = new Passthrough();
        this.setBlend(0.5);
    }

    public /* synthetic */ FrameBlur(ColorType colorType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            colorType = ColorType.FLOAT16;
        }
        this(colorType);
    }

    @NotNull
    public final ColorType getColorType() {
        return this.colorType;
    }

    public final double getBlend() {
        Map map2 = this.blend$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).doubleValue();
    }

    public final void setBlend(double d) {
        Map map2 = this.blend$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="blend", low=0.0, high=1.0)
    public static /* synthetic */ void getBlend$annotations() {
    }

    @NotNull
    public final Passthrough getPt() {
        return this.pt;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        if (!(clip == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(source.length == 0) && !(target2.length == 0)) {
            ColorBuffer it;
            ColorBuffer colorBuffer = this.intermediate;
            if (colorBuffer != null) {
                it = colorBuffer;
                boolean bl = false;
                if (ColorBufferKt.isEquivalentTo$default(it, target2[0], false, false, false, true, false, false, true, 110, null)) {
                    it.destroy();
                    this.intermediate = null;
                }
            }
            ColorBuffer colorBuffer2 = this.intermediate2;
            if (colorBuffer2 != null) {
                it = colorBuffer2;
                boolean bl = false;
                if (ColorBufferKt.isEquivalentTo$default(it, target2[0], false, false, false, true, false, false, true, 110, null)) {
                    it.destroy();
                    this.intermediate2 = null;
                }
            }
            if (this.intermediate == null) {
                ColorBuffer colorBuffer3 = this.intermediate = ColorBufferKt.createEquivalent$default(target2[0], 0, 0, 0.0, null, this.colorType, null, 0, 111, null);
                if (colorBuffer3 != null) {
                    ColorBuffer.fill$default(colorBuffer3, ColorRGBa.Companion.getTRANSPARENT(), 0, 2, null);
                }
            }
            if (this.intermediate2 == null) {
                ColorBuffer colorBuffer4 = this.intermediate2 = ColorBufferKt.createEquivalent$default(target2[0], 0, 0, 0.0, null, this.colorType, null, 0, 111, null);
                if (colorBuffer4 != null) {
                    ColorBuffer.fill$default(colorBuffer4, ColorRGBa.Companion.getTRANSPARENT(), 0, 2, null);
                }
            }
            ColorBuffer[] colorBufferArray = new ColorBuffer[2];
            colorBufferArray[0] = source[0];
            Intrinsics.checkNotNull(this.intermediate);
            ColorBuffer[] colorBufferArray2 = colorBufferArray;
            colorBufferArray = new ColorBuffer[1];
            Intrinsics.checkNotNull(this.intermediate2);
            super.apply(colorBufferArray2, colorBufferArray, clip);
            Filter filter2 = this.pt;
            ColorBuffer colorBuffer5 = this.intermediate2;
            Intrinsics.checkNotNull(colorBuffer5);
            ColorBuffer colorBuffer6 = this.intermediate;
            Intrinsics.checkNotNull(colorBuffer6);
            Filter.apply$default(filter2, colorBuffer5, colorBuffer6, null, 4, null);
            Filter filter3 = this.pt;
            ColorBuffer colorBuffer7 = this.intermediate;
            Intrinsics.checkNotNull(colorBuffer7);
            Filter.apply$default(filter3, colorBuffer7, target2[0], null, 4, null);
        }
    }

    public FrameBlur() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(FrameBlur.class, "blend", "getBlend()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

