/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ShaderWatcher;
import org.openrndr.draw.ShaderWatcherBuilder;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0018H\u0002\u001a\u001f\u0010\u0019\u001a\u00020\u00062\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\u0002\b\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\"\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "watching", "", "Ljava/nio/file/Path;", "", "Lorg/openrndr/draw/ShaderWatcher;", "pathKeys", "Ljava/nio/file/WatchKey;", "keyPaths", "watchService", "Ljava/nio/file/WatchService;", "kotlin.jvm.PlatformType", "getWatchService", "()Ljava/nio/file/WatchService;", "watchService$delegate", "Lkotlin/Lazy;", "watchThread", "Ljava/lang/Thread;", "getWatchThread", "()Ljava/lang/Thread;", "watchThread$delegate", "toFileName", "", "Ljava/net/URL;", "shaderWatcher", "init", "Lkotlin/Function1;", "Lorg/openrndr/draw/ShaderWatcherBuilder;", "", "Lkotlin/ExtensionFunctionType;", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nShaderWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderWatcher.kt\norg/openrndr/draw/ShaderWatcherKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1863#2:173\n1863#2,2:174\n1864#2:176\n*S KotlinDebug\n*F\n+ 1 ShaderWatcher.kt\norg/openrndr/draw/ShaderWatcherKt\n*L\n29#1:173\n32#1:174,2\n29#1:176\n*E\n"})
public final class ShaderWatcherKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ShaderWatcherKt::logger$lambda$0);
    @NotNull
    private static final Map<Path, List<ShaderWatcher>> watching = new LinkedHashMap();
    @NotNull
    private static final Map<Path, WatchKey> pathKeys = new LinkedHashMap();
    @NotNull
    private static final Map<WatchKey, Path> keyPaths = new LinkedHashMap();
    @NotNull
    private static final Lazy watchService$delegate = LazyKt.lazy(ShaderWatcherKt::watchService_delegate$lambda$2);
    @NotNull
    private static final Lazy watchThread$delegate = LazyKt.lazy(ShaderWatcherKt::watchThread_delegate$lambda$8);

    private static final WatchService getWatchService() {
        Lazy lazy = watchService$delegate;
        return (WatchService)lazy.getValue();
    }

    private static final Thread getWatchThread() {
        Lazy lazy = watchThread$delegate;
        return (Thread)lazy.getValue();
    }

    private static final String toFileName(URL $this$toFileName) {
        String string;
        if (Intrinsics.areEqual($this$toFileName.getProtocol(), "file")) {
            string = $this$toFileName.getPath();
        } else {
            logger.debug(() -> ShaderWatcherKt.toFileName$lambda$9($this$toFileName));
            string = null;
        }
        return string;
    }

    @NotNull
    public static final ShaderWatcher shaderWatcher(@NotNull Function1<? super ShaderWatcherBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, "init");
        ShaderWatcherBuilder swb = new ShaderWatcherBuilder();
        init.invoke(swb);
        return swb.build();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object watchService_delegate$lambda$2$lambda$1() {
        return "starting watch service";
    }

    private static final WatchService watchService_delegate$lambda$2() {
        logger.debug(ShaderWatcherKt::watchService_delegate$lambda$2$lambda$1);
        return FileSystems.getDefault().newWatchService();
    }

    private static final Object watchThread_delegate$lambda$8$lambda$7$lambda$3() {
        return "starting watch thread";
    }

    private static final Object watchThread_delegate$lambda$8$lambda$7$lambda$6$lambda$5$lambda$4(ShaderWatcher $it, Path $fullPath) {
        return "informing " + $it + " of change in " + $fullPath;
    }

    private static final Unit watchThread_delegate$lambda$8$lambda$7() {
        logger.debug(ShaderWatcherKt::watchThread_delegate$lambda$8$lambda$7$lambda$3);
        while (true) {
            WatchKey key = ShaderWatcherKt.getWatchService().take();
            Path path = keyPaths.get(key);
            List<WatchEvent<?>> list = key.pollEvents();
            Intrinsics.checkNotNullExpressionValue(list, "pollEvents(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WatchEvent event = (WatchEvent)element$iv;
                boolean bl = false;
                Object t = event.context();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type java.nio.file.Path");
                Path contextPath = (Path)t;
                Path path2 = path;
                Path fullPath = path2 != null ? path2.resolve(contextPath) : null;
                List<ShaderWatcher> list2 = watching.get(fullPath);
                if (list2 == null) continue;
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ShaderWatcher it = (ShaderWatcher)element$iv2;
                    boolean bl2 = false;
                    logger.info(() -> ShaderWatcherKt.watchThread_delegate$lambda$8$lambda$7$lambda$6$lambda$5$lambda$4(it, fullPath));
                    it.setChanged$openrndr_draw(true);
                }
            }
            key.reset();
        }
    }

    private static final Thread watchThread_delegate$lambda$8() {
        return ThreadsKt.thread$default(false, true, null, null, 0, ShaderWatcherKt::watchThread_delegate$lambda$8$lambda$7, 29, null);
    }

    private static final Object toFileName$lambda$9(URL $this_toFileName) {
        return $this_toFileName.getProtocol() + " is not 'file', returning null";
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ Map access$getWatching$p() {
        return watching;
    }

    public static final /* synthetic */ Thread access$getWatchThread() {
        return ShaderWatcherKt.getWatchThread();
    }

    public static final /* synthetic */ String access$toFileName(URL $receiver) {
        return ShaderWatcherKt.toFileName($receiver);
    }

    public static final /* synthetic */ WatchService access$getWatchService() {
        return ShaderWatcherKt.getWatchService();
    }

    public static final /* synthetic */ Map access$getPathKeys$p() {
        return pathKeys;
    }

    public static final /* synthetic */ Map access$getKeyPaths$p() {
        return keyPaths;
    }
}

