/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Program;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMapKt;
import org.openrndr.draw.LoadFontKt;
import org.openrndr.draw.font.Face;
import org.openrndr.draw.font.FontKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aJ\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u00062\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f\u00a8\u0006\u000e"}, d2={"loadFont", "Lorg/openrndr/draw/FontImageMap;", "Lorg/openrndr/Program;", "fileOrUrl", "", "size", "", "characterSet", "", "", "contentScale", "fontScaler", "Lkotlin/Function1;", "Lorg/openrndr/draw/font/Face;", "openrndr-application"})
public final class LoadFontKt {
    @NotNull
    public static final FontImageMap loadFont(@NotNull Program $this$loadFont, @NotNull String fileOrUrl, double size, @NotNull Set<Character> characterSet, double contentScale, @NotNull Function1<? super Face, Double> fontScaler) {
        FontImageMap fontImageMap;
        Intrinsics.checkNotNullParameter($this$loadFont, "<this>");
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        Intrinsics.checkNotNullParameter(characterSet, "characterSet");
        Intrinsics.checkNotNullParameter(fontScaler, "fontScaler");
        Set<Character> activeSet = characterSet.contains(Character.valueOf(' ')) ? characterSet : SetsKt.plus(characterSet, Character.valueOf(' '));
        Face font = FontKt.loadFace(fileOrUrl);
        double scale = ((Number)fontScaler.invoke(font)).doubleValue() * size;
        font.close();
        try {
            new URL(fileOrUrl);
            fontImageMap = FontImageMap.Companion.fromUrl(fileOrUrl, scale, activeSet, contentScale);
        }
        catch (MalformedURLException e) {
            File file = new File(fileOrUrl);
            if (!file.exists()) {
                boolean $i$a$-require-LoadFontKt$loadFont$42 = false;
                String $i$a$-require-LoadFontKt$loadFont$42 = "failed to load font: file '" + file.getAbsolutePath() + "' does not exist.";
                throw new IllegalArgumentException($i$a$-require-LoadFontKt$loadFont$42.toString());
            }
            Object object = new String[]{"ttf", "otf"};
            Set<String> set = SetsKt.setOf(object);
            object = FilesKt.getExtension(file);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            if (!set.contains(string)) {
                boolean bl = false;
                String string2 = "failed to load font: file '" + file.getAbsolutePath() + "' is not a .ttf or .otf file";
                throw new IllegalArgumentException(string2.toString());
            }
            fontImageMap = FontImageMap.Companion.fromFile(fileOrUrl, scale, activeSet, contentScale);
        }
        return fontImageMap;
    }

    public static /* synthetic */ FontImageMap loadFont$default(Program program2, String string, double d, Set set, double d2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            set = FontMapKt.getDefaultFontmapCharacterSet();
        }
        if ((n & 8) != 0) {
            d2 = program2.getDrawer().getContext().contentScale();
        }
        if ((n & 0x10) != 0) {
            function1 = loadFont.1.INSTANCE;
        }
        return LoadFontKt.loadFont(program2, string, d, set, d2, function1);
    }
}

