/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa$;
import org.openrndr.color.Linearity;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 B2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0002BCB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tBC\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0004H\u0096\u0002J\u0010\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0004H\u0016J\b\u0010,\u001a\u00020-H\u0016J\t\u0010.\u001a\u00020\u0004H\u00c6\u0003J\t\u0010/\u001a\u00020\u0004H\u00c6\u0003J\t\u00100\u001a\u00020\u0004H\u00c6\u0003J\t\u00101\u001a\u00020\u0004H\u00c6\u0003J1\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u00d6\u0003J\t\u00107\u001a\u00020\u000bH\u00d6\u0001J\t\u00108\u001a\u000209H\u00d6\u0001J%\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0001\u00a2\u0006\u0002\bAR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001c\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006D"}, d2={"Lorg/openrndr/color/ColorXYZa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/AlgebraicColor;", "x", "", "y", "z", "alpha", "<init>", "(DDDD)V", "seen0", "", "a", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getX", "()D", "getY", "getZ", "getAlpha", "getA$annotations", "()V", "getA", "minValue", "getMinValue", "toLABa", "Lorg/openrndr/color/ColorLABa;", "ref", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "plus", "right", "minus", "times", "scale", "opacify", "factor", "toVector4", "Lorg/openrndr/math/Vector4;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
public final class ColorXYZa
implements ColorModel<ColorXYZa>,
AlgebraicColor<ColorXYZa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    private final double alpha;
    private final double a;
    @NotNull
    private static final ColorXYZa SO2_A = new ColorXYZa(1.0983, 1.0, 0.3555, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_C = new ColorXYZa(0.9804, 1.0, 1.1811, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_F2 = new ColorXYZa(0.9809, 1.0, 0.6753, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_TL4 = new ColorXYZa(1.014, 1.0, 0.659, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_UL3000 = new ColorXYZa(1.0798999999999999, 1.0, 0.33909999999999996, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_D50 = new ColorXYZa(1.0798999999999999, 1.0, 0.8245, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_D60 = new ColorXYZa(1.0798999999999999, 1.0, 1.0086, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_D65 = new ColorXYZa(0.9501999999999999, 1.0, 1.0881999999999998, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO2_D75 = new ColorXYZa(1.0798999999999999, 1.0, 1.2253, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_A = new ColorXYZa(1.1116, 1.0, 0.3519, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_C = new ColorXYZa(0.973, 1.0, 1.1614, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_F2 = new ColorXYZa(1.0212, 1.0, 0.6937000000000001, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_TL4 = new ColorXYZa(1.0382, 1.0, 0.669, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_UL3000 = new ColorXYZa(1.1112, 1.0, 0.3521, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_D50 = new ColorXYZa(0.9672, 1.0, 0.8145, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_D60 = new ColorXYZa(0.9521, 1.0, 0.996, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_D65 = new ColorXYZa(0.9483, 1.0, 1.0737999999999999, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa SO10_D75 = new ColorXYZa(0.9445, 1.0, 1.207, 0.0, 8, null);
    @NotNull
    private static final ColorXYZa NEUTRAL = Companion.fromRGBa(new ColorRGBa(1.0, 1.0, 1.0, 0.0, Linearity.LINEAR, 8, null));

    public ColorXYZa(double x, double y, double z, double alpha) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.alpha = alpha;
        this.a = this.getAlpha();
    }

    public /* synthetic */ ColorXYZa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public final double getA() {
        return this.a;
    }

    @Deprecated(message="Legacy alpha parameter name", replaceWith=@ReplaceWith(expression="alpha", imports={}))
    public static /* synthetic */ void getA$annotations() {
    }

    public final double getMinValue() {
        return Math.min(Math.min(this.x, this.y), this.z);
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return ColorLABa.Companion.fromXYZa(this, ref);
    }

    @NotNull
    public final ColorLUVa toLUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return ColorLUVa.Companion.fromXYZa(this, ref);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        double r = 3.2406 * this.x - 1.5372 * this.y - 0.4986 * this.z;
        double g = -0.9689 * this.x + 1.8758 * this.y + 0.0415 * this.z;
        double b = 0.0557 * this.x - 0.204 * this.y + 1.057 * this.z;
        return new ColorRGBa(r, g, b, this.getAlpha(), Linearity.LINEAR);
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return this.toRGBa().toHSVa();
    }

    @NotNull
    public final ColorHSLa toHSLa() {
        return this.toRGBa().toHSLa();
    }

    @Override
    @NotNull
    public ColorXYZa plus(@NotNull ColorXYZa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.x + right.x, this.y + right.y, this.z + right.z, this.getAlpha() + right.getAlpha());
    }

    @Override
    @NotNull
    public ColorXYZa minus(@NotNull ColorXYZa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.x - right.x, this.y - right.y, this.z - right.z, this.getAlpha() - right.getAlpha());
    }

    @Override
    @NotNull
    public ColorXYZa times(double scale) {
        return this.copy(this.x * scale, this.y * scale, this.z * scale, this.getAlpha() * scale);
    }

    @Override
    @NotNull
    public ColorXYZa opacify(double factor) {
        return ColorXYZa.copy$default(this, 0.0, 0.0, 0.0, this.getAlpha() * factor, 7, null);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.x, this.y, this.z, this.getAlpha());
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa copy(double x, double y, double z, double alpha) {
        return new ColorXYZa(x, y, z, alpha);
    }

    public static /* synthetic */ ColorXYZa copy$default(ColorXYZa colorXYZa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorXYZa.x;
        }
        if ((n & 2) != 0) {
            d2 = colorXYZa.y;
        }
        if ((n & 4) != 0) {
            d3 = colorXYZa.z;
        }
        if ((n & 8) != 0) {
            d4 = colorXYZa.alpha;
        }
        return colorXYZa.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ColorXYZa(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", alpha=" + this.alpha + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        result = result * 31 + Double.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorXYZa)) {
            return false;
        }
        ColorXYZa colorXYZa = (ColorXYZa)other;
        if (Double.compare(this.x, colorXYZa.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, colorXYZa.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, colorXYZa.z) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorXYZa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorXYZa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @Override
    @NotNull
    public ColorXYZa mix(@NotNull ColorXYZa other, double factor) {
        return (ColorXYZa)AlgebraicColor.DefaultImpls.mix(this, (AlgebraicColor)other, factor);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorXYZa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.x);
        output.encodeDoubleElement(serialDesc, 1, self.y);
        output.encodeDoubleElement(serialDesc, 2, self.z);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.getAlpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.getAlpha());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : Double.compare(self.a, self.getAlpha()) != 0) {
            output.encodeDoubleElement(serialDesc, 4, self.a);
        }
    }

    public /* synthetic */ ColorXYZa(int seen0, double x, double y, double z, double alpha, double a, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
        this.a = (seen0 & 0x10) == 0 ? this.getAlpha() : a;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000500R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007\u00a8\u00061"}, d2={"Lorg/openrndr/color/ColorXYZa$Companion;", "", "<init>", "()V", "SO2_A", "Lorg/openrndr/color/ColorXYZa;", "getSO2_A", "()Lorg/openrndr/color/ColorXYZa;", "SO2_C", "getSO2_C", "SO2_F2", "getSO2_F2", "SO2_TL4", "getSO2_TL4", "SO2_UL3000", "getSO2_UL3000", "SO2_D50", "getSO2_D50", "SO2_D60", "getSO2_D60", "SO2_D65", "getSO2_D65", "SO2_D75", "getSO2_D75", "SO10_A", "getSO10_A", "SO10_C", "getSO10_C", "SO10_F2", "getSO10_F2", "SO10_TL4", "getSO10_TL4", "SO10_UL3000", "getSO10_UL3000", "SO10_D50", "getSO10_D50", "SO10_D60", "getSO10_D60", "SO10_D65", "getSO10_D65", "SO10_D75", "getSO10_D75", "NEUTRAL", "getNEUTRAL", "fromRGBa", "rgba", "Lorg/openrndr/color/ColorRGBa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorXYZa getSO2_A() {
            return SO2_A;
        }

        @NotNull
        public final ColorXYZa getSO2_C() {
            return SO2_C;
        }

        @NotNull
        public final ColorXYZa getSO2_F2() {
            return SO2_F2;
        }

        @NotNull
        public final ColorXYZa getSO2_TL4() {
            return SO2_TL4;
        }

        @NotNull
        public final ColorXYZa getSO2_UL3000() {
            return SO2_UL3000;
        }

        @NotNull
        public final ColorXYZa getSO2_D50() {
            return SO2_D50;
        }

        @NotNull
        public final ColorXYZa getSO2_D60() {
            return SO2_D60;
        }

        @NotNull
        public final ColorXYZa getSO2_D65() {
            return SO2_D65;
        }

        @NotNull
        public final ColorXYZa getSO2_D75() {
            return SO2_D75;
        }

        @NotNull
        public final ColorXYZa getSO10_A() {
            return SO10_A;
        }

        @NotNull
        public final ColorXYZa getSO10_C() {
            return SO10_C;
        }

        @NotNull
        public final ColorXYZa getSO10_F2() {
            return SO10_F2;
        }

        @NotNull
        public final ColorXYZa getSO10_TL4() {
            return SO10_TL4;
        }

        @NotNull
        public final ColorXYZa getSO10_UL3000() {
            return SO10_UL3000;
        }

        @NotNull
        public final ColorXYZa getSO10_D50() {
            return SO10_D50;
        }

        @NotNull
        public final ColorXYZa getSO10_D60() {
            return SO10_D60;
        }

        @NotNull
        public final ColorXYZa getSO10_D65() {
            return SO10_D65;
        }

        @NotNull
        public final ColorXYZa getSO10_D75() {
            return SO10_D75;
        }

        @NotNull
        public final ColorXYZa getNEUTRAL() {
            return NEUTRAL;
        }

        @NotNull
        public final ColorXYZa fromRGBa(@NotNull ColorRGBa rgba) {
            Intrinsics.checkNotNullParameter(rgba, "rgba");
            ColorRGBa linear = rgba.toLinear();
            double x = 0.4124 * linear.getR() + 0.3576 * linear.getG() + 0.1805 * linear.getB();
            double y = 0.2126 * linear.getR() + 0.7152 * linear.getG() + 0.0722 * linear.getB();
            double z = 0.0193 * linear.getR() + 0.1192 * linear.getG() + 0.9505 * linear.getB();
            return new ColorXYZa(x, y, z, linear.getAlpha());
        }

        @NotNull
        public final KSerializer<ColorXYZa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

