/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class NVStreamMetadata {
    public static final int EGL_MAX_STREAM_METADATA_BLOCKS_NV = 12880;
    public static final int EGL_MAX_STREAM_METADATA_BLOCK_SIZE_NV = 12881;
    public static final int EGL_MAX_STREAM_METADATA_TOTAL_SIZE_NV = 12882;
    public static final int EGL_PRODUCER_METADATA_NV = 12883;
    public static final int EGL_CONSUMER_METADATA_NV = 12884;
    public static final int EGL_PENDING_METADATA_NV = 13096;
    public static final int EGL_METADATA0_SIZE_NV = 12885;
    public static final int EGL_METADATA1_SIZE_NV = 12886;
    public static final int EGL_METADATA2_SIZE_NV = 12887;
    public static final int EGL_METADATA3_SIZE_NV = 12888;
    public static final int EGL_METADATA0_TYPE_NV = 12889;
    public static final int EGL_METADATA1_TYPE_NV = 12890;
    public static final int EGL_METADATA2_TYPE_NV = 12891;
    public static final int EGL_METADATA3_TYPE_NV = 12892;

    protected NVStreamMetadata() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryDisplayAttribNV(long dpy, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDisplayAttribNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPI(dpy, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDisplayAttribNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return NVStreamMetadata.neglQueryDisplayAttribNV(dpy, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static int neglSetStreamMetadataNV(long dpy, long stream, int n, int offset, int size, long data) {
        long __functionAddress = EGL.getCapabilities().eglSetStreamMetadataNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, n, offset, size, data, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglSetStreamMetadataNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLint") int n, @NativeType(value="EGLint") int offset, @NativeType(value="void const *") ByteBuffer data) {
        return NVStreamMetadata.neglSetStreamMetadataNV(dpy, stream, n, offset, data.remaining(), MemoryUtil.memAddress(data)) != 0;
    }

    public static int neglQueryStreamMetadataNV(long dpy, long stream, int name, int n, int offset, int size, long data) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamMetadataNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, name, n, offset, size, data, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamMetadataNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int name, @NativeType(value="EGLint") int n, @NativeType(value="EGLint") int offset, @NativeType(value="void *") ByteBuffer data) {
        return NVStreamMetadata.neglQueryStreamMetadataNV(dpy, stream, name, n, offset, data.remaining(), MemoryUtil.memAddress(data)) != 0;
    }
}

