/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTSurfaceCompression {
    public static final int EGL_SURFACE_COMPRESSION_EXT = 13488;
    public static final int EGL_SURFACE_COMPRESSION_PLANE1_EXT = 12942;
    public static final int EGL_SURFACE_COMPRESSION_PLANE2_EXT = 12943;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_NONE_EXT = 13489;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_DEFAULT_EXT = 13490;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_1BPC_EXT = 13492;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_2BPC_EXT = 13493;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_3BPC_EXT = 13494;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_4BPC_EXT = 13495;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_5BPC_EXT = 13496;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_6BPC_EXT = 13497;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_7BPC_EXT = 13498;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_8BPC_EXT = 13499;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_9BPC_EXT = 13500;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_10BPC_EXT = 13501;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_11BPC_EXT = 13502;
    public static final int EGL_SURFACE_COMPRESSION_FIXED_RATE_12BPC_EXT = 13503;

    protected EXTSurfaceCompression() {
        throw new UnsupportedOperationException();
    }

    public static int neglQuerySupportedCompressionRatesEXT(long dpy, long config, long attrib_list, long rates, int rate_size, long num_rates) {
        long __functionAddress = EGL.getCapabilities().eglQuerySupportedCompressionRatesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
        }
        return JNI.callPPPPPI(dpy, config, attrib_list, rates, rate_size, num_rates, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQuerySupportedCompressionRatesEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLAttrib const *") @Nullable PointerBuffer attrib_list, @NativeType(value="EGLint *") @Nullable IntBuffer rates, @NativeType(value="EGLint *") IntBuffer num_rates) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
            Checks.check((Buffer)num_rates, 1);
        }
        return EXTSurfaceCompression.neglQuerySupportedCompressionRatesEXT(dpy, config, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(rates), Checks.remainingSafe(rates), MemoryUtil.memAddress(num_rates)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQuerySupportedCompressionRatesEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLAttrib const *") @Nullable PointerBuffer attrib_list, @NativeType(value="EGLint *") int @Nullable [] rates, @NativeType(value="EGLint *") int[] num_rates) {
        long __functionAddress = EGL.getCapabilities().eglQuerySupportedCompressionRatesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.checkNTSafe(attrib_list, 12344L);
            Checks.check(num_rates, 1);
        }
        return JNI.callPPPPPI(dpy, config, MemoryUtil.memAddressSafe(attrib_list), rates, Checks.lengthSafe(rates), num_rates, __functionAddress) != 0;
    }
}

