/*
 * Decompiled with CFR 0.152.
 */
package lib.fx;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ComputeStyle;
import org.openrndr.draw.ComputeStyleKt;
import org.openrndr.draw.Filter1to1;
import org.openrndr.draw.ImageBindingKt;
import org.openrndr.draw.ShaderStorageBuffer;
import org.openrndr.draw.ShaderStorageBufferKt;
import org.openrndr.draw.ShaderStorageFormat;
import org.openrndr.draw.font.BufferAccess;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.internal.Driver;
import org.openrndr.math.IntVector3;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0&2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001e\u00a8\u0006+"}, d2={"Llib/fx/Kmeans;", "Lorg/openrndr/draw/Filter1to1;", "clusterCount", "", "random", "Lkotlin/random/Random;", "<init>", "(ILkotlin/random/Random;)V", "getClusterCount", "()I", "getRandom", "()Lkotlin/random/Random;", "sourceCopy", "Lorg/openrndr/draw/ColorBuffer;", "getSourceCopy", "()Lorg/openrndr/draw/ColorBuffer;", "setSourceCopy", "(Lorg/openrndr/draw/ColorBuffer;)V", "targetCopy", "getTargetCopy", "setTargetCopy", "clusters", "Lorg/openrndr/draw/ShaderStorageBuffer;", "getClusters", "()Lorg/openrndr/draw/ShaderStorageBuffer;", "sums", "getSums", "resetSums", "Lorg/openrndr/draw/ComputeStyle;", "getResetSums", "()Lorg/openrndr/draw/ComputeStyle;", "updateSums", "getUpdateSums", "updateClusters", "getUpdateClusters", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "deminityy"})
public final class Kmeans
extends Filter1to1 {
    private final int clusterCount;
    @NotNull
    private final Random random;
    @Nullable
    private ColorBuffer sourceCopy;
    @Nullable
    private ColorBuffer targetCopy;
    @NotNull
    private final ShaderStorageBuffer clusters;
    @NotNull
    private final ShaderStorageBuffer sums;
    @NotNull
    private final ComputeStyle resetSums;
    @NotNull
    private final ComputeStyle updateSums;
    @NotNull
    private final ComputeStyle updateClusters;

    /*
     * WARNING - void declaration
     */
    public Kmeans(int clusterCount, @NotNull Random random) {
        void $this$clusters_u24lambda_u243;
        ShaderStorageBuffer shaderStorageBuffer;
        Intrinsics.checkNotNullParameter(random, "random");
        super(null, null, 3, null);
        this.clusterCount = clusterCount;
        this.random = random;
        ShaderStorageBuffer shaderStorageBuffer2 = shaderStorageBuffer = ShaderStorageBufferKt.shaderStorageBuffer(ShaderStorageBufferKt.shaderStorageFormat(arg_0 -> Kmeans.clusters$lambda$0(this, arg_0)));
        Kmeans kmeans = this;
        boolean bl = false;
        int n = this.clusterCount;
        ArrayList<Vector3> arrayList = new ArrayList<Vector3>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Vector3> arrayList2 = arrayList;
            boolean bl2 = false;
            arrayList2.add(UniformRandomKt.uniform$default(Vector3.Companion, 0.0, 1.0, null, 4, null));
        }
        List means = arrayList;
        ShaderStorageBuffer.DefaultImpls.put$default((ShaderStorageBuffer)$this$clusters_u24lambda_u243, 0, arg_0 -> Kmeans.clusters$lambda$3$lambda$2(this, means, arg_0), 1, null);
        kmeans.clusters = shaderStorageBuffer;
        this.sums = ShaderStorageBufferKt.shaderStorageBuffer(ShaderStorageBufferKt.shaderStorageFormat(arg_0 -> Kmeans.sums$lambda$4(this, arg_0)));
        this.resetSums = ComputeStyleKt.computeStyle(arg_0 -> Kmeans.resetSums$lambda$5(this, arg_0));
        this.updateSums = ComputeStyleKt.computeStyle(arg_0 -> Kmeans.updateSums$lambda$6(this, arg_0));
        this.updateClusters = ComputeStyleKt.computeStyle(arg_0 -> Kmeans.updateClusters$lambda$7(this, arg_0));
    }

    public /* synthetic */ Kmeans(int n, Random random, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 32;
        }
        if ((n2 & 2) != 0) {
            random = Random.Default;
        }
        this(n, random);
    }

    public final int getClusterCount() {
        return this.clusterCount;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @Nullable
    public final ColorBuffer getSourceCopy() {
        return this.sourceCopy;
    }

    public final void setSourceCopy(@Nullable ColorBuffer colorBuffer) {
        this.sourceCopy = colorBuffer;
    }

    @Nullable
    public final ColorBuffer getTargetCopy() {
        return this.targetCopy;
    }

    public final void setTargetCopy(@Nullable ColorBuffer colorBuffer) {
        this.targetCopy = colorBuffer;
    }

    @NotNull
    public final ShaderStorageBuffer getClusters() {
        return this.clusters;
    }

    @NotNull
    public final ShaderStorageBuffer getSums() {
        return this.sums;
    }

    @NotNull
    public final ComputeStyle getResetSums() {
        return this.resetSums;
    }

    @NotNull
    public final ComputeStyle getUpdateSums() {
        return this.updateSums;
    }

    @NotNull
    public final ComputeStyle getUpdateClusters() {
        return this.updateClusters;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        ColorBuffer colorBuffer = this.sourceCopy;
        boolean bl = colorBuffer != null ? !ColorBufferKt.isEquivalentTo$default(colorBuffer, source[0], false, false, false, true, true, false, false, 206, null) : false;
        if (bl) {
            ColorBuffer colorBuffer2 = this.sourceCopy;
            if (colorBuffer2 != null) {
                colorBuffer2.destroy();
            }
        }
        ColorBuffer colorBuffer3 = this.targetCopy;
        boolean bl2 = colorBuffer3 != null ? !ColorBufferKt.isEquivalentTo$default(colorBuffer3, source[0], false, false, false, true, true, false, false, 206, null) : false;
        if (bl2) {
            ColorBuffer colorBuffer4 = this.targetCopy;
            if (colorBuffer4 != null) {
                colorBuffer4.destroy();
            }
        }
        if (this.sourceCopy == null) {
            this.sourceCopy = ColorBufferKt.createEquivalent$default(source[0], 0, 0, 0.0, ColorFormat.RGBa, ColorType.FLOAT16, null, 0, 103, null);
        }
        if (this.targetCopy == null) {
            this.targetCopy = ColorBufferKt.createEquivalent$default(target2[0], 0, 0, 0.0, ColorFormat.RGBa, ColorType.FLOAT16, null, 0, 103, null);
        }
        ColorBuffer colorBuffer5 = source[0];
        ColorBuffer colorBuffer6 = this.sourceCopy;
        Intrinsics.checkNotNull(colorBuffer6);
        ColorBuffer.copyTo$default(colorBuffer5, colorBuffer6, 0, 0, null, 14, null);
        ComputeStyleKt.execute$default(this.resetSums, 0, 0, 0, 7, null);
        ColorBuffer colorBuffer7 = this.sourceCopy;
        Intrinsics.checkNotNull(colorBuffer7);
        this.updateSums.image("source", ImageBindingKt.imageBinding(colorBuffer7, 0, BufferAccess.READ));
        ColorBuffer colorBuffer8 = this.targetCopy;
        Intrinsics.checkNotNull(colorBuffer8);
        this.updateSums.image("target", ImageBindingKt.imageBinding(colorBuffer8, 0, BufferAccess.WRITE));
        ComputeStyleKt.execute$default(this.updateSums, source[0].getEffectiveWidth(), source[0].getEffectiveHeight(), 0, 4, null);
        ComputeStyleKt.execute$default(this.updateClusters, 0, 0, 0, 7, null);
        Driver.Companion.getInstance().finish();
        ColorBuffer colorBuffer9 = this.targetCopy;
        Intrinsics.checkNotNull(colorBuffer9);
        ColorBuffer.copyTo$default(colorBuffer9, target2[0], 0, 0, null, 14, null);
    }

    private static final Unit clusters$lambda$0(Kmeans this$0, ShaderStorageFormat $this$shaderStorageFormat) {
        Intrinsics.checkNotNullParameter($this$shaderStorageFormat, "$this$shaderStorageFormat");
        $this$shaderStorageFormat.primitive("means", BufferPrimitiveType.VECTOR4_FLOAT32, this$0.clusterCount);
        $this$shaderStorageFormat.primitive("initialMeans", BufferPrimitiveType.VECTOR4_FLOAT32, this$0.clusterCount);
        return Unit.INSTANCE;
    }

    private static final Unit clusters$lambda$3$lambda$2(Kmeans this$0, List $means, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (int j = 0; j < 2; ++j) {
            int n = this$0.clusterCount;
            for (int i = 0; i < n; ++i) {
                $this$put.write((Vector3)$means.get(i));
                $this$put.write(0.0f);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit sums$lambda$4(Kmeans this$0, ShaderStorageFormat $this$shaderStorageFormat) {
        Intrinsics.checkNotNullParameter($this$shaderStorageFormat, "$this$shaderStorageFormat");
        $this$shaderStorageFormat.primitive("sums", BufferPrimitiveType.VECTOR4_INT32, this$0.clusterCount);
        return Unit.INSTANCE;
    }

    private static final Unit resetSums$lambda$5(Kmeans this$0, ComputeStyle $this$computeStyle) {
        Intrinsics.checkNotNullParameter($this$computeStyle, "$this$computeStyle");
        $this$computeStyle.setComputeTransform("\n            for (int i = 0; i < " + this$0.clusterCount + "; ++i) {\n                b_sums.sums[i] = ivec4(0); \n            }\n        ");
        $this$computeStyle.buffer("sums", this$0.sums);
        return Unit.INSTANCE;
    }

    private static final Unit updateSums$lambda$6(Kmeans this$0, ComputeStyle $this$computeStyle) {
        Intrinsics.checkNotNullParameter($this$computeStyle, "$this$computeStyle");
        $this$computeStyle.setComputeTransform(StringsKt.trimIndent("\n            ivec2 idx = ivec2(gl_GlobalInvocationID.xy);\n            float minDist = 1E10;\n            int minArg = -1;\n            vec4 color = imageLoad(p_source, idx);\n            for (int i = 0; i < " + this$0.clusterCount + "; ++i) {\n                float d = distance(color.rgb, b_clusters.means[i].rgb);\n                 if (d < minDist) {\n                    minDist = d;\n                    minArg = i;\n                 }\n                 \n                \n            }\n            imageStore(p_target, idx, vec4(b_clusters.initialMeans[minArg].rgb, 1.0));\n            atomicAdd(b_sums.sums[minArg].r, int(color.r * 255.0));\n            atomicAdd(b_sums.sums[minArg].g, int(color.g * 255.0));\n            atomicAdd(b_sums.sums[minArg].b, int(color.b * 255.0));\n            atomicAdd(b_sums.sums[minArg].a, 255);\n        "));
        $this$computeStyle.buffer("clusters", this$0.clusters);
        $this$computeStyle.buffer("sums", this$0.sums);
        return Unit.INSTANCE;
    }

    private static final Unit updateClusters$lambda$7(Kmeans this$0, ComputeStyle $this$computeStyle) {
        Intrinsics.checkNotNullParameter($this$computeStyle, "$this$computeStyle");
        $this$computeStyle.setComputeTransform(StringsKt.trimIndent("\n            for (int i = 0; i < " + this$0.clusterCount + "; ++i) {\n            if (b_sums.sums[i].a > 0) { \n                vec3 mean = (vec3(b_sums.sums[i].rgb) )  / float(b_sums.sums[i].a);\n                \n                 b_clusters.means[i] = vec4(mean, 1.0);\n                 }\n            }\n        "));
        $this$computeStyle.buffer("clusters", this$0.clusters);
        $this$computeStyle.buffer("sums", this$0.sums);
        $this$computeStyle.setWorkGroupSize(new IntVector3(1, 1, 1));
        return Unit.INSTANCE;
    }

    public Kmeans() {
        this(0, null, 3, null);
    }
}

