/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import kotlinx.serialization.cbor.internal.CborWriter;
import kotlinx.serialization.cbor.internal.EncoderKt;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/cbor/internal/DefiniteLengthCborWriter;", "Lkotlinx/serialization/cbor/internal/CborWriter;", "cbor", "Lkotlinx/serialization/cbor/Cbor;", "output", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "structureStack", "", "Lkotlinx/serialization/cbor/internal/CborWriter$Data;", "Lkotlinx/serialization/cbor/internal/Stack;", "getDestination", "incrementChildren", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "endStructure", "kotlinx-serialization-cbor"})
@SourceDebugExtension(value={"SMAP\nEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoder.kt\nkotlinx/serialization/cbor/internal/DefiniteLengthCborWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1863#2,2:334\n*S KotlinDebug\n*F\n+ 1 Encoder.kt\nkotlinx/serialization/cbor/internal/DefiniteLengthCborWriter\n*L\n207#1:334,2\n*E\n"})
public final class DefiniteLengthCborWriter
extends CborWriter {
    @NotNull
    private final List<CborWriter.Data> structureStack;

    public DefiniteLengthCborWriter(@NotNull Cbor cbor, @NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter(cbor, "cbor");
        Intrinsics.checkNotNullParameter(output, "output");
        super(cbor, output, null);
        this.structureStack = EncoderKt.access$Stack(new CborWriter.Data(output, -1));
    }

    @Override
    @NotNull
    protected ByteArrayOutput getDestination() {
        return EncoderKt.access$peek(this.structureStack).getBytes();
    }

    @Override
    protected void incrementChildren() {
        CborWriter.Data data = EncoderKt.access$peek(this.structureStack);
        int n = data.getElementCount();
        data.setElementCount(n + 1);
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        CborWriter.Data current = new CborWriter.Data(new ByteArrayOutput(), 0);
        EncoderKt.access$push(this.structureStack, current);
        return this;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        CborWriter.Data completedCurrent = EncoderKt.access$pop(this.structureStack);
        ByteArrayOutput accumulator = this.getDestination();
        int numChildren = completedCurrent.getElementCount();
        if (this.getCbor().getConfiguration().getEncodeObjectTags()) {
            long[] lArray = EncodingKt.getObjectTags(descriptor2);
            if (lArray != null) {
                Iterable $this$forEach$iv = ULongArray.box-impl(lArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    long it = ((ULong)element$iv).unbox-impl();
                    boolean bl = false;
                    EncoderKt.access$encodeTag-2TYgG_w(accumulator, it);
                }
            }
        }
        if (EncodingKt.hasArrayTag(descriptor2)) {
            EncoderKt.access$startArray-2TYgG_w(accumulator, ULong.constructor-impl(numChildren));
        } else {
            SerialKind serialKind = descriptor2.getKind();
            if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind) {
                EncoderKt.access$startArray-2TYgG_w(accumulator, ULong.constructor-impl(numChildren));
            } else if (serialKind instanceof StructureKind.MAP) {
                EncoderKt.access$startMap-2TYgG_w(accumulator, ULong.constructor-impl(numChildren / 2));
            } else {
                EncoderKt.access$startMap-2TYgG_w(accumulator, ULong.constructor-impl(numChildren));
            }
        }
        accumulator.copyFrom(completedCurrent.getBytes());
    }
}

